/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPackageType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkProduct;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListParser;", "", "()V", "parseJdkItem", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "item", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "filters", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "parseJdkList", "tree", "readTree", "rawData", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkList.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,602:1\n800#2,11:603\n800#2,11:614\n766#2:625\n857#2,2:626\n1549#2:628\n1620#2,2:629\n1603#2,9:632\n1855#2:641\n1856#2:643\n1612#2:644\n1622#2:645\n1#3:631\n1#3:642\n*S KotlinDebug\n*F\n+ 1 JdkList.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListParser\n*L\n359#1:603,11\n378#1:614,11\n378#1:625\n378#1:626,2\n378#1:628\n378#1:629,2\n401#1:632,9\n401#1:641\n401#1:643\n401#1:644\n378#1:645\n401#1:642\n*E\n"})
public final class JdkListParser {
    @NotNull
    public static final JdkListParser INSTANCE = new JdkListParser();

    private JdkListParser() {
    }

    @NotNull
    public final ObjectNode readTree(@NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            throw new IllegalStateException("Unexpected JSON data".toString());
        }
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> parseJdkList(@NotNull ObjectNode tree, @NotNull JdkPredicate filters) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        JsonNode jsonNode = tree.get("jdks");
        ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
        if (arrayNode == null) {
            throw new IllegalStateException("`jdks` element is missing".toString());
        }
        ArrayNode items2 = arrayNode;
        List result2 = new ArrayList();
        Iterable $this$filterIsInstance$iv = (Iterable)items2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ObjectNode item : (List)destination$iv$iv) {
            CollectionsKt.addAll((Collection)result2, (Iterable)this.parseJdkItem(item, filters));
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> parseJdkItem(@NotNull ObjectNode item, @NotNull JdkPredicate filters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ObjectNode p0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        if (!filters.testJdkProduct(item)) {
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode = item.get("packages");
        ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
        if (arrayNode == null) {
            return CollectionsKt.emptyList();
        }
        ArrayNode packages = arrayNode;
        JsonNode jsonNode2 = item.get("vendor");
        String string2 = jsonNode2 != null ? jsonNode2.asText() : null;
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode3 = item.get("product");
        JsonNode jsonNode4 = item.get("flavour");
        JdkProduct product = new JdkProduct(string2, jsonNode3 != null ? jsonNode3.asText() : null, jsonNode4 != null ? jsonNode4.asText() : null);
        byte[] contents = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)item);
        Iterable $this$filterIsInstance$iv = (Iterable)packages;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (ObjectNode)element$iv$iv;
            boolean bl = false;
            if (!filters.testJdkPackage(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2;
            String string3;
            String string4;
            String string5;
            String string6;
            Object object;
            String string7;
            Object object2;
            String string8;
            String string9;
            void pkg;
            String string10;
            String string11;
            String string12;
            String string13;
            int n;
            boolean bl;
            boolean bl2;
            Collection collection;
            block31: {
                block30: {
                    boolean bl3;
                    JsonNode jsonNode5;
                    boolean bl4;
                    JsonNode jsonNode6;
                    p0 = (ObjectNode)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    JsonNode jsonNode7 = jsonNode6 = item.get("default");
                    if (jsonNode7 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)jsonNode7, (String)"item[\"default\"]");
                        JsonNode it = jsonNode6;
                        boolean bl6 = false;
                        bl4 = Intrinsics.areEqual((Object)filters.testPredicate(it), (Object)true);
                    } else {
                        bl4 = false;
                    }
                    bl2 = bl4;
                    JsonNode jsonNode8 = jsonNode5 = item.get("listed");
                    if (jsonNode8 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)jsonNode8, (String)"item[\"listed\"]");
                        JsonNode it = jsonNode5;
                        boolean bl7 = false;
                        bl3 = Intrinsics.areEqual((Object)filters.testPredicate(it), (Object)true);
                    } else {
                        bl3 = true;
                    }
                    bl = bl3;
                    JsonNode jsonNode9 = item.get("jdk_version_major");
                    if (jsonNode9 == null) {
                        return CollectionsKt.emptyList();
                    }
                    n = jsonNode9.asInt();
                    JsonNode jsonNode10 = item.get("jdk_version");
                    String string14 = string13 = jsonNode10 != null ? jsonNode10.asText() : null;
                    if (string14 == null) {
                        return CollectionsKt.emptyList();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"item[\"jdk_version\"]?.asT\u2026t() ?: return emptyList()");
                    string12 = string13;
                    JsonNode jsonNode11 = item.get("jdk_vendor_version");
                    string13 = jsonNode11 != null ? jsonNode11.asText() : null;
                    JsonNode jsonNode12 = item.get("suggested_sdk_name");
                    String string15 = string11 = jsonNode12 != null ? jsonNode12.asText() : null;
                    if (string15 == null) {
                        return CollectionsKt.emptyList();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"item[\"suggested_sdk_name\u2026t() ?: return emptyList()");
                    string10 = string11;
                    JsonNode jsonNode13 = pkg.get("os");
                    String string16 = string9 = jsonNode13 != null ? jsonNode13.asText() : null;
                    if (string16 == null) {
                        return CollectionsKt.emptyList();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"pkg[\"os\"]?.asText() ?: return emptyList()");
                    string11 = string9;
                    JsonNode jsonNode14 = pkg.get("arch");
                    String string17 = string8 = jsonNode14 != null ? jsonNode14.asText() : null;
                    if (string17 == null) {
                        return CollectionsKt.emptyList();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"pkg[\"arch\"]?.asText() ?: return emptyList()");
                    string9 = string8;
                    object2 = pkg.get("package_type");
                    if (object2 == null || (object2 = (string7 = object2.asText())) == null) break block30;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"asText()");
                    String string18 = string7;
                    object = JdkPackageType.Companion;
                    String p02 = string18;
                    boolean bl8 = false;
                    JdkPackageType jdkPackageType = ((JdkPackageType.Companion)object).findType(p02);
                    object2 = jdkPackageType;
                    if (jdkPackageType != null) break block31;
                }
                return CollectionsKt.emptyList();
            }
            string8 = object2;
            JsonNode jsonNode15 = pkg.get("url");
            String string19 = string7 = jsonNode15 != null ? jsonNode15.asText() : null;
            if (string19 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"pkg[\"url\"]?.asText() ?: return emptyList()");
            String string20 = string7;
            JsonNode jsonNode16 = pkg.get("sha256");
            String string21 = string6 = jsonNode16 != null ? jsonNode16.asText() : null;
            if (string21 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"pkg[\"sha256\"]?.asText() ?: return emptyList()");
            string7 = string6;
            JsonNode jsonNode17 = pkg.get("archive_size");
            if (jsonNode17 == null) {
                return CollectionsKt.emptyList();
            }
            long l = jsonNode17.asLong();
            JsonNode jsonNode18 = pkg.get("archive_file_name");
            String string22 = string5 = jsonNode18 != null ? jsonNode18.asText() : null;
            if (string22 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"pkg[\"archive_file_name\"]\u2026t() ?: return emptyList()");
            object = string5;
            JsonNode jsonNode19 = pkg.get("package_root_prefix");
            String string23 = string4 = jsonNode19 != null ? jsonNode19.asText() : null;
            if (string23 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"pkg[\"package_root_prefix\u2026t() ?: return emptyList()");
            string5 = string4;
            JsonNode jsonNode20 = pkg.get("package_to_java_home_prefix");
            String string24 = string3 = jsonNode20 != null ? jsonNode20.asText() : null;
            if (string24 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"pkg[\"package_to_java_hom\u2026t() ?: return emptyList()");
            string4 = string3;
            JsonNode jsonNode21 = pkg.get("unpacked_size");
            if (jsonNode21 == null) {
                return CollectionsKt.emptyList();
            }
            long l2 = jsonNode21.asLong();
            JsonNode jsonNode22 = pkg.get("install_folder_name");
            Object object3 = jsonNode22 != null ? jsonNode22.asText() : null;
            String string25 = object3;
            if (string25 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"pkg[\"install_folder_name\u2026t() ?: return emptyList()");
            String string26 = object3;
            JsonNode jsonNode23 = item.get("shared_index_aliases");
            ArrayNode arrayNode2 = jsonNode23 instanceof ArrayNode ? (ArrayNode)jsonNode23 : null;
            if (arrayNode2 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)arrayNode2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl9 = false;
                    JsonNode it = (JsonNode)element$iv$iv;
                    boolean bl10 = false;
                    if (it.asText() == null) continue;
                    boolean bl11 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            object3 = list2;
            collection.add(new JdkItem(product, bl2, bl, n, string12, string13, string10, string11, string9, (JdkPackageType)((Object)string8), string20, string7, l, l2, string5, string4, (String)object, string26, (List<String>)object3, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(contents){
                final /* synthetic */ byte[] $contents;
                {
                    this.$contents = $contents;
                    super(1);
                }

                public final void invoke(@NotNull Path file2) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Intrinsics.checkNotNullExpressionValue((Object)this.$contents, (String)"contents");
                    PathKt.write$default(file2, this.$contents, 0, 0, 6, null);
                }
            })));
        }
        return (List)destination$iv$iv;
    }
}

