/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirement;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.util.lang.JavaVersion;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements;", "", "()V", "JAVA_VERSION_REGEX", "Lkotlin/text/Regex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseRequirement", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirement;", "request", "", "namePredicate", "versionStringPredicate", "Ljava/util/function/Predicate;", "homePredicate", "sameMajorVersionMatcher", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "parsed", "Lcom/intellij/util/lang/JavaVersion;", "strictVersionMatcher", "VersionMatcher", "VersionRequirement", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkRequirement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkRequirement.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,187:1\n1#2:188\n10#3:189\n*S KotlinDebug\n*F\n+ 1 JdkRequirement.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements\n*L\n19#1:189\n*E\n"})
public final class JdkRequirements {
    @NotNull
    public static final JdkRequirements INSTANCE = new JdkRequirements();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex JAVA_VERSION_REGEX;

    private JdkRequirements() {
    }

    private final VersionMatcher sameMajorVersionMatcher(JavaVersion parsed) {
        return new VersionMatcher(parsed){
            final /* synthetic */ JavaVersion $parsed;
            {
                this.$parsed = $parsed;
            }

            @NotNull
            public String toString() {
                return "it >= " + this.$parsed + " && same major version";
            }

            public boolean matchVersion(@NotNull String versionString) {
                Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                JavaVersion javaVersion = JavaVersion.tryParse(versionString);
                if (javaVersion == null) {
                    return false;
                }
                JavaVersion it = javaVersion;
                return it.compareTo(this.$parsed) >= 0 && it.feature == this.$parsed.feature;
            }
        };
    }

    private final VersionMatcher strictVersionMatcher(JavaVersion parsed) {
        return new VersionMatcher(parsed){
            final /* synthetic */ JavaVersion $parsed;
            {
                this.$parsed = $parsed;
            }

            @NotNull
            public String toString() {
                return "it == " + this.$parsed;
            }

            public boolean matchVersion(@NotNull String versionString) {
                Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                JavaVersion javaVersion = JavaVersion.tryParse(versionString);
                if (javaVersion == null) {
                    return false;
                }
                JavaVersion it = javaVersion;
                return Intrinsics.areEqual((Object)it, (Object)this.$parsed);
            }
        };
    }

    @Nullable
    public final JdkRequirement parseRequirement(@Nullable String namePredicate, @Nullable Predicate<String> versionStringPredicate, @Nullable Predicate<String> homePredicate) {
        JdkRequirement nameFilter;
        String string2 = namePredicate;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            v1 = INSTANCE.parseRequirement(it);
        } else {
            v1 = nameFilter = null;
        }
        if (versionStringPredicate == null && nameFilter == null) {
            return null;
        }
        return new JdkRequirement(nameFilter, homePredicate, versionStringPredicate){
            final /* synthetic */ JdkRequirement $nameFilter;
            final /* synthetic */ Predicate<String> $homePredicate;
            final /* synthetic */ Predicate<String> $versionStringPredicate;
            {
                this.$nameFilter = $nameFilter;
                this.$homePredicate = $homePredicate;
                this.$versionStringPredicate = $versionStringPredicate;
            }

            public boolean matches(@NotNull Sdk sdk2) {
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                if (this.$nameFilter != null && !this.$nameFilter.matches(sdk2)) {
                    return false;
                }
                if (this.$homePredicate != null) {
                    String string2 = sdk2.getHomePath();
                    if (string2 == null) {
                        return false;
                    }
                    String homePath = string2;
                    if (!this.$homePredicate.test(homePath)) {
                        return false;
                    }
                }
                if (this.$versionStringPredicate != null) {
                    String string3 = sdk2.getVersionString();
                    if (string3 == null) {
                        return false;
                    }
                    String versionString = string3;
                    if (!this.$versionStringPredicate.test(versionString)) {
                        return false;
                    }
                }
                return true;
            }

            public boolean matches(@NotNull JdkItem sdk2) {
                String versionString;
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                if (this.$nameFilter != null && !this.$nameFilter.matches(sdk2)) {
                    return false;
                }
                return this.$versionStringPredicate == null || this.$versionStringPredicate.test(versionString = sdk2.getVersionString());
            }

            public boolean matches(@NotNull UnknownSdkLocalSdkFix sdk2) {
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                if (this.$nameFilter != null && !this.$nameFilter.matches(sdk2)) {
                    return false;
                }
                if (this.$homePredicate != null) {
                    String string2 = sdk2.getExistingSdkHome();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdk.existingSdkHome");
                    String homePath = string2;
                    if (!this.$homePredicate.test(homePath)) {
                        return false;
                    }
                }
                if (this.$versionStringPredicate != null) {
                    String string3 = sdk2.getVersionString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sdk.versionString");
                    String versionString = string3;
                    if (!this.$versionStringPredicate.test(versionString)) {
                        return false;
                    }
                }
                return true;
            }

            @NotNull
            public String toString() {
                return SequencesKt.joinToString$default((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this.$nameFilter, this.$homePredicate, this.$versionStringPredicate, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ JdkRequirement $nameFilter;
                    final /* synthetic */ Predicate<String> $homePredicate;
                    final /* synthetic */ Predicate<String> $versionStringPredicate;
                    {
                        this.$nameFilter = $nameFilter;
                        this.$homePredicate = $homePredicate;
                        this.$versionStringPredicate = $versionStringPredicate;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                if (this.$nameFilter != null) {
                                    this.L$0 = $this$sequence;
                                    this.label = 1;
                                    v0 = $this$sequence.yield((Object)String.valueOf(this.$nameFilter), (Continuation)this);
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl17
                            }
                            case 1: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                if (this.$homePredicate != null) {
                                    this.L$0 = $this$sequence;
                                    this.label = 2;
                                    v1 = $this$sequence.yield((Object)("homePredicate: " + this.$homePredicate), (Continuation)this);
                                    if (v1 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl28
                            }
                            case 2: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl28:
                                // 2 sources

                                if (this.$versionStringPredicate != null) {
                                    this.L$0 = null;
                                    this.label = 3;
                                    v2 = $this$sequence.yield((Object)("versionPredicate: " + this.$versionStringPredicate), (Continuation)this);
                                    if (v2 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl38
                            }
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl38:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (CharSequence)", ", (CharSequence)"JdkRequirement:{ ", (CharSequence)"}", (int)0, null, null, (int)56, null);
            }
        };
    }

    @Nullable
    public final JdkRequirement parseRequirement(@NotNull String request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        try {
            KFunction versionMatcher2 = StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)request2)).toString(), (String)"=", (boolean)false, (int)2, null) ? (KFunction)new Function1<JavaVersion, VersionMatcher>((Object)this){

                @NotNull
                public final VersionMatcher invoke(@NotNull JavaVersion p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return JdkRequirements.access$strictVersionMatcher((JdkRequirements)this.receiver, p0);
                }
            } : (KFunction)new Function1<JavaVersion, VersionMatcher>((Object)this){

                @NotNull
                public final VersionMatcher invoke(@NotNull JavaVersion p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return JdkRequirements.access$sameMajorVersionMatcher((JdkRequirements)this.receiver, p0);
                }
            };
            char[] cArray = new char[]{'='};
            String text2 = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.trimStart((String)request2, (char[])cArray), (String)"(", null, (int)2, null))).toString();
            JdkRequirements $this$parseRequirement_u24lambda_u241 = this;
            boolean bl = false;
            char[] cArray2 = new char[]{'-', ' '};
            int idx = StringsKt.lastIndexOfAny$default((CharSequence)text2, (char[])cArray2, (int)0, (boolean)false, (int)6, null);
            if (idx >= 0 && idx + 1 < text2.length()) {
                String string2 = text2.substring(0, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String vendor = string2;
                String string3 = text2.substring(idx + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                String version = string3;
                if (JAVA_VERSION_REGEX.matches((CharSequence)version)) {
                    JavaVersion javaVersion = JavaVersion.tryParse(version);
                    if (javaVersion != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return@run");
                        JavaVersion javaVersion2 = javaVersion;
                        VersionMatcher matcher = (VersionMatcher)((Function1)versionMatcher2).invoke((Object)javaVersion2);
                        return new VersionRequirement(matcher, vendor){
                            final /* synthetic */ VersionMatcher $matcher;
                            final /* synthetic */ String $vendor;
                            {
                                this.$matcher = $matcher;
                                this.$vendor = $vendor;
                                super($matcher);
                            }

                            public final boolean matchesVendor(@NotNull String home2) {
                                JdkVersionDetector.JdkVersionInfo jdkVersionInfo;
                                Intrinsics.checkNotNullParameter((Object)home2, (String)"home");
                                JdkItem jdkItem = JdkInstaller.Companion.getInstance().findJdkItemForInstalledJdk(home2);
                                return (jdkItem != null ? jdkItem.matchesVendor(this.$vendor) : false) || Intrinsics.areEqual((Object)((jdkVersionInfo = SdkVersionUtil.getJdkVersionInfo((String)home2)) != null && (jdkVersionInfo = jdkVersionInfo.variant) != null ? jdkVersionInfo.prefix : null), (Object)this.$vendor);
                            }

                            public final boolean matchesVendor(@NotNull Sdk sdk2) {
                                boolean bl;
                                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                String string2 = sdk2.getHomePath();
                                if (string2 != null) {
                                    String it = string2;
                                    boolean bl2 = false;
                                    bl = this.matchesVendor(it);
                                } else {
                                    bl = false;
                                }
                                return bl;
                            }

                            public final boolean matchesVendor(@NotNull UnknownSdkLocalSdkFix sdk2) {
                                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                String string2 = sdk2.getExistingSdkHome();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdk.existingSdkHome");
                                return this.matchesVendor(string2);
                            }

                            public boolean matches(@NotNull Sdk sdk2) {
                                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                return super.matches(sdk2) && this.matchesVendor(sdk2);
                            }

                            public boolean matches(@NotNull UnknownSdkLocalSdkFix sdk2) {
                                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                return super.matches(sdk2) && this.matchesVendor(sdk2);
                            }

                            public boolean matches(@NotNull JdkItem sdk2) {
                                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                return super.matches(sdk2) && sdk2.matchesVendor(this.$vendor);
                            }

                            @NotNull
                            public String toString() {
                                return "JdkRequirement { " + this.$vendor + " && " + this.$matcher + " }";
                            }
                        };
                    }
                }
            }
            JdkRequirements $this$parseRequirement_u24lambda_u242 = this;
            boolean bl2 = false;
            if (JAVA_VERSION_REGEX.matches((CharSequence)text2)) {
                JavaVersion javaVersion = JavaVersion.tryParse(text2);
                if (javaVersion != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(text) ?: return@run");
                    JavaVersion javaVersion3 = javaVersion;
                    VersionMatcher matcher = (VersionMatcher)((Function1)versionMatcher2).invoke((Object)javaVersion3);
                    return new VersionRequirement(matcher){
                        final /* synthetic */ VersionMatcher $matcher;
                        {
                            this.$matcher = $matcher;
                            super($matcher);
                        }

                        @NotNull
                        public String toString() {
                            return "JdkRequirement { " + this.$matcher + " }";
                        }
                    };
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to parse requirement " + request2 + ". " + t.getMessage(), t);
        }
        return null;
    }

    public static final /* synthetic */ VersionMatcher access$strictVersionMatcher(JdkRequirements $this, JavaVersion parsed) {
        return $this.strictVersionMatcher(parsed);
    }

    public static final /* synthetic */ VersionMatcher access$sameMajorVersionMatcher(JdkRequirements $this, JavaVersion parsed) {
        return $this.sameMajorVersionMatcher(parsed);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JdkRequirements.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        JAVA_VERSION_REGEX = new Regex("^(9|[1-9][1-9]|)(\\.0(\\.\\d+)?)?|1\\.\\d(\\.0(_\\d+)?)?|8$");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "", "matchVersion", "", "versionString", "", "toString", "intellij.platform.lang.impl"})
    private static interface VersionMatcher {
        public boolean matchVersion(@NotNull String var1);

        @NotNull
        public String toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionRequirement;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirement;", "matcher", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;)V", "getMatcher", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "matches", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkLocalSdkFix;", "version", "", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nJdkRequirement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkRequirement.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionRequirement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
    private static class VersionRequirement
    implements JdkRequirement {
        @NotNull
        private final VersionMatcher matcher;

        public VersionRequirement(@NotNull VersionMatcher matcher) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            this.matcher = matcher;
        }

        @NotNull
        public final VersionMatcher getMatcher() {
            return this.matcher;
        }

        public final boolean matches(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.matcher.matchVersion(version);
        }

        @Override
        public boolean matches(@NotNull Sdk sdk2) {
            boolean bl;
            Object $this$matches_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            Object object = this;
            try {
                $this$matches_u24lambda_u240 = object;
                boolean bl2 = false;
                $this$matches_u24lambda_u240 = Result.constructor-impl((Object)sdk2.getVersionString());
            }
            catch (Throwable bl2) {
                $this$matches_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$matches_u24lambda_u240;
            String string2 = (String)(Result.isFailure-impl((Object)object) ? null : object);
            if (string2 != null) {
                String it = string2;
                boolean bl3 = false;
                bl = this.matches(it);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean matches(@NotNull JdkItem sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            return this.matches(sdk2.getVersionString());
        }

        @Override
        public boolean matches(@NotNull UnknownSdkLocalSdkFix sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            String string2 = sdk2.getVersionString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdk.versionString");
            return this.matcher.matchVersion(string2);
        }
    }
}

