/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdateNotificationKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u000245B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u001cH\u0002J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u0000H\u0002J\u0006\u0010+\u001a\u00020\u000bJ\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\tJ\u0010\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\u0005H\u0002J\u0012\u00102\u001a\u00020\u000b2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0000J\f\u00103\u001a\u00020\t*\u00020\u001cH\u0002R\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010 \u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010#\u001a\u00060$R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;", "", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "oldItem", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "newItem", "whenComplete", "Lkotlin/Function1;", "", "showVendorVersion", "", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;Lkotlin/jvm/functions/Function1;Z)V", "isUpdateActionVisible", "()Z", "getJdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "jdkHome", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/Nullable;", "jdkVersion", "Lcom/intellij/openapi/util/NlsSafe;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "myIsTerminated", "myIsUpdateRunning", "myRetryNotification", "Lcom/intellij/notification/Notification;", "getNewItem", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "getOldItem", "persistentId", "getPersistentId", "()Ljava/lang/String;", "updateAction", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$JdkUpdateSuggestionAction;", "getUpdateAction", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$JdkUpdateSuggestionAction;", "bindNextNotification", "notification", "isSameNotification", "other", "isTerminated", "performUpdateAction", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "reachTerminalState", "showUpdateErrorNotification", "feedItem", "tryReplaceWithNewerNotification", "bindNextNotificationAndShow", "InstallUpdateNotification", "JdkUpdateSuggestionAction", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkUpdateNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkUpdateNotification.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
public final class JdkUpdateNotification {
    @NotNull
    private final Sdk jdk;
    @NotNull
    private final JdkItem oldItem;
    @NotNull
    private final JdkItem newItem;
    @NotNull
    private final Function1<JdkUpdateNotification, Unit> whenComplete;
    private final boolean showVendorVersion;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private final String jdkVersion;
    @Nullable
    private final String jdkHome;
    private boolean myIsTerminated;
    private boolean myIsUpdateRunning;
    @Nullable
    private Notification myRetryNotification;
    @NotNull
    private final String persistentId;
    @NotNull
    private final JdkUpdateSuggestionAction updateAction;

    public JdkUpdateNotification(@NotNull Sdk jdk, @NotNull JdkItem oldItem, @NotNull JdkItem newItem, @NotNull Function1<? super JdkUpdateNotification, Unit> whenComplete, boolean showVendorVersion) {
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        Intrinsics.checkNotNullParameter(whenComplete, (String)"whenComplete");
        this.jdk = jdk;
        this.oldItem = oldItem;
        this.newItem = newItem;
        this.whenComplete = whenComplete;
        this.showVendorVersion = showVendorVersion;
        this.lock = new ReentrantLock();
        this.jdkVersion = this.jdk.getVersionString();
        this.jdkHome = this.jdk.getHomePath();
        this.persistentId = this.jdk.getName() + "-" + this.oldItem.getFullPresentationText() + "-" + this.newItem.getFullPresentationText() + "-" + this.jdk.getHomePath();
        this.updateAction = new JdkUpdateSuggestionAction();
    }

    public /* synthetic */ JdkUpdateNotification(Sdk sdk2, JdkItem jdkItem, JdkItem jdkItem2, Function1 function1, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(sdk2, jdkItem, jdkItem2, (Function1<? super JdkUpdateNotification, Unit>)function1, bl);
    }

    @NotNull
    public final Sdk getJdk() {
        return this.jdk;
    }

    @NotNull
    public final JdkItem getOldItem() {
        return this.oldItem;
    }

    @NotNull
    public final JdkItem getNewItem() {
        return this.newItem;
    }

    @NotNull
    public final String getPersistentId() {
        return this.persistentId;
    }

    private final void bindNextNotificationAndShow(Notification $this$bindNextNotificationAndShow) {
        this.bindNextNotification($this$bindNextNotificationAndShow);
        $this$bindNextNotificationAndShow.notify(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void bindNextNotification(Notification notification) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Notification notification2 = this.myRetryNotification;
            if (notification2 != null) {
                notification2.expire();
            }
            notification.whenExpired(() -> JdkUpdateNotification.bindNextNotification$lambda$2$lambda$1(this, notification));
            this.myRetryNotification = notification;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryReplaceWithNewerNotification(@Nullable JdkUpdateNotification other) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myIsUpdateRunning) {
                boolean bl2 = false;
                return bl2;
            }
            if (other != null && this.isSameNotification(other)) {
                boolean bl3 = false;
                return bl3;
            }
            Notification notification = this.myRetryNotification;
            if (notification != null) {
                notification.expire();
            }
            this.myRetryNotification = null;
            this.reachTerminalState();
            boolean bl4 = true;
            return bl4;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ boolean tryReplaceWithNewerNotification$default(JdkUpdateNotification jdkUpdateNotification, JdkUpdateNotification jdkUpdateNotification2, int n, Object object) {
        if ((n & 1) != 0) {
            jdkUpdateNotification2 = null;
        }
        return jdkUpdateNotification.tryReplaceWithNewerNotification(jdkUpdateNotification2);
    }

    private final boolean isSameNotification(JdkUpdateNotification other) {
        if (!Intrinsics.areEqual((Object)this.jdkVersion, (Object)other.jdkVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jdkHome, (Object)other.jdkHome)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.newItem, (Object)other.newItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reachTerminalState() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myIsTerminated) {
                return;
            }
            this.myIsTerminated = true;
            this.whenComplete.invoke((Object)this);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isTerminated() {
        boolean bl;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl2 = false;
            bl = this.myIsTerminated;
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    @NotNull
    public final JdkUpdateSuggestionAction getUpdateAction() {
        return this.updateAction;
    }

    public final boolean isUpdateActionVisible() {
        return !this.myIsUpdateRunning && !this.myIsTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void showUpdateErrorNotification(JdkItem feedItem) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("JDK Update Error");
            Object[] objectArray = new Object[]{this.jdk.getName(), feedItem.getFullPresentationText()};
            String string2 = ProjectBundle.message((String)"progress.title.updating.jdk.0.to.1", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"progress.title.\u2026tem.fullPresentationText)");
            objectArray = new Object[]{feedItem.getFullPresentationText()};
            String string3 = ProjectBundle.message((String)"progress.title.updating.jdk.failed", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"progress.title.\u2026tem.fullPresentationText)");
            Notification notification = notificationGroup.createNotification(string2, string3, NotificationType.ERROR).addAction((AnAction)new InstallUpdateNotification());
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"getInstance().getNotific\u2026tallUpdateNotification())");
            this.bindNextNotificationAndShow(notification);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performUpdateAction(AnActionEvent e) {
        Object object;
        Notification notification = this.myRetryNotification;
        if (notification != null) {
            notification.expire();
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.myIsUpdateRunning) {
                return;
            }
            this.myIsUpdateRunning = true;
            object = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        Object[] objectArray = new Object[]{this.jdk.getName(), this.newItem.getFullPresentationText()};
        String string2 = ProjectBundle.message((String)"progress.title.updating.jdk.0.to.1", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"progress.title.\u2026tem.fullPresentationText)");
        String title = string2;
        object = Task.Backgroundable.ALWAYS_BACKGROUND;
        ProgressManager.getInstance().run(new Task.Backgroundable(title, this, e, (PerformInBackgroundOption)object){
            final /* synthetic */ JdkUpdateNotification this$0;
            final /* synthetic */ AnActionEvent $e;
            {
                this.this$0 = $receiver;
                this.$e = $e;
                super(null, $title, true, $super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Path path2;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    JdkInstaller installer = JdkInstaller.Companion.getInstance();
                    JdkInstallRequest request2 = installer.prepareJdkInstallation(this.this$0.getNewItem(), installer.defaultInstallDir(this.this$0.getNewItem()));
                    installer.installJdk(request2, indicator, this.$e.getProject());
                    indicator.setText(ProjectBundle.message((String)"progress.text.updating.jdk.setting.up", (Object[])new Object[0]));
                    File[] fileArray = new File[]{request2.getInstallDir().toFile()};
                    VfsUtil.markDirtyAndRefresh(false, true, true, fileArray);
                    path2 = request2.getJavaHome();
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        this.this$0.reachTerminalState();
                        throw t;
                    }
                    JdkUpdateNotificationKt.access$getLOG$p().warn("Failed to update " + this.this$0.getJdk() + " to " + this.this$0.getNewItem() + ". " + t.getMessage(), t);
                    JdkUpdateNotification.access$showUpdateErrorNotification(this.this$0, this.this$0.getNewItem());
                    Lock lock = JdkUpdateNotification.access$getLock$p(this.this$0);
                    JdkUpdateNotification jdkUpdateNotification = this.this$0;
                    lock.lock();
                    try {
                        boolean bl = false;
                        JdkUpdateNotification.access$setMyIsUpdateRunning$p(jdkUpdateNotification, false);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                    return;
                }
                Path newJdkHome = path2;
                ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this.this$0, newJdkHome){
                    final /* synthetic */ JdkUpdateNotification this$0;
                    final /* synthetic */ Path $newJdkHome;
                    {
                        this.this$0 = $receiver;
                        this.$newJdkHome = $newJdkHome;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        try {
                            ActionsKt.runWriteAction((Function0)new Function0<Unit>(this.this$0, this.$newJdkHome){
                                final /* synthetic */ JdkUpdateNotification this$0;
                                final /* synthetic */ Path $newJdkHome;
                                {
                                    this.this$0 = $receiver;
                                    this.$newJdkHome = $newJdkHome;
                                    super(0);
                                }

                                public final void invoke() {
                                    SdkModificator sdkModificator = this.this$0.getJdk().getSdkModificator();
                                    Object object = this.$newJdkHome;
                                    JdkUpdateNotification jdkUpdateNotification = this.this$0;
                                    SdkModificator $this$invoke_u24lambda_u240 = sdkModificator;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u240.removeAllRoots();
                                    $this$invoke_u24lambda_u240.setHomePath(PathKt.getSystemIndependentPath((Path)object));
                                    $this$invoke_u24lambda_u240.setVersionString(jdkUpdateNotification.getNewItem().getVersionString());
                                    sdkModificator.commitChanges();
                                    object = this.this$0.getJdk().getSdkType();
                                    SdkType sdkType = object instanceof SdkType ? (SdkType)object : null;
                                    if (sdkType != null) {
                                        sdkType.setupSdkPaths(this.this$0.getJdk());
                                    }
                                    this.this$0.reachTerminalState();
                                }
                            });
                        }
                        catch (Throwable t) {
                            if (t instanceof ControlFlowException) {
                                this.this$0.reachTerminalState();
                                throw t;
                            }
                            JdkUpdateNotificationKt.access$getLOG$p().warn("Failed to apply downloaded JDK update for " + this.this$0.getJdk() + " from " + this.this$0.getNewItem() + " at " + this.$newJdkHome + ". " + t.getMessage(), t);
                            JdkUpdateNotification.access$showUpdateErrorNotification(this.this$0, this.this$0.getNewItem());
                            Lock lock = JdkUpdateNotification.access$getLock$p(this.this$0);
                            JdkUpdateNotification jdkUpdateNotification = this.this$0;
                            lock.lock();
                            try {
                                boolean bl = false;
                                JdkUpdateNotification.access$setMyIsUpdateRunning$p(jdkUpdateNotification, false);
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    }
                }, 1, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void bindNextNotification$lambda$2$lambda$1(JdkUpdateNotification this$0, Notification $notification) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this$0.myRetryNotification == $notification) {
                this$0.myRetryNotification = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static final /* synthetic */ void access$showUpdateErrorNotification(JdkUpdateNotification $this, JdkItem feedItem) {
        $this.showUpdateErrorNotification(feedItem);
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(JdkUpdateNotification $this) {
        return $this.lock;
    }

    public static final /* synthetic */ void access$setMyIsUpdateRunning$p(JdkUpdateNotification $this, boolean bl) {
        $this.myIsUpdateRunning = bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$JdkUpdateSuggestionAction;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$UpdateAction;", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;)V", "jdkUpdateNotification", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;", "getJdkUpdateNotification", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.lang.impl"})
    public final class JdkUpdateSuggestionAction
    extends SettingsEntryPointAction.UpdateAction {
        @NotNull
        private final JdkUpdateNotification jdkUpdateNotification;

        public JdkUpdateSuggestionAction() {
            this.jdkUpdateNotification = JdkUpdateNotification.this;
            Object[] objectArray = new Object[]{JdkUpdateNotification.this.getJdk().getName(), JdkUpdateNotification.this.showVendorVersion ? JdkUpdateNotification.this.getNewItem().getFullPresentationWithVendorText() : JdkUpdateNotification.this.getNewItem().getFullPresentationText(), JdkUpdateNotification.this.getOldItem().getVersionPresentationText()};
            this.getTemplatePresentation().setText(ProjectBundle.message((String)"action.title.jdk.update.found", (Object[])objectArray));
            objectArray = new Object[]{JdkUpdateNotification.this.getJdk().getName(), JdkUpdateNotification.this.getNewItem().getFullPresentationText(), JdkUpdateNotification.this.getOldItem().getVersionPresentationText()};
            this.getTemplatePresentation().setDescription(ProjectBundle.message((String)"action.description.jdk.update.found", (Object[])objectArray));
        }

        @NotNull
        public final JdkUpdateNotification getJdkUpdateNotification() {
            return this.jdkUpdateNotification;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(JdkUpdateNotification.this.isUpdateActionVisible());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JdkUpdateNotification.this.performUpdateAction(e);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification$InstallUpdateNotification;", "Lcom/intellij/notification/NotificationAction;", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdateNotification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.platform.lang.impl"})
    public final class InstallUpdateNotification
    extends NotificationAction {
        public InstallUpdateNotification() {
            super(ProjectBundle.message((String)"notification.link.jdk.update.retry", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            JdkUpdateNotification.this.performUpdateAction(e);
            notification.expire();
        }
    }
}

