/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.ProjectTopics;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkContributor;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTrackerTask;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdateCheckContributor;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdaterKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdaterNotifications;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdatesCollectorQueue;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0006\u0010\n\u001a\u00020\u0006J\u001e\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011\u00b2\u0006\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u008a\u0084\u0002"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdatesCollector;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dispose", "", "isEnabled", "", "schedule", "updateNotifications", "updateWithSnapshot", "knownSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lang.impl", "jdkFeed", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;"})
@SourceDebugExtension(value={"SMAP\nJdkUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkUpdater.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdatesCollector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n29#2,3:203\n39#3,3:206\n288#4,2:209\n*S KotlinDebug\n*F\n+ 1 JdkUpdater.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdatesCollector\n*L\n125#1:203,3\n174#1:206,3\n179#1:209,2\n*E\n"})
public final class JdkUpdatesCollector
implements Disposable {
    @NotNull
    private final Project project;

    public JdkUpdatesCollector(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.schedule();
    }

    @Override
    public void dispose() {
    }

    private final boolean isEnabled() {
        return JdkUpdaterKt.access$isEnabled(this.project);
    }

    private final void schedule() {
        if (!this.isEnabled()) {
            return;
        }
        ScheduledFuture<?> future = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> JdkUpdatesCollector.schedule$lambda$0(this), 12L, 12L, TimeUnit.HOURS);
        Disposer.register(this, () -> JdkUpdatesCollector.schedule$lambda$1(future));
        AtomicLong myLastKnownModificationId = new AtomicLong(-100500L);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this);
        Topic<ModuleRootListener> topic = ProjectTopics.PROJECT_ROOTS;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"PROJECT_ROOTS");
        messageBusConnection.subscribe(topic, new ModuleRootListener(this, myLastKnownModificationId){
            final /* synthetic */ JdkUpdatesCollector this$0;
            final /* synthetic */ AtomicLong $myLastKnownModificationId;
            {
                this.this$0 = $receiver;
                this.$myLastKnownModificationId = $myLastKnownModificationId;
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.isCausedByFileTypesChange()) {
                    return;
                }
                long newCounterValue = ProjectRootManager.getInstance(JdkUpdatesCollector.access$getProject$p(this.this$0)).getModificationCount();
                if (this.$myLastKnownModificationId.getAndSet(newCounterValue) == newCounterValue) {
                    return;
                }
                this.this$0.updateNotifications();
            }
        });
    }

    public final void updateNotifications() {
        if (!this.isEnabled()) {
            return;
        }
        ComponentManager $this$service$iv = this.project;
        boolean $i$f$service = false;
        Class<JdkUpdatesCollectorQueue> serviceClass$iv = JdkUpdatesCollectorQueue.class;
        JdkUpdatesCollectorQueue jdkUpdatesCollectorQueue = $this$service$iv.getService(serviceClass$iv);
        if (jdkUpdatesCollectorQueue == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        jdkUpdatesCollectorQueue.queue(new UnknownSdkTrackerTask(this){
            final /* synthetic */ JdkUpdatesCollector this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public UnknownSdkCollector createCollector() {
                if (!JdkUpdatesCollector.access$isEnabled(this.this$0)) {
                    return null;
                }
                Project project2 = JdkUpdatesCollector.access$getProject$p(this.this$0);
                return new UnknownSdkCollector(project2){

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    protected List<UnknownSdkContributor> getContributors() {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = JdkUpdaterKt.access$getEP_NAME$p().getExtensionList();
                        Collection collection = super.getContributors();
                        boolean $i$f$map = false;
                        void var3_4 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            JdkUpdateCheckContributor jdkUpdateCheckContributor = (JdkUpdateCheckContributor)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl = false;
                            collection2.add(new UnknownSdkContributor((JdkUpdateCheckContributor)it){
                                final /* synthetic */ JdkUpdateCheckContributor $it;
                                {
                                    this.$it = $it;
                                }

                                @NotNull
                                public List<UnknownSdk> contributeUnknownSdks(@NotNull Project project2) {
                                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                                    return CollectionsKt.emptyList();
                                }

                                @NotNull
                                public List<Sdk> contributeKnownSdks(@NotNull Project project2) {
                                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                                    return this.$it.contributeJdks(project2);
                                }
                            });
                        }
                        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            public void onLookupCompleted(@NotNull UnknownSdkSnapshot snapshot) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                if (!JdkUpdatesCollector.access$isEnabled(this.this$0)) {
                    return;
                }
                Iterable $this$filter$iv = snapshot.getKnownSdks();
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Sdk it = (Sdk)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSdkType() instanceof JavaSdkType && !(it.getSdkType() instanceof DependentSdkType))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List knownSdks = (List)destination$iv$iv;
                if (knownSdks.isEmpty()) {
                    return;
                }
                Project project2 = JdkUpdatesCollector.access$getProject$p(this.this$0);
                String string2 = ProjectBundle.message((String)"progress.title.checking.for.jdk.updates", (Object[])new Object[0]);
                object = Task.Backgroundable.ALWAYS_BACKGROUND;
                ProgressManager.getInstance().run(new Task.Backgroundable(this.this$0, knownSdks, project2, string2, (PerformInBackgroundOption)object){
                    final /* synthetic */ JdkUpdatesCollector this$0;
                    final /* synthetic */ List<Sdk> $knownSdks;
                    {
                        this.this$0 = $receiver;
                        this.$knownSdks = $knownSdks;
                        super($super_call_param$1, $super_call_param$2, true, $super_call_param$3);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)this.$knownSdks);
                        boolean $i$f$sortedBy = false;
                        JdkUpdatesCollector.access$updateWithSnapshot(this.this$0, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                Sdk it = (Sdk)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)it.getName());
                                it = (Sdk)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                            }
                        }), indicator);
                    }
                });
            }
        });
    }

    private final void updateWithSnapshot(List<? extends Sdk> knownSdks, ProgressIndicator indicator) {
        Lazy jdkFeed$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends JdkItem>>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(0);
            }

            @NotNull
            public final List<JdkItem> invoke() {
                JdkListDownloader listDownloader = JdkListDownloader.Companion.getInstance();
                JdkPredicate jdkPredicate = JdkPredicate.Companion.default();
                List items2 = listDownloader.downloadModelForJdkInstaller(this.$indicator, jdkPredicate);
                if (SystemInfo.isWindows) {
                    List list2 = WslDistributionManager.getInstance().getInstalledDistributions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInstance().installedDistributions");
                    if (!((Collection)list2).isEmpty()) {
                        jdkPredicate = JdkPredicate.Companion.forWSL();
                        items2 = CollectionsKt.plus((Collection)items2, (Iterable)listDownloader.downloadModelForJdkInstaller(this.$indicator, jdkPredicate));
                    }
                }
                return CollectionsKt.toList((Iterable)items2);
            }
        }));
        boolean $i$f$service = false;
        Class<JdkUpdaterNotifications> serviceClass$iv = JdkUpdaterNotifications.class;
        JdkUpdaterNotifications jdkUpdaterNotifications = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (jdkUpdaterNotifications == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        JdkUpdaterNotifications notifications = jdkUpdaterNotifications;
        HashSet noUpdatesFor = new HashSet(knownSdks);
        for (Sdk sdk2 : knownSdks) {
            JdkItem feedItem;
            Object v0;
            JdkItem actualItem;
            block5: {
                if (JdkInstaller.Companion.getInstance().findJdkItemForInstalledJdk(sdk2.getHomePath()) == null) continue;
                Iterable $this$firstOrNull$iv = JdkUpdatesCollector.updateWithSnapshot$lambda$2((Lazy<? extends List<JdkItem>>)jdkFeed$delegate);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JdkItem it = (JdkItem)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getSuggestedSdkName(), (Object)actualItem.getSuggestedSdkName()) && Intrinsics.areEqual((Object)it.getArch(), (Object)actualItem.getArch()) && Intrinsics.areEqual((Object)it.getOs(), (Object)actualItem.getOs()))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            if ((JdkItem)v0 == null) continue;
            boolean showVendor = false;
            int comparison = VersionComparatorUtil.compare(feedItem.getJdkVersion(), actualItem.getJdkVersion());
            if (comparison < 0) continue;
            if (comparison == 0) {
                if (feedItem.getJdkVendorVersion() == null || actualItem.getJdkVendorVersion() == null || VersionComparatorUtil.compare(feedItem.getJdkVendorVersion(), actualItem.getJdkVendorVersion()) <= 0) continue;
                showVendor = true;
            }
            notifications.showNotification(sdk2, actualItem, feedItem, showVendor);
            ((Collection)noUpdatesFor).remove(sdk2);
        }
        for (Sdk sdk3 : noUpdatesFor) {
            Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"jdk");
            notifications.hideNotification(sdk3);
        }
    }

    private static final void schedule$lambda$0(JdkUpdatesCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.project.isDisposed()) {
            return;
        }
        try {
            this$0.updateNotifications();
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                return;
            }
            JdkUpdaterKt.access$getLOG$p().warn("Failed to complete JDK Update check. " + t.getMessage(), t);
        }
    }

    private static final void schedule$lambda$1(ScheduledFuture $future) {
        $future.cancel(false);
    }

    private static final List<JdkItem> updateWithSnapshot$lambda$2(Lazy<? extends List<JdkItem>> $jdkFeed$delegate) {
        Lazy<? extends List<JdkItem>> lazy = $jdkFeed$delegate;
        return (List)lazy.getValue();
    }

    public static final /* synthetic */ Project access$getProject$p(JdkUpdatesCollector $this) {
        return $this.project;
    }

    public static final /* synthetic */ boolean access$isEnabled(JdkUpdatesCollector $this) {
        return $this.isEnabled();
    }

    public static final /* synthetic */ void access$updateWithSnapshot(JdkUpdatesCollector $this, List knownSdks, ProgressIndicator indicator) {
        $this.updateWithSnapshot(knownSdks, indicator);
    }
}

