/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderDialogHostExtension;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserCustom;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserCustomItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidatorCallback;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserModel;
import com.intellij.openapi.roots.ui.configuration.SdkPopup;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import java.awt.Component;
import java.nio.file.Path;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserCustom;", "", "()V", "isActionAvailable", "", "()Z", "jdkDownloaderExtension", "com/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserCustom$jdkDownloaderExtension$1", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserCustom$jdkDownloaderExtension$1;", "jdkDownloaderExtensionProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "getJdkDownloaderExtensionProvider", "()Lcom/intellij/openapi/actionSystem/DataProvider;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkType;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkType;", "createSdkChooserPopup", "Lcom/intellij/openapi/roots/ui/configuration/SdkPopup;", "parent", "Ljavax/swing/JComponent;", "model", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserModel;", "importDetectedItem", "", "homePath", "", "importNewItem", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nRuntimeChooserCustom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeChooserCustom.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserCustom\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n3133#2,11:111\n*S KotlinDebug\n*F\n+ 1 RuntimeChooserCustom.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserCustom\n*L\n33#1:111,11\n*E\n"})
public final class RuntimeChooserCustom {
    @NotNull
    public static final RuntimeChooserCustom INSTANCE = new RuntimeChooserCustom();
    @NotNull
    private static final DataProvider jdkDownloaderExtensionProvider = RuntimeChooserCustom::jdkDownloaderExtensionProvider$lambda$0;
    @NotNull
    private static final jdkDownloaderExtension.1 jdkDownloaderExtension = new JdkDownloaderDialogHostExtension(){

        public boolean allowWsl() {
            return false;
        }

        public boolean shouldIncludeItem(@NotNull SdkTypeId sdkType, @NotNull JdkItem item) {
            Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return Intrinsics.areEqual((Object)sdkType, (Object)RuntimeChooserCustom.INSTANCE.getSdkType()) && RuntimeChooserJreValidator.INSTANCE.isSupportedSdkItem(item);
        }
    };

    private RuntimeChooserCustom() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SdkType getSdkType() {
        Object v2;
        block2: {
            void $this$singleOrNull$iv;
            SdkType[] sdkTypeArray = SdkType.getAllTypes();
            Intrinsics.checkNotNullExpressionValue((Object)sdkTypeArray, (String)"getAllTypes()");
            Object[] objectArray = sdkTypeArray;
            Condition condition = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"notSimpleJavaSdkTypeIfAl\u2026sAndNotDependentSdkType()");
            Condition condition2 = condition;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$singleOrNull$iv) {
                SdkTypeId p0 = (SdkTypeId)element$iv;
                boolean bl = false;
                if (!condition2.value(p0)) continue;
                if (found$iv) {
                    v2 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        return v2;
    }

    public final boolean isActionAvailable() {
        return this.getSdkType() != null;
    }

    @NotNull
    public final DataProvider getJdkDownloaderExtensionProvider() {
        return jdkDownloaderExtensionProvider;
    }

    @Nullable
    public final SdkPopup createSdkChooserPopup(@NotNull JComponent parent2, @NotNull RuntimeChooserModel model2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        SdkType sdkType = this.getSdkType();
        if (sdkType == null) {
            return null;
        }
        return SdkPopupFactory.Companion.newBuilder().withSdkType((SdkTypeId)sdkType).withSdkFilter(RuntimeChooserCustom::createSdkChooserPopup$lambda$1).withSuggestedSdkFilter(RuntimeChooserCustom::createSdkChooserPopup$lambda$2).withNoDownlaodActions().onSdkSelected(arg_0 -> RuntimeChooserCustom.createSdkChooserPopup$lambda$3(parent2, model2, arg_0)).buildPopup();
    }

    private final void importNewItem(JComponent parent2, Sdk sdk2, RuntimeChooserModel model2) {
        if (sdk2 == null) {
            return;
        }
        String string2 = LangBundle.message("progress.title.choose.ide.runtime.scanning.jdk", new Object[0]);
        new Task.Modal(sdk2, model2, parent2, string2){
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ RuntimeChooserModel $model;
            final /* synthetic */ JComponent $parent;
            {
                this.$sdk = $sdk;
                this.$model = $model;
                this.$parent = $parent;
                super(null, $super_call_param$1, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RuntimeChooserJreValidator.INSTANCE.testNewJdkUnderProgress(false, (Function0<String>)((Function0)new Function0<String>(this.$sdk){
                    final /* synthetic */ Sdk $sdk;
                    {
                        this.$sdk = $sdk;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        return this.$sdk.getHomePath();
                    }
                }), new RuntimeChooserJreValidatorCallback<Unit>(this.$model, this.$parent){
                    final /* synthetic */ RuntimeChooserModel $model;
                    final /* synthetic */ JComponent $parent;
                    {
                        this.$model = $model;
                        this.$parent = $parent;
                    }

                    public void onSdkResolved(@Nullable String displayName, @NotNull String versionString, @NotNull Path sdkHome) {
                        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                        Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
                        RuntimeChooserCustomItem newItem = new RuntimeChooserCustomItem(displayName, versionString, ((Object)sdkHome).toString());
                        ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this.$model, newItem){
                            final /* synthetic */ RuntimeChooserModel $model;
                            final /* synthetic */ RuntimeChooserCustomItem $newItem;
                            {
                                this.$model = $model;
                                this.$newItem = $newItem;
                                super(0);
                            }

                            public final void invoke() {
                                this.$model.addExistingSdkItem(this.$newItem);
                            }
                        }, 1, null);
                    }

                    public void onError(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this.$parent, message){
                            final /* synthetic */ JComponent $parent;
                            final /* synthetic */ String $message;
                            {
                                this.$parent = $parent;
                                this.$message = $message;
                                super(0);
                            }

                            public final void invoke() {
                                Messages.showErrorDialog((Component)this.$parent, (String)this.$message, (String)LangBundle.message("dialog.title.choose.ide.runtime", new Object[0]));
                            }
                        }, 1, null);
                    }
                });
            }
        }.queue();
    }

    public final void importDetectedItem(@NotNull String homePath, @NotNull RuntimeChooserModel model2) {
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        String string2 = LangBundle.message("progress.title.choose.ide.runtime.scanning.jdk", new Object[0]);
        new Task.Backgroundable(homePath, model2, string2){
            final /* synthetic */ String $homePath;
            final /* synthetic */ RuntimeChooserModel $model;
            {
                this.$homePath = $homePath;
                this.$model = $model;
                super(null, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RuntimeChooserJreValidator.INSTANCE.testNewJdkUnderProgress(false, (Function0<String>)((Function0)new Function0<String>(this.$homePath){
                    final /* synthetic */ String $homePath;
                    {
                        this.$homePath = $homePath;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        return this.$homePath;
                    }
                }), new RuntimeChooserJreValidatorCallback<Unit>(this.$model){
                    final /* synthetic */ RuntimeChooserModel $model;
                    {
                        this.$model = $model;
                    }

                    public void onSdkResolved(@Nullable String displayName, @NotNull String versionString, @NotNull Path sdkHome) {
                        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                        Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
                        RuntimeChooserCustomItem newItem = new RuntimeChooserCustomItem(displayName, versionString, ((Object)sdkHome).toString());
                        ActionsKt.invokeLater(ModalityState.any(), (Function0<Unit>)((Function0)new Function0<Unit>(this.$model, newItem){
                            final /* synthetic */ RuntimeChooserModel $model;
                            final /* synthetic */ RuntimeChooserCustomItem $newItem;
                            {
                                this.$model = $model;
                                this.$newItem = $newItem;
                                super(0);
                            }

                            public final void invoke() {
                                this.$model.addExistingSdkItem(this.$newItem);
                            }
                        }));
                    }

                    public void onError(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    }
                });
            }
        }.queue();
    }

    private static final Object jdkDownloaderExtensionProvider$lambda$0(String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return JdkDownloaderKt.getJDK_DOWNLOADER_EXT().is(dataId) ? jdkDownloaderExtension : null;
    }

    private static final boolean createSdkChooserPopup$lambda$1(Sdk it) {
        return it != null && RuntimeChooserJreValidator.INSTANCE.isSupportedSdkItem(it);
    }

    private static final boolean createSdkChooserPopup$lambda$2(SdkPopupBuilder.SuggestedSdk it) {
        return it != null && RuntimeChooserJreValidator.INSTANCE.isSupportedSdkItem(it);
    }

    private static final void createSdkChooserPopup$lambda$3(JComponent $parent, RuntimeChooserModel $model, Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)$parent, (String)"$parent");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        INSTANCE.importNewItem($parent, sdk2, $model);
    }
}

