/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserAddCustomItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserCurrentItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserCustom;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserCustomItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserDialog;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserDialogResult;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserDownloadableItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserItemWithFixedLocation;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserModelKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserPresenter;
import com.intellij.openapi.roots.ui.configuration.SdkPopup;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.Gaps;
import com.intellij.ui.dsl.gridLayout.GapsKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserModel;)V", "USE_DEFAULT_RUNTIME_CODE", "", "jdkCombobox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserItem;", "jdkInstallDirSelector", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthAdditionalPanel", "Ljavax/swing/JPanel;", "createTitlePane", "getData", "", "dataId", "", "initClipboardListener", "", "showDialogAndGetResult", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserDialogResult;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nRuntimeChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeChooserDialog.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserDialog\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,233:1\n10#2:234\n10#2:235\n*S KotlinDebug\n*F\n+ 1 RuntimeChooserDialog.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserDialog\n*L\n113#1:234\n119#1:235\n*E\n"})
public final class RuntimeChooserDialog
extends DialogWrapper
implements DataProvider {
    @Nullable
    private final Project project;
    @NotNull
    private final RuntimeChooserModel model;
    private final int USE_DEFAULT_RUNTIME_CODE;
    private TextFieldWithBrowseButton jdkInstallDirSelector;
    private ComboBox<RuntimeChooserItem> jdkCombobox;

    public RuntimeChooserDialog(@Nullable Project project2, @NotNull RuntimeChooserModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(project2);
        this.project = project2;
        this.model = model2;
        this.USE_DEFAULT_RUNTIME_CODE = 44;
        this.setTitle(LangBundle.message("dialog.title.choose.ide.runtime", new Object[0]));
        this.setResizable(false);
        this.init();
        this.initClipboardListener();
    }

    private final void initClipboardListener() {
        Set knownPaths = new LinkedHashSet();
        Function0 clipboardUpdateAction2 = (Function0)new Function0<Unit>(this, (Set<String>)knownPaths){
            final /* synthetic */ RuntimeChooserDialog this$0;
            final /* synthetic */ Set<String> $knownPaths;
            {
                this.this$0 = $receiver;
                this.$knownPaths = $knownPaths;
                super(0);
            }

            public final void invoke() {
                Object object;
                Object object2 = this.this$0;
                try {
                    RuntimeChooserDialog $this$invoke_u24lambda_u240 = object2;
                    boolean bl = false;
                    Transferable transferable = CopyPasteManager.getInstance().getContents();
                    Object object3 = transferable != null ? transferable.getTransferData(DataFlavor.stringFlavor) : null;
                    object = Result.constructor-impl((Object)(object3 instanceof String ? (String)object3 : null));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                String newPath = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                object2 = newPath;
                if (!(object2 == null || StringsKt.isBlank((CharSequence)object2)) && this.$knownPaths.add(newPath)) {
                    RuntimeChooserCustom.INSTANCE.importDetectedItem(((Object)StringsKt.trim((CharSequence)newPath)).toString(), RuntimeChooserDialog.access$getModel$p(this.this$0));
                }
            }
        };
        WindowAdapter windowListener2 = new WindowAdapter((Function0<Unit>)clipboardUpdateAction2){
            final /* synthetic */ Function0<Unit> $clipboardUpdateAction;
            {
                this.$clipboardUpdateAction = $clipboardUpdateAction;
            }

            public void windowActivated(@Nullable WindowEvent e) {
                ActionsKt.invokeLater(ModalityState.any(), (Function0<Unit>)((Function0)new Function0<Unit>(this.$clipboardUpdateAction){
                    final /* synthetic */ Function0<Unit> $clipboardUpdateAction;
                    {
                        this.$clipboardUpdateAction = $clipboardUpdateAction;
                        super(0);
                    }

                    public final void invoke() {
                        this.$clipboardUpdateAction.invoke();
                    }
                }));
            }
        };
        Window window = this.getWindow();
        if (window != null) {
            Window window2 = window;
            boolean bl = false;
            window2.addWindowListener(windowListener2);
            Disposer.register(this.getDisposable(), () -> RuntimeChooserDialog.initClipboardListener$lambda$1$lambda$0(window2, windowListener2));
        }
        clipboardUpdateAction2.invoke();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return RuntimeChooserCustom.INSTANCE.getJdkDownloaderExtensionProvider().getData(dataId);
    }

    @NotNull
    protected JPanel createSouthAdditionalPanel() {
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel $this$createSouthAdditionalPanel_u24lambda_u242 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        $this$createSouthAdditionalPanel_u24lambda_u242.addToCenter(this.createJButtonForAction((Action)new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, LangBundle.message("dialog.button.choose.ide.runtime.useDefault", new Object[0]), this.USE_DEFAULT_RUNTIME_CODE)));
        return borderLayoutPanel;
    }

    @NotNull
    public final RuntimeChooserDialogResult showDialogAndGetResult() {
        boolean $i$f$asSafely;
        Object $this$asSafely$iv;
        this.show();
        if (this.getExitCode() == this.USE_DEFAULT_RUNTIME_CODE) {
            return RuntimeChooserDialogResult.UseDefault.INSTANCE;
        }
        if (this.isOK()) {
            Object object;
            RuntimeChooserDialog $this$showDialogAndGetResult_u24lambda_u243 = this;
            boolean bl = false;
            ComboBox<RuntimeChooserItem> comboBox = $this$showDialogAndGetResult_u24lambda_u243.jdkCombobox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"jdkCombobox");
                comboBox = null;
            }
            $this$asSafely$iv = comboBox.getSelectedItem();
            $i$f$asSafely = false;
            Object object2 = $this$asSafely$iv;
            if (!(object2 instanceof RuntimeChooserDownloadableItem)) {
                object2 = null;
            }
            if ((object = (RuntimeChooserDownloadableItem)object2) != null && (object = ((RuntimeChooserDownloadableItem)object).getItem()) != null) {
                Object jdkItem = object;
                RuntimeChooserModel runtimeChooserModel = $this$showDialogAndGetResult_u24lambda_u243.model;
                TextFieldWithBrowseButton textFieldWithBrowseButton = $this$showDialogAndGetResult_u24lambda_u243.jdkInstallDirSelector;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                    textFieldWithBrowseButton = null;
                }
                Path path2 = runtimeChooserModel.getInstallPathFromText((JdkItem)jdkItem, textFieldWithBrowseButton.getText());
                return new RuntimeChooserDialogResult.DownloadAndUse((JdkItem)jdkItem, path2);
            }
        }
        if (this.isOK()) {
            RuntimeChooserDialog $this$showDialogAndGetResult_u24lambda_u244 = this;
            boolean bl = false;
            ComboBox<RuntimeChooserItem> comboBox = $this$showDialogAndGetResult_u24lambda_u244.jdkCombobox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"jdkCombobox");
                comboBox = null;
            }
            $this$asSafely$iv = comboBox.getSelectedItem();
            $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof RuntimeChooserCustomItem)) {
                object = null;
            }
            RuntimeChooserCustomItem runtimeChooserCustomItem = (RuntimeChooserCustomItem)object;
            if (runtimeChooserCustomItem != null) {
                RuntimeChooserCustomItem jdkItem = runtimeChooserCustomItem;
                Path home2 = Paths.get(jdkItem.getHomeDir(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)home2, (String)"home");
                if (PathKt.isDirectory(home2)) {
                    Object[] objectArray = new String[]{jdkItem.getDisplayName(), jdkItem.getVersion()};
                    return new RuntimeChooserDialogResult.UseCustomJdk(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), home2);
                }
            }
        }
        return RuntimeChooserDialogResult.Cancel.INSTANCE;
    }

    @NotNull
    protected JComponent createTitlePane() {
        DialogPanel dialogPanel;
        DialogPanel $this$createTitlePane_u24lambda_u245 = dialogPanel = BuilderKt.panel((Function1)createTitlePane.1.INSTANCE);
        boolean bl = false;
        Border border = SystemInfo.isWindows ? JBUI.Borders.customLine(JBColor.border(), 1, 0, 1, 0) : JBUI.Borders.customLineBottom(JBColor.border());
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"when {\n        SystemInf\u2026JBColor.border())\n      }");
        Border customLine = border;
        $this$createTitlePane_u24lambda_u245.setBorder(JBUI.Borders.merge(JBUI.Borders.empty(10), customLine, true));
        $this$createTitlePane_u24lambda_u245.setBackground(ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Banner.WARNING_BACKGROUND : JBUI.CurrentTheme.Notification.BACKGROUND);
        $this$createTitlePane_u24lambda_u245.setForeground(JBUI.CurrentTheme.Notification.FOREGROUND);
        $this$createTitlePane_u24lambda_u245.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)Gaps.EMPTY);
        return (JComponent)dialogPanel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel = this.model.getMainComboBoxModel();
        this.jdkCombobox = (ComboBox)new ComboBox<RuntimeChooserItem>(this, dialogPanel){
            final /* synthetic */ RuntimeChooserDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
                this.setSwingPopup(false);
                this.setRenderer((ListCellRenderer)((Object)new RuntimeChooserPresenter()));
            }

            public void setSelectedItem(@Nullable Object anObject) {
                if (!(anObject instanceof RuntimeChooserItem)) {
                    return;
                }
                if (anObject instanceof RuntimeChooserAddCustomItem) {
                    SdkPopup sdkPopup;
                    ComboBox comboBox = RuntimeChooserDialog.access$getJdkCombobox$p(this.this$0);
                    if (comboBox == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkCombobox");
                        comboBox = null;
                    }
                    if ((sdkPopup = RuntimeChooserCustom.INSTANCE.createSdkChooserPopup((JComponent)comboBox, RuntimeChooserDialog.access$getModel$p(this.this$0))) != null) {
                        ComboBox comboBox2 = RuntimeChooserDialog.access$getJdkCombobox$p(this.this$0);
                        if (comboBox2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"jdkCombobox");
                            comboBox2 = null;
                        }
                        sdkPopup.showUnderneathOf((Component)comboBox2);
                    }
                    return;
                }
                if (anObject instanceof RuntimeChooserDownloadableItem || anObject instanceof RuntimeChooserCustomItem || anObject instanceof RuntimeChooserCurrentItem) {
                    super.setSelectedItem(anObject);
                }
            }
        };
        DialogPanel $this$createCenterPanel_u24lambda_u246 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ RuntimeChooserDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string2 = LangBundle.message("dialog.label.choose.ide.runtime.current", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"dialog.label.choose.ide.runtime.current\")");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RuntimeChooserDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        SimpleColoredComponent control = new SimpleColoredComponent();
                        $this$row.cell((JComponent)control).align((Align)AlignX.FILL.INSTANCE);
                        GraphProperty<RuntimeChooserCurrentItem> graphProperty = RuntimeChooserDialog.access$getModel$p(this.this$0).getCurrentRuntime();
                        Disposable disposable = this.this$0.getDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"disposable");
                        RuntimeChooserModelKt.getAndSubscribe(graphProperty, disposable, (Function1)new Function1<RuntimeChooserCurrentItem, Unit>(control){
                            final /* synthetic */ SimpleColoredComponent $control;
                            {
                                this.$control = $control;
                                super(1);
                            }

                            public final void invoke(@Nullable RuntimeChooserCurrentItem it) {
                                this.$control.clear();
                                if (it != null) {
                                    RuntimeChooserPresenter.Companion companion = RuntimeChooserPresenter.Companion;
                                    SimpleColoredComponent simpleColoredComponent = this.$control;
                                    RuntimeChooserPresenter.Companion $this$invoke_u24lambda_u240 = companion;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u240.presetCurrentRuntime(simpleColoredComponent, it);
                                }
                            }
                        });
                    }
                });
                String string3 = LangBundle.message("dialog.label.choose.ide.runtime.combo", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"dialog.label.choose.ide.runtime.combo\")");
                $this$panel.row(string3, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RuntimeChooserDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        ComboBox comboBox = RuntimeChooserDialog.access$getJdkCombobox$p(this.this$0);
                        if (comboBox == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"jdkCombobox");
                            comboBox = null;
                        }
                        $this$row.cell((JComponent)comboBox).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                String string4 = LangBundle.message("dialog.label.choose.ide.runtime.location", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"dialog.label.ch\u2026se.ide.runtime.location\")");
                $this$panel.row(string4, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RuntimeChooserDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Project project2 = RuntimeChooserDialog.access$getProject$p(this.this$0);
                        String string2 = LangBundle.message("dialog.title.choose.ide.runtime.select.path.to.install.jdk", new Object[0]);
                        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFolderDescriptor()");
                        RuntimeChooserDialog.access$setJdkInstallDirSelector$p(this.this$0, (TextFieldWithBrowseButton)Cell.comment$default((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (String)string2, (Project)project2, (FileChooserDescriptor)fileChooserDescriptor, null, (int)8, null).align((Align)AlignX.FILL.INSTANCE), (String)LangBundle.message("dialog.message.choose.ide.runtime.select.path.to.install.jdk", new Object[0]), (int)0, null, (int)6, null).getComponent());
                        Function0 updateLocation2 = (Function0)new Function0<Unit>(this.this$0){
                            final /* synthetic */ RuntimeChooserDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                Object item;
                                ComboBox comboBox = RuntimeChooserDialog.access$getJdkCombobox$p(this.this$0);
                                if (comboBox == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"jdkCombobox");
                                    comboBox = null;
                                }
                                if ((item = comboBox.getSelectedItem()) instanceof RuntimeChooserDownloadableItem) {
                                    TextFieldWithBrowseButton textFieldWithBrowseButton = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton = null;
                                    }
                                    textFieldWithBrowseButton.setText(RuntimeChooserDialog.access$getModel$p(this.this$0).getDefaultInstallPathFor(((RuntimeChooserDownloadableItem)item).getItem()));
                                    TextFieldWithBrowseButton textFieldWithBrowseButton2 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton2 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton2 = null;
                                    }
                                    textFieldWithBrowseButton2.setButtonEnabled(true);
                                    TextFieldWithBrowseButton textFieldWithBrowseButton3 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton3 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton3 = null;
                                    }
                                    textFieldWithBrowseButton3.setEditable(true);
                                    TextFieldWithBrowseButton textFieldWithBrowseButton4 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton4 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton4 = null;
                                    }
                                    textFieldWithBrowseButton4.setButtonVisible(true);
                                } else if (item instanceof RuntimeChooserItemWithFixedLocation) {
                                    TextFieldWithBrowseButton textFieldWithBrowseButton = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton = null;
                                    }
                                    textFieldWithBrowseButton.setText(FileUtil.getLocationRelativeToUserHome(((RuntimeChooserItemWithFixedLocation)item).getHomeDir(), false));
                                    TextFieldWithBrowseButton textFieldWithBrowseButton5 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton5 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton5 = null;
                                    }
                                    textFieldWithBrowseButton5.setButtonEnabled(false);
                                    TextFieldWithBrowseButton textFieldWithBrowseButton6 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton6 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton6 = null;
                                    }
                                    textFieldWithBrowseButton6.setEditable(false);
                                    TextFieldWithBrowseButton textFieldWithBrowseButton7 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton7 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton7 = null;
                                    }
                                    textFieldWithBrowseButton7.setButtonVisible(false);
                                } else {
                                    TextFieldWithBrowseButton textFieldWithBrowseButton = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton = null;
                                    }
                                    textFieldWithBrowseButton.setText("");
                                    TextFieldWithBrowseButton textFieldWithBrowseButton8 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton8 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton8 = null;
                                    }
                                    textFieldWithBrowseButton8.setButtonEnabled(false);
                                    TextFieldWithBrowseButton textFieldWithBrowseButton9 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton9 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton9 = null;
                                    }
                                    textFieldWithBrowseButton9.setEditable(false);
                                    TextFieldWithBrowseButton textFieldWithBrowseButton10 = RuntimeChooserDialog.access$getJdkInstallDirSelector$p(this.this$0);
                                    if (textFieldWithBrowseButton10 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"jdkInstallDirSelector");
                                        textFieldWithBrowseButton10 = null;
                                    }
                                    textFieldWithBrowseButton10.setButtonVisible(false);
                                }
                            }
                        };
                        updateLocation2.invoke();
                        ComboBox comboBox = RuntimeChooserDialog.access$getJdkCombobox$p(this.this$0);
                        if (comboBox == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"jdkCombobox");
                            comboBox = null;
                        }
                        comboBox.addItemListener(arg_0 -> createCenterPanel.3.invoke$lambda$0(updateLocation2, arg_0));
                    }

                    private static final void invoke$lambda$0(Function0 $updateLocation, ItemEvent it) {
                        Intrinsics.checkNotNullParameter((Object)$updateLocation, (String)"$updateLocation");
                        $updateLocation.invoke();
                    }
                });
            }
        }));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u246.setBorder((Border)GapsKt.toJBEmptyBorder((Gaps)new IntelliJSpacingConfiguration().getDialogGap()));
        $this$createCenterPanel_u24lambda_u246.putClientProperty((Object)"isVisualPaddingCompensatedOnComponentLevel", (Object)false);
        return (JComponent)dialogPanel;
    }

    private static final void initClipboardListener$lambda$1$lambda$0(Window $window, initClipboardListener.windowListener.1 $windowListener) {
        Intrinsics.checkNotNullParameter((Object)$window, (String)"$window");
        Intrinsics.checkNotNullParameter((Object)$windowListener, (String)"$windowListener");
        $window.removeWindowListener($windowListener);
    }

    public static final /* synthetic */ RuntimeChooserModel access$getModel$p(RuntimeChooserDialog $this) {
        return $this.model;
    }

    public static final /* synthetic */ ComboBox access$getJdkCombobox$p(RuntimeChooserDialog $this) {
        return $this.jdkCombobox;
    }

    public static final /* synthetic */ void access$setJdkInstallDirSelector$p(RuntimeChooserDialog $this, TextFieldWithBrowseButton textFieldWithBrowseButton) {
        $this.jdkInstallDirSelector = textFieldWithBrowseButton;
    }

    public static final /* synthetic */ Project access$getProject$p(RuntimeChooserDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getJdkInstallDirSelector$p(RuntimeChooserDialog $this) {
        return $this.jdkInstallDirSelector;
    }
}

