/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.wsl.WslPath;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidatorCallback;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.JavaVersion;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0082\bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0012J7\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\t2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidator;", "", "()V", "minJdkFeatureVersion", "", "getMinJdkFeatureVersion$annotations", "getMinJdkFeatureVersion", "()I", "isSupportedSdkItem", "", "versionString", "Lkotlin/Function0;", "", "homePath", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "item", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/roots/ui/configuration/SdkPopupBuilder$SuggestedSdk;", "testNewJdkUnderProgress", "R", "allowRunProcesses", "computeHomePath", "callback", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidatorCallback;", "(ZLkotlin/jvm/functions/Function0;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidatorCallback;)Ljava/lang/Object;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nRuntimeChooserJre.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeChooserJre.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n49#1,12:187\n49#1,12:199\n1#2:211\n*S KotlinDebug\n*F\n+ 1 RuntimeChooserJre.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidator\n*L\n46#1:187,12\n47#1:199,12\n*E\n"})
public final class RuntimeChooserJreValidator {
    @NotNull
    public static final RuntimeChooserJreValidator INSTANCE = new RuntimeChooserJreValidator();

    private RuntimeChooserJreValidator() {
    }

    private final int getMinJdkFeatureVersion() {
        return 11;
    }

    private static /* synthetic */ void getMinJdkFeatureVersion$annotations() {
    }

    public final boolean isSupportedSdkItem(@NotNull JdkItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (SystemInfo.isMac && !StringsKt.endsWith$default((String)item.getPackageToBinJavaPrefix(), (String)"Contents/Home", (boolean)false, (int)2, null)) {
            return false;
        }
        return item.getJdkMajorVersion() >= this.getMinJdkFeatureVersion() && Intrinsics.areEqual((Object)item.getOs(), (Object)JdkPredicate.Companion.getCurrentOS()) && Intrinsics.areEqual((Object)item.getArch(), (Object)JdkPredicate.Companion.getCurrentArch());
    }

    public final boolean isSupportedSdkItem(@NotNull Sdk sdk2) {
        boolean bl;
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RuntimeChooserJreValidator this_$iv = this;
            boolean $i$f$isSupportedSdkItem = false;
            Object object2 = this_$iv;
            try {
                RuntimeChooserJreValidator $this$isSupportedSdkItem_u24lambda_u244$iv = object2;
                boolean bl2 = false;
                boolean bl3 = false;
                String string2 = sdk2.getVersionString();
                if (string2 == null) {
                    bl = false;
                    break block6;
                }
                String version$iv = string2;
                boolean bl4 = false;
                String string3 = sdk2.getHomePath();
                if (string3 == null) {
                    bl = false;
                    break block6;
                }
                String home$iv = string3;
                if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home$iv, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                    bl = false;
                    break block6;
                }
                JavaVersion javaVersion = JavaVersion.tryParse(version$iv);
                if (javaVersion == null) {
                    bl = false;
                    break block6;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
                JavaVersion javaVersion$iv = javaVersion;
                object = Result.constructor-impl((Object)(javaVersion$iv.feature >= $this$isSupportedSdkItem_u24lambda_u244$iv.getMinJdkFeatureVersion() && !WslPath.Companion.isWslUncPath(home$iv) ? 1 : 0));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = false;
            bl = (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
        }
        return bl;
    }

    public final boolean isSupportedSdkItem(@NotNull SdkPopupBuilder.SuggestedSdk sdk2) {
        boolean bl;
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RuntimeChooserJreValidator this_$iv = this;
            boolean $i$f$isSupportedSdkItem = false;
            Object object2 = this_$iv;
            try {
                RuntimeChooserJreValidator $this$isSupportedSdkItem_u24lambda_u244$iv = object2;
                boolean bl2 = false;
                boolean bl3 = false;
                String string2 = sdk2.getVersionString();
                if (string2 == null) {
                    bl = false;
                    break block6;
                }
                String version$iv = string2;
                boolean bl4 = false;
                String string3 = sdk2.getHomePath();
                if (string3 == null) {
                    bl = false;
                    break block6;
                }
                String home$iv = string3;
                if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home$iv, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                    bl = false;
                    break block6;
                }
                JavaVersion javaVersion = JavaVersion.tryParse(version$iv);
                if (javaVersion == null) {
                    bl = false;
                    break block6;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
                JavaVersion javaVersion$iv = javaVersion;
                object = Result.constructor-impl((Object)(javaVersion$iv.feature >= $this$isSupportedSdkItem_u24lambda_u244$iv.getMinJdkFeatureVersion() && !WslPath.Companion.isWslUncPath(home$iv) ? 1 : 0));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = false;
            bl = (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
        }
        return bl;
    }

    private final boolean isSupportedSdkItem(Function0<String> versionString, Function0<String> homePath) {
        Object object;
        boolean $i$f$isSupportedSdkItem = false;
        Object object2 = this;
        try {
            RuntimeChooserJreValidator $this$isSupportedSdkItem_u24lambda_u244 = object2;
            boolean bl = false;
            String string2 = (String)versionString.invoke();
            if (string2 == null) {
                return false;
            }
            String version = string2;
            String string3 = (String)homePath.invoke();
            if (string3 == null) {
                return false;
            }
            String home2 = string3;
            if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home2, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                return false;
            }
            JavaVersion javaVersion = JavaVersion.tryParse(version);
            if (javaVersion == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
            JavaVersion javaVersion2 = javaVersion;
            object = Result.constructor-impl((Object)(javaVersion2.feature >= $this$isSupportedSdkItem_u24lambda_u244.getMinJdkFeatureVersion() && !WslPath.Companion.isWslUncPath(home2) ? 1 : 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    public final <R> R testNewJdkUnderProgress(boolean allowRunProcesses, @NotNull Function0<String> computeHomePath, @NotNull RuntimeChooserJreValidatorCallback<R> callback) {
        Object[] objectArray;
        Path path2;
        Object[] $this$testNewJdkUnderProgress_u24lambda_u245;
        Intrinsics.checkNotNullParameter(computeHomePath, (String)"computeHomePath");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object[] objectArray2 = this;
        try {
            $this$testNewJdkUnderProgress_u24lambda_u245 = objectArray2;
            boolean bl = false;
            $this$testNewJdkUnderProgress_u24lambda_u245 = Result.constructor-impl((Object)Path.of((String)computeHomePath.invoke(), new String[0]).toAbsolutePath());
        }
        catch (Throwable bl) {
            $this$testNewJdkUnderProgress_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        objectArray2 = $this$testNewJdkUnderProgress_u24lambda_u245;
        Path path3 = (Path)(Result.isFailure-impl((Object)objectArray2) ? null : objectArray2);
        if (path3 == null) {
            $this$testNewJdkUnderProgress_u24lambda_u245 = new Object[]{LangBundle.message("dialog.message.choose.ide.runtime.no.file.part", new Object[0])};
            String string2 = LangBundle.message("dialog.message.choose.ide.runtime.set.unknown.error", $this$testNewJdkUnderProgress_u24lambda_u245);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"dialog.message.\u2026e.runtime.no.file.part\"))");
            return callback.onError(string2);
        }
        Path homeDir = path3;
        if (SystemInfo.isMac && StringsKt.endsWith$default((String)((Object)homeDir).toString(), (String)"/Contents/Home", (boolean)false, (int)2, null)) {
            return this.testNewJdkUnderProgress(allowRunProcesses, (Function0<String>)((Function0)new Function0<String>(homeDir){
                final /* synthetic */ Path $homeDir;
                {
                    this.$homeDir = $homeDir;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    Path path2 = this.$homeDir.getParent();
                    return path2 != null && (path2 = path2.getParent()) != null ? ((Object)path2).toString() : null;
                }
            }), callback);
        }
        if (SystemInfo.isMac && Intrinsics.areEqual((Object)((Object)homeDir.getFileName()).toString(), (Object)"Contents")) {
            Path path4 = homeDir.resolve("Home");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
            if (PathKt.isDirectory(path4)) {
                return this.testNewJdkUnderProgress(allowRunProcesses, (Function0<String>)((Function0)new Function0<String>(homeDir){
                    final /* synthetic */ Path $homeDir;
                    {
                        this.$homeDir = $homeDir;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        Path path2 = this.$homeDir.getParent();
                        return path2 != null ? ((Object)path2).toString() : null;
                    }
                }), callback);
            }
        }
        if (SystemInfo.isMac) {
            Path path5 = homeDir.resolve("Contents");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
            Path path6 = path5.resolve("Home");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"this.resolve(other)");
            if (!PathKt.isDirectory(path6)) {
                RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". macOS Bundle layout is expected");
                objectArray2 = new Object[]{homeDir};
                String string3 = LangBundle.message("dialog.message.choose.ide.runtime.set.error.mac.bundle", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"dialog.message.\u2026ror.mac.bundle\", homeDir)");
                return callback.onError(string3);
            }
        }
        if (SystemInfo.isWindows && WslPath.Companion.isWslUncPath(((Object)homeDir).toString())) {
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". macOS Bundle layout is expected");
            objectArray2 = new Object[]{homeDir};
            String string4 = LangBundle.message("dialog.message.choose.ide.runtime.set.version.error.wsl", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"dialog.message.\u2026sion.error.wsl\", homeDir)");
            callback.onError(string4);
        }
        if (SystemInfo.isWindows) {
            Path path7 = homeDir.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"this.resolve(other)");
            Path path8 = path7.resolve("java.exe");
            path2 = path8;
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"this.resolve(other)");
        } else if (SystemInfo.isMac) {
            Path path9 = homeDir.resolve("Contents");
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"this.resolve(other)");
            Path path10 = path9.resolve("Home");
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"this.resolve(other)");
            Path path11 = path10.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"this.resolve(other)");
            Path path12 = path11.resolve("java");
            path2 = path12;
            Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"this.resolve(other)");
        } else {
            Path path13 = homeDir.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"this.resolve(other)");
            Path path14 = path13.resolve("java");
            path2 = path14;
            Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"this.resolve(other)");
        }
        Path binJava = path2;
        if (!PathKt.isFile(binJava) || SystemInfo.isUnix && !Files.isExecutable(binJava)) {
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". Failed to find bin/java executable at " + binJava);
            $this$testNewJdkUnderProgress_u24lambda_u245 = new Object[]{homeDir};
            String string5 = LangBundle.message("dialog.message.choose.ide.runtime.set.cannot.start.error", $this$testNewJdkUnderProgress_u24lambda_u245);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"dialog.message.\u2026ot.start.error\", homeDir)");
            return callback.onError(string5);
        }
        String[] stringArray = this;
        try {
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo;
            RuntimeChooserJreValidator $this$testNewJdkUnderProgress_u24lambda_u246 = stringArray;
            boolean bl = false;
            Object object = binJava.getParent();
            if (object == null || (object = object.getParent()) == null || (object = object.toString()) == null) {
                jdkVersionInfo = null;
            } else {
                Object inferredHome = object;
                jdkVersionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo((String)inferredHome);
            }
            objectArray = Result.constructor-impl(jdkVersionInfo);
        }
        catch (Throwable throwable) {
            objectArray = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        stringArray = objectArray;
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = (JdkVersionDetector.JdkVersionInfo)(Result.isFailure-impl((Object)stringArray) ? null : stringArray);
        if (jdkVersionInfo == null) {
            objectArray = new Object[]{homeDir};
            String string6 = LangBundle.message("dialog.message.choose.ide.runtime.set.unknown.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"dialog.message.\u2026.unknown.error\", homeDir)");
            return callback.onError(string6);
        }
        JdkVersionDetector.JdkVersionInfo info2 = jdkVersionInfo;
        if (info2.version == null || info2.version.feature < this.getMinJdkFeatureVersion()) {
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". The version " + info2 + " is less than " + this.getMinJdkFeatureVersion());
            Object[] bl = new Object[]{homeDir, "11", info2.version.toString()};
            String string7 = LangBundle.message("dialog.message.choose.ide.runtime.set.version.error", bl);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"dialog.message.\u2026 info.version.toString())");
            return callback.onError(string7);
        }
        String string8 = RuntimeChooserJreKt.access$tryComputeAdvancedFullVersion(binJava);
        if (string8 == null) {
            JavaVersion javaVersion = info2.version;
            string8 = javaVersion != null ? javaVersion.toString() : null;
            if (string8 == null) {
                Object[] objectArray3 = new Object[]{homeDir};
                String string9 = LangBundle.message("dialog.message.choose.ide.runtime.set.unknown.error", objectArray3);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(\"dialog.message.\u2026.unknown.error\", homeDir)");
                return callback.onError(string9);
            }
        }
        String jdkVersion = string8;
        if (allowRunProcesses) {
            try {
                stringArray = new String[]{((Object)binJava).toString(), "-version"};
                GeneralCommandLine cmd = new GeneralCommandLine(stringArray);
                int exitCode = new CapturingProcessHandler(cmd).runProcess(30000).getExitCode();
                if (exitCode != 0) {
                    RuntimeChooserJreKt.access$getLOG$p().warn("Failed to run JDK for boot runtime: " + homeDir + ". Exit code is " + exitCode + " for " + binJava + ".");
                    Object[] objectArray4 = new Object[]{homeDir};
                    String string10 = LangBundle.message("dialog.message.choose.ide.runtime.set.cannot.start.error", objectArray4);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(\"dialog.message.\u2026ot.start.error\", homeDir)");
                    return callback.onError(string10);
                }
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                RuntimeChooserJreKt.access$getLOG$p().warn("Failed to run JDK for boot runtime: " + homeDir + ". " + t.getMessage(), t);
                objectArray = new Object[]{homeDir};
                String string11 = LangBundle.message("dialog.message.choose.ide.runtime.set.cannot.start.error", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(\"dialog.message.\u2026ot.start.error\", homeDir)");
                return callback.onError(string11);
            }
        }
        return callback.onSdkResolved(info2.variant.displayName, jdkVersion, homeDir);
    }
}

