/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidatorCallback;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserMessages;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserPaths;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserPathsKt;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J&\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\nJ\u0006\u0010\f\u001a\u00020\u0006JG\u0010\r\u001a\u00020\u00062=\u0010\u000e\u001a9\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00140\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserPaths;", "", "()V", "computeJdkFilePath", "Ljava/nio/file/Path;", "installCustomJdk", "", "jdkName", "", "resolveSuggestedHome", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "resetCustomJdk", "runWithProgress", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "indicator", "jdkFile", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.lang.impl"})
public final class RuntimeChooserPaths {
    private final Path computeJdkFilePath() {
        String string2 = PathManager.getCustomOptionsDirectory();
        if (string2 == null) {
            throw new IllegalStateException("Runtime selection not supported");
        }
        String directory = string2;
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String configName = scriptName + (!SystemInfo.isWindows ? "" : (CpuArch.isIntel64() ? "64.exe" : ".exe")) + ".jdk";
        String[] stringArray = new String[]{configName};
        Path path2 = Path.of(directory, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(directory, configName)");
        return path2;
    }

    public final void installCustomJdk(@NlsSafe @NotNull String jdkName, @NotNull Function1<? super ProgressIndicator, ? extends Path> resolveSuggestedHome) {
        Intrinsics.checkNotNullParameter((Object)jdkName, (String)"jdkName");
        Intrinsics.checkNotNullParameter(resolveSuggestedHome, (String)"resolveSuggestedHome");
        this.runWithProgress((Function2<? super ProgressIndicator, ? super Path, String>)((Function2)new Function2<ProgressIndicator, Path, String>(resolveSuggestedHome, jdkName){
            final /* synthetic */ Function1<ProgressIndicator, Path> $resolveSuggestedHome;
            final /* synthetic */ String $jdkName;
            {
                this.$resolveSuggestedHome = $resolveSuggestedHome;
                this.$jdkName = $jdkName;
                super(2);
            }

            @Nullable
            public final String invoke(@NotNull ProgressIndicator indicator, @NotNull Path jdkFile) {
                Path path2;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Intrinsics.checkNotNullParameter((Object)jdkFile, (String)"jdkFile");
                try {
                    path2 = (Path)this.$resolveSuggestedHome.invoke((Object)indicator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    RuntimeChooserPathsKt.access$getLOG$p().warn("resolve failed. " + t.getMessage(), t);
                    return null;
                }
                Path sdkHome = path2;
                Path path3 = (Path)RuntimeChooserJreValidator.INSTANCE.testNewJdkUnderProgress(true, (Function0<String>)((Function0)new Function0<String>(sdkHome){
                    final /* synthetic */ Path $sdkHome;
                    {
                        this.$sdkHome = $sdkHome;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        Path path2 = this.$sdkHome;
                        return path2 != null && (path2 = path2.toAbsolutePath()) != null ? ((Object)path2).toString() : null;
                    }
                }), new RuntimeChooserJreValidatorCallback<Path>(){

                    @NotNull
                    public Path onSdkResolved(@Nullable String displayName, @NotNull String versionString, @NotNull Path sdkHome) {
                        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                        Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
                        return sdkHome;
                    }

                    @Nullable
                    public Path onError(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        RuntimeChooserMessages.showErrorMessage$default(RuntimeChooserMessages.INSTANCE, message, null, 2, null);
                        return null;
                    }
                });
                if (path3 == null) {
                    return null;
                }
                Path home2 = path3;
                Path path4 = jdkFile.getParent();
                if (path4 != null) {
                    PathKt.createDirectories(path4);
                }
                PathKt.write$default(jdkFile, ((Object)home2.toAbsolutePath()).toString(), null, false, 6, null);
                RuntimeChooserPathsKt.access$getLOG$p().warn("Set custom boot runtime to: " + home2 + " in the " + jdkFile + ". On errors, please remove the .jdk file");
                return this.$jdkName;
            }
        }));
    }

    public final void resetCustomJdk() {
        this.runWithProgress((Function2<? super ProgressIndicator, ? super Path, String>)((Function2)resetCustomJdk.1.INSTANCE));
    }

    private final void runWithProgress(Function2<? super ProgressIndicator, ? super Path, String> action2) {
        String string2 = LangBundle.message("progress.title.choose.ide.runtime.set.jdk", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"progress.title.\u2026ose.ide.runtime.set.jdk\")");
        String title = string2;
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.DEAF;
        new Task.Backgroundable(title, this, action2, performInBackgroundOption){
            final /* synthetic */ RuntimeChooserPaths this$0;
            final /* synthetic */ Function2<ProgressIndicator, Path, String> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(null, $title, true, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Path jdkFileShadow = null;
                try {
                    Path jdkFile;
                    jdkFileShadow = jdkFile = RuntimeChooserPaths.access$computeJdkFilePath(this.this$0);
                    String runtimeName = (String)this.$action.invoke((Object)indicator, (Object)jdkFile);
                    if (runtimeName != null) {
                        RuntimeChooserMessages.INSTANCE.showRestartMessage(runtimeName);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    RuntimeChooserPathsKt.access$getLOG$p().warn("Failed to change boot runtime in " + jdkFileShadow + ". " + t.getMessage(), t);
                    Object[] objectArray = new Object[]{t.getLocalizedMessage()};
                    String string2 = LangBundle.message("dialog.message.choose.ide.runtime.unknown.error", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"dialog.message.\u2026ror\", t.localizedMessage)");
                    RuntimeChooserMessages.showErrorMessage$default(RuntimeChooserMessages.INSTANCE, string2, null, 2, null);
                }
            }
        }.queue();
    }

    public static final /* synthetic */ Path access$computeJdkFilePath(RuntimeChooserPaths $this) {
        return $this.computeJdkFilePath();
    }
}

