/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.ModelBranch;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public final class DirectoryIndexImpl
extends DirectoryIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private final WorkspaceFileIndexEx myWorkspaceFileIndex;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;
    private static final Key<Pair<Long, RootIndex>> BRANCH_ROOT_INDEX = Key.create("BRANCH_ROOT_INDEX");

    public DirectoryIndexImpl(@NotNull Project project2) {
        if (project2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(0);
        }
        this.myWorkspaceFileIndex = WorkspaceFileIndexEx.IS_ENABLED ? (WorkspaceFileIndexEx)WorkspaceFileIndex.getInstance(project2) : null;
        this.myProject = project2;
        this.myConnection = project2.getMessageBus().connect();
        this.subscribeToFileChanges();
        LowMemoryWatcher.register(() -> {
            RootIndex index2 = this.myRootIndex;
            if (index2 != null) {
                index2.onLowMemory();
            }
        }, this);
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
        this.myRootIndex = null;
    }

    private void subscribeToFileChanges() {
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                RootIndex rootIndex;
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((rootIndex = DirectoryIndexImpl.this.myRootIndex) != null && DirectoryIndexImpl.shouldResetOnEvents(events)) {
                    rootIndex.myPackageDirectoryCache.clear();
                    for (VFileEvent vFileEvent : events) {
                        if (!DirectoryIndexImpl.isIgnoredFileCreated(vFileEvent)) continue;
                        DirectoryIndexImpl.this.reset();
                        break;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$1", "after"));
            }
        });
    }

    public static boolean shouldResetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (!(vFileEvent instanceof VFileCreateEvent ? ((VFileCreateEvent)vFileEvent).isDirectory() : (file2 = vFileEvent.getFile()) == null || file2.isDirectory())) continue;
            return true;
        }
        return false;
    }

    public static boolean isIgnoredFileCreated(@NotNull VFileEvent event) {
        if (event == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(2);
        }
        return event instanceof VFileMoveEvent && FileTypeRegistry.getInstance().isFileIgnored(((VFileMoveEvent)event).getNewParent()) || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name") && FileTypeRegistry.getInstance().isFileIgnored(((VFilePropertyChangeEvent)event).getFile());
    }

    private void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(3);
        }
        if (this.myWorkspaceFileIndex != null) {
            Query<VirtualFile> query2 = this.myWorkspaceFileIndex.getDirectoriesByPackageName(packageName, includeLibrarySources);
            if (query2 == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(4);
            }
            return query2;
        }
        Query<VirtualFile> query3 = this.getRootIndex(false).getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query3 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(5);
        }
        return query3;
    }

    @Override
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(7);
        }
        if (this.myWorkspaceFileIndex != null) {
            return this.myWorkspaceFileIndex.getDirectoriesByPackageName(packageName, scope);
        }
        Collection<ModelBranch> branches = scope.getModelBranchesAffectingScope();
        if (branches.isEmpty()) {
            return super.getDirectoriesByPackageName(packageName, scope);
        }
        List<RootIndex> indices = ContainerUtil.append(ContainerUtil.map(branches, DirectoryIndexImpl::obtainBranchRootIndex), this.getRootIndex(false));
        return new CollectionQuery<RootIndex>(indices).flatMapping(i2 -> i2.getDirectoriesByPackageName(packageName, true)).filtering(scope::contains);
    }

    @NotNull
    RootIndex getRootIndex(VirtualFile file2) {
        ModelBranch branch = ModelBranch.getFileBranch(file2);
        if (branch != null) {
            RootIndex rootIndex = DirectoryIndexImpl.obtainBranchRootIndex(branch);
            if (rootIndex == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(8);
            }
            return rootIndex;
        }
        RootIndex rootIndex = this.getRootIndex(false);
        if (rootIndex == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(9);
        }
        return rootIndex;
    }

    private static RootIndex obtainBranchRootIndex(ModelBranch branch) {
        Pair<Long, RootIndex> pair = branch.getUserData(BRANCH_ROOT_INDEX);
        long modCount = branch.getBranchedVfsStructureModificationCount();
        if (pair == null || (Long)pair.first != modCount) {
            pair = Pair.create(modCount, new RootIndex(branch.getProject(), RootFileSupplier.forBranch(branch)));
            branch.putUserData(BRANCH_ROOT_INDEX, pair);
        }
        return (RootIndex)pair.second;
    }

    RootIndex getRootIndex(boolean forOrderEntryGraph) {
        RootIndex rootIndex;
        if (!forOrderEntryGraph && this.myWorkspaceFileIndex != null) {
            LOG.error("Internal DirectoryIndex class must not be used directly to avoid long computations, use ProjectFileIndex API instead");
        }
        if ((rootIndex = this.myRootIndex) == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject);
        }
        return rootIndex;
    }

    @Override
    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(10);
        }
        this.checkAvailability();
        ProgressManager.checkCanceled();
        SlowOperations.assertSlowOperationsAreAllowed();
        this.dispatchPendingEvents();
        DirectoryInfo directoryInfo = this.getRootIndex(file2).getInfoForFile(file2);
        if (directoryInfo == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(11);
        }
        return directoryInfo;
    }

    @Override
    @Nullable
    public SourceFolder getSourceRootFolder(@NotNull DirectoryInfo info2) {
        boolean inModuleSource;
        if (info2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(12);
        }
        boolean bl = inModuleSource = info2 instanceof DirectoryInfoImpl && ((DirectoryInfoImpl)info2).isInModuleSource();
        if (inModuleSource) {
            return info2.getSourceRootFolder();
        }
        return null;
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info2) {
        SourceFolder folder;
        if (info2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(13);
        }
        return (folder = this.getSourceRootFolder(info2)) == null ? null : folder.getRootType();
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(14);
        }
        this.checkAvailability();
        if (this.myWorkspaceFileIndex != null) {
            return this.myWorkspaceFileIndex.getPackageName(dir);
        }
        return this.getRootIndex(dir).getPackageName(dir);
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info2;
        if (fileOrDir == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(15);
        }
        this.checkAvailability();
        if (this.myProject.isDefault()) {
            List<OrderEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(16);
            }
            return list2;
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileInternalInfo fileInfo2 = this.myWorkspaceFileIndex.getFileInfo(fileOrDir, true, true, true, true);
            WorkspaceFileSetWithCustomData<?> fileSet = fileInfo2.findFileSet(data2 -> true);
            if (fileSet == null) {
                List<OrderEntry> list3 = Collections.emptyList();
                if (list3 == null) {
                    DirectoryIndexImpl.$$$reportNull$$$0(17);
                }
                return list3;
            }
            List<OrderEntry> list4 = this.getRootIndex(true).getOrderEntries(fileSet.getRoot());
            if (list4 == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(18);
            }
            return list4;
        }
        if (fileOrDir instanceof VirtualFileWindow) {
            fileOrDir = ((VirtualFileWindow)((Object)fileOrDir)).getDelegate();
        }
        if (!((info2 = this.getInfoForFile(fileOrDir = BackedVirtualFile.getOriginFileIfBacked(fileOrDir))) instanceof DirectoryInfoImpl)) {
            List<OrderEntry> list5 = Collections.emptyList();
            if (list5 == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(19);
            }
            return list5;
        }
        List<OrderEntry> list6 = this.getRootIndex(true).getOrderEntries(((DirectoryInfoImpl)info2).getRoot());
        if (list6 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(20);
        }
        return list6;
    }

    @Override
    @NotNull
    public Set<String> getDependentUnloadedModules(@NotNull Module module2) {
        if (module2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(21);
        }
        this.checkAvailability();
        Set<String> set2 = this.getRootIndex(true).getDependentUnloadedModules(module2);
        if (set2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(22);
        }
        return set2;
    }

    private void checkAvailability() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }

    void reset() {
        this.myRootIndex = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 9, 11, 16, 17, 18, 19, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIndex";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldResetOnEvents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFileCreated";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootFolder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 8, 9, 11, 16, 17, 18, 19, 20, 22 -> new IllegalStateException(string2);
        };
    }
}

