/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/roots/impl/DumpWatchedRootsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Root", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDumpWatchedRootsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpWatchedRootsAction.kt\ncom/intellij/openapi/roots/impl/DumpWatchedRootsAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1549#2:49\n1620#2,3:50\n1549#2:53\n1620#2,2:54\n1549#2:56\n1620#2,3:57\n1622#2:60\n1045#2:61\n*S KotlinDebug\n*F\n+ 1 DumpWatchedRootsAction.kt\ncom/intellij/openapi/roots/impl/DumpWatchedRootsAction\n*L\n21#1:49\n21#1:50,3\n27#1:53\n27#1:54,2\n28#1:56\n28#1:57,3\n27#1:60\n29#1:61\n*E\n"})
public final class DumpWatchedRootsAction
extends DumbAwareAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable roots2;
        Collection collection;
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        Project[] projects = projectArray;
        MultiMap<String, Project> roots2Project = new MultiMap<String, Project>();
        for (Project project2 : projects) {
            void $this$mapTo$iv$iv2;
            ProjectRootManager projectRootManager2 = ProjectRootManager.getInstance(project2);
            Intrinsics.checkNotNull((Object)projectRootManager2, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.ProjectRootManagerComponent");
            Iterable $this$map$iv = ((ProjectRootManagerComponent)projectRootManager2).getRootsToWatch();
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                object = (LocalFileSystem.WatchRequest)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRootPath());
            }
            roots2 = (List)destination$iv$iv;
            for (String root : roots2) {
                roots2Project.putValue(root, project2);
            }
        }
        Set set2 = roots2Project.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"roots2Project.entrySet()");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        roots2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            void it;
            Object item$iv$iv2;
            Map.Entry $i$f$mapTo2 = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            String string2 = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            item$iv$iv2 = (Iterable)v;
            object = string2;
            boolean $i$f$map2 = false;
            void var18_26 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void p;
                Project project3 = (Project)item$iv$iv3;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(p.getName() + "-" + p.getLocationHash());
            }
            List list2 = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
            Object object3 = object;
            collection.add(new Root((String)object3, list2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List roots3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Root it = (Root)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (Root)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
            }
        });
        BaseListPopupStep<Root> baseListPopupStep2 = new BaseListPopupStep<Root>((List<Root>)roots3){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(@Nullable Root value) {
                Object object;
                Root root = value;
                return StringUtil.shortenPathWithEllipsis(String.valueOf(root != null ? root.getPath() : null), 100) + "  (" + ((object = value) != null && (object = ((Root)object).getProjects()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : null) + ")";
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)baseListPopupStep2);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"getInstance().createListPopup(baseListPopupStep)");
        ListPopup popup2 = listPopup;
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/roots/impl/DumpWatchedRootsAction$Root;", "", "path", "", "projects", "", "(Ljava/lang/String;Ljava/util/List;)V", "getPath", "()Ljava/lang/String;", "getProjects", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class Root {
        @NotNull
        private final String path;
        @NotNull
        private final List<String> projects;

        public Root(@NotNull String path2, @NotNull List<String> projects) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            this.path = path2;
            this.projects = projects;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final List<String> getProjects() {
            return this.projects;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final List<String> component2() {
            return this.projects;
        }

        @NotNull
        public final Root copy(@NotNull String path2, @NotNull List<String> projects) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            return new Root(path2, projects);
        }

        public static /* synthetic */ Root copy$default(Root root, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = root.path;
            }
            if ((n & 2) != 0) {
                list2 = root.projects;
            }
            return root.copy(string2, list2);
        }

        @NotNull
        public String toString() {
            return "Root(path=" + this.path + ", projects=" + this.projects + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + ((Object)this.projects).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Root)) {
                return false;
            }
            Root root = (Root)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)root.path)) {
                return false;
            }
            return Intrinsics.areEqual(this.projects, root.projects);
        }
    }
}

