/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentOrSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

abstract class FileIndexBase
implements FileIndex {
    final DirectoryIndex myDirectoryIndex;
    final WorkspaceFileIndexEx myWorkspaceFileIndex;

    FileIndexBase(@NotNull Project project2) {
        if (project2 == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        this.myDirectoryIndex = DirectoryIndex.getInstance(project2);
        this.myWorkspaceFileIndex = WorkspaceFileIndexEx.IS_ENABLED ? (WorkspaceFileIndexEx)WorkspaceFileIndex.getInstance(project2) : null;
    }

    protected abstract boolean isScopeDisposed();

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        return this.iterateContent(processor, null);
    }

    @Override
    public boolean iterateContentUnderDirectory(final @NotNull VirtualFile dir, @NotNull ContentIterator processor, final @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        final ContentIteratorEx processorEx = FileIndexBase.toContentIteratorEx(processor);
        if (this.myWorkspaceFileIndex != null) {
            return this.myWorkspaceFileIndex.processContentFilesRecursively(dir, processorEx, customFilter, fileSet -> !this.isScopeDisposed() && this.isInContent((WorkspaceFileSetWithCustomData<?>)fileSet));
        }
        VirtualFileVisitor.Result result2 = VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                boolean accepted2;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryInfo info2 = ReadAction.compute(() -> FileIndexBase.this.getInfoForFileOrDirectory(file2));
                if (file2.isDirectory()) {
                    if (info2.isExcluded(file2)) {
                        if (!info2.processContentBeneathExcluded(file2, content2 -> FileIndexBase.this.iterateContentUnderDirectory((VirtualFile)content2, processorEx, customFilter))) {
                            VirtualFileVisitor.Result result2 = 1.skipTo(dir);
                            if (result2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result2;
                        }
                        VirtualFileVisitor.Result result3 = SKIP_CHILDREN;
                        if (result3 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result3;
                    }
                    if (info2.isIgnored() || info2 instanceof NonProjectDirectoryInfo && !((NonProjectDirectoryInfo)info2).hasContentEntriesBeneath()) {
                        VirtualFileVisitor.Result result4 = SKIP_CHILDREN;
                        if (result4 == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return result4;
                    }
                }
                TreeNodeProcessingResult status = (accepted2 = ReadAction.compute(() -> !FileIndexBase.this.isScopeDisposed() && FileIndexBase.this.isInContent(file2, info2) && (customFilter == null || customFilter.accept(file2))).booleanValue()) ? processorEx.processFileEx(file2) : TreeNodeProcessingResult.CONTINUE;
                VirtualFileVisitor.Result result5 = switch (status) {
                    default -> throw new IncompatibleClassChangeError();
                    case TreeNodeProcessingResult.CONTINUE -> CONTINUE;
                    case TreeNodeProcessingResult.SKIP_CHILDREN -> SKIP_CHILDREN;
                    case TreeNodeProcessingResult.SKIP_TO_PARENT -> 1.skipTo(file2.getParent());
                    case TreeNodeProcessingResult.STOP -> 1.skipTo(dir);
                };
                if (result5 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return result5;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1, 2, 3, 4 -> new IllegalStateException(string2);
                };
            }
        });
        return !Comparing.equal(result2.skipToParent, dir);
    }

    @NotNull
    private static ContentIteratorEx toContentIteratorEx(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        if (processor instanceof ContentIteratorEx) {
            ContentIteratorEx contentIteratorEx = (ContentIteratorEx)processor;
            if (contentIteratorEx == null) {
                FileIndexBase.$$$reportNull$$$0(5);
            }
            return contentIteratorEx;
        }
        ContentIteratorEx contentIteratorEx = fileOrDir -> processor.processFile(fileOrDir) ? TreeNodeProcessingResult.CONTINUE : TreeNodeProcessingResult.STOP;
        if (contentIteratorEx == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return contentIteratorEx;
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        return this.iterateContentUnderDirectory(dir, processor, null);
    }

    boolean isTestSourcesRoot(@NotNull DirectoryInfo info2) {
        JpsModuleSourceRootType<?> rootType;
        if (info2 == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        return (rootType = this.myDirectoryIndex.getSourceRootType(info2)) != null && rootType.isForTests();
    }

    @ApiStatus.Internal
    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        file2 = BackedVirtualFile.getOriginFileIfBacked(file2);
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file2);
        if (directoryInfo == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        return directoryInfo;
    }

    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(12);
        }
        if (info2 == null) {
            FileIndexBase.$$$reportNull$$$0(13);
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info2);
    }

    protected boolean isInContent(@NotNull WorkspaceFileSetWithCustomData<?> fileSet) {
        if (fileSet == null) {
            FileIndexBase.$$$reportNull$$$0(14);
        }
        return fileSet.getData() instanceof ModuleContentOrSourceRootData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toContentIteratorEx";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFileOrDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toContentIteratorEx";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourcesRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFileOrDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 11 -> new IllegalStateException(string2);
        };
    }
}

