/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilesScanExecutor;
import com.intellij.openapi.roots.impl.StopWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.util.indexing.roots.kind.SdkOrigin;
import com.intellij.util.indexing.roots.kind.SyntheticLibraryOrigin;
import com.intellij.util.indexing.roots.origin.ExternalEntityOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001d0\u001cH\u0007J0\u0010\u001e\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J0\u0010\u001f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u0010H\u0007J0\u0010 \u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u0010H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/roots/impl/FilesScanExecutor;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "THREAD_COUNT", "", "ourExecutor", "Ljava/util/concurrent/ExecutorService;", "doProcessOnAllThreadsInReadAction", "", "T", "deque", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "consumer", "Lkotlin/Function1;", "retryCanceled", "isLibOrigin", "origin", "Lcom/intellij/util/indexing/roots/kind/IndexableSetOrigin;", "processFilesInScope", "includingBinary", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "idFilter", "Lcom/intellij/util/indexing/IdFilter;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/openapi/vfs/VirtualFile;", "processOnAllThreads", "processOnAllThreadsInReadActionNoRetries", "processOnAllThreadsInReadActionWithRetries", "runOnAllThreads", "", "runnable", "Ljava/lang/Runnable;", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFilesScanExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilesScanExecutor.kt\ncom/intellij/openapi/roots/impl/FilesScanExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public final class FilesScanExecutor {
    @NotNull
    public static final FilesScanExecutor INSTANCE = new FilesScanExecutor();
    @NotNull
    private static final Logger LOG;
    private static final int THREAD_COUNT;
    @NotNull
    private static final ExecutorService ourExecutor;

    private FilesScanExecutor() {
    }

    @JvmStatic
    public static final void runOnAllThreads(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (!ApplicationManager.getApplication().isUnitTestMode() && progress == null) {
            boolean $i$a$-checkNotNull-FilesScanExecutor$runOnAllThreads$232 = false;
            String $i$a$-checkNotNull-FilesScanExecutor$runOnAllThreads$232 = "progress indicator is required";
            throw new IllegalStateException($i$a$-checkNotNull-FilesScanExecutor$runOnAllThreads$232.toString());
        }
        ArrayList results = new ArrayList();
        int n = THREAD_COUNT;
        for (int i2 = 0; i2 < n; ++i2) {
            results.add(ourExecutor.submit(() -> FilesScanExecutor.runOnAllThreads$lambda$1(runnable, progress)));
        }
        runnable.run();
        for (Future future : results) {
            Intrinsics.checkNotNull((Object)future, (String)"null cannot be cast to non-null type java.util.concurrent.FutureTask<*>");
            ((FutureTask)future).run();
            ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future);
        }
    }

    @JvmStatic
    public static final <T> boolean processOnAllThreadsInReadActionWithRetries(@NotNull ConcurrentLinkedDeque<T> deque, @NotNull Function1<? super T, Boolean> consumer2) {
        Intrinsics.checkNotNullParameter(deque, (String)"deque");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return INSTANCE.doProcessOnAllThreadsInReadAction(deque, consumer2, true);
    }

    @JvmStatic
    public static final <T> boolean processOnAllThreadsInReadActionNoRetries(@NotNull ConcurrentLinkedDeque<T> deque, @NotNull Function1<? super T, Boolean> consumer2) {
        Intrinsics.checkNotNullParameter(deque, (String)"deque");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return INSTANCE.doProcessOnAllThreadsInReadAction(deque, consumer2, false);
    }

    private final <T> boolean doProcessOnAllThreadsInReadAction(ConcurrentLinkedDeque<T> deque, Function1<? super T, Boolean> consumer2, boolean retryCanceled) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ApplicationEx application2 = (ApplicationEx)application;
        return this.processOnAllThreads(deque, (Function1)new Function1<T, Boolean>(application2, consumer2, retryCanceled){
            final /* synthetic */ ApplicationEx $application;
            final /* synthetic */ Function1<T, Boolean> $consumer;
            final /* synthetic */ boolean $retryCanceled;
            {
                this.$application = $application;
                this.$consumer = $consumer;
                this.$retryCanceled = $retryCanceled;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(T o) {
                SensitiveProgressWrapper sensitiveProgressWrapper;
                if (this.$application.isReadAccessAllowed()) {
                    return (Boolean)this.$consumer.invoke(o);
                }
                Ref.BooleanRef result2 = new Ref.BooleanRef();
                result2.element = true;
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                Runnable runnable = () -> doProcessOnAllThreadsInReadAction.1.invoke$lambda$0(result2, this.$consumer, o);
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    void it;
                    ProgressIndicator progressIndicator2 = progressIndicator;
                    Runnable runnable2 = runnable;
                    boolean bl = false;
                    sensitiveProgressWrapper = new SensitiveProgressWrapper((ProgressIndicator)it);
                    runnable = runnable2;
                } else {
                    sensitiveProgressWrapper = null;
                }
                if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable, (ProgressIndicator)sensitiveProgressWrapper)) {
                    throw this.$retryCanceled ? (Throwable)new ProcessCanceledException() : (Throwable)new StopWorker();
                }
                return result2.element;
            }

            private static final void invoke$lambda$0(Ref.BooleanRef $result, Function1 $consumer, Object $o) {
                Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
                Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
                $result.element = (Boolean)$consumer.invoke($o);
            }
        });
    }

    private final <T> boolean processOnAllThreads(ConcurrentLinkedDeque<T> deque, Function1<? super T, Boolean> processor) {
        ProgressManager.checkCanceled();
        if (deque.isEmpty()) {
            return true;
        }
        AtomicInteger runnersCount = new AtomicInteger();
        AtomicInteger idleCount = new AtomicInteger();
        AtomicReference error2 = new AtomicReference();
        AtomicBoolean stopped = new AtomicBoolean();
        AtomicBoolean exited = new AtomicBoolean();
        FilesScanExecutor.runOnAllThreads(() -> FilesScanExecutor.processOnAllThreads$lambda$2(runnersCount, stopped, deque, idleCount, processor, exited, error2));
        ExceptionUtil.rethrowAllAsUnchecked((Throwable)error2.get());
        return !stopped.get();
    }

    private final boolean isLibOrigin(IndexableSetOrigin origin) {
        return origin instanceof LibraryOrigin || origin instanceof SyntheticLibraryOrigin || origin instanceof SdkOrigin || origin instanceof ExternalEntityOrigin;
    }

    @JvmStatic
    public static final boolean processFilesInScope(boolean includingBinary, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Processor<? super VirtualFile> processor) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = scope.getProject();
        if (project2 == null) {
            return true;
        }
        Project project3 = project2;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project3).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        boolean searchInLibs = scope.isSearchInLibraries();
        ConcurrentLinkedDeque<Object> deque = new ConcurrentLinkedDeque<Object>();
        ModelBranchImpl.processModifiedFilesInScope(scope, arg_0 -> FilesScanExecutor.processFilesInScope$lambda$3((Function1)new Function1<VirtualFile, Boolean>(deque){
            final /* synthetic */ ConcurrentLinkedDeque<Object> $deque;
            {
                this.$deque = $deque;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.$deque.add(e);
            }
        }, arg_0));
        if (scope instanceof VirtualFileEnumeration) {
            ContainerUtil.addAll((Collection)deque, FileBasedIndexEx.toFileIterable((int[])((VirtualFileEnumeration)((Object)scope)).asArray()));
        } else {
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexEx");
            deque.addAll(((FileBasedIndexEx)fileBasedIndex).getIndexableFilesProviders(project3));
        }
        AtomicInteger skippedCount = new AtomicInteger();
        AtomicInteger processedCount = new AtomicInteger();
        ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create((int)deque.size());
        Intrinsics.checkNotNullExpressionValue((Object)concurrentBitSet, (String)"create(deque.size)");
        ConcurrentBitSet visitedFiles = concurrentBitSet;
        VirtualFileFilter fileFilter = arg_0 -> FilesScanExecutor.processFilesInScope$lambda$4(visitedFiles, idFilter, fileIndex, scope, includingBinary, skippedCount, arg_0);
        Function1 consumer2 = (Function1)new Function1<Object, Boolean>(searchInLibs, project3, fileFilter, processedCount, processor, deque){
            final /* synthetic */ boolean $searchInLibs;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFileFilter $fileFilter;
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ Processor<? super VirtualFile> $processor;
            final /* synthetic */ ConcurrentLinkedDeque<Object> $deque;
            {
                this.$searchInLibs = $searchInLibs;
                this.$project = $project;
                this.$fileFilter = $fileFilter;
                this.$processedCount = $processedCount;
                this.$processor = $processor;
                this.$deque = $deque;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Object obj) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                ProgressManager.checkCanceled();
                Object object = obj;
                if (object instanceof IndexableFilesIterator) {
                    IndexableSetOrigin indexableSetOrigin = ((IndexableFilesIterator)obj).getOrigin();
                    Intrinsics.checkNotNullExpressionValue((Object)indexableSetOrigin, (String)"obj.origin");
                    IndexableSetOrigin origin = indexableSetOrigin;
                    if (!this.$searchInLibs && FilesScanExecutor.access$isLibOrigin(FilesScanExecutor.INSTANCE, origin)) {
                        return true;
                    }
                } else {
                    if (object instanceof VirtualFile) {
                        this.$processedCount.incrementAndGet();
                        if (!((VirtualFile)obj).isValid()) {
                            return true;
                        }
                        return this.$processor.process((VirtualFile)obj);
                    }
                    throw new AssertionError((Object)("unknown item: " + obj));
                }
                ((IndexableFilesIterator)obj).iterateFiles(this.$project, arg_0 -> processFilesInScope.consumer.1.invoke$lambda$0(this.$deque, arg_0), this.$fileFilter);
                return true;
            }

            private static final boolean invoke$lambda$0(ConcurrentLinkedDeque $deque, VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)$deque, (String)"$deque");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (file2.isDirectory()) {
                    return true;
                }
                $deque.add(file2);
                return true;
            }
        };
        long start = System.nanoTime();
        boolean result2 = FilesScanExecutor.processOnAllThreadsInReadActionNoRetries(deque, consumer2);
        if (LOG.isDebugEnabled()) {
            LOG.debug(processedCount.get() + " files processed (" + skippedCount.get() + " skipped) in " + TimeoutUtil.getDurationMillis(start) + " ms");
        }
        return result2;
    }

    private static final void runOnAllThreads$lambda$1(Runnable $runnable, ProgressIndicator $progress) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        ProgressManager.getInstance().runProcess($runnable, (ProgressIndicator)ProgressWrapper.wrap($progress));
    }

    private static final void processOnAllThreads$lambda$2(AtomicInteger $runnersCount, AtomicBoolean $stopped, ConcurrentLinkedDeque $deque, AtomicInteger $idleCount, Function1 $processor, AtomicBoolean $exited, AtomicReference $error) {
        Intrinsics.checkNotNullParameter((Object)$runnersCount, (String)"$runnersCount");
        Intrinsics.checkNotNullParameter((Object)$stopped, (String)"$stopped");
        Intrinsics.checkNotNullParameter((Object)$deque, (String)"$deque");
        Intrinsics.checkNotNullParameter((Object)$idleCount, (String)"$idleCount");
        Intrinsics.checkNotNullParameter((Object)$processor, (String)"$processor");
        Intrinsics.checkNotNullParameter((Object)$exited, (String)"$exited");
        Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
        $runnersCount.incrementAndGet();
        boolean idle = false;
        while (!$stopped.get()) {
            Object item;
            ProgressManager.checkCanceled();
            if ($deque.peek() == null) {
                if (!idle) {
                    idle = true;
                    $idleCount.incrementAndGet();
                }
            } else if (idle) {
                idle = false;
                $idleCount.decrementAndGet();
            }
            if (idle) {
                if ($idleCount.get() == $runnersCount.get() && $deque.isEmpty()) break;
                TimeoutUtil.sleep(1L);
                continue;
            }
            if ($deque.poll() == null) continue;
            try {
                if (!((Boolean)$processor.invoke(item)).booleanValue()) {
                    $stopped.set(true);
                }
                if ($exited.get() && !$stopped.get()) {
                    throw new AssertionError((Object)"early exit");
                }
            }
            catch (StopWorker ex) {
                $deque.addFirst(item);
                $runnersCount.decrementAndGet();
                return;
            }
            catch (ProcessCanceledException ex) {
                $deque.addFirst(item);
            }
            catch (Throwable ex) {
                $error.compareAndSet(null, ex);
            }
        }
        $exited.set(true);
        if (!$deque.isEmpty() && !$stopped.get()) {
            throw new AssertionError((Object)"early exit");
        }
    }

    private static final boolean processFilesInScope$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processFilesInScope$lambda$4(ConcurrentBitSet $visitedFiles, IdFilter $idFilter, ProjectFileIndex $fileIndex, GlobalSearchScope $scope, boolean $includingBinary, AtomicInteger $skippedCount, VirtualFile file2) {
        boolean result2;
        Intrinsics.checkNotNullParameter((Object)$visitedFiles, (String)"$visitedFiles");
        Intrinsics.checkNotNullParameter((Object)$fileIndex, (String)"$fileIndex");
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        Intrinsics.checkNotNullParameter((Object)$skippedCount, (String)"$skippedCount");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
        if ($visitedFiles.set(fileId)) {
            return false;
        }
        boolean bl = result2 = !($idFilter != null && !$idFilter.containsFileId(fileId) || $fileIndex.isExcluded(file2) || !$scope.contains(file2) || !$includingBinary && !file2.isDirectory() && file2.getFileType().isBinary());
        if (!result2) {
            $skippedCount.incrementAndGet();
        }
        return result2;
    }

    public static final /* synthetic */ boolean access$isLibOrigin(FilesScanExecutor $this, IndexableSetOrigin origin) {
        return $this.isLibOrigin(origin);
    }

    static {
        Logger logger = Logger.getInstance(FilesScanExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(FilesScanExecutor::class.java)");
        LOG = logger;
        THREAD_COUNT = RangesKt.coerceAtLeast((int)(UnindexedFilesUpdater.getNumberOfScanningThreads() - 1), (int)1);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor("Scanning", THREAD_COUNT);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026\"Scanning\", THREAD_COUNT)");
        ourExecutor = executorService;
    }
}

