/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsScope;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public final class LibraryScopeCache {
    private final LibrariesOnlyScope myLibrariesOnlyScope;
    private final Project myProject;
    private final ConcurrentMap<Module[], GlobalSearchScope> myLibraryScopes;
    private final ConcurrentMap<String, GlobalSearchScope> mySdkScopes;
    private final Map<List<? extends OrderEntry>, GlobalSearchScope> myLibraryResolveScopeCache;
    private final Map<List<? extends OrderEntry>, GlobalSearchScope> myLibraryUseScopeCache;

    public static LibraryScopeCache getInstance(@NotNull Project project2) {
        if (project2 == null) {
            LibraryScopeCache.$$$reportNull$$$0(0);
        }
        return project2.getService(LibraryScopeCache.class);
    }

    public LibraryScopeCache(@NotNull Project project2) {
        if (project2 == null) {
            LibraryScopeCache.$$$reportNull$$$0(1);
        }
        this.myLibraryScopes = ConcurrentCollectionFactory.createConcurrentMap((HashingStrategy)new HashingStrategy<Module[]>(){

            @Override
            public int hashCode(Module[] object) {
                return Arrays.hashCode(object);
            }

            @Override
            public boolean equals(Module[] o1, Module[] o2) {
                return Arrays.equals(o1, o2);
            }
        });
        this.mySdkScopes = new ConcurrentHashMap<String, GlobalSearchScope>();
        this.myLibraryResolveScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryScope((List<? extends OrderEntry>)key));
        this.myLibraryUseScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryUseScope((List<? extends OrderEntry>)key));
        this.myProject = project2;
        this.myLibrariesOnlyScope = new LibrariesOnlyScope(GlobalSearchScope.allScope(this.myProject), this.myProject);
    }

    void clear() {
        this.myLibraryScopes.clear();
        this.mySdkScopes.clear();
        this.myLibraryResolveScopeCache.clear();
        this.myLibraryUseScopeCache.clear();
    }

    @NotNull
    public GlobalSearchScope getLibrariesOnlyScope() {
        LibrariesOnlyScope librariesOnlyScope = this.myLibrariesOnlyScope;
        if (librariesOnlyScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(2);
        }
        return librariesOnlyScope;
    }

    @NotNull
    private GlobalSearchScope getScopeForLibraryUsedIn(@NotNull List<? extends Module> modulesLibraryIsUsedIn) {
        Module[] array;
        GlobalSearchScope scope;
        if (modulesLibraryIsUsedIn == null) {
            LibraryScopeCache.$$$reportNull$$$0(3);
        }
        GlobalSearchScope globalSearchScope = (scope = (GlobalSearchScope)this.myLibraryScopes.get(array = modulesLibraryIsUsedIn.toArray(Module.EMPTY_ARRAY))) != null ? scope : (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.myLibraryScopes, array, new LibraryRuntimeClasspathScope(this.myProject, modulesLibraryIsUsedIn));
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryScope(@NotNull List<? extends OrderEntry> orderEntries) {
        if (orderEntries == null) {
            LibraryScopeCache.$$$reportNull$$$0(5);
        }
        GlobalSearchScope globalSearchScope = this.myLibraryResolveScopeCache.get(orderEntries);
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryUseScope(@NotNull List<? extends OrderEntry> orderEntries) {
        if (orderEntries == null) {
            LibraryScopeCache.$$$reportNull$$$0(7);
        }
        GlobalSearchScope globalSearchScope = this.myLibraryUseScopeCache.get(orderEntries);
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryScope(@NotNull List<? extends OrderEntry> orderEntries) {
        GlobalSearchScope allCandidates;
        if (orderEntries == null) {
            LibraryScopeCache.$$$reportNull$$$0(9);
        }
        ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
        LibraryOrderEntry lib = null;
        for (OrderEntry orderEntry2 : orderEntries) {
            if (orderEntry2 instanceof JdkOrderEntry) {
                GlobalSearchScope globalSearchScope = this.getScopeForSdk((JdkOrderEntry)orderEntry2);
                if (globalSearchScope == null) {
                    LibraryScopeCache.$$$reportNull$$$0(10);
                }
                return globalSearchScope;
            }
            if (orderEntry2 instanceof LibraryOrderEntry) {
                lib = (LibraryOrderEntry)orderEntry2;
                modulesLibraryUsedIn.add(orderEntry2.getOwnerModule());
                continue;
            }
            if (!(orderEntry2 instanceof ModuleOrderEntry)) continue;
            modulesLibraryUsedIn.add(orderEntry2.getOwnerModule());
        }
        Comparator<Module> comparator = Comparator.comparing(Module::getName);
        modulesLibraryUsedIn.sort(comparator);
        List<Module> list2 = ContainerUtil.removeDuplicatesFromSorted(modulesLibraryUsedIn, comparator);
        GlobalSearchScope globalSearchScope = allCandidates = list2.isEmpty() ? this.myLibrariesOnlyScope : this.getScopeForLibraryUsedIn(list2);
        if (lib != null) {
            final LibraryRuntimeClasspathScope preferred = new LibraryRuntimeClasspathScope(this.myProject, lib);
            return new DelegatingGlobalSearchScope(allCandidates, new Object[]{preferred}){

                @Override
                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    if (file1 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    boolean c1 = preferred.contains(file1);
                    boolean c2 = preferred.contains(file2);
                    if (c1 && !c2) {
                        return 1;
                    }
                    if (c2 && !c1) {
                        return -1;
                    }
                    return super.compare(file1, file2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file2";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/impl/LibraryScopeCache$2";
                    objectArray[2] = "compare";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        GlobalSearchScope globalSearchScope2 = allCandidates;
        if (globalSearchScope2 == null) {
            LibraryScopeCache.$$$reportNull$$$0(11);
        }
        return globalSearchScope2;
    }

    @NotNull
    public GlobalSearchScope getScopeForSdk(@NotNull JdkOrderEntry jdkOrderEntry) {
        String jdkName;
        if (jdkOrderEntry == null) {
            LibraryScopeCache.$$$reportNull$$$0(12);
        }
        if ((jdkName = jdkOrderEntry.getJdkName()) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myProject);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = (GlobalSearchScope)this.mySdkScopes.get(jdkName);
        if (scope == null) {
            scope = new JdkScope(this.myProject, jdkOrderEntry);
            GlobalSearchScope globalSearchScope = ConcurrencyUtil.cacheOrGet(this.mySdkScopes, jdkName, scope);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryUseScope(@NotNull List<? extends OrderEntry> entries2) {
        if (entries2 == null) {
            LibraryScopeCache.$$$reportNull$$$0(16);
        }
        HashSet modulesWithLibrary = new HashSet(entries2.size());
        HashSet<Module> modulesWithSdk = new HashSet<Module>(entries2.size());
        for (OrderEntry orderEntry2 : entries2) {
            (orderEntry2 instanceof JdkOrderEntry ? modulesWithSdk : modulesWithLibrary).add(orderEntry2.getOwnerModule());
        }
        modulesWithSdk.removeAll(modulesWithLibrary);
        if (modulesWithSdk.size() + modulesWithLibrary.size() == ModuleManager.getInstance(this.myProject).getModules().length) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myProject);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(17);
            }
            return globalSearchScope;
        }
        ArrayList<GlobalSearchScope> united = new ArrayList<GlobalSearchScope>();
        if (!modulesWithSdk.isEmpty()) {
            united.add(new ModulesScope(modulesWithSdk, this.myProject));
            united.add(this.myLibrariesOnlyScope.intersectWith(new LibraryRuntimeClasspathScope(this.myProject, modulesWithSdk)));
        } else {
            united.add(this.myLibrariesOnlyScope);
        }
        if (!modulesWithLibrary.isEmpty()) {
            united.add(new ModuleWithDependentsScope(this.myProject, modulesWithLibrary));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union(united.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(18);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/LibraryScopeCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesLibraryIsUsedIn";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkOrderEntry";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/LibraryScopeCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesOnlyScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForLibraryUsedIn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUseScope";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLibraryScope";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForSdk";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLibraryUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForLibraryUsedIn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUseScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcLibraryScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForSdk";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcLibraryUseScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 18 -> new IllegalStateException(string2);
        };
    }

    private static final class LibrariesOnlyScope
    extends DelegatingGlobalSearchScope {
        private final ProjectFileIndex myIndex;

        private LibrariesOnlyScope(@NotNull GlobalSearchScope original, @NotNull Project project2) {
            if (original == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(1);
            }
            super(original);
            this.myIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(2);
            }
            return super.contains(file2) && this.myIndex.isInLibrary(file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(3);
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public String toString() {
            return "Libraries only in (" + this.myBaseScope + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

