/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentOrSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    @NotNull
    private final Module myModule;

    public ModuleFileIndexImpl(@NotNull Module module2) {
        if (module2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(0);
        }
        super(module2.getProject());
        this.myModule = module2;
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter2) {
        if (processor == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(1);
        }
        Set<VirtualFile> contentRoots = this.getModuleRootsToIterate();
        for (VirtualFile contentRoot : contentRoots) {
            if (this.iterateContentUnderDirectory(contentRoot, processor, filter2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Set<VirtualFile> getModuleRootsToIterate() {
        Set set2 = ReadAction.compute(() -> {
            if (this.myModule.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(this.myModule);
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(this.myModule.getProject());
            Iterator iterator2 = Arrays.asList(moduleRootManager.getContentRoots(), moduleRootManager.getSourceRoots()).iterator();
            while (iterator2.hasNext()) {
                VirtualFile[] roots2;
                for (VirtualFile root : roots2 = (VirtualFile[])iterator2.next()) {
                    Module parentModule;
                    VirtualFile parent2;
                    if (!projectFileIndex.isInProject(root) || (parent2 = root.getParent()) != null && this.myModule.equals(parentModule = projectFileIndex.getModuleForFile(parent2, false))) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
        if (set2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(3);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleContentOrSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, false, ModuleContentOrSourceRootData.class);
            return this.isFromThisModule(fileSet);
        }
        return this.isInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    private boolean isFromThisModule(@Nullable WorkspaceFileSetWithCustomData<? extends ModuleContentOrSourceRootData> fileSet) {
        return fileSet != null && fileSet.getData().getModule().equals(this.myModule);
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(4);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, false, ModuleSourceRootData.class);
            return fileSet != null && this.isFromThisModule(fileSet);
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInModuleSource(fileOrDir) && this.myModule.equals(info2.getModule());
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(5);
        }
        return ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(fileOrDir));
    }

    @Override
    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(6);
        }
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(fileOrDir));
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(7);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, false, ModuleSourceRootData.class);
            return fileSet != null && this.isFromThisModule(fileSet) && fileSet.getKind() == WorkspaceFileKind.TEST_CONTENT;
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInModuleSource(fileOrDir) && this.myModule.equals(info2.getModule()) && this.isTestSourcesRoot(info2);
    }

    @Override
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(8);
        }
        if (rootTypes == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(9);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, false, ModuleSourceRootData.class);
            return this.isFromThisModule(fileSet) && ProjectFileIndexImpl.isSourceRootOfType(fileSet, rootTypes);
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInModuleSource(fileOrDir) && this.myModule.equals(info2.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info2));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myModule.isDisposed();
    }

    @Nullable
    public static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> orderEntries) {
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(10);
        }
        if (orderEntries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(11);
        }
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry2 : orderEntries) {
                if (orderEntry2.getOwnerModule() != ownerModule) continue;
                return orderEntry2;
            }
            return null;
        }
        int index2 = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index2 < 0 ? null : orderEntries.get(index2);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> entries2) {
        int lastIndex;
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(12);
        }
        if (entries2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(13);
        }
        if (entries2.isEmpty()) {
            List<OrderEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(14);
            }
            return list2;
        }
        if (entries2.size() == 1) {
            OrderEntry entry = entries2.get(0);
            ArrayList<OrderEntry> arrayList = entry.getOwnerModule() == ownerModule ? new ArrayList<OrderEntry>(entries2) : Collections.emptyList();
            if (arrayList == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        int index2 = Collections.binarySearch(entries2, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index2 < 0) {
            List<OrderEntry> list3 = Collections.emptyList();
            if (list3 == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(16);
            }
            return list3;
        }
        int firstIndex = index2;
        while (firstIndex - 1 >= 0 && entries2.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index2 + 1; lastIndex < entries2.size() && entries2.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        return new ArrayList<OrderEntry>(entries2.subList(firstIndex, lastIndex));
    }

    @Override
    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info2) {
        if (file2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(17);
        }
        if (info2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(18);
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info2) && this.myModule.equals(info2.getModule());
    }

    @Override
    protected boolean isInContent(@NotNull WorkspaceFileSetWithCustomData<?> fileSet) {
        ModuleContentOrSourceRootData data2;
        Object obj;
        if (fileSet == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(19);
        }
        return (obj = fileSet.getData()) instanceof ModuleContentOrSourceRootData && this.myModule.equals((data2 = (ModuleContentOrSourceRootData)obj).getModule());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootsToIterate";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrderEntryWithOwnerModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 14, 15, 16 -> new IllegalStateException(string2);
        };
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        FakeOrderEntry(@NotNull Module ownerModule) {
            if (ownerModule == null) {
                FakeOrderEntry.$$$reportNull$$$0(0);
            }
            this.myOwnerModule = ownerModule;
        }

        @Override
        public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type) {
            if (type == null) {
                FakeOrderEntry.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                FakeOrderEntry.$$$reportNull$$$0(2);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public Module getOwnerModule() {
            Module module2 = this.myOwnerModule;
            if (module2 == null) {
                FakeOrderEntry.$$$reportNull$$$0(3);
            }
            return module2;
        }

        @Override
        public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
            if (policy == null) {
                FakeOrderEntry.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public int compareTo(@NotNull OrderEntry o) {
            if (o == null) {
                FakeOrderEntry.$$$reportNull$$$0(5);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }
}

