/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OrderEntryUtil {
    private OrderEntryUtil() {
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model2, @Nullable Library library) {
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(0);
        }
        if (library == null) {
            return null;
        }
        for (OrderEntry orderEntry2 : model2.getOrderEntries()) {
            if (!(orderEntry2 instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry2).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry2;
        }
        return null;
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model2, @NotNull String libraryName) {
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            OrderEntryUtil.$$$reportNull$$$0(2);
        }
        for (OrderEntry orderEntry2 : model2.getOrderEntries()) {
            String libName;
            if (!(orderEntry2 instanceof LibraryOrderEntry) || !libraryName.equals(libName = ((LibraryOrderEntry)orderEntry2).getLibraryName())) continue;
            return (LibraryOrderEntry)orderEntry2;
        }
        return null;
    }

    @Nullable
    public static ModuleOrderEntry findModuleOrderEntry(@NotNull ModuleRootModel model2, @Nullable Module module2) {
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            return null;
        }
        for (OrderEntry orderEntry2 : model2.getOrderEntries()) {
            if (!(orderEntry2 instanceof ModuleOrderEntry) || !module2.equals(((ModuleOrderEntry)orderEntry2).getModule())) continue;
            return (ModuleOrderEntry)orderEntry2;
        }
        return null;
    }

    @Nullable
    public static JdkOrderEntry findJdkOrderEntry(@NotNull ModuleRootModel model2, @Nullable Sdk sdk2) {
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(4);
        }
        if (sdk2 == null) {
            return null;
        }
        for (OrderEntry orderEntry2 : model2.getOrderEntries()) {
            if (!(orderEntry2 instanceof JdkOrderEntry) || !sdk2.equals(((JdkOrderEntry)orderEntry2).getJdk())) continue;
            return (JdkOrderEntry)orderEntry2;
        }
        return null;
    }

    public static boolean equals(OrderEntry orderEntry1, OrderEntry orderEntry2) {
        if (orderEntry1 instanceof JdkOrderEntry && orderEntry2 instanceof JdkOrderEntry) {
            JdkOrderEntry jdkOrderEntry1 = (JdkOrderEntry)orderEntry1;
            JdkOrderEntry jdkOrderEntry2 = (JdkOrderEntry)orderEntry2;
            return Comparing.equal(jdkOrderEntry1.getJdk(), jdkOrderEntry2.getJdk()) && Comparing.strEqual(jdkOrderEntry1.getJdkName(), jdkOrderEntry2.getJdkName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry && orderEntry2 instanceof LibraryOrderEntry) {
            LibraryOrderEntry jdkOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry jdkOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            return Comparing.equal(jdkOrderEntry1.getLibrary(), jdkOrderEntry2.getLibrary());
        }
        if (orderEntry1 instanceof ModuleSourceOrderEntry && orderEntry2 instanceof ModuleSourceOrderEntry) {
            ModuleSourceOrderEntry jdkOrderEntry1 = (ModuleSourceOrderEntry)orderEntry1;
            ModuleSourceOrderEntry jdkOrderEntry2 = (ModuleSourceOrderEntry)orderEntry2;
            return Comparing.equal(jdkOrderEntry1.getOwnerModule(), jdkOrderEntry2.getOwnerModule());
        }
        if (orderEntry1 instanceof ModuleOrderEntry && orderEntry2 instanceof ModuleOrderEntry) {
            ModuleOrderEntry jdkOrderEntry1 = (ModuleOrderEntry)orderEntry1;
            ModuleOrderEntry jdkOrderEntry2 = (ModuleOrderEntry)orderEntry2;
            return Comparing.equal(jdkOrderEntry1.getModule(), jdkOrderEntry2.getModule());
        }
        return false;
    }

    public static boolean equals(Library library1, Library library2) {
        if (library1 == library2) {
            return true;
        }
        if (library1 == null || library2 == null) {
            return false;
        }
        LibraryTable table = library1.getTable();
        if (table != null) {
            if (library2.getTable() != table) {
                return false;
            }
            String name = library1.getName();
            return name != null && name.equals(library2.getName());
        }
        if (library2.getTable() != null) {
            return false;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            if (Arrays.equals(library1.getUrls(type), library2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    public static void addLibraryToRoots(@NotNull LibraryOrderEntry libraryOrderEntry, @NotNull Module module2) {
        Library library;
        if (libraryOrderEntry == null) {
            OrderEntryUtil.$$$reportNull$$$0(5);
        }
        if (module2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(6);
        }
        if ((library = libraryOrderEntry.getLibrary()) == null) {
            return;
        }
        OrderEntryUtil.addLibraryToRoots(module2, library);
    }

    public static void addLibraryToRoots(@NotNull Module module2, @NotNull Library library) {
        if (module2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(7);
        }
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(8);
        }
        OrderEntryUtil.addLibraryToRoots(module2, library, DependencyScope.COMPILE, false);
    }

    public static void addLibraryToRoots(@NotNull Module module2, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        LibraryOrderEntry entry;
        if (module2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(9);
        }
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            OrderEntryUtil.$$$reportNull$$$0(11);
        }
        ModifiableRootModel rootModel = ModuleRootManager.getInstance(module2).getModifiableModel();
        if (library.getTable() == null) {
            Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
            Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
            for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                VirtualFile[] files2;
                for (VirtualFile jarFile : files2 = library.getFiles(orderRootType)) {
                    libraryModel.addRoot(jarFile, orderRootType);
                }
            }
            libraryModel.commit();
            entry = rootModel.findLibraryOrderEntry(jarLibrary);
        } else {
            entry = rootModel.addLibraryEntry(library);
        }
        if (entry != null) {
            entry.setScope(scope);
            entry.setExported(exported);
        }
        rootModel.commit();
    }

    private static int findLibraryOrderEntry(OrderEntry @NotNull [] entries2, @NotNull Library library) {
        if (library == null) {
            OrderEntryUtil.$$$reportNull$$$0(12);
        }
        if (entries2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(13);
        }
        for (int i2 = 0; i2 < entries2.length; ++i2) {
            OrderEntry entry = entries2[i2];
            if (!(entry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)entry).getLibrary())) continue;
            return i2;
        }
        return -1;
    }

    public static void replaceLibrary(@NotNull ModifiableRootModel model2, @NotNull Library oldLibrary, @NotNull Library newLibrary) {
        int i2;
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(14);
        }
        if (oldLibrary == null) {
            OrderEntryUtil.$$$reportNull$$$0(15);
        }
        if (newLibrary == null) {
            OrderEntryUtil.$$$reportNull$$$0(16);
        }
        if ((i2 = OrderEntryUtil.findLibraryOrderEntry(model2.getOrderEntries(), oldLibrary)) == -1) {
            return;
        }
        model2.addLibraryEntry(newLibrary);
        OrderEntryUtil.replaceLibraryByAdded(model2, i2);
    }

    public static void replaceLibraryEntryByAdded(@NotNull ModifiableRootModel model2, @NotNull LibraryOrderEntry entry) {
        int i2;
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(17);
        }
        if (entry == null) {
            OrderEntryUtil.$$$reportNull$$$0(18);
        }
        if ((i2 = ArrayUtil.indexOf(model2.getOrderEntries(), entry)) == -1) {
            return;
        }
        OrderEntryUtil.replaceLibraryByAdded(model2, i2);
    }

    private static void replaceLibraryByAdded(@NotNull ModifiableRootModel model2, int toReplace) {
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(19);
        }
        OrderEntry[] entries2 = model2.getOrderEntries();
        LibraryOrderEntry newEntry2 = (LibraryOrderEntry)entries2[entries2.length - 1];
        LibraryOrderEntry libraryEntry2 = (LibraryOrderEntry)entries2[toReplace];
        boolean exported = libraryEntry2.isExported();
        DependencyScope scope = libraryEntry2.getScope();
        model2.removeOrderEntry(libraryEntry2);
        newEntry2.setExported(exported);
        newEntry2.setScope(scope);
        OrderEntry[] newEntries = new OrderEntry[entries2.length - 1];
        System.arraycopy(entries2, 0, newEntries, 0, toReplace);
        newEntries[toReplace] = newEntry2;
        System.arraycopy(entries2, toReplace + 1, newEntries, toReplace + 1, entries2.length - toReplace - 2);
        model2.rearrangeOrderEntries(newEntries);
    }

    public static <T extends OrderEntry> void processOrderEntries(@NotNull Module module2, @NotNull Class<? extends T> orderEntryClass, @NotNull Processor<? super T> processor) {
        OrderEntry[] orderEntries;
        if (module2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(20);
        }
        if (orderEntryClass == null) {
            OrderEntryUtil.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            OrderEntryUtil.$$$reportNull$$$0(22);
        }
        for (OrderEntry orderEntry2 : orderEntries = ModuleRootManager.getInstance(module2).getOrderEntries()) {
            if (orderEntryClass.isInstance(orderEntry2) && !processor.process(orderEntryClass.cast(orderEntry2))) break;
        }
    }

    @NotNull
    public static DependencyScope intersectScopes(@NotNull DependencyScope scope1, @NotNull DependencyScope scope2) {
        if (scope1 == null) {
            OrderEntryUtil.$$$reportNull$$$0(23);
        }
        if (scope2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(24);
        }
        if (scope1 == scope2) {
            DependencyScope dependencyScope = scope1;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(25);
            }
            return dependencyScope;
        }
        if (scope1 == DependencyScope.COMPILE) {
            DependencyScope dependencyScope = scope2;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(26);
            }
            return dependencyScope;
        }
        if (scope2 == DependencyScope.COMPILE) {
            DependencyScope dependencyScope = scope1;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(27);
            }
            return dependencyScope;
        }
        if (scope1 == DependencyScope.TEST || scope2 == DependencyScope.TEST) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                OrderEntryUtil.$$$reportNull$$$0(28);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = scope1;
        if (dependencyScope == null) {
            OrderEntryUtil.$$$reportNull$$$0(29);
        }
        return dependencyScope;
    }

    @NotNull
    public static List<Library> getModuleLibraries(@NotNull ModuleRootModel model2) {
        if (model2 == null) {
            OrderEntryUtil.$$$reportNull$$$0(30);
        }
        OrderEntry[] orderEntries = model2.getOrderEntries();
        ArrayList<Library> libraries2 = new ArrayList<Library>();
        for (OrderEntry orderEntry2 : orderEntries) {
            LibraryOrderEntry entry;
            if (!(orderEntry2 instanceof LibraryOrderEntry) || !(entry = (LibraryOrderEntry)orderEntry2).isModuleLevel()) continue;
            libraries2.add(entry.getLibrary());
        }
        ArrayList<Library> arrayList = libraries2;
        if (arrayList == null) {
            OrderEntryUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public static boolean isModuleLibraryOrderEntry(@Nullable OrderEntry orderEntry2) {
        return orderEntry2 instanceof LibraryOrderEntry && ((LibraryOrderEntry)orderEntry2).isModuleLevel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 25, 26, 27, 28, 29, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryOrderEntry";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLibrary";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLibrary";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderEntryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderEntryUtil";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectScopes";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findModuleOrderEntry";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findJdkOrderEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryToRoots";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibrary";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibraryEntryByAdded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibraryByAdded";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processOrderEntries";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "intersectScopes";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getModuleLibraries";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 25, 26, 27, 28, 29, 31 -> new IllegalStateException(string2);
        };
    }
}

