/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

class OrderRootsEnumeratorImpl
implements OrderRootsEnumerator {
    private static final Logger LOG = Logger.getInstance(OrderRootsEnumeratorImpl.class);
    private final OrderEnumeratorBase myOrderEnumerator;
    private final OrderRootType myRootType;
    private final NotNullFunction<? super OrderEntry, ? extends OrderRootType> myRootTypeProvider;
    private boolean myUsingCache;
    private NotNullFunction<? super JdkOrderEntry, VirtualFile[]> myCustomSdkRootProvider;
    private boolean myWithoutSelfModuleOutput;

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull OrderRootType rootType) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(0);
        }
        if (rootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(1);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = rootType;
        this.myRootTypeProvider = null;
    }

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(2);
        }
        if (rootTypeProvider == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(3);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = null;
        this.myRootTypeProvider = rootTypeProvider;
    }

    @Override
    public VirtualFile @NotNull [] getRoots() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache2 = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            VirtualFile[] virtualFileArray = cache2.getOrComputeRoots(this.myRootType, flags, this::computeRootsUrls);
            if (virtualFileArray == null) {
                OrderRootsEnumeratorImpl.$$$reportNull$$$0(4);
            }
            return virtualFileArray;
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.computeRoots());
        if (virtualFileArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    @Override
    public String @NotNull [] getUrls() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache2 = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            String[] stringArray = cache2.getOrComputeUrls(this.myRootType, flags, this::computeRootsUrls);
            if (stringArray == null) {
                OrderRootsEnumeratorImpl.$$$reportNull$$$0(6);
            }
            return stringArray;
        }
        String[] stringArray = ArrayUtilRt.toStringArray(this.computeRootsUrls());
        if (stringArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    private void checkCanUseCache() {
        LOG.assertTrue(this.myRootTypeProvider == null, "Caching not supported for OrderRootsEnumerator with root type provider");
        LOG.assertTrue(this.myCustomSdkRootProvider == null, "Caching not supported for OrderRootsEnumerator with 'usingCustomRootProvider' option");
        LOG.assertTrue(!this.myWithoutSelfModuleOutput, "Caching not supported for OrderRootsEnumerator with 'withoutSelfModuleOutput' option");
    }

    @NotNull
    private Collection<VirtualFile> computeRoots() {
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        this.myOrderEnumerator.forEach((orderEntry2, customHandlers) -> {
            OrderRootType type = this.getRootType((OrderEntry)orderEntry2);
            if (orderEntry2 instanceof ModuleSourceOrderEntry) {
                this.collectModuleRoots(type, ((ModuleSourceOrderEntry)orderEntry2).getRootModel(), (Collection<? super VirtualFile>)result2, true, !this.myOrderEnumerator.isProductionOnly(), (List<? extends OrderEnumerationHandler>)customHandlers);
            } else if (orderEntry2 instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry2;
                Module module2 = moduleOrderEntry.getModule();
                if (module2 != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module2);
                    boolean productionOnTests = ((ModuleOrderEntry)orderEntry2).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRoots(type, rootModel, (Collection<? super VirtualFile>)result2, !productionOnTests, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers);
                }
            } else if (orderEntry2 instanceof LibraryOrSdkOrderEntry) {
                if (this.myCustomSdkRootProvider != null && orderEntry2 instanceof JdkOrderEntry) {
                    Collections.addAll(result2, this.myCustomSdkRootProvider.fun((JdkOrderEntry)orderEntry2));
                    return true;
                }
                if (OrderEnumeratorBase.addCustomRootsForLibraryOrSdk((LibraryOrSdkOrderEntry)orderEntry2, type, result2, customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, ((LibraryOrSdkOrderEntry)orderEntry2).getRootFiles(type));
            } else {
                LOG.error("Unexpected implementation of OrderEntry: " + orderEntry2.getClass().getName());
            }
            return true;
        });
        LinkedHashSet<VirtualFile> linkedHashSet = result2;
        if (linkedHashSet == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<String> computeRootsUrls() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        this.myOrderEnumerator.forEach((orderEntry2, customHandlers) -> {
            OrderRootType type = this.getRootType((OrderEntry)orderEntry2);
            if (orderEntry2 instanceof ModuleSourceOrderEntry) {
                boolean includeTests = !this.myOrderEnumerator.isProductionOnly();
                this.collectModuleRootsUrls(type, ((ModuleSourceOrderEntry)orderEntry2).getRootModel(), (Collection<String>)result2, true, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers);
            } else if (orderEntry2 instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry2;
                Module module2 = moduleOrderEntry.getModule();
                if (module2 != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module2);
                    boolean productionOnTests = ((ModuleOrderEntry)orderEntry2).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRootsUrls(type, rootModel, (Collection<String>)result2, !productionOnTests, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers);
                }
            } else if (orderEntry2 instanceof LibraryOrSdkOrderEntry) {
                if (OrderEnumeratorBase.addCustomRootUrlsForLibraryOrSdk((LibraryOrSdkOrderEntry)orderEntry2, type, result2, customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, ((LibraryOrSdkOrderEntry)orderEntry2).getRootUrls(type));
            } else {
                LOG.error("Unexpected implementation of OrderEntry: " + orderEntry2.getClass().getName());
            }
            return true;
        });
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public PathsList getPathsList() {
        PathsList list2 = new PathsList();
        this.collectPaths(list2);
        PathsList pathsList = list2;
        if (pathsList == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(10);
        }
        return pathsList;
    }

    @Override
    public void collectPaths(@NotNull PathsList list2) {
        if (list2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(11);
        }
        list2.addVirtualFiles(this.getRoots());
    }

    @Override
    @NotNull
    public OrderRootsEnumerator usingCache() {
        this.myUsingCache = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(12);
        }
        return orderRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(13);
        }
        return orderRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator usingCustomRootProvider(@NotNull NotNullFunction<? super OrderEntry, VirtualFile[]> provider2) {
        if (provider2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(14);
        }
        OrderRootsEnumerator orderRootsEnumerator = this.usingCustomSdkRootProvider(provider2);
        if (orderRootsEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(15);
        }
        return orderRootsEnumerator;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator usingCustomSdkRootProvider(@NotNull NotNullFunction<? super JdkOrderEntry, VirtualFile[]> provider2) {
        if (provider2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(16);
        }
        this.myCustomSdkRootProvider = provider2;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(17);
        }
        return orderRootsEnumeratorImpl;
    }

    private void collectModuleRoots(@NotNull OrderRootType type, ModuleRootModel rootModel, @NotNull Collection<? super VirtualFile> result2, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        CompilerModuleExtension extension2;
        if (type == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(19);
        }
        if (customHandlers == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(20);
        }
        if (type.equals(OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRoots(includeTests));
            } else {
                result2.addAll(rootModel.getSourceRoots(JavaModuleSourceRootTypes.TESTS));
            }
        } else if (type.equals(OrderRootType.CLASSES) && (extension2 = rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result2, extension2.getOutputRoots(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result2, extension2.getOutputRoots(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result2, extension2.getCompilerOutputPathForTests());
            }
        }
        OrderEnumeratorBase.addCustomRootsForModule(type, rootModel, result2, includeProduction, includeTests, customHandlers);
    }

    private void collectModuleRootsUrls(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result2, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (type == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(21);
        }
        if (rootModel == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(22);
        }
        if (result2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(23);
        }
        if (customHandlers == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(24);
        }
        if (type.equals(OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRootUrls(includeTests));
            } else {
                for (ContentEntry entry : rootModel.getContentEntries()) {
                    for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.TESTS)) {
                        result2.add(folder.getUrl());
                    }
                }
            }
        } else if (type.equals(OrderRootType.CLASSES)) {
            boolean hasTests = false;
            boolean hasProduction = false;
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    if (sourceFolder.isTestSource()) {
                        hasTests = true;
                        continue;
                    }
                    hasProduction = true;
                }
            }
            includeTests &= hasTests;
            includeProduction &= hasProduction;
            CompilerModuleExtension extension2 = rootModel.getModuleExtension(CompilerModuleExtension.class);
            if (extension2 != null) {
                if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                    if (includeTests && includeProduction) {
                        Collections.addAll(result2, extension2.getOutputRootUrls(false));
                    }
                } else if (includeProduction) {
                    Collections.addAll(result2, extension2.getOutputRootUrls(includeTests));
                } else if (includeTests) {
                    ContainerUtil.addIfNotNull(result2, extension2.getCompilerOutputUrlForTests());
                }
            }
        }
        OrderEnumeratorBase.addCustomRootsUrlsForModule(type, rootModel, result2, includeProduction, includeTests, customHandlers);
    }

    @NotNull
    private OrderRootType getRootType(@NotNull OrderEntry e) {
        if (e == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(25);
        }
        OrderRootType orderRootType = this.myRootType != null ? this.myRootType : this.myRootTypeProvider.fun(e);
        if (orderRootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(26);
        }
        return orderRootType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 12, 13, 15, 17, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEnumerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootsUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSelfModuleOutput";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCustomRootProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCustomSdkRootProvider";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "usingCustomRootProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "usingCustomSdkRootProvider";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleRoots";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleRootsUrls";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRootType";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6, 7, 8, 9, 10, 12, 13, 15, 17, 26 -> new IllegalStateException(string2);
        };
    }
}

