/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentOrSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleOrLibrarySourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.UnloadedModuleContentRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.SourceRootTypeRegistry;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance(ProjectFileIndexImpl.class);
    private final Project myProject;

    public ProjectFileIndexImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myProject = project2;
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter2) {
        Module[] modules2;
        if (processor == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(1);
        }
        for (Module module2 : modules2 = ReadAction.compute(() -> ModuleManager.getInstance(this.myProject).getModules())) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module2)) {
                if (this.iterateContentUnderDirectory(contentRoot, processor, filter2)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<VirtualFile> getRootsToIterate(@NotNull Module module2) {
        if (module2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(2);
        }
        Set set2 = ReadAction.compute(() -> {
            if (module2.isDisposed()) {
                return Collections.emptySet();
            }
            ModuleFileIndexImpl moduleFileIndex = (ModuleFileIndexImpl)ModuleRootManager.getInstance(module2).getFileIndex();
            Set<VirtualFile> result2 = moduleFileIndex.getModuleRootsToIterate();
            Iterator<VirtualFile> iterator2 = result2.iterator();
            while (iterator2.hasNext()) {
                VirtualFile root = iterator2.next();
                Module moduleForFile = this.getModuleForFile(root, false);
                if (!module2.equals(moduleForFile)) {
                    iterator2.remove();
                    continue;
                }
                VirtualFile parent2 = root.getParent();
                if (parent2 == null || !this.isInContent(parent2)) continue;
                iterator2.remove();
            }
            return result2;
        });
        if (set2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(4);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileInternalInfo info2 = this.myWorkspaceFileIndex.getFileInfo(file2, true, true, true, true);
            return info2 == WorkspaceFileInternalInfo.NonWorkspace.IGNORED || info2 == WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED;
        }
        DirectoryInfo info3 = this.getInfoForFileOrDirectory(file2);
        return info3.isIgnored() || info3.isExcluded(file2);
    }

    @Override
    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(5);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileInternalInfo info2 = this.myWorkspaceFileIndex.getFileInfo(file2, true, true, true, true);
            return info2 == WorkspaceFileInternalInfo.NonWorkspace.IGNORED;
        }
        return this.getInfoForFileOrDirectory(file2).isIgnored();
    }

    @Override
    public boolean isInProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(6);
        }
        if (this.myWorkspaceFileIndex != null) {
            return this.myWorkspaceFileIndex.isInWorkspace(file2);
        }
        return this.getInfoForFileOrDirectory(file2).isInProject(file2);
    }

    @Override
    public boolean isInProjectOrExcluded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(7);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileInternalInfo info2 = this.myWorkspaceFileIndex.getFileInfo(file2, true, true, true, true);
            return info2 == WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED || !(info2 instanceof WorkspaceFileInternalInfo.NonWorkspace);
        }
        DirectoryInfo directoryInfo = this.getInfoForFileOrDirectory(file2);
        return directoryInfo.isInProject(file2) || directoryInfo.isExcluded(file2);
    }

    @Override
    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(8);
        }
        return this.getModuleForFile(file2, true);
    }

    @Override
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        DirectoryInfo info2;
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(9);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleContentOrSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file2, honorExclusion, true, false, false, ModuleContentOrSourceRootData.class);
            if (fileSet == null) {
                return null;
            }
            return fileSet.getData().getModule();
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        if ((info2 = this.getInfoForFileOrDirectory(file2 = BackedVirtualFile.getOriginFileIfBacked(file2))).isInProject(file2) || !honorExclusion && info2.isExcluded(file2)) {
            return info2.getModule();
        }
        return null;
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(10);
        }
        List<OrderEntry> list2 = this.myDirectoryIndex.getOrderEntries(file2);
        if (list2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    public VirtualFile getClassRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(12);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSet fileSet = this.myWorkspaceFileIndex.findFileSet(file2, true, false, true, false);
            if (fileSet == null) {
                return null;
            }
            return fileSet.getRoot();
        }
        return ProjectFileIndexImpl.getClassRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getContainingSourceRootType(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(13);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file2, true, true, false, false, ModuleSourceRootData.class);
            if (fileSet == null) {
                return null;
            }
            return SourceRootTypeRegistry.getInstance().findTypeById(fileSet.getData().getRootType());
        }
        SourceFolder sourceFolder = this.getSourceFolder(file2);
        return sourceFolder != null ? sourceFolder.getRootType() : null;
    }

    @Override
    public boolean isInGeneratedSources(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(14);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file2, true, true, false, false, ModuleSourceRootData.class);
            return fileSet != null && fileSet.getData().getForGeneratedSources();
        }
        SourceFolder sourceFolder = this.getSourceFolder(file2);
        if (sourceFolder == null) {
            return false;
        }
        JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        JavaResourceRootProperties resourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
        return properties != null && properties.isForGeneratedSources() || resourceProperties != null && resourceProperties.isForGeneratedSources();
    }

    @Nullable
    public static VirtualFile getClassRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(15);
        }
        if (info2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(16);
        }
        return info2.isInProject(file2) ? info2.getLibraryClassRoot() : null;
    }

    @Override
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(17);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleOrLibrarySourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file2, true, true, false, true, ModuleOrLibrarySourceRootData.class);
            if (fileSet == null) {
                return null;
            }
            return fileSet.getRoot();
        }
        return ProjectFileIndexImpl.getSourceRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Nullable
    public static VirtualFile getSourceRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(18);
        }
        if (info2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(19);
        }
        return info2.isInProject(file2) ? info2.getSourceRoot() : null;
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(20);
        }
        return this.getContentRootForFile(file2, true);
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(21);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleContentOrSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file2, honorExclusion, true, false, false, ModuleContentOrSourceRootData.class);
            if (fileSet == null) {
                WorkspaceFileSetWithCustomData<UnloadedModuleContentRootData> unloadedFileSet;
                if (!honorExclusion && (unloadedFileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file2, false, true, false, false, UnloadedModuleContentRootData.class)) != null) {
                    return unloadedFileSet.getRoot();
                }
                return null;
            }
            VirtualFile contentRoot = fileSet.getData().getCustomContentRoot();
            if (contentRoot != null) {
                return contentRoot;
            }
            return fileSet.getRoot();
        }
        return ProjectFileIndexImpl.getContentRootForFile(this.getInfoForFileOrDirectory(file2), file2, honorExclusion);
    }

    @Nullable
    public static VirtualFile getContentRootForFile(@NotNull DirectoryInfo info2, @NotNull VirtualFile file2, boolean honorExclusion) {
        if (info2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(23);
        }
        if (info2.isInProject(file2) || !honorExclusion && info2.isExcluded(file2)) {
            return info2.getContentRoot();
        }
        return null;
    }

    @Override
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(24);
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myDirectoryIndex.getPackageName(dir);
    }

    @Override
    public boolean isLibraryClassFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(25);
        }
        if (file2.isDirectory()) {
            return false;
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSet fileSet = this.myWorkspaceFileIndex.findFileSet(file2, true, false, true, false);
            return fileSet != null;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file2);
        return parentInfo.isInProject(file2) && parentInfo.hasLibraryClassRoot();
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(26);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleOrLibrarySourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, true, ModuleOrLibrarySourceRootData.class);
            return fileSet != null;
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInModuleSource(fileOrDir) || info2.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(27);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSet fileSet = this.myWorkspaceFileIndex.findFileSet(fileOrDir, true, false, true, false);
            return fileSet != null;
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInProject(fileOrDir) && info2.hasLibraryClassRoot();
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(28);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSet fileSet = this.myWorkspaceFileIndex.findFileSet(fileOrDir, true, false, false, true);
            return fileSet != null;
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInProject(fileOrDir) && info2.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(29);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSet fileSet = this.myWorkspaceFileIndex.findFileSet(fileOrDir, true, false, true, true);
            return fileSet != null;
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInProject(fileOrDir) && (info2.hasLibraryClassRoot() || info2.isInLibrarySource(fileOrDir));
    }

    @Override
    public boolean isIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(30);
        }
        return this.isExcluded(file2);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(31);
        }
        if (this.myWorkspaceFileIndex != null) {
            return this.myWorkspaceFileIndex.isInContent(fileOrDir);
        }
        return ProjectFileIndexImpl.isFileInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    public static boolean isFileInContent(@NotNull VirtualFile fileOrDir, @NotNull DirectoryInfo info2) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(32);
        }
        if (info2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(33);
        }
        return info2.isInProject(fileOrDir) && info2.getModule() != null;
    }

    @Nullable
    public VirtualFile getModuleSourceOrLibraryClassesRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(34);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileInternalInfo info2 = this.myWorkspaceFileIndex.getFileInfo(file2, true, true, true, false);
            WorkspaceFileSetWithCustomData<?> fileSet = info2.findFileSet(it -> {
                WorkspaceFileKind kind = it.getKind();
                return kind.isContent() && it.getData() instanceof ModuleOrLibrarySourceRootData || kind == WorkspaceFileKind.EXTERNAL;
            });
            return fileSet != null ? fileSet.getRoot() : null;
        }
        DirectoryInfo info3 = this.getInfoForFileOrDirectory(file2);
        if (ProjectFileIndexImpl.isFileInContent(file2, info3)) {
            return ProjectFileIndexImpl.getSourceRootForFile(file2, info3);
        }
        return ProjectFileIndexImpl.getClassRootForFile(file2, info3);
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(35);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, false, ModuleSourceRootData.class);
            return fileSet != null;
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource(fileOrDir);
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(36);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, false, ModuleSourceRootData.class);
            return fileSet != null && fileSet.getKind() == WorkspaceFileKind.TEST_CONTENT;
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInModuleSource(fileOrDir) && this.isTestSourcesRoot(info2);
    }

    @Override
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(37);
        }
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(38);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, false, false, ModuleSourceRootData.class);
            return ProjectFileIndexImpl.isSourceRootOfType(fileSet, rootTypes);
        }
        DirectoryInfo info2 = this.getInfoForFileOrDirectory(fileOrDir);
        return info2.isInModuleSource(fileOrDir) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info2));
    }

    static boolean isSourceRootOfType(@Nullable WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(39);
        }
        if (fileSet == null) {
            return false;
        }
        JpsModuleSourceRootType<?> type = SourceRootTypeRegistry.getInstance().findTypeById(fileSet.getData().getRootType());
        return type != null && rootTypes.contains(type);
    }

    @Override
    @Nullable
    public SourceFolder getSourceFolder(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(40);
        }
        return this.myDirectoryIndex.getSourceRootFolder(this.getInfoForFileOrDirectory(fileOrDir));
    }

    @Override
    @Nullable
    public String getUnloadedModuleNameForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(41);
        }
        if (this.myWorkspaceFileIndex != null) {
            WorkspaceFileSetWithCustomData<UnloadedModuleContentRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, false, true, false, false, UnloadedModuleContentRootData.class);
            return fileSet != null ? fileSet.getData().getModuleName() : null;
        }
        return this.getInfoForFileOrDirectory(fileOrDir).getUnloadedModuleName();
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myProject.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 19: 
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToIterate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToIterate";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnderIgnored";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectOrExcluded";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassRootForFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainingSourceRootType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInGeneratedSources";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootForFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryClassFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isInSource";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFileInContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSourceOrLibraryClassesRoot";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isSourceRootOfType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolder";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleNameForFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 11 -> new IllegalStateException(string2);
        };
    }
}

