/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.configurationStore.BatchUpdateListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryIndexImpl;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponentKt;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.EntityIndexingService;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u00019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0003J\b\u0010\u001e\u001a\u00020\u001dH\u0014J\b\u0010\u001f\u001a\u00020\u001dH\u0016J,\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\u0006\u0010$\u001a\u00020\fH\u0002J(\u0010%\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0'0&2\u0006\u0010(\u001a\u00020\u0002H\u0002J\b\u0010)\u001a\u00020\u001dH\u0016J\b\u0010*\u001a\u00020\u001dH\u0007J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\fH\u0014J\u001e\u0010-\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\f2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0014J\b\u00101\u001a\u00020\u0011H\u0016J\b\u00102\u001a\u00020\u001dH\u0016J8\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u00022\u001e\u00106\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0'0&H\u0002J\b\u00107\u001a\u00020\u001dH\u0014J\b\u00108\u001a\u00020\u001dH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u0002\u00a2\u0006\u0002\b\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u00a8\u0006:"}, d2={"Lcom/intellij/openapi/roots/impl/ProjectRootManagerComponent;", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectWatchRootsJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/Job;", "insideWriteAction", "", "isStartupActivityPerformed", "", "pointerChangesDetected", "rootPointersDisposable", "Lorg/jetbrains/annotations/NotNull;", "rootsChangedListener", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "<set-?>", "", "Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "rootsToWatch", "getRootsToWatch", "()Ljava/util/Set;", "sequentialDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getSequentialDispatcher$annotations", "()V", "addRootsToWatch", "", "clearScopesCaches", "clearScopesCachesForModules", "collectModuleWatchRoots", "recursivePaths", "", "flatPaths", "logRoots", "collectWatchRoots", "Lcom/intellij/openapi/util/Pair;", "", "disposable", "dispose", "disposeVirtualFilePointersAfterTest", "fireBeforeRootsChangeEvent", "fileTypes", "fireRootsChangedEvent", "indexingInfos", "", "Lcom/intellij/openapi/project/RootsChangeRescanningInfo;", "getRootsValidityChangedListener", "markRootsForRefresh", "postCollect", "newDisposable", "oldDisposable", "watchRoots", "projectClosed", "registerListeners", "AppListener", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nProjectRootManagerComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectRootManagerComponent.kt\ncom/intellij/openapi/roots/impl/ProjectRootManagerComponent\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,383:1\n19#2,4:384\n19#2,4:388\n19#2,4:392\n19#2,4:396\n19#2,4:400\n19#2,4:404\n*S KotlinDebug\n*F\n+ 1 ProjectRootManagerComponent.kt\ncom/intellij/openapi/roots/impl/ProjectRootManagerComponent\n*L\n254#1:384,4\n261#1:388,4\n266#1:392,4\n275#1:396,4\n321#1:400,4\n314#1:404,4\n*E\n"})
public class ProjectRootManagerComponent
extends ProjectRootManagerImpl
implements Disposable {
    private boolean isStartupActivityPerformed;
    @NotNull
    private AtomicReference<Job> collectWatchRootsJob;
    private boolean pointerChangesDetected;
    private int insideWriteAction;
    @NotNull
    private final CoroutineDispatcher sequentialDispatcher;
    @NotNull
    private Set<LocalFileSystem.WatchRequest> rootsToWatch;
    @NotNull
    private Disposable rootPointersDisposable;
    @NotNull
    private final VirtualFilePointerListener rootsChangedListener;

    public ProjectRootManagerComponent(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.collectWatchRootsJob = new AtomicReference();
        this.sequentialDispatcher = Dispatchers.getDefault().limitedParallelism(1);
        Set set2 = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"createSmallMemoryFootprintSet()");
        this.rootsToWatch = set2;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        this.rootPointersDisposable = disposable;
        this.rootsChangedListener = new VirtualFilePointerListener(this){
            final /* synthetic */ ProjectRootManagerComponent this$0;
            {
                this.this$0 = $receiver;
            }

            private final RootsChangeRescanningInfo getPointersChanges(VirtualFilePointer[] pointers2) {
                RootsChangeRescanningInfo result2 = null;
                for (VirtualFilePointer pointer : pointers2) {
                    if (pointer.isValid()) {
                        RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.TOTAL_RESCAN;
                        Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"TOTAL_RESCAN");
                        return rootsChangeRescanningInfo;
                    }
                    if (result2 != null) continue;
                    result2 = RootsChangeRescanningInfo.NO_RESCAN_NEEDED;
                }
                RootsChangeRescanningInfo rootsChangeRescanningInfo = ObjectUtils.notNull(result2, RootsChangeRescanningInfo.TOTAL_RESCAN);
                Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"notNull(result, RootsCha\u2026canningInfo.TOTAL_RESCAN)");
                return rootsChangeRescanningInfo;
            }

            public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers2) {
                Intrinsics.checkNotNullParameter((Object)pointers2, (String)"pointers");
                if (this.this$0.myProject.isDisposed()) {
                    return;
                }
                if (!this.isInsideWriteAction() && !ProjectRootManagerComponent.access$getPointerChangesDetected$p(this.this$0)) {
                    ProjectRootManagerComponent.access$setPointerChangesDetected$p(this.this$0, true);
                    this.this$0.myRootsChanged.levelUp();
                }
                this.this$0.myRootsChanged.beforeRootsChanged();
                if (ProjectRootManagerComponentKt.access$getLOG_CACHES_UPDATE() || ProjectRootManagerComponentKt.access$getLOG$p().isTraceEnabled()) {
                    ProjectRootManagerComponentKt.access$getLOG$p().trace(new Throwable(pointers2.length > 0 ? pointers2[0].getPresentableUrl() : ""));
                }
            }

            public void validityChanged(@NotNull VirtualFilePointer[] pointers2) {
                Intrinsics.checkNotNullParameter((Object)pointers2, (String)"pointers");
                RootsChangeRescanningInfo changeInfo = this.getPointersChanges(pointers2);
                if (this.this$0.myProject.isDisposed()) {
                    return;
                }
                if (this.isInsideWriteAction()) {
                    this.this$0.myRootsChanged.rootsChanged(changeInfo);
                } else {
                    this.this$0.clearScopesCaches();
                }
            }

            private final boolean isInsideWriteAction() {
                return ProjectRootManagerComponent.access$getInsideWriteAction$p(this.this$0) == 0;
            }
        };
        if (!this.myProject.isDefault()) {
            this.registerListeners();
        }
    }

    private static /* synthetic */ void getSequentialDispatcher$annotations() {
    }

    @NotNull
    public final Set<LocalFileSystem.WatchRequest> getRootsToWatch() {
        return this.rootsToWatch;
    }

    private final void registerListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this);
        Topic<ProjectManagerListener> topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, new ProjectManagerListener(this){
            final /* synthetic */ ProjectRootManagerComponent this$0;
            {
                this.this$0 = $receiver;
            }

            @Deprecated(message="Deprecated in Java")
            public void projectOpened(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                if (project2 == this.this$0.myProject) {
                    ProjectRootManagerComponent.access$addRootsToWatch(this.this$0);
                    ApplicationManager.getApplication().addApplicationListener(this.this$0.new AppListener(), this.this$0.myProject);
                }
            }

            public void projectClosed(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                if (project2 == this.this$0.myProject) {
                    this.this$0.projectClosed();
                }
            }
        });
        Topic topic2 = FileTypeManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, new FileTypeListener(this){
            final /* synthetic */ ProjectRootManagerComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.myFileTypesChanged.beforeRootsChanged();
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.myFileTypesChanged.rootsChanged();
            }
        });
        StartupManager.getInstance(this.myProject).registerStartupActivity(() -> ProjectRootManagerComponent.registerListeners$lambda$0(this));
        Topic topic3 = BatchUpdateListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        connection.subscribe(topic3, new BatchUpdateListener(this){
            final /* synthetic */ ProjectRootManagerComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBatchUpdateStarted() {
                this.this$0.myRootsChanged.levelUp();
                this.this$0.myFileTypesChanged.levelUp();
            }

            public void onBatchUpdateFinished() {
                this.this$0.myRootsChanged.levelDown();
                this.this$0.myFileTypesChanged.levelDown();
            }
        });
        Runnable rootsExtensionPointListener = () -> ProjectRootManagerComponent.registerListeners$lambda$3(this);
        AdditionalLibraryRootsProvider.EP_NAME.addChangeListener(rootsExtensionPointListener, this);
        OrderEnumerationHandler.EP_NAME.addChangeListener(rootsExtensionPointListener, this);
    }

    protected void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots((Collection<LocalFileSystem.WatchRequest>)this.rootsToWatch);
    }

    @RequiresEdt
    private final void addRootsToWatch() {
        if (this.myProject.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        Disposable oldDisposable = this.rootPointersDisposable;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable newDisposable = disposable;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Pair<Set<String>, Set<String>> watchRoots2 = this.collectWatchRoots(newDisposable);
            this.postCollect(newDisposable, oldDisposable, watchRoots2);
        } else {
            CoroutineScope coroutineScope = this.myProject.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"myProject.coroutineScope");
            BuildersKt.launch$default(coroutineScope, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, newDisposable, oldDisposable, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ ProjectRootManagerComponent this$0;
                final /* synthetic */ Disposable $newDisposable;
                final /* synthetic */ Disposable $oldDisposable;
                {
                    this.this$0 = $receiver;
                    this.$newDisposable = $newDisposable;
                    this.$oldDisposable = $oldDisposable;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Job job2;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            job2 = BuildersKt.launch$default($this$launch, null, CoroutineStart.LAZY, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$newDisposable, this.$oldDisposable, null){
                                int label;
                                final /* synthetic */ ProjectRootManagerComponent this$0;
                                final /* synthetic */ Disposable $newDisposable;
                                final /* synthetic */ Disposable $oldDisposable;
                                {
                                    this.this$0 = $receiver;
                                    this.$newDisposable = $newDisposable;
                                    this.$oldDisposable = $oldDisposable;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = CoroutinesKt.readAction((Function0)new Function0<Pair<Set<? extends String>, Set<? extends String>>>(this.this$0, this.$newDisposable){
                                                final /* synthetic */ ProjectRootManagerComponent this$0;
                                                final /* synthetic */ Disposable $newDisposable;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$newDisposable = $newDisposable;
                                                    super(0);
                                                }

                                                @NotNull
                                                public final Pair<Set<String>, Set<String>> invoke() {
                                                    return ProjectRootManagerComponent.access$collectWatchRoots(this.this$0, this.$newDisposable);
                                                }
                                            }, (Continuation)this);
                                            if (v0 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            watchRoots = (Pair)v0;
                                            v1 = CoroutinesKt.getEDT(Dispatchers.INSTANCE);
                                            v2 = ModalityState.any();
                                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any()");
                                            this.label = 2;
                                            v3 = BuildersKt.withContext(v1.plus(ModalityKt.asContextElement(v2)), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$newDisposable, this.$oldDisposable, (Pair<Set<String>, Set<String>>)watchRoots, null){
                                                int label;
                                                final /* synthetic */ ProjectRootManagerComponent this$0;
                                                final /* synthetic */ Disposable $newDisposable;
                                                final /* synthetic */ Disposable $oldDisposable;
                                                final /* synthetic */ Pair<Set<String>, Set<String>> $watchRoots;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$newDisposable = $newDisposable;
                                                    this.$oldDisposable = $oldDisposable;
                                                    this.$watchRoots = $watchRoots;
                                                    super(2, $completion);
                                                }

                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object object) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            ProjectRootManagerComponent.access$postCollect(this.this$0, this.$newDisposable, this.$oldDisposable, this.$watchRoots);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }, (Continuation)this);
                                            if (v3 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl25
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v3 = $result;
lbl25:
                                            // 2 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            Job job3 = ProjectRootManagerComponent.access$getCollectWatchRootsJob$p(this.this$0).getAndSet(job2);
                            if (job3 == null) break;
                            this.L$0 = job2;
                            this.label = 1;
                            Object object3 = JobKt.cancelAndJoin(job3, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 == object2) {
                                return object2;
                            }
                            break;
                        }
                        case 1: {
                            void $result;
                            job2 = (Job)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            break;
                        }
                    }
                    job2.start();
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    private final void postCollect(Disposable newDisposable, Disposable oldDisposable, Pair<Set<String>, Set<String>> watchRoots2) {
        this.rootPointersDisposable = newDisposable;
        Disposer.dispose(oldDisposable);
        Set<LocalFileSystem.WatchRequest> set2 = LocalFileSystem.getInstance().replaceWatchedRoots((Collection<LocalFileSystem.WatchRequest>)this.rootsToWatch, (Collection)watchRoots2.first, (Collection)watchRoots2.second);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getInstance().replaceWat\u2026first, watchRoots.second)");
        this.rootsToWatch = set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.myProject);
            DirectoryIndexImpl directoryIndexImpl = directoryIndex instanceof DirectoryIndexImpl ? (DirectoryIndexImpl)directoryIndex : null;
            if (directoryIndexImpl != null) {
                directoryIndexImpl.reset();
            }
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            WorkspaceFileIndex workspaceFileIndex = WorkspaceFileIndex.Companion.getInstance(project2);
            Intrinsics.checkNotNull((Object)workspaceFileIndex, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx");
            ((WorkspaceFileIndexEx)workspaceFileIndex).getIndexData().resetCustomContributors();
            MessageBus messageBus = this.myProject.getMessageBus();
            Topic<ModuleRootListener> topic = ProjectTopics.PROJECT_ROOTS;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"PROJECT_ROOTS");
            messageBus.syncPublisher(topic).beforeRootsChange(new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireRootsChangedEvent(boolean fileTypes, @NotNull List<? extends RootsChangeRescanningInfo> indexingInfos) {
        Intrinsics.checkNotNullParameter(indexingInfos, (String)"indexingInfos");
        this.isFiringEvent = true;
        try {
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.myProject);
            DirectoryIndexImpl directoryIndexImpl = directoryIndex instanceof DirectoryIndexImpl ? (DirectoryIndexImpl)directoryIndex : null;
            if (directoryIndexImpl != null) {
                directoryIndexImpl.reset();
            }
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            WorkspaceFileIndex workspaceFileIndex = WorkspaceFileIndex.Companion.getInstance(project2);
            Intrinsics.checkNotNull((Object)workspaceFileIndex, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx");
            ((WorkspaceFileIndexEx)workspaceFileIndex).getIndexData().resetCustomContributors();
            boolean isFromWorkspaceOnly = EntityIndexingService.getInstance().isFromWorkspaceOnly(indexingInfos);
            MessageBus messageBus = this.myProject.getMessageBus();
            Topic<ModuleRootListener> topic = ProjectTopics.PROJECT_ROOTS;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"PROJECT_ROOTS");
            messageBus.syncPublisher(topic).rootsChanged(new ModuleRootEventImpl(this.myProject, fileTypes, indexingInfos, isFromWorkspaceOnly));
        }
        finally {
            this.isFiringEvent = false;
        }
        if (this.isStartupActivityPerformed) {
            EntityIndexingService.getInstance().indexChanges(this.myProject, indexingInfos);
        }
        this.addRootsToWatch();
    }

    private final Pair<Set<String>, Set<String>> collectWatchRoots(Disposable disposable) {
        Object $this$trace$iv;
        Object object;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<String> set2 = CollectionFactory.createFilePathSet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"createFilePathSet()");
        Set<String> recursivePathsToWatch = set2;
        Set<String> set3 = CollectionFactory.createFilePathSet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"createFilePathSet()");
        Set<String> flatPaths = set3;
        Logger $this$trace$iv2 = ProjectRootManagerComponentKt.access$getWATCH_ROOTS_LOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            object = $this$trace$iv2;
            boolean bl = false;
            ((Logger)object).trace("watch roots for " + this.myProject + "}");
        }
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        IProjectStore store = ProjectKt.getStateStore(project2);
        Path path2 = store.getProjectFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"store.projectFilePath");
        Path projectFilePath = path2;
        Path path3 = projectFilePath.getParent().getFileName();
        if (!Intrinsics.areEqual((Object)".idea", (Object)(path3 != null ? ((Object)path3).toString() : null))) {
            flatPaths.add(PathKt.getSystemIndependentPath(projectFilePath));
            Path path4 = store.getWorkspacePath();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"store.workspacePath");
            flatPaths.add(PathKt.getSystemIndependentPath(path4));
            Logger $this$trace$iv3 = ProjectRootManagerComponentKt.access$getWATCH_ROOTS_LOG$p();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                object = $this$trace$iv3;
                boolean bl = false;
                ((Logger)object).trace("  project store: " + flatPaths);
            }
        }
        for (AdditionalLibraryRootsProvider extension2 : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            Collection<VirtualFile> toWatch;
            Intrinsics.checkNotNullExpressionValue(extension2.getRootsToWatch(this.myProject), (String)"extension.getRootsToWatch(myProject)");
            if (toWatch.isEmpty()) continue;
            $this$trace$iv = ProjectRootManagerComponentKt.access$getWATCH_ROOTS_LOG$p();
            boolean $i$f$trace3 = false;
            if (((Logger)$this$trace$iv).isTraceEnabled()) {
                object = $this$trace$iv;
                boolean bl = false;
                ((Logger)object).trace("  " + extension2.getClass() + "}: " + toWatch);
            }
            for (VirtualFile file2 : toWatch) {
                recursivePathsToWatch.add(file2.getPath());
            }
        }
        for (WatchedRootsProvider extension3 : ProjectRootManagerComponentKt.access$getWATCHED_ROOTS_PROVIDER_EP_NAME$p().getExtensionList()) {
            Set<String> toWatch;
            Intrinsics.checkNotNullExpressionValue(extension3.getRootsToWatch(this.myProject), (String)"extension.getRootsToWatch(myProject)");
            if (toWatch.isEmpty()) continue;
            $this$trace$iv = ProjectRootManagerComponentKt.access$getWATCH_ROOTS_LOG$p();
            boolean $i$f$trace4 = false;
            if (((Logger)$this$trace$iv).isTraceEnabled()) {
                object = $this$trace$iv;
                boolean bl = false;
                ((Logger)object).trace("  " + extension3.getClass() + "}: " + toWatch);
            }
            for (String path5 : toWatch) {
                recursivePathsToWatch.add(FileUtilRt.toSystemIndependentName(path5));
            }
        }
        HashSet excludedUrls = new HashSet();
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(project3)) {
            Collection collection = excludedUrls;
            String[] stringArray = excludePolicy.getExcludeUrlsForProject();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"excludePolicy.excludeUrlsForProject");
            CollectionsKt.addAll((Collection)collection, (Object[])stringArray);
        }
        if (!excludedUrls.isEmpty()) {
            Disposer.register(this, disposable);
            VirtualFilePointerContainer virtualFilePointerContainer = VirtualFilePointerManager.getInstance().createContainer(disposable, this.getRootsValidityChangedListener());
            Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointerContainer, (String)"getInstance().createCont\u2026sValidityChangedListener)");
            VirtualFilePointerContainer container = virtualFilePointerContainer;
            ((VirtualFilePointerContainerImpl)container).addAll(excludedUrls);
        }
        this.collectModuleWatchRoots(recursivePathsToWatch, flatPaths, true);
        return new Pair<Set<String>, Set<String>>(recursivePathsToWatch, flatPaths);
    }

    private final void collectModuleWatchRoots(Set<String> recursivePaths, Set<String> flatPaths, boolean logRoots) {
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        for (Module module2 : ModuleManager.Companion.getInstance(project2).getModules()) {
            if (logRoots) {
                Logger $this$trace$iv = ProjectRootManagerComponentKt.access$getLOG$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("  module " + module2);
                }
            }
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module2);
            String[] stringArray = rootManager.getContentRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"rootManager.contentRootUrls");
            ProjectRootManagerComponent.collectModuleWatchRoots$collectUrls(logRoots, recursivePaths, flatPaths, stringArray, "content");
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(arg_0 -> ProjectRootManagerComponent.collectModuleWatchRoots$lambda$10((Function1)new Function1<OrderEntry, Boolean>(logRoots, recursivePaths, flatPaths){
                final /* synthetic */ boolean $logRoots;
                final /* synthetic */ Set<String> $recursivePaths;
                final /* synthetic */ Set<String> $flatPaths;
                {
                    this.$logRoots = $logRoots;
                    this.$recursivePaths = $recursivePaths;
                    this.$flatPaths = $flatPaths;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(OrderEntry entry) {
                    if (entry instanceof LibraryOrSdkOrderEntry) {
                        OrderRootType[] orderRootTypeArray = OrderRootType.getAllTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)orderRootTypeArray, (String)"getAllTypes()");
                        for (OrderRootType type : orderRootTypeArray) {
                            String[] stringArray = ((LibraryOrSdkOrderEntry)entry).getRootUrls(type);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"entry.getRootUrls(type)");
                            ProjectRootManagerComponent.access$collectModuleWatchRoots$collectUrls(this.$logRoots, this.$recursivePaths, this.$flatPaths, stringArray, entry + " [" + type + "]");
                        }
                    }
                    return true;
                }
            }, arg_0));
        }
    }

    @Override
    protected void clearScopesCaches() {
        block0: {
            super.clearScopesCaches();
            LibraryScopeCache libraryScopeCache = this.myProject.getServiceIfCreated(LibraryScopeCache.class);
            if (libraryScopeCache == null) break block0;
            libraryScopeCache.clear();
        }
    }

    @Override
    public void clearScopesCachesForModules() {
        super.clearScopesCachesForModules();
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        for (Module module2 : ModuleManager.Companion.getInstance(project2).getModules()) {
            Intrinsics.checkNotNull((Object)module2, (String)"null cannot be cast to non-null type com.intellij.openapi.module.impl.ModuleEx");
            ((ModuleEx)module2).clearScopesCache();
        }
    }

    @Override
    public void markRootsForRefresh() {
        Set<String> set2 = CollectionFactory.createFilePathSet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"createFilePathSet()");
        Set<String> paths2 = set2;
        this.collectModuleWatchRoots(paths2, paths2, false);
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (String path2 : paths2) {
            VirtualFile root = fs.findFileByPath(path2);
            if (!(root instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)root).markDirtyRecursively();
        }
    }

    @Override
    public void dispose() {
    }

    @TestOnly
    public final void disposeVirtualFilePointersAfterTest() {
        Disposer.dispose(this.rootPointersDisposable);
    }

    @Override
    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        return this.rootsChangedListener;
    }

    private static final void registerListeners$lambda$0(ProjectRootManagerComponent this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isStartupActivityPerformed = true;
    }

    private static final void registerListeners$lambda$3$lambda$2$lambda$1(ProjectRootManagerComponent this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.makeRootsChange(EmptyRunnable.getInstance(), RootsChangeRescanningInfo.TOTAL_RESCAN);
    }

    private static final void registerListeners$lambda$3$lambda$2(ProjectRootManagerComponent this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManagerComponent.registerListeners$lambda$3$lambda$2$lambda$1(this$0));
    }

    private static final void registerListeners$lambda$3(ProjectRootManagerComponent this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ApplicationManager.getApplication().invokeLater(() -> ProjectRootManagerComponent.registerListeners$lambda$3$lambda$2(this$0));
    }

    /*
     * Unable to fully structure code
     */
    private static final void collectModuleWatchRoots$collectUrls(boolean $logRoots, Set<String> $recursivePaths, Set<String> $flatPaths, String[] urls, String logDescriptor) {
        if ($logRoots) {
            v0 = CollectionFactory.createFilePathSet();
            v1 = v0;
            Intrinsics.checkNotNullExpressionValue(v0, (String)"createFilePathSet()");
        } else {
            v1 = recursive = $recursivePaths;
        }
        if ($logRoots) {
            v2 = CollectionFactory.createFilePathSet();
            v3 = v2;
            Intrinsics.checkNotNullExpressionValue(v2, (String)"createFilePathSet()");
        } else {
            v3 = $flatPaths;
        }
        flat = v3;
        block5: for (String url : urls) {
            var10_12 = VirtualFileManager.extractProtocol(url);
            if (var10_12 == null) ** GOTO lbl27
            switch (var10_12.hashCode()) {
                case 3143036: {
                    if (!var10_12.equals("file")) {
                        continue block5;
                    }
                    ** GOTO lbl27
                }
                case 104987: {
                    if (var10_12.equals("jar")) break;
                    continue block5;
                }
                case 105516: {
                    if (!var10_12.equals("jrt")) continue block5;
lbl27:
                    // 3 sources

                    ((Collection)recursive).add(ProjectRootManagerImpl.extractLocalPath(url));
                    continue block5;
                }
            }
            ((Collection)flat).add(ProjectRootManagerImpl.extractLocalPath(url));
        }
        if ($logRoots) {
            $this$trace$iv = ProjectRootManagerComponentKt.access$getLOG$p();
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                var11_13 = $this$trace$iv;
                $i$a$-trace-ProjectRootManagerComponent$collectModuleWatchRoots$collectUrls$1 = false;
                var11_13.trace("    " + logDescriptor + ": " + recursive + ", " + flat);
            }
            CollectionsKt.addAll((Collection)$recursivePaths, (Iterable)recursive);
            CollectionsKt.addAll((Collection)$flatPaths, (Iterable)flat);
        }
    }

    private static final boolean collectModuleWatchRoots$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$addRootsToWatch(ProjectRootManagerComponent $this) {
        $this.addRootsToWatch();
    }

    public static final /* synthetic */ Pair access$collectWatchRoots(ProjectRootManagerComponent $this, Disposable disposable) {
        return $this.collectWatchRoots(disposable);
    }

    public static final /* synthetic */ void access$postCollect(ProjectRootManagerComponent $this, Disposable newDisposable, Disposable oldDisposable, Pair watchRoots2) {
        $this.postCollect(newDisposable, oldDisposable, watchRoots2);
    }

    public static final /* synthetic */ AtomicReference access$getCollectWatchRootsJob$p(ProjectRootManagerComponent $this) {
        return $this.collectWatchRootsJob;
    }

    public static final /* synthetic */ void access$collectModuleWatchRoots$collectUrls(boolean $logRoots, Set $recursivePaths, Set $flatPaths, String[] urls, String logDescriptor) {
        ProjectRootManagerComponent.collectModuleWatchRoots$collectUrls($logRoots, $recursivePaths, $flatPaths, urls, logDescriptor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/roots/impl/ProjectRootManagerComponent$AppListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "(Lcom/intellij/openapi/roots/impl/ProjectRootManagerComponent;)V", "beforeWriteActionStart", "", "action", "", "writeActionFinished", "intellij.platform.lang.impl"})
    private final class AppListener
    implements ApplicationListener {
        @Override
        public void beforeWriteActionStart(@NotNull Object action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            ProjectRootManagerComponent projectRootManagerComponent = ProjectRootManagerComponent.this;
            int n = projectRootManagerComponent.insideWriteAction;
            projectRootManagerComponent.insideWriteAction = n + 1;
        }

        @Override
        public void writeActionFinished(@NotNull Object action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            ProjectRootManagerComponent projectRootManagerComponent = ProjectRootManagerComponent.this;
            projectRootManagerComponent.insideWriteAction = projectRootManagerComponent.insideWriteAction + -1;
            if (projectRootManagerComponent.insideWriteAction == 0 && ProjectRootManagerComponent.this.pointerChangesDetected) {
                ProjectRootManagerComponent.this.pointerChangesDetected = false;
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
            }
        }
    }
}

