/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.FilesScanExecutor;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.FilePropertyPusherEx;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedDiagnostic;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushingStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ProjectIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.StandardContributorsKt;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushedFilePropertiesUpdaterImpl
extends PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance(PushedFilePropertiesUpdater.class);
    private final Project myProject;
    private final Queue<Runnable> myTasks;

    public PushedFilePropertiesUpdaterImpl(final @NotNull Project project2) {
        if (project2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(0);
        }
        this.myTasks = new ConcurrentLinkedQueue<Runnable>();
        this.myProject = project2;
        project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(new Throwable("Processing roots changed event (caused by file type change: " + event.isCausedByFileTypesChange() + ")"));
                }
                for (FilePropertyPusher<?> pusher : FilePropertyPusher.EP_NAME.getExtensionList()) {
                    pusher.afterRootsChanged(project2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$1", "rootsChanged"));
            }
        });
        project2.getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void beforePluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                PushedFilePropertiesUpdaterImpl.this.myTasks.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$2", "beforePluginLoaded"));
            }
        });
    }

    @ApiStatus.Internal
    public void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        boolean pushingSomethingSynchronously;
        if (events == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(1);
        }
        ArrayList syncTasks = new ArrayList();
        ArrayList delayedTasks = new ArrayList();
        List<FilePropertyPusher<?>> filePushers = PushedFilePropertiesUpdaterImpl.getFilePushers();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (vFileEvent instanceof VFileCreateEvent) {
                List<FilePropertyPusher<?>> pushers;
                boolean isDirectory = ((VFileCreateEvent)vFileEvent).isDirectory();
                List<FilePropertyPusher<?>> list2 = pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
                if (!vFileEvent.isFromRefresh()) {
                    ContainerUtil.addIfNotNull(syncTasks, this.createRecursivePushTask(vFileEvent, pushers));
                    continue;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(((VFileCreateEvent)vFileEvent).getChildName());
                boolean isProjectOrWorkspaceFile = fileType instanceof InternalFileType || VfsUtilCore.findContainingDirectory(((VFileCreateEvent)vFileEvent).getParent(), ".idea") != null;
                if (isProjectOrWorkspaceFile) continue;
                ContainerUtil.addIfNotNull(delayedTasks, this.createRecursivePushTask(vFileEvent, pushers));
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent) || (file2 = PushedFilePropertiesUpdaterImpl.getFile(vFileEvent)) == null) continue;
            boolean isDirectory = file2.isDirectory();
            List<FilePropertyPusher<?>> pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
            ContainerUtil.addIfNotNull(syncTasks, this.createRecursivePushTask(vFileEvent, pushers));
        }
        boolean bl = pushingSomethingSynchronously = !syncTasks.isEmpty() && syncTasks.size() < FileBasedIndexProjectHandler.ourMinFilesToStartDumbMode;
        if (pushingSomethingSynchronously) {
            syncTasks.forEach(Runnable::run);
        } else {
            delayedTasks.addAll(syncTasks);
        }
        if (!delayedTasks.isEmpty()) {
            this.queueTasks(delayedTasks, "Push on VFS changes");
        }
        if (pushingSomethingSynchronously) {
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                this.scheduleDumbModeReindexingIfNeeded();
            } else {
                application.invokeLater(this::scheduleDumbModeReindexingIfNeeded, this.myProject.getDisposed());
            }
        }
    }

    private static VirtualFile getFile(@NotNull VFileEvent event) {
        if (event == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(2);
        }
        VirtualFile file2 = event.getFile();
        if (event instanceof VFileCopyEvent) {
            file2 = ((VFileCopyEvent)event).getNewParent().findChild(((VFileCopyEvent)event).getNewChildName());
        }
        return file2;
    }

    @Override
    public void runConcurrentlyIfPossible(List<? extends Runnable> tasks) {
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public void initializeProperties() {
        FilePropertyPusher.EP_NAME.forEachExtensionSafe(pusher -> pusher.initExtra(this.myProject));
    }

    public static void applyScannersToFile(@NotNull VirtualFile fileOrDir, List<? extends IndexableFileScanner.IndexableFileVisitor> sessions) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(3);
        }
        for (IndexableFileScanner.IndexableFileVisitor indexableFileVisitor : sessions) {
            try {
                indexableFileVisitor.visitFile(fileOrDir);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Failed to visit file", (Throwable)e, new Attachment("filePath.txt", fileOrDir.getPath()));
            }
        }
    }

    @Nullable
    private Runnable createRecursivePushTask(@NotNull VFileEvent event, @NotNull List<? extends FilePropertyPusher<?>> pushers) {
        if (event == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(4);
        }
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(5);
        }
        List scanners = IndexableFileScanner.EP_NAME.getExtensionList();
        if (pushers.isEmpty() && scanners.isEmpty()) {
            return null;
        }
        return () -> {
            VirtualFile dir = PushedFilePropertiesUpdaterImpl.getFile(event);
            ProjectFileIndex fileIndex = ReadAction.compute(() -> ProjectFileIndex.getInstance(this.myProject));
            if (dir != null && ReadAction.compute(() -> fileIndex.isInContent(dir)).booleanValue() && !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)dir)) {
                this.doPushRecursively(pushers, scanners, (IndexableFilesIterator)new ProjectIndexableFilesIteratorImpl(dir));
            }
        };
    }

    private void doPushRecursively(@NotNull List<? extends FilePropertyPusher<?>> pushers, @NotNull List<? extends IndexableFileScanner> scanners, @NotNull IndexableFilesIterator indexableFilesIterator) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(6);
        }
        if (scanners == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(7);
        }
        if (indexableFilesIterator == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(8);
        }
        List<IndexableFileScanner.IndexableFileVisitor> sessions = ContainerUtil.mapNotNull(scanners, visitor2 -> visitor2.startSession(this.myProject).createVisitor(indexableFilesIterator.getOrigin()));
        indexableFilesIterator.iterateFiles(this.myProject, fileOrDir -> {
            this.applyPushersToFile(fileOrDir, pushers, null);
            PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, sessions);
            return true;
        }, (VirtualFileFilter)IndexableFilesDeduplicateFilter.create());
        PushedFilePropertiesUpdaterImpl.finishVisitors(sessions);
    }

    public static void finishVisitors(List<? extends IndexableFileScanner.IndexableFileVisitor> sessions) {
        for (IndexableFileScanner.IndexableFileVisitor indexableFileVisitor : sessions) {
            indexableFileVisitor.visitingFinished();
        }
    }

    private void queueTasks(@NotNull List<? extends Runnable> actions, @NotNull @NonNls String reason) {
        if (actions == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(9);
        }
        if (reason == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(10);
        }
        actions.forEach(this.myTasks::offer);
        final MyDumbModeTask task2 = new MyDumbModeTask(reason, this);
        this.myProject.getMessageBus().connect(task2).subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (RootsChangeRescanningInfo rootsChangeRescanningInfo : ((ModuleRootEventImpl)event).getInfos()) {
                    if (rootsChangeRescanningInfo != RootsChangeRescanningInfo.TOTAL_RESCAN) continue;
                    DumbService.getInstance(PushedFilePropertiesUpdaterImpl.this.myProject).cancelTask(task2);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$3", "rootsChanged"));
            }
        });
        task2.queue(this.myProject);
    }

    public void performDelayedPushTasks() {
        this.performDelayedPushTasks(null);
    }

    private void performDelayedPushTasks(@Nullable ChangedFilesPushingStatistics statistics) {
        boolean hadTasks = false;
        while (true) {
            ProgressManager.checkCanceled();
            Runnable task2 = this.myTasks.poll();
            if (task2 == null) break;
            try {
                task2.run();
                hadTasks = true;
            }
            catch (ProcessCanceledException e) {
                if (statistics != null) {
                    statistics.finished(true);
                    ChangedFilesPushedDiagnostic.INSTANCE.addEvent(this.myProject, statistics);
                }
                this.queueTasks(Collections.singletonList(task2), "Rerun pushing tasks after process cancelled");
                throw e;
            }
        }
        if (hadTasks) {
            this.scheduleDumbModeReindexingIfNeeded();
        }
        if (statistics != null) {
            statistics.finished(false);
            ChangedFilesPushedDiagnostic.INSTANCE.addEvent(this.myProject, statistics);
        }
    }

    private void scheduleDumbModeReindexingIfNeeded() {
        FileBasedIndexProjectHandler.scheduleReindexingInDumbMode(this.myProject);
    }

    @Override
    public void filePropertiesChanged(@NotNull VirtualFile fileOrDir, @NotNull Condition<? super VirtualFile> acceptFileCondition) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(11);
        }
        if (acceptFileCondition == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(12);
        }
        if (fileOrDir.isDirectory()) {
            for (VirtualFile child : fileOrDir.getChildren()) {
                if (child.isDirectory() || !acceptFileCondition.value(child)) continue;
                this.filePropertiesChanged(child);
            }
        } else if (acceptFileCondition.value(fileOrDir)) {
            this.filePropertiesChanged(fileOrDir);
        }
    }

    private static <T> T findNewPusherValue(Project project2, VirtualFile fileOrDir, FilePropertyPusher<? extends T> pusher, T moduleValue) {
        T immediateValue = pusher.getImmediateValue(project2, fileOrDir);
        if (immediateValue != null) {
            return immediateValue;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        return PushedFilePropertiesUpdaterImpl.findNewPusherValueFromParent(project2, fileOrDir, pusher);
    }

    private static <T> T findNewPusherValueFromParent(Project project2, VirtualFile fileOrDir, FilePropertyPusher<? extends T> pusher) {
        VirtualFile parent2 = fileOrDir.getParent();
        if (parent2 != null && ProjectFileIndex.getInstance(project2).isInContent(parent2)) {
            T userValue = pusher.getFilePropertyKey().getPersistentValue(parent2);
            if (userValue != null) {
                return userValue;
            }
            return PushedFilePropertiesUpdaterImpl.findNewPusherValue(project2, parent2, pusher, null);
        }
        T projectValue = pusher.getImmediateValue(project2, null);
        return projectValue != null ? projectValue : pusher.getDefaultValue();
    }

    @Override
    public void pushAll(FilePropertyPusher<?> ... pushers) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(13);
        }
        this.queueTasks(Collections.singletonList(() -> this.doPushAll(Arrays.asList(pushers))), "Push all on " + Arrays.toString(pushers));
    }

    private void doPushAll(@NotNull List<? extends FilePropertyPusher<?>> pushers) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(14);
        }
        PushedFilePropertiesUpdaterImpl.scanProject(this.myProject, module2 -> {
            Object[] moduleValues = PushedFilePropertiesUpdaterImpl.getModuleImmediateValues(pushers, module2);
            return fileOrDir -> {
                this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                return TreeNodeProcessingResult.CONTINUE;
            };
        });
    }

    public static Object @NotNull [] getModuleImmediateValues(@NotNull List<? extends FilePropertyPusher<?>> pushers, @NotNull Module module2) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(15);
        }
        if (module2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(16);
        }
        Object[] moduleValues = new Object[pushers.size()];
        for (int i2 = 0; i2 < moduleValues.length; ++i2) {
            moduleValues[i2] = pushers.get(i2).getImmediateValue(module2);
        }
        if (moduleValues == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(17);
        }
        return moduleValues;
    }

    public static Object @NotNull [] getImmediateValuesEx(@NotNull List<? extends FilePropertyPusherEx<?>> pushers, @NotNull IndexableSetOrigin origin) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(18);
        }
        if (origin == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(19);
        }
        Object[] moduleValues = new Object[pushers.size()];
        for (int i2 = 0; i2 < moduleValues.length; ++i2) {
            moduleValues[i2] = pushers.get(i2).getImmediateValueEx(origin);
        }
        if (moduleValues == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(20);
        }
        return moduleValues;
    }

    public static void scanProject(@NotNull Project project2, @NotNull Function<? super Module, ? extends ContentIteratorEx> iteratorProducer) {
        Stream tasksStream;
        if (project2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(21);
        }
        if (iteratorProducer == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(22);
        }
        if (StandardContributorsKt.shouldIndexProjectBasedOnIndexableEntityProviders()) {
            Sequence modulesSequence = ReadAction.compute(() -> WorkspaceModel.getInstance(project2).getCurrentSnapshot().entities(ModuleEntity.class));
            List moduleEntities = SequencesKt.toList((Sequence)modulesSequence);
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
            tasksStream = moduleEntities.stream().flatMap(moduleEntity -> ReadAction.compute(() -> {
                EntityStorageSnapshot storage = WorkspaceModel.getInstance(project2).getCurrentSnapshot();
                ModuleBridge module2 = ModuleEntityUtils.findModule(moduleEntity, (EntityStorage)storage);
                if (module2 == null) {
                    return Stream.empty();
                }
                ProgressManager.checkCanceled();
                return ContainerUtil.map(IndexableEntityProviderMethods.INSTANCE.createIterators((ModuleEntity)moduleEntity, (EntityStorage)storage, project2), it -> new Object((IndexableFilesIterator)it, iteratorProducer, module2){
                    final IndexableFilesIterator files;
                    final ContentIteratorEx iterator;
                    final /* synthetic */ IndexableFilesIterator val$it;
                    final /* synthetic */ Function val$iteratorProducer;
                    final /* synthetic */ Module val$module;
                    {
                        this.val$it = indexableFilesIterator;
                        this.val$iteratorProducer = function;
                        this.val$module = module2;
                        this.files = this.val$it;
                        this.iterator = (ContentIteratorEx)this.val$iteratorProducer.apply(this.val$module);
                    }
                }).stream().map(pair -> () -> pair.files.iterateFiles(project2, (ContentIterator)pair.iterator, (VirtualFileFilter)indexableFilesDeduplicateFilter));
            }));
        } else {
            Module[] modules2 = ReadAction.compute(() -> ModuleManager.getInstance(project2).getModules());
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
            tasksStream = Arrays.stream(modules2).flatMap(module2 -> ReadAction.compute(() -> {
                if (module2.isDisposed()) {
                    return Stream.empty();
                }
                ProgressManager.checkCanceled();
                return ContainerUtil.map(ModuleIndexableFilesIteratorImpl.getModuleIterators(module2), it -> new Object((ModuleIndexableFilesIteratorImpl)it, iteratorProducer){
                    final IndexableFilesIterator files;
                    final ContentIteratorEx iterator;
                    final /* synthetic */ ModuleIndexableFilesIteratorImpl val$it;
                    final /* synthetic */ Function val$iteratorProducer;
                    {
                        this.val$it = moduleIndexableFilesIteratorImpl;
                        this.val$iteratorProducer = function;
                        this.files = this.val$it;
                        this.iterator = (ContentIteratorEx)this.val$iteratorProducer.apply(this.val$it.getOrigin().getModule());
                    }
                }).stream().map(pair -> () -> pair.files.iterateFiles(project2, (ContentIterator)pair.iterator, (VirtualFileFilter)indexableFilesDeduplicateFilter));
            }));
        }
        List tasks = tasksStream.collect(Collectors.toList());
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public static void invokeConcurrentlyIfPossible(@NotNull List<? extends Runnable> tasks) {
        if (tasks == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(23);
        }
        if (tasks.isEmpty()) {
            return;
        }
        if (tasks.size() == 1 || ApplicationManager.getApplication().isWriteAccessAllowed() || DumbServiceImpl.isSynchronousTaskExecution()) {
            for (Runnable runnable : tasks) {
                runnable.run();
            }
            return;
        }
        ConcurrentLinkedQueue<? extends Runnable> tasksQueue = new ConcurrentLinkedQueue<Runnable>(tasks);
        FilesScanExecutor.runOnAllThreads(() -> {
            Runnable runnable;
            while ((runnable = (Runnable)tasksQueue.poll()) != null) {
                runnable.run();
            }
        });
    }

    public void applyPushersToFile(VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object[] moduleValues) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(24);
        }
        if (pushers.isEmpty()) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            fileOrDir.getChildren();
        }
        ReadAction.run(() -> {
            if (!fileOrDir.isValid() || !(fileOrDir instanceof VirtualFileWithId)) {
                return;
            }
            this.doApplyPushersToFile(fileOrDir, pushers, moduleValues);
        });
    }

    private void doApplyPushersToFile(@NotNull VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object @Nullable [] moduleValues) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(25);
        }
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(26);
        }
        boolean isDir = fileOrDir.isDirectory();
        for (int i2 = 0; i2 < pushers.size(); ++i2) {
            FilePropertyPusher<?> pusher = pushers.get(i2);
            if (!isDir ? pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir, this.myProject) : !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
            Object value = moduleValues != null ? moduleValues[i2] : null;
            this.findAndUpdateValue(fileOrDir, pusher, value);
        }
    }

    @Override
    public <T> void findAndUpdateValue(@NotNull VirtualFile fileOrDir, @NotNull FilePropertyPusher<T> pusher, @Nullable T moduleValue) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(27);
        }
        if (pusher == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(28);
        }
        T newValue = PushedFilePropertiesUpdaterImpl.findNewPusherValue(this.myProject, fileOrDir, pusher, moduleValue);
        try {
            pusher.persistAttribute(this.myProject, fileOrDir, newValue);
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Override
    public void filePropertiesChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex instanceof FileBasedIndexImpl) {
            ((FileBasedIndexImpl)fileBasedIndex).requestReindex(file2, false);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            PushedFilePropertiesUpdaterImpl.reloadPsi(file2, project2);
        }
    }

    private static void reloadPsi(VirtualFile file2, Project project2) {
        FileManagerImpl fileManager = (FileManagerImpl)PsiManagerEx.getInstanceEx(project2).getFileManager();
        if (fileManager.findCachedViewProvider(file2) != null) {
            ModalityUiUtil.invokeLaterIfNeeded(ModalityState.defaultModalityState(), project2.getDisposed(), () -> WriteAction.run(() -> fileManager.forceReload(file2)));
        }
    }

    private static List<FilePropertyPusher<?>> getFilePushers() {
        return ContainerUtil.findAll(FilePropertyPusher.EP_NAME.getExtensionList(), pusher -> !pusher.pushDirectoriesOnly());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 11: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanners";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexableFilesIterator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptFileCondition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteratorProducer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pusher";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleImmediateValues";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateValuesEx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAfterVfsChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyScannersToFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRecursivePushTask";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPushRecursively";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "queueTasks";
                break;
            }
            case 11: 
            case 12: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "filePropertiesChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pushAll";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doPushAll";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModuleImmediateValues";
                break;
            }
            case 17: 
            case 20: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValuesEx";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scanProject";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "invokeConcurrentlyIfPossible";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyPushersToFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doApplyPushersToFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findAndUpdateValue";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 17, 20 -> new IllegalStateException(string2);
        };
    }

    private static class MyDumbModeTask
    extends DumbModeTask {
        @NotNull
        @NonNls
        private final String myReason;
        private final PushedFilePropertiesUpdaterImpl myUpdater;

        private MyDumbModeTask(@NotNull @NonNls String reason, @NotNull PushedFilePropertiesUpdaterImpl updater2) {
            if (reason == null) {
                MyDumbModeTask.$$$reportNull$$$0(0);
            }
            if (updater2 == null) {
                MyDumbModeTask.$$$reportNull$$$0(1);
            }
            this.myUpdater = updater2;
            this.myReason = reason;
        }

        @Override
        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyDumbModeTask.$$$reportNull$$$0(2);
            }
            indicator.setIndeterminate(true);
            indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
            ChangedFilesPushingStatistics statistics = !ApplicationManager.getApplication().isUnitTestMode() || IndexDiagnosticDumper.getShouldDumpInUnitTestMode() ? new ChangedFilesPushingStatistics(this.myReason) : null;
            ((GistManagerImpl)GistManager.getInstance()).runWithMergingDependentCacheInvalidations(() -> this.myUpdater.performDelayedPushTasks(statistics));
        }

        @Override
        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue == null) {
                MyDumbModeTask.$$$reportNull$$$0(3);
            }
            if (taskFromQueue instanceof MyDumbModeTask && ((MyDumbModeTask)taskFromQueue).myUpdater == this.myUpdater) {
                return this;
            }
            return null;
        }

        public String toString() {
            return super.toString() + " (reason: " + this.myReason + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskFromQueue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$MyDumbModeTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryMergeWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

