/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class RootFileSupplier {
    private static final Logger LOG = Logger.getInstance(RootFileSupplier.class);
    public static final RootFileSupplier INSTANCE = new RootFileSupplier();

    @NotNull
    @NotNull List<@NotNull VirtualFile> getUnloadedContentRoots(UnloadedModuleDescription description) {
        List<VirtualFile> list2 = ContainerUtil.mapNotNull(description.getContentRoots(), VirtualFilePointer::getFile);
        if (list2 == null) {
            RootFileSupplier.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    public VirtualFile correctRoot(@NotNull VirtualFile file2, @NotNull Object container, @Nullable Object containerProvider) {
        if (file2 == null) {
            RootFileSupplier.$$$reportNull$$$0(1);
        }
        if (container == null) {
            RootFileSupplier.$$$reportNull$$$0(2);
        }
        if (!RootFileSupplier.ensureValid(file2, container, containerProvider)) {
            return null;
        }
        return file2;
    }

    @Nullable
    public VirtualFile findFileByUrl(String url) {
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    public VirtualFile @NotNull [] getExcludedRoots(LibraryEx library) {
        VirtualFile[] virtualFileArray = library.getExcludedRoots();
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    VirtualFile @NotNull [] getLibraryRoots(LibraryOrSdkOrderEntry entry, OrderRootType type) {
        VirtualFile[] virtualFileArray = entry.getRootFiles(type);
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getLibraryRoots(Library library, OrderRootType type) {
        VirtualFile[] virtualFileArray = library.getFiles(type);
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    VirtualFile @NotNull [] getSdkRoots(@NotNull Sdk entry, OrderRootType type) {
        if (entry == null) {
            RootFileSupplier.$$$reportNull$$$0(6);
        }
        VirtualFile[] virtualFileArray = entry.getRootProvider().getFiles(type);
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @Nullable
    VirtualFile getContentRoot(ContentEntry contentEntry) {
        return contentEntry.getFile();
    }

    @Nullable
    VirtualFile getSourceRoot(SourceFolder sourceFolder) {
        return sourceFolder.getFile();
    }

    @Nullable
    public VirtualFile findFile(@NotNull VirtualFileUrl virtualFileUrl) {
        if (virtualFileUrl == null) {
            RootFileSupplier.$$$reportNull$$$0(8);
        }
        return VirtualFileUrls.getVirtualFile(virtualFileUrl);
    }

    public static RootFileSupplier forBranch(final ModelBranch branch) {
        return new RootFileSupplier(){

            @Override
            public VirtualFile @NotNull [] getExcludedRoots(LibraryEx library) {
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull(library.getExcludedRootUrls(), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFileArray;
            }

            @Override
            protected VirtualFile @NotNull [] getLibraryRoots(LibraryOrSdkOrderEntry entry, OrderRootType type) {
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull(entry.getRootUrls(type), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return virtualFileArray;
            }

            @Override
            public VirtualFile @NotNull [] getLibraryRoots(Library library, OrderRootType type) {
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull(library.getUrls(type), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return virtualFileArray;
            }

            @Override
            VirtualFile @NotNull [] getSdkRoots(@NotNull Sdk sdk2, OrderRootType type) {
                if (sdk2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull(sdk2.getRootProvider().getUrls(type), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return virtualFileArray;
            }

            @Override
            @Nullable
            protected VirtualFile getContentRoot(ContentEntry contentEntry) {
                return this.findFileByUrl(contentEntry.getUrl());
            }

            @Override
            @Nullable
            protected VirtualFile getSourceRoot(SourceFolder sourceFolder) {
                return this.findFileByUrl(sourceFolder.getUrl());
            }

            @Override
            @Nullable
            public VirtualFile findFile(@NotNull VirtualFileUrl virtualFileUrl) {
                if (virtualFileUrl == null) {
                    1.$$$reportNull$$$0(5);
                }
                return this.findFileByUrl(virtualFileUrl.getUrl());
            }

            @Override
            @NotNull
            protected @NotNull List<@NotNull VirtualFile> getUnloadedContentRoots(UnloadedModuleDescription description) {
                List<VirtualFile> list2 = ContainerUtil.mapNotNull(description.getContentRoots(), p -> this.findFileByUrl(p.getUrl()));
                if (list2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return list2;
            }

            @Override
            @Nullable
            public VirtualFile correctRoot(@NotNull VirtualFile file2, @NotNull Object container, @Nullable Object containerProvider) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (container == null) {
                    1.$$$reportNull$$$0(8);
                }
                if ((file2 = super.correctRoot(file2, container, containerProvider)) != null && !(file2 = branch.findFileCopy(file2)).isValid()) {
                    return null;
                }
                return file2;
            }

            @Override
            @Nullable
            public VirtualFile findFileByUrl(String url) {
                return branch.findFileByUrl(url);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 3, 5, 7, 8 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/RootFileSupplier$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sdk";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "virtualFileUrl";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "container";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExcludedRoots";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLibraryRoots";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/RootFileSupplier$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSdkRoots";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnloadedContentRoots";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getSdkRoots";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "findFile";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "correctRoot";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 3, 5, 7, 8 -> new IllegalArgumentException(string2);
                };
            }
        };
    }

    public static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container, @Nullable Object containerProvider) {
        if (file2 == null) {
            RootFileSupplier.$$$reportNull$$$0(9);
        }
        if (container == null) {
            RootFileSupplier.$$$reportNull$$$0(10);
        }
        if (!file2.isValid()) {
            if (containerProvider != null) {
                Class<?> providerClass = containerProvider.getClass();
                PluginException.logPluginError(LOG, "Invalid root " + file2 + " in " + container + " provided by " + providerClass, null, providerClass);
            } else {
                LOG.error("Invalid root " + file2 + " in " + container);
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 6, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootFileSupplier";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedContentRoots";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootFileSupplier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 6, 8, 9, 10 -> new IllegalArgumentException(string2);
        };
    }
}

