/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaSyntheticLibrary;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.Synthetic;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.CustomEntityProjectModelInfoProvider;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.DirectoryInfoWithExcludePatterns;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.PackageDirectoryCacheImpl;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.CollectionQuery;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.Stack;
import com.intellij.workspaceModel.ide.VirtualFileUrls;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

class RootIndex {
    static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance(RootIndex.class);
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();
    private final Map<VirtualFile, String> myPackagePrefixByRoot;
    private final Map<VirtualFile, DirectoryInfo> myRootInfos;
    private final boolean myHasNonDirectoryRoots;
    private final ConcurrentBitSet myNonInterestingIds;
    @NotNull
    private final Project myProject;
    private final RootFileSupplier myRootSupplier;
    final PackageDirectoryCacheImpl myPackageDirectoryCache;
    private volatile OrderEntryGraph myOrderEntryGraph;

    RootIndex(@NotNull Project project2) {
        if (project2 == null) {
            RootIndex.$$$reportNull$$$0(0);
        }
        this(project2, RootFileSupplier.INSTANCE);
    }

    RootIndex(@NotNull Project project2, @NotNull RootFileSupplier rootSupplier) {
        ModuleManager manager;
        if (project2 == null) {
            RootIndex.$$$reportNull$$$0(1);
        }
        if (rootSupplier == null) {
            RootIndex.$$$reportNull$$$0(2);
        }
        this.myNonInterestingIds = ConcurrentBitSet.create();
        this.myProject = project2;
        this.myRootSupplier = rootSupplier;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project2.isDefault()) {
            LOG.error("Directory index may not be queried for default project");
        }
        if ((manager = ModuleManager.getInstance(project2)) instanceof ModuleManagerEx) {
            LOG.assertTrue(((ModuleManagerEx)manager).areModulesLoaded(), "Directory index can only be queried after project initialization");
        }
        RootInfo info2 = this.buildRootInfo(project2);
        Set<VirtualFile> allRoots = info2.getAllRoots();
        MultiMap<String, VirtualFile> rootsByPackagePrefix = MultiMap.create(allRoots.size(), 0.75f);
        this.myRootInfos = new HashMap<VirtualFile, DirectoryInfo>(allRoots.size());
        this.myHasNonDirectoryRoots = ContainerUtil.exists(allRoots, r -> !r.isDirectory());
        this.myPackagePrefixByRoot = new HashMap<VirtualFile, String>(allRoots.size());
        ArrayList<List<VirtualFile>> hierarchies = new ArrayList<List<VirtualFile>>(allRoots.size());
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info2);
            hierarchies.add(hierarchy);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfoAndPackagePrefix(root, hierarchy, info2);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super(NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.myRootInfos.put(root, (DirectoryInfo)pair3.first);
            String packagePrefix = (String)pair3.second;
            rootsByPackagePrefix.putValue(packagePrefix, root);
            this.myPackagePrefixByRoot.put(root, packagePrefix);
        }
        this.storeContentsBeneathExcluded(allRoots, hierarchies);
        this.storeOutsideProjectRootsButHasContentInside();
        this.myPackageDirectoryCache = new PackageDirectoryCacheImpl((packageName, result2) -> PackageDirectoryCacheImpl.addValidDirectories(rootsByPackagePrefix.get((String)packageName), result2), this::isPackageDirectory);
    }

    private boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        if (dir == null) {
            RootIndex.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            RootIndex.$$$reportNull$$$0(4);
        }
        return this.getInfoForFile(dir).isInProject(dir) && packageName.equals(this.getPackageName(dir));
    }

    private void storeOutsideProjectRootsButHasContentInside() {
        block0: for (VirtualFile root : new ArrayList<VirtualFile>(this.myRootInfos.keySet())) {
            DirectoryInfo info2;
            VirtualFile v;
            for (v = root.getParent(); v != null && (info2 = this.myRootInfos.get(v)) != NonProjectDirectoryInfo.OUTSIDE_PROJECT_ROOTS_BUT_HAS_CONTENT_BENEATH; v = v.getParent()) {
                if (info2 != null) continue block0;
            }
            for (v = root.getParent(); v != null && (info2 = this.myRootInfos.get(v)) != NonProjectDirectoryInfo.OUTSIDE_PROJECT_ROOTS_BUT_HAS_CONTENT_BENEATH; v = v.getParent()) {
                this.myRootInfos.put(v, NonProjectDirectoryInfo.OUTSIDE_PROJECT_ROOTS_BUT_HAS_CONTENT_BENEATH);
            }
        }
    }

    private void storeContentsBeneathExcluded(@NotNull Set<? extends VirtualFile> allRoots, @NotNull List<? extends List<VirtualFile>> hierarchies) {
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(5);
        }
        if (hierarchies == null) {
            RootIndex.$$$reportNull$$$0(6);
        }
        int i2 = 0;
        for (VirtualFile virtualFile2 : allRoots) {
            DirectoryInfo parentInfo;
            VirtualFile parentRoot;
            List<VirtualFile> hierarchy;
            if ((hierarchy = hierarchies.get(i2++)) == null) continue;
            DirectoryInfo dirInfo = this.myRootInfos.get(virtualFile2);
            assert (dirInfo != null);
            boolean hasContent2 = !RootIndex.isExcluded(dirInfo) && dirInfo.getContentRoot() != null;
            if (!hasContent2 || (parentRoot = hierarchy.size() >= 2 ? hierarchy.get(1) : null) == null || !RootIndex.isExcluded(parentInfo = this.myRootInfos.get(parentRoot))) continue;
            this.addContentBeneathExcludedInfo(parentInfo, parentRoot, dirInfo);
        }
    }

    private void addContentBeneathExcludedInfo(@NotNull DirectoryInfo parentExcludedInfo, @NotNull VirtualFile parentFile, @NotNull DirectoryInfo childInfo) {
        List<DirectoryInfoImpl> beneathInfo;
        if (parentExcludedInfo == null) {
            RootIndex.$$$reportNull$$$0(7);
        }
        if (parentFile == null) {
            RootIndex.$$$reportNull$$$0(8);
        }
        if (childInfo == null) {
            RootIndex.$$$reportNull$$$0(9);
        }
        if (parentExcludedInfo instanceof NonProjectDirectoryInfo.WithBeneathInfo) {
            beneathInfo = ((NonProjectDirectoryInfo.WithBeneathInfo)parentExcludedInfo).myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof NonProjectDirectoryInfo) {
            NonProjectDirectoryInfo.WithBeneathInfo newInfo = new NonProjectDirectoryInfo.WithBeneathInfo((NonProjectDirectoryInfo)parentExcludedInfo);
            this.myRootInfos.put(parentFile, newInfo);
            beneathInfo = newInfo.myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof DirectoryInfoImpl) {
            beneathInfo = ((DirectoryInfoImpl)parentExcludedInfo).myContentInfosBeneath;
        } else {
            throw new RuntimeException("unknown info: " + parentExcludedInfo);
        }
        beneathInfo.add((DirectoryInfoImpl)childInfo);
    }

    private static boolean isExcluded(@NotNull DirectoryInfo info2) {
        if (info2 == null) {
            RootIndex.$$$reportNull$$$0(10);
        }
        return info2 instanceof DirectoryInfoImpl && info2.isExcluded(((DirectoryInfoImpl)info2).getRoot()) || info2 instanceof NonProjectDirectoryInfo && ((NonProjectDirectoryInfo)info2).isExcluded();
    }

    void onLowMemory() {
        this.myPackageDirectoryCache.onLowMemory();
    }

    /*
     * Could not resolve type clashes
     */
    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project2) {
        Iterator<Object> sdk2;
        if (project2 == null) {
            RootIndex.$$$reportNull$$$0(11);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start building root info " + Thread.currentThread());
        }
        RootInfo info2 = new RootInfo();
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        boolean includeProjectJdk = true;
        for (Module module2 : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
            for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
                for (Object excludeRoot : contentEntry.getExcludeFolderFiles()) {
                    if (!RootIndex.ensureValid((VirtualFile)excludeRoot, contentEntry)) continue;
                    info2.excludedFromModule.put((VirtualFile)excludeRoot, module2);
                }
                VirtualFile contentRoot = this.myRootSupplier.getContentRoot(contentEntry);
                if (contentRoot != null && RootIndex.ensureValid(contentRoot, module2)) {
                    List<String> patterns;
                    if (!info2.contentRootOf.containsKey(contentRoot)) {
                        info2.contentRootOf.put(contentRoot, module2);
                    }
                    if (!(patterns = contentEntry.getExcludePatterns()).isEmpty()) {
                        Object excludeRoot;
                        FileTypeAssocTable table = new FileTypeAssocTable();
                        excludeRoot = patterns.iterator();
                        while (excludeRoot.hasNext()) {
                            String pattern = (String)excludeRoot.next();
                            table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), (Object)Boolean.TRUE);
                        }
                        info2.excludeFromContentRootTables.put(contentRoot, (FileTypeAssocTable<Boolean>)table);
                    }
                }
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    VirtualFile sourceFolderRoot = this.myRootSupplier.getSourceRoot(sourceFolder);
                    if (sourceFolderRoot == null || !RootIndex.ensureValid(sourceFolderRoot, sourceFolder)) continue;
                    info2.sourceFolders.put(sourceFolderRoot, sourceFolder);
                    info2.classAndSourceRoots.add(sourceFolderRoot);
                    info2.sourceRootOf.putValue(sourceFolderRoot, module2);
                    info2.packagePrefix.put(sourceFolderRoot, sourceFolder.getPackagePrefix());
                }
            }
            for (Synthetic orderEntry2 : moduleRootManager.getOrderEntries()) {
                if (!(orderEntry2 instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry2;
                VirtualFile[] sourceRoots = this.myRootSupplier.getLibraryRoots(entry, OrderRootType.SOURCES);
                VirtualFile[] classRoots = this.myRootSupplier.getLibraryRoots(entry, OrderRootType.CLASSES);
                RootIndex.fillIndexWithLibraryRoots(info2, entry, sourceRoots, classRoots);
                if (orderEntry2 instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)orderEntry2).getLibrary();
                    if (library == null) continue;
                    for (VirtualFile root : this.myRootSupplier.getExcludedRoots((LibraryEx)library)) {
                        if (!RootIndex.ensureValid(root, library)) continue;
                        info2.excludedFromLibraries.putValue(root, library);
                    }
                    for (VirtualFile root : sourceRoots) {
                        if (!RootIndex.ensureValid(root, library)) continue;
                        info2.sourceOfLibraries.putValue(root, library);
                    }
                    for (VirtualFile root : classRoots) {
                        if (!RootIndex.ensureValid(root, library)) continue;
                        info2.classOfLibraries.putValue(root, library);
                    }
                    continue;
                }
                includeProjectJdk = false;
            }
        }
        if (includeProjectJdk && (sdk2 = ProjectRootManager.getInstance(project2).getProjectSdk()) != null) {
            RootIndex.fillIndexWithLibraryRoots(info2, sdk2, this.myRootSupplier.getSdkRoots((Sdk)((Object)sdk2), OrderRootType.SOURCES), this.myRootSupplier.getSdkRoots((Sdk)((Object)sdk2), OrderRootType.CLASSES));
        }
        for (AdditionalLibraryRootsProvider provider2 : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            Collection<SyntheticLibrary> libraries2 = provider2.getAdditionalProjectLibraries(project2);
            for (SyntheticLibrary library : libraries2) {
                for (VirtualFile sourceRoot : library.getSourceRoots()) {
                    if ((sourceRoot = this.myRootSupplier.correctRoot(sourceRoot, library, provider2)) == null) continue;
                    info2.libraryOrSdkSources.add(sourceRoot);
                    info2.classAndSourceRoots.add(sourceRoot);
                    if (library instanceof JavaSyntheticLibrary) {
                        info2.packagePrefix.put(sourceRoot, "");
                    }
                    info2.sourceOfLibraries.putValue(sourceRoot, library);
                }
                for (VirtualFile classRoot : library.getBinaryRoots()) {
                    if ((classRoot = this.myRootSupplier.correctRoot(classRoot, library, provider2)) == null) continue;
                    info2.libraryOrSdkClasses.add(classRoot);
                    info2.classAndSourceRoots.add(classRoot);
                    if (library instanceof JavaSyntheticLibrary) {
                        info2.packagePrefix.put(classRoot, "");
                    }
                    info2.classOfLibraries.putValue(classRoot, library);
                }
                for (VirtualFile file3 : library.getExcludedRoots()) {
                    if ((file3 = this.myRootSupplier.correctRoot(file3, library, provider2)) == null) continue;
                    info2.excludedFromLibraries.putValue(file3, library);
                }
            }
        }
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(project2)) {
            List<VirtualFile> files2 = ContainerUtil.mapNotNull(policy.getExcludeUrlsForProject(), this.myRootSupplier::findFileByUrl);
            info2.excludedFromProject.addAll(ContainerUtil.filter(files2, file2 -> RootFileSupplier.ensureValid(file2, project2, policy)));
            com.intellij.util.Function<Sdk, List<VirtualFile>> fun = policy.getExcludeSdkRootsStrategy();
            if (fun == null) continue;
            Set<Sdk> sdks = this.collectSdks();
            Set<VirtualFile> roots2 = RootIndex.collectSdkClasses(sdks);
            for (Sdk sdk3 : sdks) {
                for (VirtualFile file4 : fun.fun(sdk3)) {
                    if (roots2.contains(file4)) continue;
                    ContainerUtil.addIfNotNull(info2.excludedFromSdkRoots, this.myRootSupplier.correctRoot(file4, sdk3, policy));
                }
            }
        }
        for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
            for (VirtualFile contentRoot : this.myRootSupplier.getUnloadedContentRoots(description)) {
                if (!RootIndex.ensureValid(contentRoot, description)) continue;
                info2.contentRootOfUnloaded.put(contentRoot, description.getName());
            }
        }
        EntityStorageSnapshot snapshot = WorkspaceModel.getInstance(project2).getCurrentSnapshot();
        for (CustomEntityProjectModelInfoProvider<?> provider3 : CustomEntityProjectModelInfoProvider.EP.getExtensionList()) {
            this.handleCustomEntities(provider3, info2, (EntityStorage)snapshot);
        }
        RootInfo rootInfo = info2;
        if (rootInfo == null) {
            RootIndex.$$$reportNull$$$0(12);
        }
        return rootInfo;
    }

    private <T extends WorkspaceEntity> void handleCustomEntities(@NotNull CustomEntityProjectModelInfoProvider<T> provider2, @NotNull RootInfo info2, @NotNull EntityStorage snapshot) {
        WorkspaceEntity entity;
        if (provider2 == null) {
            RootIndex.$$$reportNull$$$0(13);
        }
        if (info2 == null) {
            RootIndex.$$$reportNull$$$0(14);
        }
        if (snapshot == null) {
            RootIndex.$$$reportNull$$$0(15);
        }
        Sequence entities2 = snapshot.entities(provider2.getEntityClass());
        for (CustomEntityProjectModelInfoProvider.CustomContentRoot customContentRoot : SequencesKt.asIterable(provider2.getContentRoots(entities2, snapshot))) {
            Iterator<VirtualFile> module2;
            VirtualFile root = this.myRootSupplier.correctRoot(customContentRoot.root, customContentRoot.generativeEntity, provider2);
            if (root == null || info2.contentRootOf.containsKey(root) || (module2 = ModuleEntityUtils.findModule(customContentRoot.parentModule, snapshot)) == null) continue;
            info2.contentRootOf.put(root, (Module)((Object)module2));
        }
        for (CustomEntityProjectModelInfoProvider.LibraryRoots libraryRoots : SequencesKt.asIterable(provider2.getLibraryRoots(entities2, snapshot))) {
            entity = (WorkspaceEntity)libraryRoots.generativeEntity;
            for (VirtualFile root : libraryRoots.sources) {
                VirtualFile librarySource = this.myRootSupplier.correctRoot(root, entity, provider2);
                if (librarySource == null) continue;
                info2.libraryOrSdkSources.add(librarySource);
                info2.classAndSourceRoots.add(librarySource);
                info2.sourceOfLibraries.putValue(librarySource, entity);
                info2.packagePrefix.put(librarySource, "");
            }
            for (VirtualFile root : libraryRoots.classes) {
                VirtualFile libraryClass = this.myRootSupplier.correctRoot(root, entity, provider2);
                if (libraryClass == null) continue;
                info2.libraryOrSdkClasses.add(libraryClass);
                info2.classAndSourceRoots.add(libraryClass);
                info2.classOfLibraries.putValue(libraryClass, entity);
                info2.packagePrefix.put(libraryClass, "");
            }
            for (VirtualFile root : libraryRoots.excluded) {
                VirtualFile libraryExcluded = this.myRootSupplier.correctRoot(root, entity, provider2);
                if (libraryExcluded == null) continue;
                info2.excludedFromLibraries.putValue(libraryExcluded, entity);
            }
            SyntheticLibrary.ExcludeFileCondition excludeFileCondition = libraryRoots.excludeFileCondition;
            if (excludeFileCondition == null) continue;
            Set<VirtualFile> allRoots = ContainerUtil.union(libraryRoots.sources, libraryRoots.classes);
            info2.customEntitiesExcludeConditions.put(entity, excludeFileCondition.transformToCondition(allRoots));
        }
        for (CustomEntityProjectModelInfoProvider.ExcludeStrategy excludeStrategy : SequencesKt.asIterable(provider2.getExcludeSdkRootStrategies(entities2, snapshot))) {
            entity = (WorkspaceEntity)excludeStrategy.generativeEntity;
            List<VirtualFile> files2 = ContainerUtil.mapNotNull(excludeStrategy.excludeUrls, VirtualFileUrls::getVirtualFile);
            info2.excludedFromProject.addAll(ContainerUtil.filter(files2, file2 -> RootFileSupplier.ensureValid(file2, entity, provider2)));
            @Nullable Function<Sdk, List<VirtualFile>> fun = excludeStrategy.excludeSdkRootsStrategy;
            if (fun == null) continue;
            Set<Sdk> sdks = this.collectSdks();
            Set<VirtualFile> roots2 = RootIndex.collectSdkClasses(sdks);
            for (Sdk sdk2 : sdks) {
                for (VirtualFile file3 : fun.apply(sdk2)) {
                    if (roots2.contains(file3)) continue;
                    ContainerUtil.addIfNotNull(info2.excludedFromSdkRoots, this.myRootSupplier.correctRoot(file3, sdk2, provider2));
                }
            }
        }
    }

    @NotNull
    private static Set<VirtualFile> collectSdkClasses(Set<? extends Sdk> sdks) {
        HashSet<VirtualFile> roots2 = new HashSet<VirtualFile>();
        for (Sdk sdk2 : sdks) {
            roots2.addAll(Arrays.asList(sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)));
        }
        HashSet<VirtualFile> hashSet = roots2;
        if (hashSet == null) {
            RootIndex.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    private Set<Sdk> collectSdks() {
        HashSet<Sdk> sdks = new HashSet<Sdk>();
        for (Module m : ModuleManager.getInstance(this.myProject).getModules()) {
            Sdk sdk2 = ModuleRootManager.getInstance(m).getSdk();
            if (sdk2 == null) continue;
            sdks.add(sdk2);
        }
        HashSet<Sdk> hashSet = sdks;
        if (hashSet == null) {
            RootIndex.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    private static void fillIndexWithLibraryRoots(RootInfo info2, Object container, VirtualFile[] sourceRoots, VirtualFile[] classRoots) {
        for (VirtualFile sourceRoot : sourceRoots) {
            if (!RootIndex.ensureValid(sourceRoot, container)) continue;
            info2.classAndSourceRoots.add(sourceRoot);
            info2.libraryOrSdkSources.add(sourceRoot);
            info2.packagePrefix.put(sourceRoot, "");
        }
        for (VirtualFile classRoot : classRoots) {
            if (!RootIndex.ensureValid(classRoot, container)) continue;
            info2.classAndSourceRoots.add(classRoot);
            info2.libraryOrSdkClasses.add(classRoot);
            info2.packagePrefix.put(classRoot, "");
        }
    }

    private static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(18);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(19);
        }
        return RootFileSupplier.ensureValid(file2, container, null);
    }

    @NotNull
    private OrderEntryGraph getOrderEntryGraph() {
        if (this.myOrderEntryGraph == null) {
            RootInfo rootInfo = this.buildRootInfo(this.myProject);
            Couple<MultiMap<VirtualFile, OrderEntry>> pair = this.initLibraryClassSourceRoots();
            this.myOrderEntryGraph = new OrderEntryGraph(this.myProject, rootInfo, (MultiMap)pair.first, (MultiMap)pair.second);
        }
        OrderEntryGraph orderEntryGraph = this.myOrderEntryGraph;
        if (orderEntryGraph == null) {
            RootIndex.$$$reportNull$$$0(20);
        }
        return orderEntryGraph;
    }

    @NotNull
    private Couple<MultiMap<VirtualFile, OrderEntry>> initLibraryClassSourceRoots() {
        MultiMap<VirtualFile, OrderEntry> libClassRootEntries = new MultiMap<VirtualFile, OrderEntry>();
        MultiMap<VirtualFile, OrderEntry> libSourceRootEntries = new MultiMap<VirtualFile, OrderEntry>();
        for (Module module2 : ModuleManager.getInstance(this.myProject).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
            for (OrderEntry orderEntry2 : moduleRootManager.getOrderEntries()) {
                if (!(orderEntry2 instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry2;
                for (VirtualFile sourceRoot : this.myRootSupplier.getLibraryRoots(entry, OrderRootType.SOURCES)) {
                    libSourceRootEntries.putValue(sourceRoot, orderEntry2);
                }
                for (VirtualFile classRoot : this.myRootSupplier.getLibraryRoots(entry, OrderRootType.CLASSES)) {
                    libClassRootEntries.putValue(classRoot, orderEntry2);
                }
            }
        }
        Couple<MultiMap<VirtualFile, OrderEntry>> couple = Couple.of(libClassRootEntries, libSourceRootEntries);
        if (couple == null) {
            RootIndex.$$$reportNull$$$0(21);
        }
        return couple;
    }

    @NotNull
    DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(22);
        }
        if (!file2.isValid()) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.INVALID;
            if (nonProjectDirectoryInfo == null) {
                RootIndex.$$$reportNull$$$0(23);
            }
            return nonProjectDirectoryInfo;
        }
        if (!file2.isDirectory()) {
            DirectoryInfo info2 = this.getOwnFileInfo(file2);
            if (info2 != null) {
                DirectoryInfo directoryInfo = info2;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(24);
                }
                return directoryInfo;
            }
            file2 = file2.getParent();
        }
        if (file2 instanceof VirtualFileWithId) {
            for (each = file2; each != null; each = each.getParent()) {
                DirectoryInfo info3;
                int id = ((VirtualFileWithId)((Object)each)).getId();
                if (this.myNonInterestingIds.get(id) || (info3 = this.handleInterestingId(id, each)) == null) continue;
                DirectoryInfo directoryInfo = info3;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(25);
                }
                return directoryInfo;
            }
        } else {
            for (each = file2; each != null; each = each.getParent()) {
                DirectoryInfo info4 = this.getOwnInfo(each);
                if (info4 == null) continue;
                DirectoryInfo directoryInfo = info4;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(26);
                }
                return directoryInfo;
            }
        }
        NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS;
        if (nonProjectDirectoryInfo == null) {
            RootIndex.$$$reportNull$$$0(27);
        }
        return nonProjectDirectoryInfo;
    }

    @Nullable
    private DirectoryInfo getOwnFileInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(28);
        }
        if (this.myHasNonDirectoryRoots) {
            return file2 instanceof VirtualFileWithId ? this.getOwnInfo(((VirtualFileWithId)((Object)file2)).getId(), file2) : this.getOwnInfo(file2);
        }
        return ourFileTypes.isFileIgnored(file2) ? NonProjectDirectoryInfo.IGNORED : null;
    }

    @Nullable
    private DirectoryInfo getOwnInfo(int id, VirtualFile file2) {
        return this.myNonInterestingIds.get(id) ? null : this.handleInterestingId(id, file2);
    }

    @Nullable
    private DirectoryInfo getOwnInfo(@NotNull VirtualFile file2) {
        DirectoryInfo info2;
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(29);
        }
        if ((info2 = this.myRootInfos.get(file2)) != null) {
            return info2;
        }
        if (ourFileTypes.isFileIgnored(file2)) {
            return NonProjectDirectoryInfo.IGNORED;
        }
        return null;
    }

    @Nullable
    private DirectoryInfo handleInterestingId(int id, @NotNull VirtualFile file2) {
        DirectoryInfo info2;
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(30);
        }
        if ((info2 = this.myRootInfos.get(file2)) == null && ourFileTypes.isFileIgnored(file2)) {
            info2 = NonProjectDirectoryInfo.IGNORED;
        }
        if (info2 == null) {
            if ((id > 500000000 || id < 0) && LOG.isDebugEnabled()) {
                LOG.error("Invalid id: " + id + " for " + file2 + " of " + file2.getClass());
            }
            this.myNonInterestingIds.set(id);
        }
        return info2;
    }

    @NotNull
    Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            RootIndex.$$$reportNull$$$0(31);
        }
        List<VirtualFile> result2 = this.myPackageDirectoryCache.getDirectoriesByPackageName(packageName);
        if (!includeLibrarySources) {
            result2 = ContainerUtil.filter(result2, file2 -> {
                DirectoryInfo info2 = this.getInfoForFile((VirtualFile)file2);
                return info2.isInProject((VirtualFile)file2) && (!info2.isInLibrarySource((VirtualFile)file2) || info2.isInModuleSource((VirtualFile)file2) || info2.hasLibraryClassRoot());
            });
        }
        return new CollectionQuery<VirtualFile>(result2);
    }

    @Nullable
    String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            RootIndex.$$$reportNull$$$0(32);
        }
        if (dir.isDirectory()) {
            if (ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (this.myPackagePrefixByRoot.containsKey(dir)) {
                return this.myPackagePrefixByRoot.get(dir);
            }
            VirtualFile parent2 = dir.getParent();
            if (parent2 != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent2), dir.getName());
            }
        }
        return null;
    }

    private static String getPackageNameForSubdir(@Nullable String parentPackageName, @NotNull String subdirName) {
        if (subdirName == null) {
            RootIndex.$$$reportNull$$$0(33);
        }
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static @Nullable(value="returns null only if dir is under ignored folder") List<VirtualFile> getHierarchy(@NotNull VirtualFile deepDir, @NotNull Set<? extends VirtualFile> allRoots, @NotNull RootInfo info2) {
        if (deepDir == null) {
            RootIndex.$$$reportNull$$$0(34);
        }
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(35);
        }
        if (info2 == null) {
            RootIndex.$$$reportNull$$$0(36);
        }
        ArrayList<VirtualFile> hierarchy = new ArrayList<VirtualFile>();
        boolean hasContentRoots = false;
        for (VirtualFile dir = deepDir; dir != null; dir = dir.getParent()) {
            if (!(hasContentRoots |= info2.contentRootOf.get(dir) != null) && ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (!allRoots.contains(dir)) continue;
            hierarchy.add(dir);
        }
        return hierarchy;
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfoAndPackagePrefix(@NotNull VirtualFile root, @NotNull List<? extends VirtualFile> hierarchy, @NotNull RootInfo info2) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        if (root == null) {
            RootIndex.$$$reportNull$$$0(37);
        }
        if (hierarchy == null) {
            RootIndex.$$$reportNull$$$0(38);
        }
        if (info2 == null) {
            RootIndex.$$$reportNull$$$0(39);
        }
        VirtualFile moduleContentRoot = info2.findNearestContentRoot(hierarchy);
        Pair<VirtualFile, List<Condition<? super VirtualFile>>> librarySourceRootInfo = info2.findLibraryRootInfo(hierarchy, true);
        VirtualFile librarySourceRoot = Pair.getFirst(librarySourceRootInfo);
        Pair<VirtualFile, List<Condition<? super VirtualFile>>> libraryClassRootInfo = info2.findLibraryRootInfo(hierarchy, false);
        VirtualFile libraryClassRoot = Pair.getFirst(libraryClassRootInfo);
        boolean bl = inProject = moduleContentRoot != null || (libraryClassRoot != null || librarySourceRoot != null) && !info2.excludedFromSdkRoots.contains(root);
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info2.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                return new Pair<NonProjectDirectoryInfo, Object>(NonProjectDirectoryInfo.EXCLUDED, null);
            }
        }
        VirtualFile sourceRoot = info2.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = librarySourceRoot == null ? sourceRoot : info2.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        SourceFolder sourceFolder = moduleSourceRoot != null ? info2.sourceFolders.get(moduleSourceRoot) : null;
        Module module2 = info2.contentRootOf.get(nearestContentRoot);
        String unloadedModuleName = info2.contentRootOfUnloaded.get(nearestContentRoot);
        FileTypeAssocTable<Boolean> contentExcludePatterns = moduleContentRoot != null ? info2.excludeFromContentRootTables.get(moduleContentRoot) : null;
        Condition<? super VirtualFile> libraryExclusionPredicate = RootIndex.getLibraryExclusionPredicate(Pair.getSecond(librarySourceRootInfo));
        DirectoryInfoImpl directoryInfo = contentExcludePatterns != null || libraryExclusionPredicate != null ? new DirectoryInfoWithExcludePatterns(root, module2, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, contentExcludePatterns, libraryExclusionPredicate, unloadedModuleName) : new DirectoryInfoImpl(root, module2, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, unloadedModuleName);
        VirtualFile packageRoot = libraryClassRoot == null ? sourceRoot : info2.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        String packagePrefix = info2.calcPackagePrefix(root, packageRoot);
        Pair<DirectoryInfo, String> pair = Pair.create(directoryInfo, packagePrefix);
        if (pair == null) {
            RootIndex.$$$reportNull$$$0(40);
        }
        return pair;
    }

    @Nullable
    private static Condition<? super VirtualFile> getLibraryExclusionPredicate(@Nullable List<? extends Condition<? super VirtualFile>> exclusions) {
        if (exclusions != null) {
            Condition<Object> result2 = Conditions.alwaysFalse();
            for (Condition<? super VirtualFile> condition : exclusions) {
                result2 = Conditions.or(result2, condition);
            }
            return result2 == Conditions.alwaysFalse() ? null : result2;
        }
        return null;
    }

    @NotNull
    List<OrderEntry> getOrderEntries(@NotNull VirtualFile root) {
        if (root == null) {
            RootIndex.$$$reportNull$$$0(41);
        }
        List<OrderEntry> list2 = this.getOrderEntryGraph().getOrderEntries(root);
        if (list2 == null) {
            RootIndex.$$$reportNull$$$0(42);
        }
        return list2;
    }

    @NotNull
    Set<String> getDependentUnloadedModules(@NotNull Module module2) {
        if (module2 == null) {
            RootIndex.$$$reportNull$$$0(43);
        }
        Set<String> set2 = this.getOrderEntryGraph().getDependentUnloadedModules(module2);
        if (set2 == null) {
            RootIndex.$$$reportNull$$$0(44);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16, 17, 20, 21, 23, 24, 25, 26, 27, 40, 42, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSupplier";
                break;
            }
            case 3: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchies";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExcludedInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childInfo";
                break;
            }
            case 10: 
            case 14: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 18: 
            case 22: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepDir";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRootInfo";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdkClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdks";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryGraph";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "initLibraryClassSourceRoots";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDirectoryInfoAndPackagePrefix";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "storeContentsBeneathExcluded";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addContentBeneathExcludedInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildRootInfo";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 40: 
            case 42: 
            case 44: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleCustomEntities";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOwnFileInfo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOwnInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "handleInterestingId";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameForSubdir";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "calcDirectoryInfoAndPackagePrefix";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 16, 17, 20, 21, 23, 24, 25, 26, 27, 40, 42, 44 -> new IllegalStateException(string2);
        };
    }

    private static class RootInfo {
        @NotNull
        private final Set<VirtualFile> classAndSourceRoots = new LinkedHashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkSources = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkClasses = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> contentRootOf = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, String> contentRootOfUnloaded = new HashMap<VirtualFile, String>();
        @NotNull
        private final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        private final Map<VirtualFile, SourceFolder> sourceFolders = new HashMap<VirtualFile, SourceFolder>();
        @NotNull
        private final MultiMap<VirtualFile, Object> excludedFromLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> classOfLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> sourceOfLibraries = MultiMap.createSet();
        @NotNull
        private final Map<WorkspaceEntity, Condition<VirtualFile>> customEntitiesExcludeConditions = new HashMap<WorkspaceEntity, Condition<VirtualFile>>();
        @NotNull
        private final Set<VirtualFile> excludedFromProject = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> excludedFromSdkRoots = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> excludedFromModule = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, FileTypeAssocTable<Boolean>> excludeFromContentRootTables = new HashMap<VirtualFile, FileTypeAssocTable<Boolean>>();
        @NotNull
        private final Map<VirtualFile, String> packagePrefix = new HashMap<VirtualFile, String>();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            result2.addAll(this.classAndSourceRoots);
            result2.addAll(this.contentRootOf.keySet());
            result2.addAll(this.contentRootOfUnloaded.keySet());
            result2.addAll(this.excludedFromLibraries.keySet());
            result2.addAll(this.excludedFromModule.keySet());
            result2.addAll(this.excludedFromProject);
            result2.addAll(this.excludedFromSdkRoots);
            LinkedHashSet<VirtualFile> linkedHashSet = result2;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        @Nullable
        private VirtualFile findNearestContentRoot(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(1);
            }
            Collection<Module> sourceRootOwners = null;
            boolean underExcludedSourceRoot = false;
            for (VirtualFile virtualFile2 : hierarchy) {
                Collection<Module> modulesForSourceRoot;
                FileTypeAssocTable<Boolean> table;
                Module module2 = this.contentRootOf.get(virtualFile2);
                Module excludedFrom = this.excludedFromModule.get(virtualFile2);
                if (module2 != null && (table = this.excludeFromContentRootTables.get(virtualFile2)) != null && RootInfo.isExcludedByPattern(virtualFile2, hierarchy, table)) {
                    excludedFrom = module2;
                }
                if (module2 != null && (excludedFrom != module2 || underExcludedSourceRoot && sourceRootOwners.contains(module2))) {
                    return virtualFile2;
                }
                if (excludedFrom != null || this.excludedFromProject.contains(virtualFile2) || this.contentRootOfUnloaded.containsKey(virtualFile2)) {
                    if (sourceRootOwners == null) {
                        return null;
                    }
                    underExcludedSourceRoot = true;
                }
                if (underExcludedSourceRoot || !this.sourceRootOf.containsKey(virtualFile2) || (modulesForSourceRoot = this.sourceRootOf.get(virtualFile2)).isEmpty()) continue;
                sourceRootOwners = sourceRootOwners == null ? modulesForSourceRoot : ContainerUtil.union(sourceRootOwners, modulesForSourceRoot);
            }
            return null;
        }

        private static boolean isExcludedByPattern(@NotNull VirtualFile contentRoot, @NotNull List<? extends VirtualFile> hierarchy, @NotNull FileTypeAssocTable<Boolean> table) {
            if (contentRoot == null) {
                RootInfo.$$$reportNull$$$0(2);
            }
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(3);
            }
            if (table == null) {
                RootInfo.$$$reportNull$$$0(4);
            }
            for (VirtualFile virtualFile2 : hierarchy) {
                if (table.findAssociatedFileType(virtualFile2.getNameSequence()) != null) {
                    return true;
                }
                if (!virtualFile2.equals(contentRoot)) continue;
                break;
            }
            return false;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(5);
            }
            for (VirtualFile virtualFile2 : hierarchy) {
                if (!this.contentRootOf.containsKey(virtualFile2) && !this.contentRootOfUnloaded.containsKey(virtualFile2)) continue;
                return virtualFile2;
            }
            return null;
        }

        @Nullable
        private Pair<VirtualFile, List<Condition<? super VirtualFile>>> findLibraryRootInfo(@NotNull List<? extends VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(6);
            }
            Set<Object> librariesToIgnore = RootInfo.createLibrarySet();
            for (VirtualFile virtualFile2 : hierarchy) {
                List<Condition<? super VirtualFile>> found2;
                librariesToIgnore.addAll(this.excludedFromLibraries.get(virtualFile2));
                if (source && this.libraryOrSdkSources.contains(virtualFile2)) {
                    List<Condition<? super VirtualFile>> found22 = RootInfo.findInLibraryProducers(virtualFile2, this.sourceOfLibraries, librariesToIgnore, this.customEntitiesExcludeConditions);
                    if (found22 == null) continue;
                    return Pair.create(virtualFile2, found22);
                }
                if (source || !this.libraryOrSdkClasses.contains(virtualFile2) || (found2 = RootInfo.findInLibraryProducers(virtualFile2, this.classOfLibraries, librariesToIgnore, this.customEntitiesExcludeConditions)) == null) continue;
                return Pair.create(virtualFile2, found2);
            }
            return null;
        }

        @NotNull
        private static Set<Object> createLibrarySet() {
            Set<Object> set2 = CollectionFactory.createCustomHashingStrategySet(new HashingStrategy<Object>(){

                @Override
                public int hashCode(Object object) {
                    return Objects.hashCode(object instanceof Library ? ((Library)object).getName() : object);
                }

                @Override
                public boolean equals(Object o1, Object o2) {
                    return Objects.equals(o1, o2);
                }
            });
            if (set2 == null) {
                RootInfo.$$$reportNull$$$0(7);
            }
            return set2;
        }

        private static List<Condition<? super VirtualFile>> findInLibraryProducers(@NotNull VirtualFile root, @NotNull MultiMap<VirtualFile, Object> libraryRoots, @NotNull Set<Object> librariesToIgnore, @NotNull Map<WorkspaceEntity, Condition<VirtualFile>> customEntitiesExcludeConditions) {
            if (root == null) {
                RootInfo.$$$reportNull$$$0(8);
            }
            if (libraryRoots == null) {
                RootInfo.$$$reportNull$$$0(9);
            }
            if (librariesToIgnore == null) {
                RootInfo.$$$reportNull$$$0(10);
            }
            if (customEntitiesExcludeConditions == null) {
                RootInfo.$$$reportNull$$$0(11);
            }
            if (!libraryRoots.containsKey(root)) {
                return Collections.emptyList();
            }
            Collection<Object> producers = libraryRoots.get(root);
            HashSet<Object> libraries2 = new HashSet<Object>(producers.size());
            SmartList<Condition<? super VirtualFile>> exclusions = new SmartList<Condition<? super VirtualFile>>();
            for (Object library : producers) {
                Condition<VirtualFile> condition;
                if (librariesToIgnore.contains(library)) continue;
                if (library instanceof SyntheticLibrary) {
                    Condition<VirtualFile> exclusion = ((SyntheticLibrary)library).getUnitedExcludeCondition();
                    if (exclusion != null) {
                        exclusions.add(exclusion);
                        if (exclusion.value(root)) {
                            continue;
                        }
                    }
                } else if (library instanceof WorkspaceEntity && (condition = customEntitiesExcludeConditions.get(library)) != null) {
                    exclusions.add(condition);
                    if (condition.value(root)) continue;
                }
                libraries2.add(library);
            }
            if (!libraries2.isEmpty()) {
                return exclusions;
            }
            return null;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, VirtualFile packageRoot) {
            String prefix;
            if (root == null) {
                RootInfo.$$$reportNull$$$0(12);
            }
            if ((prefix = this.packagePrefix.get(packageRoot)) != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath(root, packageRoot, '.');
                prefix = StringUtil.isEmpty(prefix) ? relative : prefix + "." + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<? extends VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(13);
            }
            for (VirtualFile virtualFile2 : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get(virtualFile2).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return virtualFile2;
                }
                if (virtualFile2.equals(libraryClassRoot) || virtualFile2.equals(librarySourceRoot)) {
                    return virtualFile2;
                }
                if (!virtualFile2.equals(moduleContentRoot) || this.sourceRootOf.containsKey(virtualFile2) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private Set<OrderEntry> getLibraryOrderEntries(@NotNull List<? extends VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(14);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(15);
            }
            if (libSourceRootEntries == null) {
                RootInfo.$$$reportNull$$$0(16);
            }
            LinkedHashSet<OrderEntry> orderEntries = new LinkedHashSet<OrderEntry>();
            for (VirtualFile virtualFile2 : hierarchy) {
                if (virtualFile2.equals(libraryClassRoot) && !this.sourceRootOf.containsKey(virtualFile2)) {
                    orderEntries.addAll(libClassRootEntries.get(virtualFile2));
                }
                if (virtualFile2.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get(virtualFile2));
                }
                if (!libClassRootEntries.containsKey(virtualFile2) && (!this.sourceRootOf.containsKey(virtualFile2) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet<OrderEntry> linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(17);
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<? extends VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(18);
            }
            if (moduleContentRoot == null) {
                RootInfo.$$$reportNull$$$0(19);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(20);
            }
            Module module2 = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile virtualFile2 : hierarchy) {
                if (this.sourceRootOf.get(virtualFile2).contains(module2)) {
                    return ContainerUtil.findInstance(ModuleRootManager.getInstance(module2).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey(virtualFile2)) continue;
                return null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hierarchy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRoot";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryRoots";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "librariesToIgnore";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customEntitiesExcludeConditions";
                    break;
                }
                case 15: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libClassRootEntries";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libSourceRootEntries";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleContentRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibrarySet";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryOrderEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isExcludedByPattern";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRootForExcluded";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibraryRootInfo";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findInLibraryProducers";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "calcPackagePrefix";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "findPackageRootInfo";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryOrderEntries";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleSourceEntry";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20 -> new IllegalArgumentException(string2);
            };
        }
    }

    private static class OrderEntryGraph {
        private final Project myProject;
        private final RootInfo myRootInfo;
        private final Set<VirtualFile> myAllRoots;
        private final Graph myGraph;
        private final MultiMap<VirtualFile, Node> myRoots;
        private final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        private final SynchronizedSLRUCache<Module, Set<String>> myDependentUnloadedModulesCache;
        private final MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private final MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        OrderEntryGraph(@NotNull Project project2, @NotNull RootInfo rootInfo, MultiMap<VirtualFile, OrderEntry> libClassRootEntries, MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (project2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(0);
            }
            if (rootInfo == null) {
                OrderEntryGraph.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myRootInfo = rootInfo;
            this.myAllRoots = this.myRootInfo.getAllRoots();
            int cacheSize = Math.max(25, this.myAllRoots.size() / 100 * 2);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public List<OrderEntry> createValue(@NotNull VirtualFile key) {
                    if (key == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<OrderEntry> list2 = this.collectOrderEntries(key);
                    if (list2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 1 -> new IllegalStateException(string2);
                    };
                }
            };
            int dependentUnloadedModulesCacheSize = ModuleManager.getInstance(project2).getModules().length / 2;
            this.myDependentUnloadedModulesCache = new SynchronizedSLRUCache<Module, Set<String>>(dependentUnloadedModulesCacheSize, dependentUnloadedModulesCacheSize){

                @Override
                @NotNull
                public Set<String> createValue(@NotNull Module key) {
                    if (key == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Set<String> set2 = this.collectDependentUnloadedModules(key);
                    if (set2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 1 -> new IllegalStateException(string2);
                    };
                }
            };
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = this.initGraphRoots();
            this.myGraph = pair.getFirst();
            this.myRoots = pair.getSecond();
            this.myLibClassRootEntries = libClassRootEntries;
            this.myLibSourceRootEntries = libSourceRootEntries;
        }

        @NotNull
        private Pair<Graph, MultiMap<VirtualFile, Node>> initGraphRoots() {
            ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
            Module[] modules2 = moduleManager.getModules();
            Graph graph2 = new Graph(modules2.length);
            MultiMap<VirtualFile, Node> roots2 = new MultiMap<VirtualFile, Node>();
            for (Module module2 : modules2) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
                List<OrderEnumerationHandler> handlers2 = OrderEnumeratorBase.getCustomHandlers(module2);
                for (OrderEntry orderEntry2 : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry2 instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry2).getModule()) == null) continue;
                    Node node2 = graph2.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries(depModule).exportedOnly();
                    if (node2 == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node2 = new Node(depModule);
                        graph2.myNodes.put(depModule, node2);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots2.putValue(importedClassRoot, node2);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots2.putValue(sourceRoot, node2);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers2);
                    node2.myEdges.add(new Edge(module2, moduleOrderEntry, shouldRecurse));
                }
            }
            for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
                for (String depName : description.getDependencyModuleNames()) {
                    Module depModule = moduleManager.findModuleByName(depName);
                    if (depModule == null) continue;
                    Node node3 = graph2.myNodes.get(depModule);
                    if (node3 == null) {
                        node3 = new Node(depModule);
                        graph2.myNodes.put(depModule, node3);
                    }
                    if (node3.myUnloadedDependentModules == null) {
                        node3.myUnloadedDependentModules = new LinkedHashSet<String>();
                    }
                    node3.myUnloadedDependentModules.add(description.getName());
                }
            }
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = Pair.create(graph2, roots2);
            if (pair == null) {
                OrderEntryGraph.$$$reportNull$$$0(2);
            }
            return pair;
        }

        @NotNull
        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file2) {
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(3);
            }
            List<OrderEntry> list2 = this.myCache.get(file2);
            if (list2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        private List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file2) {
            List<VirtualFile> roots2;
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(5);
            }
            if ((roots2 = RootIndex.getHierarchy(file2, this.myAllRoots, this.myRootInfo)) == null) {
                List<OrderEntry> list2 = Collections.emptyList();
                if (list2 == null) {
                    OrderEntryGraph.$$$reportNull$$$0(6);
                }
                return list2;
            }
            Stack<Node> stack = new Stack<Node>(roots2.size());
            for (VirtualFile root : roots2) {
                Collection<Node> nodes2 = this.myRoots.get(root);
                for (Node node2 : nodes2) {
                    stack.push(node2);
                }
            }
            HashSet<Node> seen = new HashSet<Node>(stack.size());
            ArrayList<OrderEntry> result2 = new ArrayList<OrderEntry>(stack.size());
            while (!stack.isEmpty()) {
                Node node3 = (Node)stack.pop();
                if (!seen.add(node3)) continue;
                for (Edge edge : node3.myEdges) {
                    Node targetNode;
                    result2.add(edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Pair<VirtualFile, List<Condition<? super VirtualFile>>> libraryClassRootInfo = this.myRootInfo.findLibraryRootInfo(roots2, false);
            Pair<VirtualFile, List<Condition<? super VirtualFile>>> librarySourceRootInfo = this.myRootInfo.findLibraryRootInfo(roots2, true);
            result2.addAll(this.myRootInfo.getLibraryOrderEntries(roots2, Pair.getFirst(libraryClassRootInfo), Pair.getFirst(librarySourceRootInfo), this.myLibClassRootEntries, this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findNearestContentRoot(roots2);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result2, this.myRootInfo.getModuleSourceEntry(roots2, moduleContentRoot, this.myLibClassRootEntries));
            }
            result2.sort(BY_OWNER_MODULE);
            ImmutableList<OrderEntry> immutableList = ContainerUtil.immutableList(result2);
            if (immutableList == null) {
                OrderEntryGraph.$$$reportNull$$$0(7);
            }
            return immutableList;
        }

        @NotNull
        Set<String> getDependentUnloadedModules(@NotNull Module module2) {
            if (module2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(8);
            }
            Set<String> set2 = this.myDependentUnloadedModulesCache.get(module2);
            if (set2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(9);
            }
            return set2;
        }

        @NotNull
        private Set<String> collectDependentUnloadedModules(@NotNull Module module2) {
            Node start;
            if (module2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(10);
            }
            if ((start = this.myGraph.myNodes.get(module2)) == null) {
                Set<String> set2 = Collections.emptySet();
                if (set2 == null) {
                    OrderEntryGraph.$$$reportNull$$$0(11);
                }
                return set2;
            }
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            stack.push(start);
            HashSet<Node> seen = new HashSet<Node>();
            Set<String> result2 = null;
            while (!stack.isEmpty()) {
                Node node2 = (Node)stack.pop();
                if (!seen.add(node2)) continue;
                if (node2.myUnloadedDependentModules != null) {
                    if (result2 == null) {
                        result2 = new LinkedHashSet<String>(node2.myUnloadedDependentModules);
                    } else {
                        result2.addAll(node2.myUnloadedDependentModules);
                    }
                }
                for (Edge edge : node2.myEdges) {
                    Node targetNode;
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Set<String> set3 = result2 != null ? result2 : Collections.emptySet();
            if (set3 == null) {
                OrderEntryGraph.$$$reportNull$$$0(12);
            }
            return set3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6, 7, 9, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootInfo";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initGraphRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrderEntries";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectOrderEntries";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependentUnloadedModules";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectDependentUnloadedModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrderEntries";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectOrderEntries";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependentUnloadedModules";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependentUnloadedModules";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 4, 6, 7, 9, 11, 12 -> new IllegalStateException(string2);
            };
        }

        private static class Graph {
            private final Map<Module, Node> myNodes;

            Graph(int moduleCount) {
                this.myNodes = new HashMap<Module, Node>(moduleCount);
            }
        }

        private static final class Node {
            private final Module myKey;
            private final List<Edge> myEdges;
            private Set<String> myUnloadedDependentModules;

            private Node(@NotNull Module key) {
                if (key == null) {
                    Node.$$$reportNull$$$0(0);
                }
                this.myEdges = new ArrayList<Edge>();
                this.myKey = key;
            }

            public String toString() {
                return this.myKey.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Node", "<init>"));
            }
        }

        private static class Edge {
            private final Module myKey;
            private final ModuleOrderEntry myOrderEntry;
            private final boolean myRecursive;

            Edge(@NotNull Module key, @NotNull ModuleOrderEntry orderEntry2, boolean recursive) {
                if (key == null) {
                    Edge.$$$reportNull$$$0(0);
                }
                if (orderEntry2 == null) {
                    Edge.$$$reportNull$$$0(1);
                }
                this.myKey = key;
                this.myOrderEntry = orderEntry2;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "orderEntry";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Edge";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        private final Object myLock = ObjectUtils.sentinel("Root index lock");

        SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(@NotNull K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public V get(K key) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key);
                if (value != null) {
                    Object v = value;
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (v == null) {
                        SynchronizedSLRUCache.$$$reportNull$$$0(0);
                    }
                    return v;
                }
            }
            value = this.createValue(key);
            object = this.myLock;
            synchronized (object) {
                this.put(key, value);
            }
            Object v = value;
            if (v == null) {
                SynchronizedSLRUCache.$$$reportNull$$$0(1);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
        }
    }
}

