/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public abstract class RootModelBase
implements ModuleRootModel {
    @Override
    public VirtualFile @NotNull [] getContentRoots() {
        Collection<ContentEntry> content2 = this.getContent();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(content2.size());
        for (ContentEntry contentEntry : content2) {
            VirtualFile file2 = contentEntry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(0);
        }
        return virtualFileArray;
    }

    @Override
    public String @NotNull [] getContentRootUrls() {
        Collection<ContentEntry> content2 = this.getContent();
        if (content2.isEmpty()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                RootModelBase.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result2 = new ArrayList<String>(content2.size());
        for (ContentEntry contentEntry : content2) {
            result2.add(contentEntry.getUrl());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] getExcludeRootUrls() {
        SmartList<String> result2 = new SmartList<String>();
        for (ContentEntry contentEntry : this.getContent()) {
            result2.addAll(contentEntry.getExcludeFolderUrls());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Override
    public VirtualFile @NotNull [] getExcludeRoots() {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            Collections.addAll(result2, contentEntry.getExcludeFolderFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @Override
    public String @NotNull [] getSourceRootUrls() {
        String[] stringArray = this.getSourceRootUrls(true);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] getSourceRootUrls(boolean includingTests) {
        SmartList<String> result2 = new SmartList<String>();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders2;
            for (SourceFolder sourceFolder : sourceFolders2 = contentEntry.getSourceFolders()) {
                if (!includingTests && sourceFolder.isTestSource()) continue;
                result2.add(sourceFolder.getUrl());
            }
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.getSourceRoots(true);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(boolean includingTests) {
        SmartList<VirtualFile> result2 = new SmartList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders2;
            for (SourceFolder sourceFolder : sourceFolders2 = contentEntry.getSourceFolders()) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null || !includingTests && sourceFolder.isTestSource()) continue;
                result2.add(file2);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            RootModelBase.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            RootModelBase.$$$reportNull$$$0(9);
        }
        List<VirtualFile> list2 = this.getSourceRoots(Collections.singleton(rootType));
        if (list2 == null) {
            RootModelBase.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            RootModelBase.$$$reportNull$$$0(11);
        }
        SmartList<VirtualFile> result2 = new SmartList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            List<SourceFolder> sourceFolders2 = contentEntry.getSourceFolders(rootTypes);
            for (SourceFolder sourceFolder : sourceFolders2) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null) continue;
                result2.add(file2);
            }
        }
        SmartList<VirtualFile> smartList = result2;
        if (smartList == null) {
            RootModelBase.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    @Override
    public ContentEntry @NotNull [] getContentEntries() {
        Collection<ContentEntry> content2 = this.getContent();
        ContentEntry[] contentEntryArray = content2.toArray(new ContentEntry[0]);
        if (contentEntryArray == null) {
            RootModelBase.$$$reportNull$$$0(13);
        }
        return contentEntryArray;
    }

    protected abstract Collection<ContentEntry> getContent();

    @Override
    public Sdk getSdk() {
        for (OrderEntry orderEntry2 : this.getOrderEntries()) {
            if (!(orderEntry2 instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry2).getJdk();
        }
        return null;
    }

    @Override
    public boolean isSdkInherited() {
        for (OrderEntry orderEntry2 : this.getOrderEntries()) {
            if (!(orderEntry2 instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this, null);
    }

    @Override
    public <R> R processOrder(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            RootModelBase.$$$reportNull$$$0(14);
        }
        R result2 = initialValue;
        for (OrderEntry orderEntry2 : this.getOrderEntries()) {
            result2 = orderEntry2.accept(policy, result2);
        }
        return result2;
    }

    @Override
    public String @NotNull [] getDependencyModuleNames() {
        List result2 = this.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process(new CollectDependentModules(), new ArrayList());
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            RootModelBase.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    @Override
    public Module @NotNull [] getModuleDependencies() {
        Module[] moduleArray = this.getModuleDependencies(true);
        if (moduleArray == null) {
            RootModelBase.$$$reportNull$$$0(16);
        }
        return moduleArray;
    }

    @Override
    public Module @NotNull [] getModuleDependencies(boolean includeTests) {
        OrderEntry[] entries2 = this.getOrderEntries();
        SmartList<Module> result2 = null;
        for (OrderEntry entry : entries2) {
            Module module2;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            DependencyScope scope = ((ModuleOrderEntry)entry).getScope();
            if (!includeTests && !scope.isForProductionCompile() && !scope.isForProductionRuntime() || (module2 = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            if (result2 == null) {
                result2 = new SmartList<Module>();
            }
            result2.add(module2);
        }
        Module[] moduleArray = result2 == null ? Module.EMPTY_ARRAY : result2.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            RootModelBase.$$$reportNull$$$0(17);
        }
        return moduleArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 9, 11, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootModelBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootUrls";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootModelBase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentEntries";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyModuleNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processOrder";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 9, 11, 14 -> new IllegalArgumentException(string2);
        };
    }

    public static class CollectDependentModules
    extends RootPolicy<List<String>> {
        @Override
        @NotNull
        public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull List<String> arrayList) {
            if (moduleOrderEntry == null) {
                CollectDependentModules.$$$reportNull$$$0(0);
            }
            if (arrayList == null) {
                CollectDependentModules.$$$reportNull$$$0(1);
            }
            arrayList.add(moduleOrderEntry.getModuleName());
            List<String> list2 = arrayList;
            if (list2 == null) {
                CollectDependentModules.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleOrderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootModelBase$CollectDependentModules";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitModuleOrderEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitModuleOrderEntry";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

