/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryKindRegistry;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/roots/impl/libraries/LibraryKindRegistryImpl;", "Lcom/intellij/openapi/roots/libraries/LibraryKindRegistry;", "()V", "forgetKind", "", "kind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "processAllLibraries", "processor", "Lkotlin/Function1;", "rememberKind", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nLibraryKindRegistryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryKindRegistryImpl.kt\ncom/intellij/openapi/roots/impl/libraries/LibraryKindRegistryImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,64:1\n13579#2,2:65\n13579#2,2:67\n13579#2,2:69\n*S KotlinDebug\n*F\n+ 1 LibraryKindRegistryImpl.kt\ncom/intellij/openapi/roots/impl/libraries/LibraryKindRegistryImpl\n*L\n35#1:65,2\n37#1:67,2\n40#1:69,2\n*E\n"})
public final class LibraryKindRegistryImpl
extends LibraryKindRegistry {
    private LibraryKindRegistryImpl() {
        LibraryType.EP_NAME.getExtensionList();
        LibraryType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<LibraryType<?>>(){

            @Override
            public void extensionAdded(@NotNull LibraryType<?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                WriteAction.run(() -> 1.extensionAdded$lambda$0(extension2, this));
            }

            @Override
            public void extensionRemoved(@NotNull LibraryType<?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                LibraryKind.unregisterKind(extension2.getKind());
                this.processAllLibraries((Function1<? super Library, Unit>)((Function1)new Function1<Library, Unit>(this, extension2){
                    final /* synthetic */ LibraryKindRegistryImpl this$0;
                    final /* synthetic */ LibraryType<?> $extension;
                    {
                        this.this$0 = $receiver;
                        this.$extension = $extension;
                        super(1);
                    }

                    public final void invoke(@NotNull Library it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LibraryKind libraryKind = this.$extension.getKind();
                        Intrinsics.checkNotNullExpressionValue((Object)libraryKind, (String)"extension.kind");
                        LibraryKindRegistryImpl.access$forgetKind(this.this$0, (PersistentLibraryKind)libraryKind, it);
                    }
                }));
            }

            private static final void extensionAdded$lambda$0(LibraryType $extension, LibraryKindRegistryImpl this$0) {
                Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                LibraryKind.registerKind($extension.getKind());
                this$0.processAllLibraries((Function1<? super Library, Unit>)((Function1)new Function1<Library, Unit>(this$0, $extension){
                    final /* synthetic */ LibraryKindRegistryImpl this$0;
                    final /* synthetic */ LibraryType<?> $extension;
                    {
                        this.this$0 = $receiver;
                        this.$extension = $extension;
                        super(1);
                    }

                    public final void invoke(@NotNull Library it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LibraryKind libraryKind = this.$extension.getKind();
                        Intrinsics.checkNotNullExpressionValue((Object)libraryKind, (String)"extension.kind");
                        LibraryKindRegistryImpl.access$rememberKind(this.this$0, (PersistentLibraryKind)libraryKind, it);
                    }
                }));
            }
        }, null);
    }

    private final void processAllLibraries(Function1<? super Library, Unit> processor) {
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getInstance().libraryTable.libraries");
        Object[] $this$forEach$iv = libraryArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor.invoke(element$iv);
        }
        for (LibraryTable table : LibraryTablesRegistrar.getInstance().getCustomLibraryTables()) {
            Library[] libraryArray2 = table.getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray2, (String)"table.libraries");
            Object[] $this$forEach$iv2 = libraryArray2;
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int element$iv = 0; element$iv < n; ++element$iv) {
                Object element$iv2 = $this$forEach$iv2[element$iv];
                processor.invoke(element$iv2);
            }
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        for (Project project2 : projectArray) {
            Library[] libraryArray3 = LibraryTablesRegistrar.getInstance().getLibraryTable(project2).getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray3, (String)"getInstance().getLibraryTable(project).libraries");
            Object[] $this$forEach$iv3 = libraryArray3;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                processor.invoke(element$iv);
            }
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            for (Module module2 : ModuleManager.Companion.getInstance(project2).getModules()) {
                for (Library library : OrderEntryUtil.getModuleLibraries(ModuleRootManager.getInstance(module2))) {
                    Intrinsics.checkNotNullExpressionValue((Object)library, (String)"library");
                    processor.invoke((Object)library);
                }
            }
        }
    }

    private final void forgetKind(PersistentLibraryKind<?> kind, Library library) {
        Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        if (Intrinsics.areEqual(kind, ((LibraryEx)library).getKind())) {
            LibraryEx.ModifiableModelEx modifiableModelEx = ((LibraryEx)library).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"library.modifiableModel");
            LibraryEx.ModifiableModelEx model2 = modifiableModelEx;
            model2.forgetKind();
            model2.commit();
        }
    }

    private final void rememberKind(PersistentLibraryKind<?> kind, Library library) {
        Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        PersistentLibraryKind<?> persistentLibraryKind = ((LibraryEx)library).getKind();
        UnknownLibraryKind unknownLibraryKind = persistentLibraryKind instanceof UnknownLibraryKind ? (UnknownLibraryKind)persistentLibraryKind : null;
        if (Intrinsics.areEqual((Object)(unknownLibraryKind != null ? unknownLibraryKind.getKindId() : null), (Object)kind.getKindId())) {
            LibraryEx.ModifiableModelEx modifiableModelEx = ((LibraryEx)library).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"library.modifiableModel");
            LibraryEx.ModifiableModelEx model2 = modifiableModelEx;
            model2.restoreKind();
            model2.commit();
        }
    }

    public static final /* synthetic */ void access$forgetKind(LibraryKindRegistryImpl $this, PersistentLibraryKind kind, Library library) {
        $this.forgetKind(kind, library);
    }

    public static final /* synthetic */ void access$rememberKind(LibraryKindRegistryImpl $this, PersistentLibraryKind kind, Library library) {
        $this.rememberKind(kind, library);
    }
}

