/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public final class LibraryTableTracker {
    private Library[] stored;
    private Throwable trace;
    private boolean isTracking;
    private LibraryTable myLibraryTable;

    public LibraryTableTracker() {
        this.store();
    }

    private synchronized void store() {
        if (this.isTracking) {
            this.isTracking = false;
            if (this.trace != null) {
                this.trace.printStackTrace(System.err);
            }
            throw new IllegalStateException("Previous test did not call assertDisposed() - see 'Caused by:' for its stacktrace", this.trace);
        }
        this.trace = new Throwable();
        this.myLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        this.stored = this.dumpAll();
        this.isTracking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertDisposed() {
        if (!this.isTracking) {
            throw new IllegalStateException("Double call of assertDisposed() - see 'Caused by:' for the previous call", this.trace);
        }
        Library[] actual = this.dumpAll();
        try {
            Collection<Library> leaked = ContainerUtil.subtract(Arrays.asList(actual), Arrays.asList(this.stored));
            if (!leaked.isEmpty()) {
                for (Library library : leaked) {
                    System.err.println("Leaked library: " + library + " creation trace:\n" + ((TraceableDisposable)((Object)library)).getStackTrace());
                    ((TraceableDisposable)((Object)library)).throwDisposalError("Leaked library: " + library);
                }
            }
        }
        finally {
            this.stored = null;
            this.trace = new Throwable();
            this.isTracking = false;
            this.myLibraryTable = null;
        }
    }

    private Library @NotNull [] dumpAll() {
        Library[] libraryArray = this.myLibraryTable.getLibraries();
        if (libraryArray == null) {
            LibraryTableTracker.$$$reportNull$$$0(0);
        }
        return libraryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableTracker", "dumpAll"));
    }
}

