/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.CustomLibraryTableImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.CustomLibraryTableDescription;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import com.intellij.workspaceModel.ide.legacyBridge.GlobalLibraryTableBridge;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibraryTablesRegistrarImpl
extends LibraryTablesRegistrar
implements Disposable {
    private static final ExtensionPointName<CustomLibraryTableDescription> CUSTOM_TABLES_EP = new ExtensionPointName("com.intellij.customLibraryTable");
    private final Map<String, LibraryTableBase> myCustomLibraryTables = new ConcurrentHashMap<String, LibraryTableBase>();
    private volatile boolean myExtensionsLoaded = false;
    private final Object myExtensionsLoadingLock = new Object();

    LibraryTablesRegistrarImpl() {
        VirtualFilePointerManager.getInstance();
    }

    @Override
    @NotNull
    public LibraryTable getLibraryTable() {
        if (GlobalLibraryTableBridge.isEnabled()) {
            GlobalLibraryTableBridge globalLibraryTableBridge = GlobalLibraryTableBridge.getInstance();
            if (globalLibraryTableBridge == null) {
                LibraryTablesRegistrarImpl.$$$reportNull$$$0(0);
            }
            return globalLibraryTableBridge;
        }
        ApplicationLibraryTable applicationLibraryTable = ApplicationLibraryTable.getApplicationTable();
        if (applicationLibraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(1);
        }
        return applicationLibraryTable;
    }

    @Override
    @NotNull
    public LibraryTable getLibraryTable(@NotNull Project project2) {
        if (project2 == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(2);
        }
        LibraryTable libraryTable = project2.getService(ProjectLibraryTable.class);
        if (libraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(3);
        }
        return libraryTable;
    }

    @Override
    public LibraryTable getLibraryTableByLevel(String level, @NotNull Project project2) {
        if (project2 == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(4);
        }
        return switch (level) {
            case "project" -> this.getLibraryTable(project2);
            case "application" -> this.getLibraryTable();
            default -> this.getCustomLibraryTableByLevel(level);
        };
    }

    @Override
    @Nullable
    public LibraryTable getCustomLibraryTableByLevel(String level) {
        return this.getCustomLibrariesMap().get(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, LibraryTableBase> getCustomLibrariesMap() {
        if (this.myExtensionsLoaded) {
            Map<String, LibraryTableBase> map2 = this.myCustomLibraryTables;
            if (map2 == null) {
                LibraryTablesRegistrarImpl.$$$reportNull$$$0(5);
            }
            return map2;
        }
        Object object = this.myExtensionsLoadingLock;
        synchronized (object) {
            if (!this.myExtensionsLoaded) {
                CUSTOM_TABLES_EP.getPoint().addExtensionPointListener(new ExtensionPointListener<CustomLibraryTableDescription>(){

                    @Override
                    public void extensionAdded(@NotNull CustomLibraryTableDescription extension2, @NotNull PluginDescriptor pluginDescriptor) {
                        if (extension2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (pluginDescriptor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        CustomLibraryTableImpl table = new CustomLibraryTableImpl(extension2.getTableLevel(), extension2.getPresentation());
                        LibraryTablesRegistrarImpl.this.myCustomLibraryTables.put(extension2.getTableLevel(), table);
                    }

                    @Override
                    public void extensionRemoved(@NotNull CustomLibraryTableDescription extension2, @NotNull PluginDescriptor pluginDescriptor) {
                        LibraryTableBase table;
                        if (extension2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (pluginDescriptor == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if ((table = LibraryTablesRegistrarImpl.this.myCustomLibraryTables.remove(extension2.getTableLevel())) != null) {
                            Disposer.dispose(table);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "extension";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "pluginDescriptor";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "extensionAdded";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "extensionRemoved";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, true, null);
                this.myExtensionsLoaded = true;
            }
        }
        Map<String, LibraryTableBase> map3 = this.myCustomLibraryTables;
        if (map3 == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(6);
        }
        return map3;
    }

    @Override
    @NotNull
    public List<LibraryTable> getCustomLibraryTables() {
        return new SmartList<LibraryTable>(this.getCustomLibrariesMap().values());
    }

    @Override
    public void dispose() {
        for (LibraryTableBase value : this.myCustomLibraryTables.values()) {
            Disposer.dispose(value);
        }
        this.myCustomLibraryTables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryTable";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLibrariesMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTableByLevel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 4 -> new IllegalArgumentException(string2);
        };
    }
}

