/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTypeServiceImpl
extends LibraryTypeService {
    private static final String DEFAULT_LIBRARY_NAME = "Unnamed";

    @Override
    public NewLibraryConfiguration createLibraryFromFiles(@NotNull LibraryRootsComponentDescriptor descriptor2, @NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, LibraryType<?> type, Project project2) {
        if (descriptor2 == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(0);
        }
        if (parentComponent == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(1);
        }
        FileChooserDescriptor chooserDescriptor = descriptor2.createAttachFilesChooserDescriptor(null);
        chooserDescriptor.setTitle(ProjectBundle.message((String)"chooser.title.select.library.files", (Object[])new Object[0]));
        VirtualFile[] rootCandidates = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)parentComponent, (Project)project2, (VirtualFile)contextDirectory);
        if (rootCandidates.length == 0) {
            return null;
        }
        List<OrderRoot> roots2 = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), parentComponent, project2, descriptor2);
        if (roots2.isEmpty()) {
            return null;
        }
        String name = LibraryTypeServiceImpl.suggestLibraryName(roots2);
        return LibraryTypeServiceImpl.doCreate(type, name, roots2);
    }

    @NotNull
    private static <P extends LibraryProperties<?>> NewLibraryConfiguration doCreate(LibraryType<P> type, String name, final List<? extends OrderRoot> roots2) {
        return new NewLibraryConfiguration(name, type, type != null ? (LibraryProperties)((PersistentLibraryKind)type.getKind()).createDefaultProperties() : null){

            @Override
            public void addRoots(@NotNull LibraryEditor editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                editor2.addRoots(roots2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl$1", "addRoots"));
            }
        };
    }

    @NotNull
    public static String suggestLibraryName(VirtualFile @NotNull [] classesRoots) {
        if (classesRoots == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(2);
        }
        if (classesRoots.length >= 1) {
            String string2 = FileUtilRt.getNameWithoutExtension(PathUtil.getFileName(classesRoots[0].getPath()));
            if (string2 == null) {
                LibraryTypeServiceImpl.$$$reportNull$$$0(3);
            }
            return string2;
        }
        return DEFAULT_LIBRARY_NAME;
    }

    @NotNull
    public static String suggestLibraryName(@NotNull List<? extends OrderRoot> roots2) {
        if (roots2 == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(4);
        }
        if (roots2.size() >= 1) {
            String string2 = FileUtilRt.getNameWithoutExtension(PathUtil.getFileName(roots2.get(0).getFile().getPath()));
            if (string2 == null) {
                LibraryTypeServiceImpl.$$$reportNull$$$0(5);
            }
            return string2;
        }
        return DEFAULT_LIBRARY_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryFromFiles";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestLibraryName";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5 -> new IllegalStateException(string2);
        };
    }
}

