/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RenameLibraryHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameLibraryHandler.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext2) {
        Library library;
        if (dataContext2 == null) {
            RenameLibraryHandler.$$$reportNull$$$0(0);
        }
        return (library = (Library)LangDataKeys.LIBRARY.getData(dataContext2)) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext2) {
        if (project2 == null) {
            RenameLibraryHandler.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(false);
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, @NotNull DataContext dataContext2) {
        Library library;
        if (project2 == null) {
            RenameLibraryHandler.$$$reportNull$$$0(2);
        }
        if (dataContext2 == null) {
            RenameLibraryHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            RenameLibraryHandler.$$$reportNull$$$0(4);
        }
        LOG.assertTrue((library = (Library)LangDataKeys.LIBRARY.getData(dataContext2)) != null);
        Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.enter.new.library.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)library.getName(), (InputValidator)new MyInputValidator(project2, library));
    }

    @Override
    public String getActionTitle() {
        return IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInputValidator
    implements InputValidator {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Library myLibrary;

        MyInputValidator(@NotNull Project project2, @NotNull Library library) {
            if (project2 == null) {
                MyInputValidator.$$$reportNull$$$0(0);
            }
            if (library == null) {
                MyInputValidator.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myLibrary = library;
        }

        @Override
        public boolean checkInput(String inputString) {
            return inputString != null && !inputString.isEmpty() && this.myLibrary.getTable().getLibraryByName(inputString) == null;
        }

        @Override
        public boolean canClose(final String inputString) {
            final String oldName = this.myLibrary.getName();
            Library.ModifiableModel modifiableModel = this.renameLibrary(inputString);
            Ref<Boolean> success = Ref.create(Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                BasicUndoableAction action2 = new BasicUndoableAction(){

                    @Override
                    public void undo() {
                        Library.ModifiableModel modifiableModel1 = this.renameLibrary(oldName);
                        modifiableModel1.commit();
                    }

                    @Override
                    public void redo() {
                        Library.ModifiableModel modifiableModel1 = this.renameLibrary(inputString);
                        modifiableModel1.commit();
                    }
                };
                UndoManager.getInstance(this.myProject).undoableActionPerformed(action2);
                ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
            }, IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{oldName}), null);
            return success.get();
        }

        @NotNull
        private Library.ModifiableModel renameLibrary(String inputString) {
            Library.ModifiableModel modifiableModel = this.myLibrary.getModifiableModel();
            modifiableModel.setName(inputString);
            Library.ModifiableModel modifiableModel2 = modifiableModel;
            if (modifiableModel2 == null) {
                MyInputValidator.$$$reportNull$$$0(2);
            }
            return modifiableModel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler$MyInputValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler$MyInputValidator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renameLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

