/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathStorage {
    @Nullable
    public static ClasspathStorageProvider getProvider(@NotNull String type) {
        if (type == null) {
            ClasspathStorage.$$$reportNull$$$0(0);
        }
        if (type.equals("default")) {
            return null;
        }
        for (ClasspathStorageProvider provider2 : ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!type.equals(provider2.getID())) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    public static String getStorageRootFromOptions(@NotNull Module module2) {
        if (module2 == null) {
            ClasspathStorage.$$$reportNull$$$0(1);
        }
        String moduleRoot = ModuleUtilCore.getModuleDirPath(module2);
        String storageRef = module2.getOptionValue("classpath-dir");
        if (storageRef == null) {
            String string2 = moduleRoot;
            if (string2 == null) {
                ClasspathStorage.$$$reportNull$$$0(2);
            }
            return string2;
        }
        storageRef = FileUtil.toSystemIndependentName(storageRef);
        if (SystemInfo.isWindows ? FileUtil.isAbsolutePlatformIndependent(storageRef) : FileUtil.isUnixAbsolutePath(storageRef)) {
            String string3 = storageRef;
            if (string3 == null) {
                ClasspathStorage.$$$reportNull$$$0(3);
            }
            return string3;
        }
        String string4 = moduleRoot + "/" + storageRef;
        if (string4 == null) {
            ClasspathStorage.$$$reportNull$$$0(4);
        }
        return string4;
    }

    public static void setStorageType(@NotNull ModuleRootModel model2, @NotNull String storageId) {
        ClasspathStorageProvider newProvider;
        Module module2;
        String oldStorageType;
        if (model2 == null) {
            ClasspathStorage.$$$reportNull$$$0(5);
        }
        if (storageId == null) {
            ClasspathStorage.$$$reportNull$$$0(6);
        }
        if ((oldStorageType = ClassPathStorageUtil.getStorageType(module2 = model2.getModule())).equals(storageId)) {
            return;
        }
        ClasspathStorageProvider provider2 = ClasspathStorage.getProvider(oldStorageType);
        if (provider2 != null) {
            provider2.detach(module2);
        }
        module2.setOption("classpath", (newProvider = ClasspathStorage.getProvider(storageId)) == null ? null : storageId);
        module2.setOption("classpath-dir", newProvider == null ? null : newProvider.getContentRoot(model2));
        if (newProvider != null) {
            newProvider.attach(model2);
        }
    }

    public static void modulePathChanged(@NotNull Module module2) {
        ClasspathStorageProvider provider2;
        if (module2 == null) {
            ClasspathStorage.$$$reportNull$$$0(7);
        }
        if ((provider2 = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module2))) != null) {
            provider2.modulePathChanged(module2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/storage/ClasspathStorage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/storage/ClasspathStorage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageRootFromOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStorageRootFromOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setStorageType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modulePathChanged";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

