/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.UnknownLibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryType<P extends LibraryProperties>
extends LibraryPresentationProvider<P> {
    public static final ExtensionPointName<LibraryType<?>> EP_NAME = ExtensionPointName.create("com.intellij.library.type");
    public static final OrderRootType[] DEFAULT_EXTERNAL_ROOT_TYPES = new OrderRootType[]{OrderRootType.CLASSES};

    protected LibraryType(@NotNull PersistentLibraryKind<P> libraryKind) {
        if (libraryKind == null) {
            LibraryType.$$$reportNull$$$0(0);
        }
        super(libraryKind);
    }

    @Override
    @NotNull
    public PersistentLibraryKind<P> getKind() {
        PersistentLibraryKind persistentLibraryKind = (PersistentLibraryKind)super.getKind();
        if (persistentLibraryKind == null) {
            LibraryType.$$$reportNull$$$0(1);
        }
        return persistentLibraryKind;
    }

    @NlsContexts.Label
    @Nullable
    public abstract String getCreateActionName();

    @Nullable
    public abstract NewLibraryConfiguration createNewLibrary(@NotNull JComponent var1, @Nullable VirtualFile var2, @NotNull Project var3);

    public boolean isSuitableModule(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        if (module2 == null) {
            LibraryType.$$$reportNull$$$0(2);
        }
        if (facetsProvider == null) {
            LibraryType.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Nullable
    public LibraryRootsComponentDescriptor createLibraryRootsComponentDescriptor() {
        return null;
    }

    @Nullable
    public abstract LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<P> var1);

    @Override
    public P detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            LibraryType.$$$reportNull$$$0(4);
        }
        return null;
    }

    public OrderRootType @NotNull [] getExternalRootTypes() {
        if (DEFAULT_EXTERNAL_ROOT_TYPES == null) {
            LibraryType.$$$reportNull$$$0(5);
        }
        return DEFAULT_EXTERNAL_ROOT_TYPES;
    }

    @NotNull
    public static LibraryType findByKind(@NotNull LibraryKind kind) {
        if (kind == null) {
            LibraryType.$$$reportNull$$$0(6);
        }
        for (LibraryType<?> type : EP_NAME.getExtensions()) {
            if (type.getKind() != kind) continue;
            LibraryType<?> libraryType = type;
            if (libraryType == null) {
                LibraryType.$$$reportNull$$$0(7);
            }
            return libraryType;
        }
        if (kind instanceof UnknownLibraryKind) {
            return new UnknownLibraryType((UnknownLibraryKind)kind);
        }
        throw new IllegalArgumentException("Library with kind " + kind + " is not registered");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKind";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/LibraryType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/LibraryType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalRootTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findByKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findByKind";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 5, 7 -> new IllegalStateException(string2);
        };
    }
}

