/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.DetectedRootsChooserDialog;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RootDetectionUtil {
    private static final Logger LOG = Logger.getInstance(RootDetectionUtil.class);

    private RootDetectionUtil() {
    }

    @NotNull
    public static List<OrderRoot> detectRoots(@NotNull Collection<? extends VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project2, @NotNull LibraryRootsComponentDescriptor rootsComponentDescriptor) {
        if (rootCandidates == null) {
            RootDetectionUtil.$$$reportNull$$$0(0);
        }
        if (rootsComponentDescriptor == null) {
            RootDetectionUtil.$$$reportNull$$$0(1);
        }
        return RootDetectionUtil.detectRoots(rootCandidates, parentComponent, project2, rootsComponentDescriptor.getRootsDetector(), rootsComponentDescriptor.getRootTypes());
    }

    @NotNull
    public static List<OrderRoot> detectRoots(final @NotNull Collection<? extends VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project2, final @NotNull LibraryRootsDetector detector, OrderRootType @NotNull [] rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
        if (rootCandidates == null) {
            RootDetectionUtil.$$$reportNull$$$0(2);
        }
        if (detector == null) {
            RootDetectionUtil.$$$reportNull$$$0(3);
        }
        if (rootTypesAllowedToBeSelectedByUserIfNothingIsDetected == null) {
            RootDetectionUtil.$$$reportNull$$$0(4);
        }
        final ArrayList<OrderRoot> result2 = new ArrayList<OrderRoot>();
        final ArrayList<SuggestedChildRootInfo> suggestedRoots = new ArrayList<SuggestedChildRootInfo>();
        new Task.Modal(project2, ProjectBundle.message((String)"progress.title.scanning.for.roots", (Object[])new Object[0]), true){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    for (VirtualFile rootCandidate : rootCandidates) {
                        Collection<DetectedLibraryRoot> roots2 = detector.detectRoots(rootCandidate, indicator);
                        if (!roots2.isEmpty() && RootDetectionUtil.allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(roots2, rootCandidate)) {
                            for (DetectedLibraryRoot root : roots2) {
                                LibraryRootType libraryRootType = root.getTypes().get(0);
                                result2.add(new OrderRoot(root.getFile(), libraryRootType.getType(), libraryRootType.isJarDirectory()));
                            }
                            continue;
                        }
                        for (DetectedLibraryRoot root : roots2) {
                            HashMap<LibraryRootType, String> names = new HashMap<LibraryRootType, String>();
                            for (LibraryRootType type : root.getTypes()) {
                                String typeName = detector.getRootTypeName(type);
                                LOG.assertTrue(typeName != null, "Unexpected root type " + type.getType().name() + (type.isJarDirectory() ? " (JAR directory)" : "") + ", detectors: " + detector);
                                names.put(type, typeName);
                            }
                            suggestedRoots.add(new SuggestedChildRootInfo(rootCandidate, root, names));
                        }
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil$1", "run"));
            }
        }.queue();
        if (!suggestedRoots.isEmpty()) {
            DetectedRootsChooserDialog dialog;
            DetectedRootsChooserDialog detectedRootsChooserDialog = dialog = parentComponent != null ? new DetectedRootsChooserDialog(parentComponent, suggestedRoots) : new DetectedRootsChooserDialog(project2, suggestedRoots);
            if (!dialog.showAndGet()) {
                List<OrderRoot> list2 = Collections.emptyList();
                if (list2 == null) {
                    RootDetectionUtil.$$$reportNull$$$0(5);
                }
                return list2;
            }
            for (SuggestedChildRootInfo rootInfo : dialog.getChosenRoots()) {
                LibraryRootType selectedRootType = rootInfo.getSelectedRootType();
                result2.add(new OrderRoot(rootInfo.getDetectedRoot().getFile(), selectedRootType.getType(), selectedRootType.isJarDirectory()));
            }
        }
        if (result2.isEmpty() && rootTypesAllowedToBeSelectedByUserIfNothingIsDetected.length > 0) {
            HashMap<String, Pair<Object, Boolean>> types = new HashMap<String, Pair<Object, Boolean>>();
            for (OrderRootType type : rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
                for (Object object : (LibraryRootType)new boolean[]{false, true}) {
                    String string2 = detector.getRootTypeName(new LibraryRootType(type, (boolean)object));
                    if (string2 == null) continue;
                    types.put(StringUtil.capitalizeWords(string2, true), Pair.create(type, (boolean)object));
                }
            }
            LOG.assertTrue(!types.isEmpty(), "No allowed root types found for " + detector);
            ArrayList<String> names = new ArrayList<String>(types.keySet());
            if (names.size() == 1) {
                int answer;
                String title = LangBundle.message("dialog.title.attach.roots", new Object[0]);
                String typeName = (String)names.get(0);
                String message = LangBundle.message("dialog.message.cannot.determine", ApplicationNamesInfo.getInstance().getProductName(), typeName);
                int n = answer = parentComponent != null ? Messages.showYesNoDialog((Component)parentComponent, (String)message, (String)title, null) : Messages.showYesNoDialog((Project)project2, (String)message, (String)title, null);
                if (answer == 0) {
                    Pair pair = (Pair)types.get(typeName);
                    for (VirtualFile virtualFile2 : rootCandidates) {
                        result2.add(new OrderRoot(virtualFile2, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                    }
                }
            } else {
                String title = LangBundle.message("dialog.title.choose.categories.selected.files", new Object[0]);
                String description = XmlStringUtil.wrapInHtml(LangBundle.message("root.detector.cannot.determine.file.kind", ApplicationNamesInfo.getInstance().getProductName()));
                ChooseRootTypeElementsDialog dialog = parentComponent != null ? new ChooseRootTypeElementsDialog(parentComponent, names, title, description) : new ChooseRootTypeElementsDialog(project2, names, title, description);
                for (String rootType : dialog.showAndGetResult()) {
                    Pair pair = (Pair)types.get(rootType);
                    for (VirtualFile virtualFile3 : rootCandidates) {
                        result2.add(new OrderRoot(virtualFile3, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                    }
                }
            }
        }
        ArrayList<OrderRoot> arrayList = result2;
        if (arrayList == null) {
            RootDetectionUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(Collection<? extends DetectedLibraryRoot> roots2, VirtualFile candidate) {
        for (DetectedLibraryRoot detectedLibraryRoot : roots2) {
            if (detectedLibraryRoot.getTypes().size() <= 1 && (detectedLibraryRoot.getFile().equals(candidate) || detectedLibraryRoot.getFile().equals(candidate.getParent()))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCandidates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsComponentDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypesAllowedToBeSelectedByUserIfNothingIsDetected";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/ui/impl/RootDetectionUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }

    private static class ChooseRootTypeElementsDialog
    extends ChooseElementsDialog<String> {
        ChooseRootTypeElementsDialog(Project project2, List<String> names, @NlsContexts.DialogTitle String title, @NlsContexts.Label String description) {
            super(project2, names, title, description, true);
        }

        private ChooseRootTypeElementsDialog(Component parent2, List<String> names, @NlsContexts.DialogTitle String title, @NlsContexts.Label String description) {
            super(parent2, names, title, description, true);
        }

        protected String getItemText(@NlsSafe String item) {
            return item;
        }

        @Nullable
        protected Icon getItemIcon(String item) {
            return null;
        }
    }
}

