/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditorListenerAdapter;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.roots.ToolbarPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CommonContentEntriesEditor
extends ModuleElementsEditor {
    private static final Logger LOG = Logger.getInstance(CommonContentEntriesEditor.class);
    @Deprecated(forRemoval=true)
    public static final String NAME = "Sources";
    protected ContentEntryTreeEditor myRootTreeEditor;
    private MyContentEntryEditorListener myContentEntryEditorListener;
    protected JPanel myEditorsPanel;
    protected final Map<String, ContentEntryEditor> myEntryToEditorMap = new HashMap<String, ContentEntryEditor>();
    private String mySelectedEntryUrl;
    private VirtualFile myLastSelectedDir = null;
    private final String myModuleName;
    private final ModulesProvider myModulesProvider;
    private final boolean myWithBorders;
    private final ModuleConfigurationState myState;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers = new ArrayList();

    public CommonContentEntriesEditor(String moduleName, final ModuleConfigurationState state, boolean withBorders, JpsModuleSourceRootType<?> ... rootTypes) {
        super(state);
        this.myState = state;
        this.myModuleName = moduleName;
        this.myModulesProvider = state.getModulesProvider();
        this.myWithBorders = withBorders;
        for (JpsModuleSourceRootType<?> type : rootTypes) {
            ContainerUtil.addIfNotNull(this.myEditHandlers, ModuleSourceRootEditHandler.getEditHandler(type));
        }
        VirtualFileManagerListener fileManagerListener = new VirtualFileManagerListener(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                if (state.getProject().isDisposed()) {
                    return;
                }
                Module module2 = CommonContentEntriesEditor.this.getModule();
                if (module2 == null || module2.isDisposed()) {
                    return;
                }
                for (ContentEntryEditor editor2 : CommonContentEntriesEditor.this.myEntryToEditorMap.values()) {
                    editor2.update();
                }
            }
        };
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        Disposable disposable = Disposer.newDisposable();
        fileManager.addVirtualFileManagerListener(fileManagerListener, disposable);
        this.registerDisposable(disposable);
    }

    public CommonContentEntriesEditor(String moduleName, ModuleConfigurationState state, JpsModuleSourceRootType<?> ... rootTypes) {
        this(moduleName, state, false, rootTypes);
    }

    @Override
    protected ModifiableRootModel getModel() {
        return this.myState.getModifiableRootModel();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.sources";
    }

    public String getDisplayName() {
        return CommonContentEntriesEditor.getName();
    }

    protected final List<ModuleSourceRootEditHandler<?>> getEditHandlers() {
        return this.myEditHandlers;
    }

    @Override
    public void disposeUIResources() {
        if (this.myRootTreeEditor != null) {
            this.myRootTreeEditor.setContentEntryEditor(null);
        }
        this.myEntryToEditorMap.clear();
        super.disposeUIResources();
    }

    @Override
    public JPanel createComponentImpl() {
        ContentEntry[] contentEntries;
        ModifiableRootModel model2;
        Module module2 = this.getModule();
        Project project2 = module2.getProject();
        this.myContentEntryEditorListener = new MyContentEntryEditorListener();
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.addAdditionalSettingsToPanel(mainPanel);
        DefaultActionGroup group2 = new DefaultActionGroup();
        AddContentEntryAction action2 = new AddContentEntryAction();
        action2.registerCustomShortcutSet(67, 512, mainPanel);
        group2.add((AnAction)action2);
        this.myEditorsPanel = new ScrollablePanel(new VerticalStackLayout());
        this.myEditorsPanel.setBackground(UIUtil.getListBackground());
        JScrollPane myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myEditorsPanel, (boolean)true);
        ToolbarPanel toolbarPanel = new ToolbarPanel((JComponent)myScrollPane, (ActionGroup)group2, "ContentEntryEditorToolbar", (JComponent)this.myEditorsPanel);
        int border = this.myWithBorders ? 1 : 0;
        toolbarPanel.setBorder((Border)new CustomLineBorder(1, 0, border, border));
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setProportion(0.6f);
        splitter.setHonorComponentsMinimumSize(true);
        this.myRootTreeEditor = this.createContentEntryTreeEditor(project2);
        JComponent component2 = this.myRootTreeEditor.createComponent();
        component2.setBorder(new CustomLineBorder(1, border, border, 0));
        splitter.setFirstComponent(component2);
        splitter.setSecondComponent((JComponent)toolbarPanel);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ProjectStructureContentEntries", (ActionGroup)this.myRootTreeEditor.getEditingActionsGroup(), true);
        actionToolbar.setTargetComponent((JComponent)this.myRootTreeEditor.myTree);
        contentPanel.add((Component)new JLabel(ProjectBundle.message((String)"label.text.mark.as", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, JBInsets.create(0, 10), 0, 0));
        contentPanel.add((Component)actionToolbar.getComponent(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, JBInsets.emptyInsets(), 0, 0));
        contentPanel.add((Component)splitter, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 17, 1, JBInsets.emptyInsets(), 0, 0));
        mainPanel.add((Component)contentPanel, "Center");
        JPanel innerPanel = this.createBottomControl(module2);
        if (innerPanel != null) {
            mainPanel.add((Component)innerPanel, "South");
        }
        if ((model2 = this.getModel()) != null && (contentEntries = model2.getContentEntries()).length > 0) {
            ContentEntry[] sortedContentRoots = ArrayUtil.newArray(ContentEntry.class, contentEntries.length);
            System.arraycopy(contentEntries, 0, sortedContentRoots, 0, contentEntries.length);
            Arrays.sort(sortedContentRoots, Comparator.comparing(ContentEntry::getUrl));
            for (ContentEntry contentEntry : sortedContentRoots) {
                this.addContentEntryPanel(contentEntry.getUrl());
            }
            this.selectContentEntry(sortedContentRoots[0].getUrl(), false);
        }
        return mainPanel;
    }

    @Nullable
    protected JPanel createBottomControl(Module module2) {
        return null;
    }

    protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project2) {
        return new ContentEntryTreeEditor(project2, this.myEditHandlers);
    }

    protected void addAdditionalSettingsToPanel(JPanel mainPanel) {
    }

    protected Module getModule() {
        return this.myModulesProvider.getModule(this.myModuleName);
    }

    protected void addContentEntryPanel(String contentEntry) {
        final ContentEntryEditor contentEntryEditor = this.createContentEntryEditor(contentEntry);
        contentEntryEditor.initUI();
        contentEntryEditor.addContentEntryEditorListener(this.myContentEntryEditorListener);
        this.registerDisposable(new Disposable(){

            @Override
            public void dispose() {
                contentEntryEditor.removeContentEntryEditorListener(CommonContentEntriesEditor.this.myContentEntryEditorListener);
            }
        });
        this.myEntryToEditorMap.put(contentEntry, contentEntryEditor);
        Border border = BorderFactory.createEmptyBorder(2, 2, 0, 2);
        JComponent component2 = contentEntryEditor.getComponent();
        Border componentBorder = component2.getBorder();
        if (componentBorder != null) {
            border = BorderFactory.createCompoundBorder(border, componentBorder);
        }
        component2.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.myEditorsPanel.add(component2);
    }

    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        return new ContentEntryEditor(contentEntryUrl, this.myEditHandlers){

            @Override
            protected ModifiableRootModel getModel() {
                return CommonContentEntriesEditor.this.getModel();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectContentEntry(String contentEntryUrl, boolean requestFocus) {
        if (this.mySelectedEntryUrl != null && this.mySelectedEntryUrl.equals(contentEntryUrl)) {
            if (requestFocus) {
                this.myRootTreeEditor.requestFocus();
            }
            return;
        }
        try {
            ContentEntryEditor editor2;
            if (this.mySelectedEntryUrl != null && (editor2 = this.myEntryToEditorMap.get(this.mySelectedEntryUrl)) != null) {
                editor2.setSelected(false);
            }
            if (contentEntryUrl != null && (editor2 = this.myEntryToEditorMap.get(contentEntryUrl)) != null) {
                editor2.setSelected(true);
                JComponent component2 = editor2.getComponent();
                JComponent scroller = (JComponent)component2.getParent();
                SwingUtilities.invokeLater(() -> scroller.scrollRectToVisible(component2.getBounds()));
                this.myRootTreeEditor.setContentEntryEditor(editor2);
                if (requestFocus) {
                    this.myRootTreeEditor.requestFocus();
                }
            }
        }
        finally {
            this.mySelectedEntryUrl = contentEntryUrl;
        }
    }

    public void moduleStateChanged() {
        if (this.myRootTreeEditor != null) {
            this.myRootTreeEditor.update();
        }
    }

    @Nullable
    private String getNextContentEntry(String contentEntryUrl) {
        return this.getAdjacentContentEntry(contentEntryUrl, 1);
    }

    @Nullable
    private String getAdjacentContentEntry(String contentEntryUrl, int delta) {
        ContentEntry[] contentEntries = this.getModel().getContentEntries();
        for (int idx = 0; idx < contentEntries.length; ++idx) {
            ContentEntry entry = contentEntries[idx];
            if (!contentEntryUrl.equals(entry.getUrl())) continue;
            int nextEntryIndex = (idx + delta) % contentEntries.length;
            if (nextEntryIndex < 0) {
                nextEntryIndex += contentEntries.length;
            }
            return nextEntryIndex == idx ? null : contentEntries[nextEntryIndex].getUrl();
        }
        return null;
    }

    protected List<ContentEntry> addContentEntries(VirtualFile[] files2) {
        ArrayList<ContentEntry> contentEntries = new ArrayList<ContentEntry>();
        for (VirtualFile file2 : files2) {
            if (this.isAlreadyAdded(file2)) continue;
            ContentEntry contentEntry = this.getModel().addContentEntry(file2);
            contentEntries.add(contentEntry);
        }
        return contentEntries;
    }

    private boolean isAlreadyAdded(VirtualFile file2) {
        VirtualFile[] contentRoots = this.getModel().getContentRoots();
        return ArrayUtil.contains(file2, contentRoots);
    }

    protected void addContentEntryPanels(ContentEntry[] contentEntriesArray) {
        ContentEntry[] sortedContentRoots = ArrayUtil.newArray(ContentEntry.class, contentEntriesArray.length);
        System.arraycopy(contentEntriesArray, 0, sortedContentRoots, 0, contentEntriesArray.length);
        Arrays.sort(sortedContentRoots, Comparator.comparing(ContentEntry::getUrl));
        for (ContentEntry contentEntry : sortedContentRoots) {
            this.addContentEntryPanel(contentEntry.getUrl());
        }
        this.myEditorsPanel.revalidate();
        this.myEditorsPanel.repaint();
        this.selectContentEntry(sortedContentRoots[sortedContentRoots.length - 1].getUrl(), false);
    }

    @NlsContexts.ConfigurableName
    public static String getName() {
        return ProjectBundle.message((String)"module.paths.title", (Object[])new Object[0]);
    }

    private final class MyContentEntryEditorListener
    extends ContentEntryEditorListenerAdapter {
        private MyContentEntryEditorListener() {
        }

        @Override
        public void sourceFolderAdded(@NotNull ContentEntryEditor editor2, SourceFolder folder) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(0);
            }
            CommonContentEntriesEditor.this.fireConfigurationChanged();
        }

        @Override
        public void sourceFolderRemoved(@NotNull ContentEntryEditor editor2, VirtualFile file2) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(1);
            }
            CommonContentEntriesEditor.this.fireConfigurationChanged();
        }

        @Override
        public void folderExcluded(@NotNull ContentEntryEditor editor2, VirtualFile file2) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(2);
            }
            CommonContentEntriesEditor.this.fireConfigurationChanged();
        }

        @Override
        public void folderIncluded(@NotNull ContentEntryEditor editor2, String fileUrl) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(3);
            }
            CommonContentEntriesEditor.this.fireConfigurationChanged();
        }

        @Override
        public void sourceRootPropertiesChanged(@NotNull ContentEntryEditor editor2, @NotNull SourceFolder folder) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(4);
            }
            if (folder == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(5);
            }
            CommonContentEntriesEditor.this.fireConfigurationChanged();
        }

        @Override
        public void editingStarted(@NotNull ContentEntryEditor editor2) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(6);
            }
            CommonContentEntriesEditor.this.selectContentEntry(editor2.getContentEntryUrl(), true);
        }

        @Override
        public void beforeEntryDeleted(@NotNull ContentEntryEditor editor2) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(7);
            }
            String entryUrl = editor2.getContentEntryUrl();
            if (CommonContentEntriesEditor.this.mySelectedEntryUrl != null && CommonContentEntriesEditor.this.mySelectedEntryUrl.equals(entryUrl)) {
                CommonContentEntriesEditor.this.myRootTreeEditor.setContentEntryEditor(null);
            }
            String nextContentEntryUrl = CommonContentEntriesEditor.this.getNextContentEntry(entryUrl);
            this.removeContentEntryPanel(entryUrl);
            CommonContentEntriesEditor.this.selectContentEntry(nextContentEntryUrl, true);
            editor2.removeContentEntryEditorListener(this);
        }

        @Override
        public void navigationRequested(@NotNull ContentEntryEditor editor2, VirtualFile file2) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(8);
            }
            CommonContentEntriesEditor.this.selectContentEntry(editor2.getContentEntryUrl(), true);
            CommonContentEntriesEditor.this.myRootTreeEditor.select(file2);
        }

        private void removeContentEntryPanel(String contentEntryUrl) {
            ContentEntryEditor editor2 = CommonContentEntriesEditor.this.myEntryToEditorMap.get(contentEntryUrl);
            if (editor2 != null) {
                CommonContentEntriesEditor.this.myEditorsPanel.remove(editor2.getComponent());
                CommonContentEntriesEditor.this.myEntryToEditorMap.remove(contentEntryUrl);
                CommonContentEntriesEditor.this.myEditorsPanel.revalidate();
                CommonContentEntriesEditor.this.myEditorsPanel.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/CommonContentEntriesEditor$MyContentEntryEditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceFolderAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceFolderRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "folderExcluded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "folderIncluded";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceRootPropertiesChanged";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editingStarted";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEntryDeleted";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigationRequested";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddContentEntryAction
    extends IconWithTextAction
    implements DumbAware {
        private final FileChooserDescriptor myDescriptor;

        AddContentEntryAction() {
            super(ProjectBundle.message((String)"module.paths.add.content.action", (Object[])new Object[0]), ProjectBundle.message((String)"module.paths.add.content.action.description", (Object[])new Object[0]), AllIcons.General.Add);
            this.myDescriptor = new FileChooserDescriptor(false, true, true, false, true, true){

                public void validateSelectedFiles(VirtualFile @NotNull [] files2) throws Exception {
                    if (files2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AddContentEntryAction.this.validateContentEntriesCandidates(files2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/roots/ui/configuration/CommonContentEntriesEditor$AddContentEntryAction$1", "validateSelectedFiles"));
                }
            };
            this.myDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)CommonContentEntriesEditor.this.getModule());
            this.myDescriptor.setTitle(ProjectBundle.message((String)"module.paths.add.content.title", (Object[])new Object[0]));
            this.myDescriptor.setDescription(ProjectBundle.message((String)"module.paths.add.content.prompt", (Object[])new Object[0]));
            this.myDescriptor.putUserData(FileChooserKeys.DELETE_ACTION_AVAILABLE, (Object)false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddContentEntryAction.$$$reportNull$$$0(0);
            }
            FileChooser.chooseFiles((FileChooserDescriptor)this.myDescriptor, (Project)CommonContentEntriesEditor.this.myProject, (VirtualFile)CommonContentEntriesEditor.this.myLastSelectedDir, files2 -> {
                CommonContentEntriesEditor.this.myLastSelectedDir = (VirtualFile)files2.get(0);
                CommonContentEntriesEditor.this.addContentEntries(VfsUtilCore.toVirtualFileArray(files2));
            });
        }

        @Nullable
        private ContentEntry getContentEntry(String url) {
            ContentEntry[] entries2;
            for (ContentEntry entry : entries2 = CommonContentEntriesEditor.this.getModel().getContentEntries()) {
                if (!entry.getUrl().equals(url)) continue;
                return entry;
            }
            return null;
        }

        private void validateContentEntriesCandidates(VirtualFile[] files2) throws Exception {
            for (VirtualFile file2 : files2) {
                Module[] modules2;
                for (String contentEntryUrl : CommonContentEntriesEditor.this.myEntryToEditorMap.keySet()) {
                    VirtualFile contentEntryFile;
                    ContentEntry contentEntry = this.getContentEntry(contentEntryUrl);
                    if (contentEntry == null || (contentEntryFile = contentEntry.getFile()) == null) continue;
                    if (contentEntryFile.equals(file2)) {
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.already.exists.error", (Object[])new Object[]{file2.getPresentableUrl()}));
                    }
                    if (VfsUtilCore.isAncestor(contentEntryFile, file2, true) && !ContentEntryEditor.isExcludedOrUnderExcludedDirectory(CommonContentEntriesEditor.this.myProject, contentEntry, file2)) {
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.intersect.error", (Object[])new Object[]{file2.getPresentableUrl(), contentEntryFile.getPresentableUrl()}));
                    }
                    if (!VfsUtilCore.isAncestor(file2, contentEntryFile, true)) continue;
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.dominate.error", (Object[])new Object[]{file2.getPresentableUrl(), contentEntryFile.getPresentableUrl()}));
                }
                for (Module module2 : modules2 = CommonContentEntriesEditor.this.myModulesProvider.getModules()) {
                    VirtualFile[] moduleContentRoots;
                    if (CommonContentEntriesEditor.this.myModuleName.equals(module2.getName())) continue;
                    ModuleRootModel rootModel = CommonContentEntriesEditor.this.myModulesProvider.getRootModel(module2);
                    LOG.assertTrue(rootModel != null);
                    for (VirtualFile moduleContentRoot : moduleContentRoots = rootModel.getContentRoots()) {
                        if (!file2.equals(moduleContentRoot)) continue;
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.duplicate.error", (Object[])new Object[]{file2.getPresentableUrl(), module2.getName()}));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/CommonContentEntriesEditor$AddContentEntryAction", "actionPerformed"));
        }
    }
}

