/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.ui.configuration.ContentFolderRef;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ContentEntryEditor
implements ContentRootPanel.ActionCallback {
    private boolean myIsSelected;
    private ContentRootPanel myContentRootPanel;
    private JPanel myMainPanel;
    protected EventDispatcher<ContentEntryEditorListener> myEventDispatcher;
    private final String myContentEntryUrl;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers;

    public ContentEntryEditor(String url, List<ModuleSourceRootEditHandler<?>> editHandlers) {
        this.myContentEntryUrl = url;
        this.myEditHandlers = editHandlers;
    }

    protected final List<ModuleSourceRootEditHandler<?>> getEditHandlers() {
        return this.myEditHandlers;
    }

    public String getContentEntryUrl() {
        return this.myContentEntryUrl;
    }

    public void initUI() {
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.setOpaque(false);
        this.myMainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ContentEntryEditor.this.myEventDispatcher.getMulticaster().editingStarted(ContentEntryEditor.this);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!ContentEntryEditor.this.myIsSelected) {
                    ContentEntryEditor.this.highlight(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!ContentEntryEditor.this.myIsSelected) {
                    ContentEntryEditor.this.highlight(false);
                }
            }
        });
        this.myEventDispatcher = EventDispatcher.create(ContentEntryEditorListener.class);
        this.setSelected(false);
        this.update();
    }

    @Nullable
    protected ContentEntry getContentEntry() {
        ModifiableRootModel model2 = this.getModel();
        if (model2 != null) {
            ContentEntry[] entries2;
            for (ContentEntry entry : entries2 = model2.getContentEntries()) {
                if (!entry.getUrl().equals(this.myContentEntryUrl)) continue;
                return entry;
            }
        }
        return null;
    }

    protected abstract ModifiableRootModel getModel();

    @Override
    public void deleteContentEntry() {
        String path2 = FileUtil.toSystemDependentName(VfsUtilCore.urlToPath(this.myContentEntryUrl));
        if (!MessageDialogBuilder.yesNo((String)ProjectBundle.message((String)"module.paths.remove.content.title", (Object[])new Object[0]), (String)ProjectBundle.message((String)"module.paths.remove.content.prompt", (Object[])new Object[]{path2})).ask(this.getModel().getProject())) {
            return;
        }
        this.myEventDispatcher.getMulticaster().beforeEntryDeleted(this);
        ContentEntry entry = this.getContentEntry();
        if (entry != null) {
            this.getModel().removeContentEntry(entry);
        }
    }

    @Override
    public void deleteContentFolder(ContentEntry contentEntry, ContentFolderRef folderRef) {
        ContentFolder folder = folderRef.getContentFolder();
        if (folder instanceof SourceFolder) {
            this.removeSourceFolder((SourceFolder)folder);
            this.update();
        } else if (folder instanceof ExcludeFolder) {
            this.removeExcludeFolder(folder.getUrl());
            this.update();
        }
    }

    @Override
    public void navigateFolder(ContentEntry contentEntry, ContentFolderRef contentFolderRef) {
        VirtualFile file2 = contentFolderRef.getFile();
        if (file2 != null) {
            this.myEventDispatcher.getMulticaster().navigationRequested(this, file2);
        }
    }

    @Override
    public void onSourceRootPropertiesChanged(@NotNull SourceFolder folder) {
        if (folder == null) {
            ContentEntryEditor.$$$reportNull$$$0(0);
        }
        this.update();
        this.myEventDispatcher.getMulticaster().sourceRootPropertiesChanged(this, folder);
    }

    public void addContentEntryEditorListener(ContentEntryEditorListener listener2) {
        this.myEventDispatcher.addListener(listener2);
    }

    public void removeContentEntryEditorListener(ContentEntryEditorListener listener2) {
        this.myEventDispatcher.removeListener(listener2);
    }

    public void setSelected(boolean isSelected) {
        if (this.myIsSelected != isSelected) {
            this.highlight(isSelected);
            this.myIsSelected = isSelected;
        }
    }

    private void highlight(boolean selected) {
        if (this.myContentRootPanel != null) {
            this.myContentRootPanel.setSelected(selected);
        }
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void update() {
        if (this.myContentRootPanel != null) {
            this.myMainPanel.remove(this.myContentRootPanel);
        }
        this.myContentRootPanel = this.createContentRootPane();
        this.myContentRootPanel.initUI();
        this.myContentRootPanel.setSelected(this.myIsSelected);
        this.myMainPanel.add((Component)this.myContentRootPanel, "Center");
        this.myMainPanel.revalidate();
    }

    protected ContentRootPanel createContentRootPane() {
        return new ContentRootPanel(this, this.myEditHandlers){

            @Override
            protected ContentEntry getContentEntry() {
                return ContentEntryEditor.this.getContentEntry();
            }
        };
    }

    @Nullable
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource, String packagePrefix) {
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(1);
        }
        return this.addSourceFolder(file2, (JpsModuleSourceRootType)(isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE), (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties(packagePrefix));
    }

    @Nullable
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, JpsModuleSourceRootType<P> rootType, P properties) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(2);
        }
        if ((contentEntry = this.getContentEntry()) != null) {
            SourceFolder sourceFolder = contentEntry.addSourceFolder(file2, rootType, properties);
            this.myEventDispatcher.getMulticaster().sourceFolderAdded(this, sourceFolder);
            this.update();
            return sourceFolder;
        }
        return null;
    }

    @Nullable
    protected SourceFolder doAddSourceFolder(@NotNull VirtualFile file2, boolean isTestSource) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(3);
        }
        return (contentEntry = this.getContentEntry()) != null ? contentEntry.addSourceFolder(file2, isTestSource) : null;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            ContentEntryEditor.$$$reportNull$$$0(4);
        }
        try {
            this.doRemoveSourceFolder(sourceFolder);
        }
        finally {
            this.myEventDispatcher.getMulticaster().sourceFolderRemoved(this, sourceFolder.getFile());
            this.update();
        }
    }

    protected void doRemoveSourceFolder(@NotNull SourceFolder sourceFolder) {
        ContentEntry contentEntry;
        if (sourceFolder == null) {
            ContentEntryEditor.$$$reportNull$$$0(5);
        }
        if ((contentEntry = this.getContentEntry()) != null) {
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    @Nullable
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(6);
        }
        try {
            ExcludeFolder excludeFolder = this.doAddExcludeFolder(file2);
            return excludeFolder;
        }
        finally {
            this.myEventDispatcher.getMulticaster().folderExcluded(this, file2);
            this.update();
        }
    }

    @Nullable
    protected ExcludeFolder doAddExcludeFolder(@NotNull VirtualFile file2) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(7);
        }
        return (contentEntry = this.getContentEntry()) != null ? contentEntry.addExcludeFolder(file2) : null;
    }

    public void removeExcludeFolder(@NotNull String excludeRootUrl) {
        if (excludeRootUrl == null) {
            ContentEntryEditor.$$$reportNull$$$0(8);
        }
        try {
            this.doRemoveExcludeFolder(excludeRootUrl);
        }
        finally {
            this.myEventDispatcher.getMulticaster().folderIncluded(this, excludeRootUrl);
            this.update();
        }
    }

    protected void doRemoveExcludeFolder(@NotNull String excludeRootUrl) {
        ContentEntry contentEntry;
        if (excludeRootUrl == null) {
            ContentEntryEditor.$$$reportNull$$$0(9);
        }
        if ((contentEntry = this.getContentEntry()) != null) {
            contentEntry.removeExcludeFolder(excludeRootUrl);
        }
    }

    @Nullable
    public JpsModuleSourceRootType<?> getRootType(@NotNull VirtualFile file2) {
        SourceFolder folder;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(10);
        }
        return (folder = this.getSourceFolder(file2)) != null ? folder.getRootType() : null;
    }

    public boolean isExcludedOrUnderExcludedDirectory(@NotNull VirtualFile file2) {
        ModifiableRootModel model2;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(11);
        }
        if ((model2 = this.getModel()) == null) {
            throw new AssertionError((Object)(this.getClass() + ".getModel() returned null unexpectedly"));
        }
        Project project2 = model2.getProject();
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return false;
        }
        return ContentEntryEditor.isExcludedOrUnderExcludedDirectory(project2, contentEntry, file2);
    }

    public static boolean isExcludedOrUnderExcludedDirectory(@Nullable Project project2, @NotNull ContentEntry entry, @NotNull VirtualFile file2) {
        if (entry == null) {
            ContentEntryEditor.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(13);
        }
        return ContentEntryEditor.isExcludedOrUnderExcludedDirectory(entry, ContentEntryEditor.getEntryExcludedUrls(project2, entry), file2);
    }

    public static boolean isExcludedOrUnderExcludedDirectory(@NotNull ContentEntry entry, @NotNull Set<String> excludedUrls, @NotNull VirtualFile file2) {
        if (entry == null) {
            ContentEntryEditor.$$$reportNull$$$0(14);
        }
        if (excludedUrls == null) {
            ContentEntryEditor.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(16);
        }
        Set<VirtualFile> sourceRoots = ContainerUtil.set(entry.getSourceFolderFiles());
        for (VirtualFile parent2 = file2; parent2 != null; parent2 = parent2.getParent()) {
            if (excludedUrls.contains(parent2.getUrl())) {
                return true;
            }
            if (!sourceRoots.contains(parent2)) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public static Set<String> getEntryExcludedUrls(@Nullable Project project2, @NotNull ContentEntry entry) {
        if (entry == null) {
            ContentEntryEditor.$$$reportNull$$$0(17);
        }
        HashSet<String> excludedUrls = new HashSet<String>(entry.getExcludeFolderUrls());
        if (project2 != null) {
            for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.getExtensions(project2)) {
                ContainerUtil.addAll(excludedUrls, policy.getExcludeUrlsForProject());
            }
        }
        HashSet<String> hashSet = excludedUrls;
        if (hashSet == null) {
            ContentEntryEditor.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @Nullable
    public SourceFolder getSourceFolder(@NotNull VirtualFile file2) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(19);
        }
        if ((contentEntry = this.getContentEntry()) == null) {
            return null;
        }
        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
            VirtualFile f = sourceFolder.getFile();
            if (f == null || !f.equals(file2)) continue;
            return sourceFolder;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeRootUrl";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedUrls";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ContentEntryEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryExcludedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onSourceRootPropertiesChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddSourceFolder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFolder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveSourceFolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeFolder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doAddExcludeFolder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludeFolder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveExcludeFolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRootType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedOrUnderExcludedDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEntryExcludedUrls";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolder";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 18 -> new IllegalStateException(string2);
        };
    }

    public static interface ContentEntryEditorListener
    extends EventListener {
        public void editingStarted(@NotNull ContentEntryEditor var1);

        public void beforeEntryDeleted(@NotNull ContentEntryEditor var1);

        public void sourceFolderAdded(@NotNull ContentEntryEditor var1, SourceFolder var2);

        public void sourceFolderRemoved(@NotNull ContentEntryEditor var1, VirtualFile var2);

        public void folderExcluded(@NotNull ContentEntryEditor var1, VirtualFile var2);

        public void folderIncluded(@NotNull ContentEntryEditor var1, String var2);

        public void navigationRequested(@NotNull ContentEntryEditor var1, VirtualFile var2);

        public void sourceRootPropertiesChanged(@NotNull ContentEntryEditor var1, @NotNull SourceFolder var2);
    }
}

