/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.NewFolderAction;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditorListenerAdapter;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.roots.ui.configuration.actions.ToggleExcludedStateAction;
import com.intellij.openapi.roots.ui.configuration.actions.ToggleSourcesStateAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentEntryTreeEditor {
    private final Project myProject;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers;
    protected final Tree myTree;
    private FileSystemTreeImpl myFileSystemTree;
    private final JPanel myTreePanel;
    protected final DefaultActionGroup myEditingActionsGroup;
    private ContentEntryEditor myContentEntryEditor;
    private final MyContentEntryEditorListener myContentEntryEditorListener = new MyContentEntryEditorListener();
    private final FileChooserDescriptor myDescriptor;
    private final JTextField myExcludePatternsField;

    public ContentEntryTreeEditor(Project project2, List<ModuleSourceRootEditHandler<?>> editHandlers) {
        this.myProject = project2;
        this.myEditHandlers = editHandlers;
        this.myTree = new Tree();
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        this.myEditingActionsGroup = new DefaultActionGroup();
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        JPanel excludePatternsPanel = new JPanel(new GridBagLayout());
        excludePatternsPanel.setBorder(JBUI.Borders.empty(5));
        GridBag gridBag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultPaddingX(JBUIScale.scale(5));
        JLabel myExcludePatternsLabel = new JLabel(ProjectBundle.message((String)"module.paths.exclude.patterns", (Object[])new Object[0]));
        excludePatternsPanel.add((Component)myExcludePatternsLabel, gridBag.nextLine().next());
        this.myExcludePatternsField = new JTextField();
        myExcludePatternsLabel.setLabelFor(this.myExcludePatternsField);
        this.myExcludePatternsField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                List<String> patterns;
                ContentEntry entry;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ContentEntryTreeEditor.this.myContentEntryEditor != null && (entry = ContentEntryTreeEditor.this.myContentEntryEditor.getContentEntry()) != null && !(patterns = StringUtil.split(ContentEntryTreeEditor.this.myExcludePatternsField.getText().trim(), ";")).equals(entry.getExcludePatterns())) {
                    entry.setExcludePatterns(patterns);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$1", "textChanged"));
            }
        });
        excludePatternsPanel.add((Component)this.myExcludePatternsField, gridBag.next().fillCellHorizontally());
        JBLabel excludePatternsLegendLabel = new JBLabel(XmlStringUtil.wrapInHtml(ProjectBundle.message((String)"label.content.entry.separate.name.patterns", (Object[])new Object[0])));
        excludePatternsLegendLabel.setForeground((Color)JBColor.GRAY);
        excludePatternsPanel.add((Component)excludePatternsLegendLabel, gridBag.nextLine().next().next().fillCellHorizontally());
        this.myTreePanel = new MyPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true);
        this.myTreePanel.add((Component)scrollPane, "Center");
        this.myTreePanel.add((Component)excludePatternsPanel, "South");
        this.myTreePanel.setVisible(false);
        this.myDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        this.myDescriptor.setShowFileSystemRoots(false);
    }

    protected void createEditingActions() {
        for (ModuleSourceRootEditHandler<?> editor2 : this.myEditHandlers) {
            ToggleSourcesStateAction action2 = new ToggleSourcesStateAction((JTree)this.myTree, this, editor2);
            CustomShortcutSet shortcutSet = editor2.getMarkRootShortcutSet();
            if (shortcutSet != null) {
                action2.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)this.myTree);
            }
            this.myEditingActionsGroup.add(action2);
        }
        this.setupExcludedAction();
    }

    protected List<ModuleSourceRootEditHandler<?>> getEditHandlers() {
        return this.myEditHandlers;
    }

    protected TreeCellRenderer getContentEntryCellRenderer(@NotNull ContentEntry contentEntry) {
        if (contentEntry == null) {
            ContentEntryTreeEditor.$$$reportNull$$$0(0);
        }
        return new ContentEntryTreeCellRenderer(this, contentEntry, this.myEditHandlers);
    }

    public void setContentEntryEditor(ContentEntryEditor contentEntryEditor) {
        if (this.myContentEntryEditor != null && this.myContentEntryEditor.equals(contentEntryEditor)) {
            return;
        }
        if (this.myFileSystemTree != null) {
            Disposer.dispose((Disposable)this.myFileSystemTree);
            this.myFileSystemTree = null;
        }
        if (this.myContentEntryEditor != null) {
            this.myContentEntryEditor.removeContentEntryEditorListener(this.myContentEntryEditorListener);
            this.myContentEntryEditor = null;
        }
        if (contentEntryEditor == null) {
            this.myTreePanel.setVisible(false);
            if (this.myFileSystemTree != null) {
                Disposer.dispose((Disposable)this.myFileSystemTree);
            }
            return;
        }
        this.myTreePanel.setVisible(true);
        this.myContentEntryEditor = contentEntryEditor;
        this.myContentEntryEditor.addContentEntryEditorListener(this.myContentEntryEditorListener);
        ContentEntry entry = contentEntryEditor.getContentEntry();
        assert (entry != null) : contentEntryEditor;
        VirtualFile file2 = entry.getFile();
        if (file2 != null) {
            this.myDescriptor.setRoots(new VirtualFile[]{file2});
        } else {
            String path2 = VfsUtilCore.urlToPath(entry.getUrl());
            this.myDescriptor.setTitle(FileUtil.toSystemDependentName(path2));
        }
        this.myExcludePatternsField.setText(StringUtil.join(entry.getExcludePatterns(), ";"));
        Runnable init = () -> {
            this.myFileSystemTree.updateTree();
            this.myFileSystemTree.select(file2, null);
        };
        this.myFileSystemTree = new FileSystemTreeImpl(this.myProject, this.myDescriptor, this.myTree, this.getContentEntryCellRenderer(entry), init, null);
        this.myFileSystemTree.showHiddens(true);
        Disposer.register(this.myProject, (Disposable)this.myFileSystemTree);
        MyNewFolderAction newFolderAction = new MyNewFolderAction();
        DefaultActionGroup mousePopupGroup = new DefaultActionGroup();
        mousePopupGroup.add((AnAction)this.myEditingActionsGroup);
        mousePopupGroup.addSeparator();
        mousePopupGroup.add((AnAction)newFolderAction);
        this.myFileSystemTree.registerMouseListener((ActionGroup)mousePopupGroup);
    }

    public ContentEntryEditor getContentEntryEditor() {
        return this.myContentEntryEditor;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ContentEntryTreeEditor.$$$reportNull$$$0(1);
        }
        return project2;
    }

    public JComponent createComponent() {
        this.createEditingActions();
        return this.myTreePanel;
    }

    public void select(VirtualFile file2) {
        if (this.myFileSystemTree != null) {
            this.myFileSystemTree.select(file2, null);
        }
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
    }

    public void update() {
        if (this.myFileSystemTree != null) {
            ContentEntry entry;
            ContentEntry contentEntry = entry = this.myContentEntryEditor == null ? null : this.myContentEntryEditor.getContentEntry();
            if (entry != null) {
                this.myFileSystemTree.getTree().setCellRenderer(this.getContentEntryCellRenderer(entry));
            }
            this.myFileSystemTree.updateTree();
        }
    }

    public DefaultActionGroup getEditingActionsGroup() {
        return this.myEditingActionsGroup;
    }

    protected void setupExcludedAction() {
        ToggleExcludedStateAction toggleExcludedAction = new ToggleExcludedStateAction((JTree)this.myTree, this);
        this.myEditingActionsGroup.add((AnAction)toggleExcludedAction);
        toggleExcludedAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(69, 8)), (JComponent)this.myTree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContentEntryCellRenderer";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private class MyContentEntryEditorListener
    extends ContentEntryEditorListenerAdapter {
        private MyContentEntryEditorListener() {
        }

        @Override
        public void sourceFolderAdded(@NotNull ContentEntryEditor editor2, SourceFolder folder) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(0);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void sourceFolderRemoved(@NotNull ContentEntryEditor editor2, VirtualFile file2) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(1);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void folderExcluded(@NotNull ContentEntryEditor editor2, VirtualFile file2) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(2);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void folderIncluded(@NotNull ContentEntryEditor editor2, String fileUrl) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(3);
            }
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void sourceRootPropertiesChanged(@NotNull ContentEntryEditor editor2, @NotNull SourceFolder folder) {
            if (editor2 == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(4);
            }
            if (folder == null) {
                MyContentEntryEditorListener.$$$reportNull$$$0(5);
            }
            ContentEntryTreeEditor.this.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyContentEntryEditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceFolderAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceFolderRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "folderExcluded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "folderIncluded";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceRootPropertiesChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        private MyPanel(LayoutManager layout) {
            super(layout);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if (FileSystemTree.DATA_KEY.is(dataId)) {
                return ContentEntryTreeEditor.this.myFileSystemTree;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return ContentEntryTreeEditor.this.myFileSystemTree == null ? null : ContentEntryTreeEditor.this.myFileSystemTree.getSelectedFiles();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyPanel", "getData"));
        }
    }

    private static final class MyNewFolderAction
    extends NewFolderAction
    implements CustomComponentAction {
        private MyNewFolderAction() {
            super(ActionsBundle.message((String)"action.FileChooser.NewFolder.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.FileChooser.NewFolder.description", (Object[])new Object[0]), AllIcons.Actions.NewFolder);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                MyNewFolderAction.$$$reportNull$$$0(0);
            }
            if (place == null) {
                MyNewFolderAction.$$$reportNull$$$0(1);
            }
            JComponent jComponent = IconWithTextAction.createCustomComponentImpl((AnAction)this, (Presentation)presentation2, (String)place);
            if (jComponent == null) {
                MyNewFolderAction.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyNewFolderAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeEditor$MyNewFolderAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

