/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class JavaSourceRootEditHandlerBase
extends ModuleSourceRootEditHandler<JavaSourceRootProperties> {
    public JavaSourceRootEditHandlerBase(JpsModuleSourceRootType<JavaSourceRootProperties> rootType) {
        super(rootType);
    }

    @Override
    @NotNull
    public Icon getRootIcon(@NotNull JavaSourceRootProperties properties) {
        if (properties == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(0);
        }
        Icon icon2 = properties.isForGeneratedSources() ? this.getGeneratedRootIcon() : this.getRootIcon();
        if (icon2 == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @Override
    @Nullable
    public Icon getRootFileLayerIcon() {
        return AllIcons.Modules.SourceRootFileLayer;
    }

    @NotNull
    protected abstract Icon getGeneratedRootIcon();

    @Override
    @Nullable
    public String getPropertiesString(@NotNull JavaSourceRootProperties properties) {
        String packagePrefix;
        if (properties == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(2);
        }
        StringBuilder buffer = new StringBuilder();
        if (properties.isForGeneratedSources()) {
            buffer.append(" [generated]");
        }
        if (!(packagePrefix = properties.getPackagePrefix()).isEmpty()) {
            buffer.append(" (").append(packagePrefix).append(")");
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    @Override
    @Nullable
    public JComponent createPropertiesEditor(@NotNull SourceFolder folder, @NotNull JComponent parentComponent, @NotNull ContentRootPanel.ActionCallback callback) {
        if (folder == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(3);
        }
        if (parentComponent == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(5);
        }
        IconActionComponent iconComponent = new IconActionComponent(AllIcons.General.Inline_edit, AllIcons.General.Inline_edit_hovered, ProjectBundle.message((String)"module.paths.edit.properties.tooltip", (Object[])new Object[0]), () -> {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            assert (properties != null);
            SourceRootPropertiesDialog dialog = new SourceRootPropertiesDialog(parentComponent, properties);
            if (dialog.showAndGet()) {
                callback.onSourceRootPropertiesChanged(folder);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        panel2.add((Component)iconComponent, "Center");
        panel2.add(Box.createHorizontalStrut(3), "East");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootIcon";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesEditor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static final class SourceRootPropertiesDialog
    extends DialogWrapper {
        private final JTextField myPackagePrefixField;
        private final JCheckBox myIsGeneratedCheckBox;
        private final JPanel myMainPanel;
        @NotNull
        private final JavaSourceRootProperties myProperties;

        private SourceRootPropertiesDialog(@NotNull JComponent parentComponent, @NotNull JavaSourceRootProperties properties) {
            if (parentComponent == null) {
                SourceRootPropertiesDialog.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                SourceRootPropertiesDialog.$$$reportNull$$$0(1);
            }
            super((Component)parentComponent, true);
            this.myProperties = properties;
            this.setTitle(ProjectBundle.message((String)"module.paths.edit.properties.title", (Object[])new Object[0]));
            this.myPackagePrefixField = new JTextField();
            this.myIsGeneratedCheckBox = new JCheckBox(ProjectBundle.message((String)"checkbox.for.generated.sources", (Object[])new Object[0]));
            this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent(ProjectBundle.message((String)"label.package.prefix", (Object[])new Object[0]), (JComponent)this.myPackagePrefixField).addComponent((JComponent)this.myIsGeneratedCheckBox).getPanel();
            this.myPackagePrefixField.setText(this.myProperties.getPackagePrefix());
            this.myPackagePrefixField.setColumns(25);
            this.myIsGeneratedCheckBox.setSelected(this.myProperties.isForGeneratedSources());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPackagePrefixField;
        }

        protected void doOKAction() {
            this.myProperties.setPackagePrefix(this.myPackagePrefixField.getText().trim());
            this.myProperties.setForGeneratedSources(this.myIsGeneratedCheckBox.isSelected());
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "properties";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase$SourceRootPropertiesDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

