/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleElementsEditor
implements ModuleConfigurationEditor {
    @NotNull
    protected final Project myProject;
    protected JComponent myComponent;
    private final CompositeDisposable myDisposables;
    private final EventDispatcher<ModuleElementsEditorListener> myDispatcher;
    private final ModuleConfigurationState myState;

    protected ModuleElementsEditor(@NotNull ModuleConfigurationState state) {
        if (state == null) {
            ModuleElementsEditor.$$$reportNull$$$0(0);
        }
        this.myDisposables = new CompositeDisposable();
        this.myDispatcher = EventDispatcher.create(ModuleElementsEditorListener.class);
        this.myProject = state.getProject();
        this.myState = state;
    }

    public void addListener(ModuleElementsEditorListener listener2) {
        this.myDispatcher.addListener(listener2);
    }

    protected void fireConfigurationChanged() {
        this.myDispatcher.getMulticaster().configurationChanged();
    }

    public boolean isModified() {
        return this.getModel() != null && this.getModel().isChanged();
    }

    protected ModifiableRootModel getModel() {
        return this.myState.getModifiableRootModel();
    }

    @NotNull
    protected ModuleConfigurationState getState() {
        ModuleConfigurationState moduleConfigurationState = this.myState;
        if (moduleConfigurationState == null) {
            ModuleElementsEditor.$$$reportNull$$$0(1);
        }
        return moduleConfigurationState;
    }

    public void canApply() throws ConfigurationException {
    }

    public void apply() throws ConfigurationException {
    }

    public void moduleCompileOutputChanged(String baseUrl, String moduleName) {
    }

    public void disposeUIResources() {
        Disposer.dispose(this.myDisposables);
    }

    public final JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.createComponentImpl();
        }
        return this.myComponent;
    }

    public JComponent getComponent() {
        return this.createComponent();
    }

    protected void registerDisposable(Disposable disposable) {
        this.myDisposables.add(disposable);
    }

    protected abstract JComponent createComponentImpl();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ModuleElementsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModuleElementsEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    public static interface ModuleElementsEditorListener
    extends EventListener {
        public void configurationChanged();
    }
}

