/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.LibrarySettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsService {
    public static ProjectSettingsService getInstance(Project project2) {
        return project2.getService(ProjectSettingsService.class);
    }

    public void openProjectSettings() {
    }

    public void openGlobalLibraries() {
    }

    public void openLibrary(@NotNull Library library) {
        if (library == null) {
            ProjectSettingsService.$$$reportNull$$$0(0);
        }
    }

    public void openModuleSettings(Module module2) {
    }

    public boolean canOpenModuleSettings() {
        return false;
    }

    public void openModuleLibrarySettings(Module module2) {
    }

    public boolean canOpenModuleLibrarySettings() {
        return false;
    }

    public void openContentEntriesSettings(Module module2) {
    }

    public boolean canOpenContentEntriesSettings() {
        return false;
    }

    public void openModuleDependenciesSettings(@NotNull Module module2, @Nullable OrderEntry orderEntry2) {
        if (module2 == null) {
            ProjectSettingsService.$$$reportNull$$$0(1);
        }
    }

    public boolean canOpenModuleDependenciesSettings() {
        return false;
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry2) {
        Configurable additionalSettingsConfigurable;
        if (orderEntry2 == null) {
            ProjectSettingsService.$$$reportNull$$$0(2);
        }
        if ((additionalSettingsConfigurable = ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry2)) != null) {
            ShowSettingsUtil.getInstance().showSettingsDialog(orderEntry2.getOwnerModule().getProject(), additionalSettingsConfigurable.getDisplayName());
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry2) {
        return ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry2) != null;
    }

    @Nullable
    private static Configurable getLibrarySettingsConfigurable(OrderEntry orderEntry2) {
        if (!(orderEntry2 instanceof LibraryOrderEntry)) {
            return null;
        }
        LibraryOrderEntry libOrderEntry = (LibraryOrderEntry)orderEntry2;
        Library lib = libOrderEntry.getLibrary();
        if (lib instanceof LibraryEx) {
            Project project2 = libOrderEntry.getOwnerModule().getProject();
            PersistentLibraryKind<?> libKind = ((LibraryEx)lib).getKind();
            if (libKind != null) {
                return LibrarySettingsProvider.getAdditionalSettingsConfigurable(project2, libKind);
            }
        }
        return null;
    }

    public boolean processModulesMoved(Module[] modules2, @Nullable ModuleGroup targetGroup) {
        return false;
    }

    public void showModuleConfigurationDialog(@Nullable String moduleToSelect, @Nullable String editorNameToSelect) {
    }

    @Deprecated
    @Nullable
    public Sdk chooseAndSetSdk() {
        Logger.getInstance(this.getClass()).warn("Call to the deprecated ProjectSettingsService#chooseAndSetSdk method. Please use new API instead");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ProjectSettingsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openModuleDependenciesSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibraryOrSdkSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

