/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxBase;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxModel;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupMenuListenerAdapter;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\r\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/SdkComboBox;", "Lcom/intellij/openapi/roots/ui/configuration/SdkComboBoxBase;", "Lcom/intellij/openapi/roots/ui/configuration/SdkListItem;", "model", "Lcom/intellij/openapi/roots/ui/configuration/SdkComboBoxModel;", "(Lcom/intellij/openapi/roots/ui/configuration/SdkComboBoxModel;)V", "getModel", "()Lcom/intellij/openapi/roots/ui/configuration/SdkComboBoxModel;", "findSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/annotations/Nullable;", "sdk", "getSelectedItem", "getSelectedSdk", "onModelUpdated", "", "listModel", "Lcom/intellij/openapi/roots/ui/configuration/SdkListModel;", "setSelectedItem", "anObject", "", "setSelectedSdk", "sdkName", "", "ModelReloadProvider", "intellij.platform.lang.impl"})
public final class SdkComboBox
extends SdkComboBoxBase<SdkListItem> {
    public SdkComboBox(@NotNull SdkComboBoxModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2.getModelBuilder());
        this.setModel(model2);
        this.setRenderer((ListCellRenderer)((Object)new SdkListPresenter(() -> SdkComboBox._init_$lambda$0(this))));
        this.addPopupMenuListener((PopupMenuListener)((Object)new ModelReloadProvider()));
        this.reloadModel();
    }

    @NotNull
    public final SdkComboBoxModel getModel() {
        ComboBoxModel comboBoxModel = this.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.ui.configuration.SdkComboBoxModel");
        return (SdkComboBoxModel)comboBoxModel;
    }

    @Override
    protected void onModelUpdated(@NotNull SdkListModel listModel) {
        Intrinsics.checkNotNullParameter((Object)listModel, (String)"listModel");
        this.setModel(this.getModel().copyAndSetListModel(listModel));
    }

    @Nullable
    public SdkListItem getSelectedItem() {
        return (SdkListItem)super.getSelectedItem();
    }

    public void setSelectedItem(@Nullable Object anObject) {
        if (anObject instanceof SdkListItem && this.myModel.executeAction((JComponent)((Object)this), (SdkListItem)anObject, this::setSelectedItem)) {
            return;
        }
        Object object = anObject;
        if (object instanceof SdkListItem.ProjectSdkItem) {
            this.showProjectSdkItem();
        } else if (object instanceof SdkListItem.InvalidSdkItem) {
            this.showInvalidSdkItem(((SdkListItem.InvalidSdkItem)anObject).sdkName);
        } else if (object instanceof SdkListItem.NoneSdkItem) {
            this.showNoneSdkItem();
        }
        this.reloadModel();
        super.setSelectedItem(anObject);
    }

    public final void setSelectedSdk(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        this.reloadModel();
        SdkListItem.SdkItem sdkItem = this.getModel().getListModel().findSdkItem(sdk2);
        this.setSelectedItem(sdkItem == null ? this.showInvalidSdkItem(sdk2.getName()) : (SdkListItem)sdkItem);
    }

    public final void setSelectedSdk(@NotNull String sdkName) {
        Intrinsics.checkNotNullParameter((Object)sdkName, (String)"sdkName");
        this.reloadModel();
        SdkListItem.SdkItem sdkItem = this.getModel().getListModel().findSdkItem(sdkName);
        this.setSelectedItem(sdkItem == null ? this.showInvalidSdkItem(sdkName) : (SdkListItem)sdkItem);
    }

    @Nullable
    public final Sdk getSelectedSdk() {
        SdkListItem it = this.getSelectedItem();
        return it instanceof SdkListItem.ProjectSdkItem ? this.findSdk(this.getModel().getSdksModel().getProjectSdk()) : (it instanceof SdkListItem.SdkItem ? this.findSdk(((SdkListItem.SdkItem)it).sdk) : null);
    }

    private final Sdk findSdk(Sdk sdk2) {
        return this.getModel().getSdksModel().findSdk(sdk2);
    }

    private static final SdkListModel _init_$lambda$0(SdkComboBox this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getModel().getListModel();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/SdkComboBox$ModelReloadProvider;", "Lcom/intellij/ui/PopupMenuListenerAdapter;", "(Lcom/intellij/openapi/roots/ui/configuration/SdkComboBox;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "popupMenuWillBecomeInvisible", "", "e", "Ljavax/swing/event/PopupMenuEvent;", "popupMenuWillBecomeVisible", "setReloadDisposable", "parentDisposable", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nSdkComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkComboBox.kt\ncom/intellij/openapi/roots/ui/configuration/SdkComboBox$ModelReloadProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
    private final class ModelReloadProvider
    extends PopupMenuListenerAdapter {
        @Nullable
        private Disposable disposable;

        public void popupMenuWillBecomeVisible(@NotNull PopupMenuEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
            Disposable disposable2 = disposable;
            this.setReloadDisposable(disposable2);
            SdkComboBox.this.myModel.reloadActions();
            SdkComboBox.this.myModel.detectItems((JComponent)((Object)SdkComboBox.this), disposable2);
        }

        public void popupMenuWillBecomeInvisible(@NotNull PopupMenuEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.setReloadDisposable(null);
        }

        private final void setReloadDisposable(Disposable parentDisposable) {
            Disposable it;
            ApplicationManager.getApplication().assertIsDispatchThread();
            Disposable disposable = parentDisposable;
            if (disposable != null) {
                Disposable disposable2 = disposable;
                SdkComboBox sdkComboBox = SdkComboBox.this;
                it = disposable2;
                boolean bl = false;
                Disposer.register(sdkComboBox.getModel().getProject(), it);
            }
            Disposable disposable3 = this.disposable;
            if (disposable3 != null) {
                it = disposable3;
                boolean bl = false;
                Disposer.dispose(it);
            }
            this.disposable = parentDisposable;
        }
    }
}

