/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkListModel
extends AbstractListModel<SdkListItem>
implements ComboBoxPopupState<SdkListItem> {
    private final boolean myIsSearching;
    private final List<SdkListItem> myItems;
    private final Producer<? extends Sdk> myGetProjectSdk;
    private final ImmutableMap<SdkListItem, @NlsContexts.Separator String> mySeparators;

    @NotNull
    public static SdkListModel emptyModel() {
        return new SdkListModel(false, (List<? extends SdkListItem>)ImmutableList.of(), () -> null);
    }

    SdkListModel(boolean isSearching, @NotNull List<? extends SdkListItem> items2, @NotNull Producer<? extends Sdk> getProjectSdk) {
        if (items2 == null) {
            SdkListModel.$$$reportNull$$$0(0);
        }
        if (getProjectSdk == null) {
            SdkListModel.$$$reportNull$$$0(1);
        }
        this.myIsSearching = isSearching;
        this.myItems = List.copyOf(items2);
        this.myGetProjectSdk = getProjectSdk;
        boolean myFirstSepSet = false;
        boolean mySuggestedSep = false;
        ImmutableMap.Builder sep = ImmutableMap.builder();
        int lastSepIndex = 0;
        for (int i2 = 0; i2 < this.myItems.size(); ++i2) {
            SdkListItem it = this.myItems.get(i2);
            if (!myFirstSepSet && (it instanceof SdkListItem.GroupItem || it instanceof SdkListItem.ActionItem)) {
                myFirstSepSet = true;
                if (lastSepIndex < i2) {
                    sep.put((Object)it, (Object)"");
                    lastSepIndex = i2;
                }
            }
            if (mySuggestedSep || !(it instanceof SdkListItem.SuggestedItem)) continue;
            mySuggestedSep = true;
            if (lastSepIndex >= i2) continue;
            sep.put((Object)it, (Object)ProjectBundle.message((String)"jdk.combo.box.autodetected", (Object[])new Object[0]));
            lastSepIndex = i2;
        }
        this.mySeparators = sep.build();
    }

    @Nullable
    public SdkListItem findProjectSdkItem() {
        return this.findFirstItemOfType(SdkListItem.ProjectSdkItem.class);
    }

    @Nullable
    public SdkListItem findNoneSdkItem() {
        return this.findFirstItemOfType(SdkListItem.NoneSdkItem.class);
    }

    @Nullable
    private SdkListItem findFirstItemOfType(Class<? extends SdkListItem> itemClass) {
        return (SdkListItem)((Object)ContainerUtil.find(this.getItems(), itemClass::isInstance));
    }

    @Nullable
    Sdk resolveProjectSdk() {
        return this.myGetProjectSdk.produce();
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    @NotNull
    public SdkListItem getElementAt(int index2) {
        SdkListItem sdkListItem = this.myItems.get(index2);
        if (sdkListItem == null) {
            SdkListModel.$$$reportNull$$$0(2);
        }
        return sdkListItem;
    }

    @Nullable
    public SdkListModel onChosen(SdkListItem selectedValue) {
        if (!(selectedValue instanceof SdkListItem.GroupItem)) {
            return null;
        }
        return new SdkListModel(this.myIsSearching, ((SdkListItem.GroupItem)selectedValue).subItems, this.myGetProjectSdk);
    }

    public boolean hasSubstep(SdkListItem selectedValue) {
        return selectedValue instanceof SdkListItem.GroupItem;
    }

    public boolean isSearching() {
        return this.myIsSearching;
    }

    @NotNull
    public List<SdkListItem> getItems() {
        List<SdkListItem> list2 = this.myItems;
        if (list2 == null) {
            SdkListModel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    @NlsContexts.Separator
    public String getSeparatorTextAbove(@NotNull SdkListItem value) {
        if (value == null) {
            SdkListModel.$$$reportNull$$$0(4);
        }
        return (String)this.mySeparators.get((Object)value);
    }

    @Nullable
    public SdkListItem.SdkItem findSdkItem(@Nullable Sdk value) {
        if (value == null) {
            return null;
        }
        for (SdkListItem item : this.myItems) {
            SdkListItem.SdkItem sdkItem;
            if (!(item instanceof SdkListItem.SdkItem) || !(sdkItem = (SdkListItem.SdkItem)item).hasSameSdk(value)) continue;
            return sdkItem;
        }
        return null;
    }

    @Nullable
    public SdkListItem.SdkItem findSdkItem(@Nullable String sdkName) {
        if (sdkName == null) {
            return null;
        }
        for (SdkListItem item : this.myItems) {
            if (!(item instanceof SdkListItem.SdkItem)) continue;
            SdkListItem.SdkItem sdkItem = (SdkListItem.SdkItem)item;
            Sdk sdk2 = sdkItem.sdk;
            if (!sdkName.equals(sdk2.getName())) continue;
            return sdkItem;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getProjectSdk";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSeparatorTextAbove";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

