/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.RelayUiToDelegateIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.roots.ui.configuration.SdkLookupContext;
import com.intellij.openapi.roots.ui.configuration.SdkLookupContextEx;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDownloadDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupImplKt;
import com.intellij.openapi.roots.ui.configuration.SdkLookupParameters;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0002\u001a\u00020\u0006J-\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\bH\u0002J-\u0010\u001a\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\b\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\bH\u0002J$\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020$0#2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002J\u001a\u0010(\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/SdkLookupContextEx;", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupContext;", "lookup", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupParameters;", "(Lcom/intellij/openapi/roots/ui/configuration/SdkLookupParameters;)V", "continueSdkLookupWithSuggestions", "", "rootProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doWaitSdkDownloadToComplete", "Lkotlin/Function0;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "executeFix", "indicator", "possibleFix", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkFixAction;", "resolveDownloadFix", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkDownloadableSdkFix;", "Lorg/jetbrains/annotations/Nullable;", "resolvers", "", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver$UnknownSdkLookup;", "unknownSdk", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdk;", "resolveLocalFix", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkLocalSdkFix;", "runSdkResolutionUnderProgress", "action", "Lkotlin/Function1;", "testExistingSdk", "testLoadSdkAndWaitIfNeeded", "testSdkAndWaitForDownloadIfNeeded", "toHomePredicate", "Ljava/util/function/Predicate;", "", "sdkHomeFilter", "toVersionPredicate", "versionFilter", "trySdk", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSdkLookupImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkLookupImpl.kt\ncom/intellij/openapi/roots/ui/configuration/SdkLookupContextEx\n+ 2 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,413:1\n12#2,8:414\n12#2,8:422\n*S KotlinDebug\n*F\n+ 1 SdkLookupImpl.kt\ncom/intellij/openapi/roots/ui/configuration/SdkLookupContextEx\n*L\n374#1:414,8\n389#1:422,8\n*E\n"})
class SdkLookupContextEx
extends SdkLookupContext {
    public SdkLookupContextEx(@NotNull SdkLookupParameters lookup2) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        super(lookup2);
    }

    public final void lookup() {
        Sdk namedSdk2;
        ProgressIndicator rootProgressIndicator = this.resolveProgressIndicator();
        SdkLookupContextEx $this$lookup_u24lambda_u241 = this;
        boolean bl = false;
        String string2 = $this$lookup_u24lambda_u241.getSdkName();
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            v1 = (Sdk)ActionsKt.runReadAction((Function0)new Function0<Sdk>($this$lookup_u24lambda_u241){
                final /* synthetic */ SdkLookupContextEx $this_run;
                {
                    this.$this_run = $receiver;
                    super(0);
                }

                @Nullable
                public final Sdk invoke() {
                    return this.$this_run.getSdkType() == null ? ProjectJdkTable.getInstance().findJdk(this.$this_run.getSdkName()) : ProjectJdkTable.getInstance().findJdk(this.$this_run.getSdkName(), this.$this_run.getSdkType().getName());
                }
            });
        } else {
            v1 = namedSdk2 = null;
        }
        if ($this$lookup_u24lambda_u241.trySdk(namedSdk2, rootProgressIndicator)) {
            return;
        }
        for (Sdk sdk2 : SdkDownloadTracker.getInstance().findDownloadingSdks(this.getSdkName())) {
            if (!this.trySdk(sdk2, rootProgressIndicator)) continue;
            return;
        }
        for (Sdk sdk2 : this.getTestSdkSequence()) {
            if (!this.trySdk(sdk2, rootProgressIndicator)) continue;
            return;
        }
        this.continueSdkLookupWithSuggestions(rootProgressIndicator);
    }

    private final boolean trySdk(Sdk sdk2, ProgressIndicator rootProgressIndicator) {
        rootProgressIndicator.checkCanceled();
        if (sdk2 == null) {
            return false;
        }
        return this.testLoadSdkAndWaitIfNeeded(sdk2, rootProgressIndicator);
    }

    private final boolean testLoadSdkAndWaitIfNeeded(Sdk sdk2, ProgressIndicator rootProgressIndicator) {
        if (!this.checkSdkVersion(sdk2)) {
            return false;
        }
        if (this.testSdkAndWaitForDownloadIfNeeded(sdk2, rootProgressIndicator)) {
            return true;
        }
        return this.testExistingSdk(sdk2);
    }

    public final boolean testSdkAndWaitForDownloadIfNeeded(@NotNull Sdk sdk2, @NotNull ProgressIndicator rootProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)rootProgressIndicator, (String)"rootProgressIndicator");
        if (!SdkDownloadTracker.getInstance().isDownloading(sdk2)) {
            return false;
        }
        Function0 action2 = (Function0)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)new Function0<Function0<? extends Boolean>>(sdk2, this, rootProgressIndicator){
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ SdkLookupContextEx this$0;
            final /* synthetic */ ProgressIndicator $rootProgressIndicator;
            {
                this.$sdk = $sdk;
                this.this$0 = $receiver;
                this.$rootProgressIndicator = $rootProgressIndicator;
                super(0);
            }

            @NotNull
            public final Function0<Boolean> invoke() {
                if (!SdkDownloadTracker.getInstance().isDownloading(this.$sdk)) {
                    return testSdkAndWaitForDownloadIfNeeded.action.1.INSTANCE;
                }
                this.this$0.onSdkNameResolved(this.$sdk);
                return switch (testSdkAndWaitForDownloadIfNeeded.action.WhenMappings.$EnumSwitchMapping$0[((SdkLookupDownloadDecision)((Object)this.this$0.getOnDownloadingSdkDetected().invoke((Object)this.$sdk))).ordinal()]) {
                    case 1 -> this.this$0.doWaitSdkDownloadToComplete(this.$sdk, this.$rootProgressIndicator);
                    case 2 -> testSdkAndWaitForDownloadIfNeeded.action.2.INSTANCE;
                    case 3 -> (Function0)new Function0<Boolean>(this.this$0){
                        final /* synthetic */ SdkLookupContextEx this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final Boolean invoke() {
                            this.this$0.onSdkResolved(null);
                            return true;
                        }
                    };
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }, 1, null);
        return (Boolean)action2.invoke();
    }

    @NotNull
    public Function0<Boolean> doWaitSdkDownloadToComplete(@NotNull Sdk sdk2, @NotNull ProgressIndicator rootProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)rootProgressIndicator, (String)"rootProgressIndicator");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable disposable2 = disposable;
        Consumer<Boolean> onDownloadCompleted = arg_0 -> SdkLookupContextEx.doWaitSdkDownloadToComplete$lambda$2(disposable2, this, sdk2, arg_0);
        boolean isDownloading = SdkDownloadTracker.getInstance().tryRegisterDownloadingListener(sdk2, disposable2, rootProgressIndicator, onDownloadCompleted);
        if (!isDownloading) {
            Disposer.dispose(disposable2);
            return doWaitSdkDownloadToComplete.1.INSTANCE;
        }
        return doWaitSdkDownloadToComplete.2.INSTANCE;
    }

    public final boolean testExistingSdk(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (!this.checkSdkHomeAndVersion(sdk2)) {
            return false;
        }
        this.onSdkResolved(sdk2);
        return true;
    }

    private final void continueSdkLookupWithSuggestions(ProgressIndicator rootProgressIndicator) {
        if (this.getSdkType() == null) {
            this.onSdkResolved(null);
            return;
        }
        if (this.getOnBeforeSdkSuggestionStarted().invoke() == SdkLookupDecision.STOP) {
            this.onSdkResolved(null);
            return;
        }
        UnknownSdk unknownSdk2 = new UnknownSdk(this){
            @Nullable
            private final Predicate<String> versionPredicate;
            @Nullable
            private final Predicate<String> homePredicate;
            final /* synthetic */ SdkLookupContextEx this$0;
            {
                Predicate predicate2;
                Predicate predicate3;
                Function1<String, Boolean> p0;
                continueSdkLookupWithSuggestions.unknownSdk.1 var4_3;
                this.this$0 = $receiver;
                continueSdkLookupWithSuggestions.unknownSdk.1 v0 = this;
                Function1<String, Boolean> function1 = $receiver.getVersionFilter();
                if (function1 != null) {
                    Function1<String, Boolean> function12 = function1;
                    var4_3 = v0;
                    boolean bl = false;
                    predicate3 = SdkLookupContextEx.access$toVersionPredicate($receiver, (Function1)p0);
                    v0 = var4_3;
                } else {
                    predicate3 = null;
                }
                v0.versionPredicate = predicate3;
                continueSdkLookupWithSuggestions.unknownSdk.1 v3 = this;
                Function1<String, Boolean> function13 = $receiver.getSdkHomeFilter();
                if (function13 != null) {
                    p0 = function13;
                    var4_3 = v3;
                    boolean bl = false;
                    predicate2 = SdkLookupContextEx.access$toHomePredicate($receiver, p0);
                    v3 = var4_3;
                } else {
                    predicate2 = null;
                }
                v3.homePredicate = predicate2;
            }

            @Nullable
            public final Predicate<String> getVersionPredicate() {
                return this.versionPredicate;
            }

            @Nullable
            public final Predicate<String> getHomePredicate() {
                return this.homePredicate;
            }

            @Nullable
            public String getSdkName() {
                return this.this$0.getSdkName();
            }

            @NotNull
            public SdkType getSdkType() {
                return this.this$0.getSdkType();
            }

            @Nullable
            public Predicate<String> getSdkVersionStringPredicate() {
                return this.versionPredicate;
            }

            @Nullable
            public Predicate<String> getSdkHomePredicate() {
                return this.homePredicate;
            }

            @NotNull
            public String toString() {
                Function1<String, Boolean> it;
                StringBuilder stringBuilder;
                SdkLookupContextEx sdkLookupContextEx = this.this$0;
                StringBuilder $this$toString_u24lambda_u244 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$toString_u24lambda_u244.append("SdkLookup{" + this.getSdkType().getPresentableName());
                String string2 = this.getSdkName();
                if (string2 != null) {
                    it = string2;
                    boolean bl2 = false;
                    $this$toString_u24lambda_u244.append(", name=" + (String)it);
                }
                Predicate<String> predicate2 = this.versionPredicate;
                if (predicate2 != null) {
                    it = predicate2;
                    boolean bl3 = false;
                    $this$toString_u24lambda_u244.append(", withVersionFilter");
                }
                Function1<String, Boolean> function1 = sdkLookupContextEx.getSdkHomeFilter();
                if (function1 != null) {
                    it = function1;
                    boolean bl4 = false;
                    $this$toString_u24lambda_u244.append(", withSdkHomeFilter");
                }
                $this$toString_u24lambda_u244.append("}");
                String string3 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                return string3;
            }
        };
        this.runSdkResolutionUnderProgress(rootProgressIndicator, (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(unknownSdk2, this){
            final /* synthetic */ continueSdkLookupWithSuggestions.unknownSdk.1 $unknownSdk;
            final /* synthetic */ SdkLookupContextEx this$0;
            {
                this.$unknownSdk = $unknownSdk;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    List resolvers2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull(UnknownSdkResolver.EP_NAME.lazySequence(), (Function1)((Function1)new Function1<UnknownSdkResolver, UnknownSdkResolver.UnknownSdkLookup>(this.this$0, indicator){
                        final /* synthetic */ SdkLookupContextEx this$0;
                        final /* synthetic */ ProgressIndicator $indicator;
                        {
                            this.this$0 = $receiver;
                            this.$indicator = $indicator;
                            super(1);
                        }

                        @Nullable
                        public final UnknownSdkResolver.UnknownSdkLookup invoke(UnknownSdkResolver it) {
                            return it.createResolver(this.this$0.getProject(), this.$indicator);
                        }
                    })));
                    indicator.checkCanceled();
                    UnknownSdkFixAction possibleFix = UnknownMissingSdk.createMissingFixAction(this.$unknownSdk, () -> continueSdkLookupWithSuggestions.1.invoke$lambda$0(this.this$0, resolvers2, this.$unknownSdk, indicator), () -> continueSdkLookupWithSuggestions.1.invoke$lambda$1(this.this$0, resolvers2, this.$unknownSdk, indicator));
                    if (possibleFix == null) {
                        this.this$0.onSdkResolved(null);
                        return;
                    }
                    Sdk sdkPrototype = possibleFix.getRegisteredSdkPrototype();
                    if (sdkPrototype != null) {
                        T t = ActionsKt.runReadAction(continueSdkLookupWithSuggestions.1.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue(t, (String)"runReadAction { ProjectJ\u2026e.getInstance().allJdks }");
                        if (ArraysKt.contains((Object[])((Object[])t), (Object)sdkPrototype)) {
                            if (SdkLookupContextEx.access$testLoadSdkAndWaitIfNeeded(this.this$0, sdkPrototype, indicator)) {
                                return;
                            }
                            SdkLookupImplKt.access$getLOG$p().warn("The matched local SDK " + possibleFix + " does not pass our filters in " + this.this$0);
                            this.this$0.onSdkResolved(null);
                            return;
                        }
                    }
                    if (this.this$0.getOnSdkFixResolved().invoke((Object)possibleFix) != SdkLookupDecision.CONTINUE) {
                        this.this$0.onSdkResolved(null);
                        return;
                    }
                    possibleFix.addSuggestionListener(this.this$0.getFixListener(possibleFix));
                    this.this$0.executeFix(indicator, possibleFix);
                }
                catch (ProcessCanceledException e) {
                    this.this$0.onSdkResolved(null);
                    throw e;
                }
                catch (Throwable t) {
                    SdkLookupImplKt.access$getLOG$p().warn("Failed to resolve SDK for " + this.this$0 + ". " + t.getMessage(), t);
                    this.this$0.onSdkResolved(null);
                }
            }

            private static final UnknownSdkLocalSdkFix invoke$lambda$0(SdkLookupContextEx this$0, List $resolvers, continueSdkLookupWithSuggestions.unknownSdk.1 $unknownSdk, ProgressIndicator $indicator) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$resolvers, (String)"$resolvers");
                Intrinsics.checkNotNullParameter((Object)$unknownSdk, (String)"$unknownSdk");
                Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
                return SdkLookupContextEx.access$resolveLocalFix(this$0, $resolvers, $unknownSdk, $indicator);
            }

            private static final UnknownSdkDownloadableSdkFix invoke$lambda$1(SdkLookupContextEx this$0, List $resolvers, continueSdkLookupWithSuggestions.unknownSdk.1 $unknownSdk, ProgressIndicator $indicator) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$resolvers, (String)"$resolvers");
                Intrinsics.checkNotNullParameter((Object)$unknownSdk, (String)"$unknownSdk");
                Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
                return SdkLookupContextEx.access$resolveDownloadFix(this$0, $resolvers, $unknownSdk, $indicator);
            }
        }));
    }

    private final Predicate<String> toHomePredicate(Function1<? super String, Boolean> sdkHomeFilter) {
        return new Predicate<String>(sdkHomeFilter){
            final /* synthetic */ Function1<String, Boolean> $sdkHomeFilter;
            {
                this.$sdkHomeFilter = $sdkHomeFilter;
            }

            public boolean test(@NotNull String t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return (Boolean)this.$sdkHomeFilter.invoke((Object)t);
            }

            @NotNull
            public String toString() {
                return this.$sdkHomeFilter.toString();
            }
        };
    }

    private final Predicate<String> toVersionPredicate(Function1<? super String, Boolean> versionFilter) {
        return new Predicate<String>(versionFilter){
            final /* synthetic */ Function1<String, Boolean> $versionFilter;
            {
                this.$versionFilter = $versionFilter;
            }

            public boolean test(@NotNull String t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return (Boolean)this.$versionFilter.invoke((Object)t);
            }

            @NotNull
            public String toString() {
                return this.$versionFilter.toString();
            }
        };
    }

    public void executeFix(@NotNull ProgressIndicator indicator, @NotNull UnknownSdkFixAction possibleFix) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)possibleFix, (String)"possibleFix");
        possibleFix.applySuggestionAsync(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UnknownSdkLocalSdkFix resolveLocalFix(List<? extends UnknownSdkResolver.UnknownSdkLookup> resolvers2, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        UnknownSdkLocalSdkFix unknownSdkLocalSdkFix;
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.local.sdks", (Object[])new Object[0]));
            unknownSdkLocalSdkFix = (UnknownSdkLocalSdkFix)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)resolvers2), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, Unit>(indicator){
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$indicator = $indicator;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, UnknownSdkLocalSdkFix>(unknownSdk2, indicator){
                final /* synthetic */ UnknownSdk $unknownSdk;
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$unknownSdk = $unknownSdk;
                    this.$indicator = $indicator;
                    super(1);
                }

                @Nullable
                public final UnknownSdkLocalSdkFix invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.proposeLocalFix(this.$unknownSdk, this.$indicator);
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Boolean>(this){
                final /* synthetic */ SdkLookupContextEx this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1<String, Boolean> function1 = this.this$0.getVersionFilter();
                    if (function1 != null) {
                        String string2 = it.getVersionString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.versionString");
                        bl = !((Boolean)function1.invoke((Object)string2)).booleanValue();
                    } else {
                        bl = false;
                    }
                    return !bl;
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Boolean>(this){
                final /* synthetic */ SdkLookupContextEx this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1<String, Boolean> function1 = this.this$0.getSdkHomeFilter();
                    if (function1 != null) {
                        String string2 = it.getExistingSdkHome();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.existingSdkHome");
                        bl = !((Boolean)function1.invoke((Object)string2)).booleanValue();
                    } else {
                        bl = false;
                    }
                    return !bl;
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Unit>(indicator){
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$indicator = $indicator;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Boolean>(this){
                final /* synthetic */ SdkLookupContextEx this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getOnLocalSdkSuggested().invoke((Object)it) == SdkLookupDecision.CONTINUE;
                }
            })));
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
        return unknownSdkLocalSdkFix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UnknownSdkDownloadableSdkFix resolveDownloadFix(List<? extends UnknownSdkResolver.UnknownSdkLookup> resolvers2, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        UnknownSdkDownloadableSdkFix unknownSdkDownloadableSdkFix;
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.downloadable.sdks", (Object[])new Object[0]));
            unknownSdkDownloadableSdkFix = (UnknownSdkDownloadableSdkFix)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)resolvers2), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, Unit>(indicator){
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$indicator = $indicator;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, UnknownSdkDownloadableSdkFix>(unknownSdk2, indicator){
                final /* synthetic */ UnknownSdk $unknownSdk;
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$unknownSdk = $unknownSdk;
                    this.$indicator = $indicator;
                    super(1);
                }

                @Nullable
                public final UnknownSdkDownloadableSdkFix invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.proposeDownload(this.$unknownSdk, this.$indicator);
                }
            })), (Function1)((Function1)new Function1<UnknownSdkDownloadableSdkFix, Boolean>(this){
                final /* synthetic */ SdkLookupContextEx this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UnknownSdkDownloadableSdkFix it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1<String, Boolean> function1 = this.this$0.getVersionFilter();
                    if (function1 != null) {
                        String string2 = it.getVersionString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.versionString");
                        bl = !((Boolean)function1.invoke((Object)string2)).booleanValue();
                    } else {
                        bl = false;
                    }
                    return !bl;
                }
            })), (Function1)((Function1)new Function1<UnknownSdkDownloadableSdkFix, Unit>(indicator){
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$indicator = $indicator;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkDownloadableSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkDownloadableSdkFix, Boolean>(this){
                final /* synthetic */ SdkLookupContextEx this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UnknownSdkDownloadableSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getOnDownloadableSdkSuggested().invoke((Object)it) == SdkLookupDecision.CONTINUE;
                }
            })));
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
        return unknownSdkDownloadableSdkFix;
    }

    public void runSdkResolutionUnderProgress(@NotNull ProgressIndicator rootProgressIndicator, @NotNull Function1<? super ProgressIndicator, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)rootProgressIndicator, (String)"rootProgressIndicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Object object = this.getSdkType();
        if (object == null || (object = object.getPresentableName()) == null) {
            object = ProjectBundle.message((String)"sdk", (Object[])new Object[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sdkType?.presentableName\u2026jectBundle.message(\"sdk\")");
        Object sdkTypeName = object;
        String string2 = this.getProgressMessageTitle();
        if (string2 == null) {
            Object[] objectArray = new Object[]{sdkTypeName};
            String string3 = ProjectBundle.message((String)"sdk.lookup.resolving.sdk.progress", (Object[])objectArray);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"sdk.lookup.reso\u2026k.progress\", sdkTypeName)");
        }
        String title = string2;
        Project project2 = this.getProject();
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        ProgressManager.getInstance().run(new Task.Backgroundable(title, rootProgressIndicator, action2, project2, performInBackgroundOption){
            final /* synthetic */ ProgressIndicator $rootProgressIndicator;
            final /* synthetic */ Function1<ProgressIndicator, Unit> $action;
            {
                this.$rootProgressIndicator = $rootProgressIndicator;
                this.$action = $action;
                super($super_call_param$1, $title, true, $super_call_param$2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void parentProgress$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator progressIndicator = this.$rootProgressIndicator;
                Function1<ProgressIndicator, Unit> action$iv = this.$action;
                boolean $i$f$runUnderNestedProgressAndRelayMessages = false;
                Function1 action$iv2 = (Function1)new Function1<ProgressIndicator, Unit>(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                        super(1);
                    }

                    public final Unit invoke(@NotNull ProgressIndicator it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$action.invoke((Object)it);
                    }
                };
                if (parentProgress$iv instanceof AbstractProgressIndicatorExBase) {
                    void parentProgress$iv$iv;
                    AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = (AbstractProgressIndicatorExBase)parentProgress$iv;
                    AbstractProgressIndicatorExBase delegate$iv$iv = new RelayUiToDelegateIndicator(indicator);
                    boolean $i$f$runWithStateDelegate = false;
                    parentProgress$iv$iv.addStateDelegate(delegate$iv$iv);
                    try {
                        Object object;
                        boolean bl = false;
                        boolean $i$f$runUnderBoundCancellation = false;
                        Function0 action$iv$iv = (Function0)new Function0<Unit>(action$iv2, (ProgressIndicator)parentProgress$iv){
                            final /* synthetic */ Function1 $action$inlined;
                            final /* synthetic */ ProgressIndicator $parentProgress$inlined;
                            {
                                this.$action$inlined = function1;
                                this.$parentProgress$inlined = progressIndicator;
                                super(0);
                            }

                            public final Unit invoke() {
                                boolean bl = false;
                                return this.$action$inlined.invoke((Object)this.$parentProgress$inlined);
                            }
                        };
                        if (!(indicator instanceof AbstractProgressIndicatorExBase)) {
                            object = action$iv$iv.invoke();
                        } else {
                            AbstractProgressIndicatorExBase relay$iv$iv = new AbstractProgressIndicatorExBase((ProgressIndicator)parentProgress$iv){
                                final /* synthetic */ ProgressIndicator $cancels;
                                {
                                    this.$cancels = $cancels;
                                }

                                public void cancel() {
                                    super.cancel();
                                    this.$cancels.cancel();
                                }
                            };
                            AbstractProgressIndicatorExBase parentProgress$iv$iv$iv = (AbstractProgressIndicatorExBase)indicator;
                            boolean $i$f$runWithStateDelegate2 = false;
                            parentProgress$iv$iv$iv.addStateDelegate(relay$iv$iv);
                            try {
                                Object object2 = action$iv$iv.invoke();
                                object = object2;
                            }
                            finally {
                                parentProgress$iv$iv$iv.removeStateDelegate(relay$iv$iv);
                            }
                        }
                        Object object3 = object;
                    }
                    finally {
                        parentProgress$iv$iv.removeStateDelegate(delegate$iv$iv);
                    }
                }
                if (indicator instanceof AbstractProgressIndicatorExBase) {
                    AbstractProgressIndicatorExBase parentProgress$iv$iv = (AbstractProgressIndicatorExBase)indicator;
                    AbstractProgressIndicatorExBase delegate$iv$iv = new RelayUiToDelegateIndicator((ProgressIndicator)parentProgress$iv);
                    boolean $i$f$runWithStateDelegate = false;
                    parentProgress$iv$iv.addStateDelegate(delegate$iv$iv);
                    try {
                        Object object;
                        boolean bl = false;
                        boolean $i$f$runUnderBoundCancellation = false;
                        Function0 action$iv$iv = (Function0)new Function0<Unit>(action$iv2, indicator){
                            final /* synthetic */ Function1 $action$inlined;
                            final /* synthetic */ ProgressIndicator $childProgress$inlined;
                            {
                                this.$action$inlined = function1;
                                this.$childProgress$inlined = progressIndicator;
                                super(0);
                            }

                            public final Unit invoke() {
                                boolean bl = false;
                                return this.$action$inlined.invoke((Object)this.$childProgress$inlined);
                            }
                        };
                        if (!(parentProgress$iv instanceof AbstractProgressIndicatorExBase)) {
                            object = action$iv$iv.invoke();
                        } else {
                            AbstractProgressIndicatorExBase relay$iv$iv = new AbstractProgressIndicatorExBase(indicator){
                                final /* synthetic */ ProgressIndicator $cancels;
                                {
                                    this.$cancels = $cancels;
                                }

                                public void cancel() {
                                    super.cancel();
                                    this.$cancels.cancel();
                                }
                            };
                            AbstractProgressIndicatorExBase parentProgress$iv$iv$iv = (AbstractProgressIndicatorExBase)parentProgress$iv;
                            boolean $i$f$runWithStateDelegate3 = false;
                            parentProgress$iv$iv$iv.addStateDelegate(relay$iv$iv);
                            try {
                                Object object4 = action$iv$iv.invoke();
                                object = object4;
                            }
                            finally {
                                parentProgress$iv$iv$iv.removeStateDelegate(relay$iv$iv);
                            }
                        }
                        Object object5 = object;
                    }
                    finally {
                        parentProgress$iv$iv.removeStateDelegate(delegate$iv$iv);
                    }
                }
                action$iv2.invoke((Object)indicator);
            }
        });
    }

    private static final void doWaitSdkDownloadToComplete$lambda$2(Disposable $disposable, SdkLookupContextEx this$0, Sdk $sdk, Boolean onSucceeded) {
        Sdk sdk2;
        Intrinsics.checkNotNullParameter((Object)$disposable, (String)"$disposable");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sdk, (String)"$sdk");
        Disposer.dispose($disposable);
        Intrinsics.checkNotNullExpressionValue((Object)onSucceeded, (String)"onSucceeded");
        if (onSucceeded.booleanValue() && this$0.checkSdkHomeAndVersion($sdk)) {
            sdk2 = $sdk;
        } else if (onSucceeded.booleanValue()) {
            SdkLookupImplKt.access$getLOG$p().warn("Just downloaded SDK: " + $sdk + " has failed the checkSdkHomeAndVersion test");
            sdk2 = null;
        } else {
            sdk2 = null;
        }
        Sdk finalSdk = sdk2;
        this$0.onSdkResolved(finalSdk);
    }

    public static final /* synthetic */ Predicate access$toVersionPredicate(SdkLookupContextEx $this, Function1 versionFilter) {
        return $this.toVersionPredicate((Function1<? super String, Boolean>)versionFilter);
    }

    public static final /* synthetic */ Predicate access$toHomePredicate(SdkLookupContextEx $this, Function1 sdkHomeFilter) {
        return $this.toHomePredicate((Function1<? super String, Boolean>)sdkHomeFilter);
    }

    public static final /* synthetic */ boolean access$testLoadSdkAndWaitIfNeeded(SdkLookupContextEx $this, Sdk sdk2, ProgressIndicator rootProgressIndicator) {
        return $this.testLoadSdkAndWaitIfNeeded(sdk2, rootProgressIndicator);
    }

    public static final /* synthetic */ UnknownSdkLocalSdkFix access$resolveLocalFix(SdkLookupContextEx $this, List resolvers2, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        return $this.resolveLocalFix(resolvers2, unknownSdk2, indicator);
    }

    public static final /* synthetic */ UnknownSdkDownloadableSdkFix access$resolveDownloadFix(SdkLookupContextEx $this, List resolvers2, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        return $this.resolveDownloadFix(resolvers2, unknownSdk2, indicator);
    }
}

