/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class ContentEntryEditingAction
extends ToggleAction
implements DumbAware {
    protected final JTree myTree;

    protected ContentEntryEditingAction(JTree tree) {
        this.myTree = tree;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ContentEntryEditingAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        presentation2.setEnabled(true);
        VirtualFile[] files2 = this.getSelectedFiles();
        if (files2.length == 0) {
            presentation2.setEnabled(false);
            return;
        }
        for (VirtualFile file2 : files2) {
            if (file2 != null && file2.isDirectory()) continue;
            presentation2.setEnabled(false);
            break;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ContentEntryEditingAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    protected final VirtualFile @NotNull [] getSelectedFiles() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                ContentEntryEditingAction.$$$reportNull$$$0(2);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> selected = new ArrayList<VirtualFile>();
        for (TreePath treePath : selectionPaths) {
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object nodeDescriptor = node2.getUserObject();
            if (!(nodeDescriptor instanceof FileNodeDescriptor)) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    ContentEntryEditingAction.$$$reportNull$$$0(3);
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            FileElement fileElement = ((FileNodeDescriptor)nodeDescriptor).getElement();
            VirtualFile file2 = fileElement.getFile();
            if (file2 == null) continue;
            selected.add(file2);
        }
        VirtualFile[] virtualFileArray = selected.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            ContentEntryEditingAction.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/actions/ContentEntryEditingAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/actions/ContentEntryEditingAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

