/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeleteProvider
implements DeleteProvider,
TitledHandler {
    public static ModuleDeleteProvider getInstance() {
        return ApplicationManager.getApplication().getService(ModuleDeleteProvider.class);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(1);
        }
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext2);
        List unloadedModules = (List)ProjectView.UNLOADED_MODULES_CONTEXT_KEY.getData(dataContext2);
        return modules2 != null && !ModuleDeleteProvider.containsPrimaryModule(modules2) || unloadedModules != null && !unloadedModules.isEmpty();
    }

    private static boolean containsPrimaryModule(Module[] modules2) {
        if (!ProjectAttachProcessor.canAttachToProject()) {
            return !PlatformUtils.isIntelliJ();
        }
        for (Module module2 : modules2) {
            Path ideaDir;
            String moduleFile = module2.getModuleFilePath();
            Project project2 = module2.getProject();
            if (!ProjectKt.isDirectoryBased(project2) || (ideaDir = ProjectKt.getStateStore(project2).getDirectoryStorePath()) == null || !PathUtilRt.getParentPath(moduleFile).equals(FileUtil.toSystemIndependentName(ideaDir.toString()))) continue;
            return true;
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(2);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        assert (project2 != null);
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext2);
        List unloadedModules = (List)ProjectView.UNLOADED_MODULES_CONTEXT_KEY.getData(dataContext2);
        Set<String> moduleNamesToDelete = ModuleDeleteProvider.getModuleNamesToDelete(modules2, unloadedModules);
        String names = StringUtil.join(moduleNamesToDelete, name -> "'" + name + "'", ", ");
        String dialogTitle = StringUtil.trimEnd(this.getActionTitle(), "...");
        int ret = Messages.showOkCancelDialog((String)this.getConfirmationText(names, moduleNamesToDelete.size()), (String)dialogTitle, (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            Runnable action2 = () -> this.detachModules(project2, modules2, unloadedModules);
            ApplicationManager.getApplication().runWriteAction(action2);
        }, ProjectBundle.message((String)"module.remove.command", (Object[])new Object[0]), null);
    }

    private static Set<String> getModuleNamesToDelete(Module @Nullable [] modules2, @Nullable List<? extends UnloadedModuleDescription> unloadedModules) {
        HashSet<String> moduleNamesToDelete = new HashSet<String>();
        if (null != modules2) {
            for (Module module2 : modules2) {
                moduleNamesToDelete.add(module2.getName());
            }
        }
        if (unloadedModules != null) {
            for (UnloadedModuleDescription unloadedModuleDescription : unloadedModules) {
                moduleNamesToDelete.add(unloadedModuleDescription.getName());
            }
        }
        return moduleNamesToDelete;
    }

    protected void doDetachModules(@NotNull Project project2, Module @Nullable [] modules2, @Nullable List<? extends UnloadedModuleDescription> unloadedModules) {
        if (project2 == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(3);
        }
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        Module[] currentModules = moduleManager.getModules();
        ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
        HashMap<Module, ModifiableRootModel> otherModuleRootModels = new HashMap<Module, ModifiableRootModel>();
        Set<String> moduleNamesToDelete = ModuleDeleteProvider.getModuleNamesToDelete(modules2, unloadedModules);
        for (Module otherModule : currentModules) {
            if (moduleNamesToDelete.contains(otherModule.getName())) continue;
            otherModuleRootModels.put(otherModule, ModuleRootManager.getInstance(otherModule).getModifiableModel());
        }
        ModuleDeleteProvider.removeDependenciesOnModules(moduleNamesToDelete, otherModuleRootModels.values());
        if (modules2 != null) {
            for (Module module2 : modules2) {
                for (ProjectAttachProcessor processor : ProjectAttachProcessor.EP_NAME.getExtensionList()) {
                    processor.beforeDetach(module2);
                }
                modifiableModuleModel.disposeModule(module2);
            }
        }
        ModifiableRootModel[] modifiableRootModels = otherModuleRootModels.values().toArray(new ModifiableRootModel[0]);
        ModifiableModelCommitter.multiCommit(modifiableRootModels, modifiableModuleModel);
        if (unloadedModules != null) {
            moduleManager.removeUnloadedModules(unloadedModules);
        }
    }

    private void detachModules(@NotNull Project project2, Module @Nullable [] modules2, @Nullable List<? extends UnloadedModuleDescription> unloadedModules) {
        if (project2 == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(4);
        }
        this.doDetachModules(project2, modules2, unloadedModules);
    }

    public static void detachModules(@NotNull Project project2, Module @Nullable [] modules2) {
        if (project2 == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(5);
        }
        ModuleDeleteProvider.getInstance().detachModules(project2, modules2, null);
    }

    @NlsContexts.DialogMessage
    protected String getConfirmationText(String names, int numberOfModules) {
        if (ProjectAttachProcessor.canAttachToProject()) {
            return ProjectBundle.message((String)"project.remove.confirmation.prompt", (Object[])new Object[]{names, numberOfModules});
        }
        return ProjectBundle.message((String)"module.remove.confirmation.prompt", (Object[])new Object[]{names, numberOfModules});
    }

    @Override
    public String getActionTitle() {
        return ProjectAttachProcessor.canAttachToProject() ? ProjectBundle.message((String)"action.text.remove.from.project.view", (Object[])new Object[0]) : ProjectBundle.message((String)"action.text.remove.module", (Object[])new Object[0]);
    }

    private static void doRemoveModule(@NotNull Module moduleToRemove, @NotNull Collection<? extends ModifiableRootModel> otherModuleRootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (moduleToRemove == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(6);
        }
        if (otherModuleRootModels == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(7);
        }
        if (moduleModel == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(8);
        }
        ModuleDeleteProvider.removeDependenciesOnModules(Collections.singleton(moduleToRemove.getName()), otherModuleRootModels);
        moduleModel.disposeModule(moduleToRemove);
    }

    public static void removeModule(@NotNull Module moduleToRemove, @NotNull Collection<? extends ModifiableRootModel> otherModuleRootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (moduleToRemove == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(9);
        }
        if (otherModuleRootModels == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(10);
        }
        if (moduleModel == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(11);
        }
        ModuleDeleteProvider.doRemoveModule(moduleToRemove, otherModuleRootModels, moduleModel);
    }

    private static void removeDependenciesOnModules(@NotNull Set<String> moduleNamesToRemove, @NotNull Collection<? extends ModifiableRootModel> otherModuleRootModels) {
        if (moduleNamesToRemove == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(12);
        }
        if (otherModuleRootModels == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(13);
        }
        for (ModifiableRootModel modifiableRootModel : otherModuleRootModels) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry2 : orderEntries = modifiableRootModel.getOrderEntries()) {
                if (!(orderEntry2 instanceof ModuleOrderEntry) || !moduleNamesToRemove.contains(((ModuleOrderEntry)orderEntry2).getModuleName())) continue;
                modifiableRootModel.removeOrderEntry(orderEntry2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleToRemove";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherModuleRootModels";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNamesToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doDetachModules";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detachModules";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveModule";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeDependenciesOnModules";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string2);
        };
    }
}

