/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.util.CachedImageIcon;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ImageDataByUrlLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/ui/ImageDataByPathLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "original", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lcom/intellij/openapi/ui/ImageDataByPathLoader;)V", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "equals", "", "other", "", "hashCode", "", "isMyClassLoader", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "patch", "originalPath", "transform", "Lcom/intellij/ui/icons/IconTransform;", "toString", "Companion", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class ImageDataByPathLoader
implements ImageDataLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @NotNull
    private final ClassLoader classLoader;
    @Nullable
    private final ImageDataByPathLoader original;

    private ImageDataByPathLoader(String path2, ClassLoader classLoader, ImageDataByPathLoader original) {
        this.path = path2;
        this.classLoader = classLoader;
        this.original = original;
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        int flags = 3;
        if (parameters2.isDark) {
            flags |= 4;
        }
        return ImageLoader.loadImage$default(ImageLoader.INSTANCE, this.path, parameters2, null, this.classLoader, flags, !StringsKt.endsWith$default((String)this.path, (String)".svg", (boolean)false, (int)2, null), 4, null);
    }

    @Override
    @Nullable
    public URL getUrl() {
        return this.classLoader.getResource(this.path);
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        boolean isOriginal = this.original == null;
        ImageDataByPathLoader imageDataByPathLoader = isOriginal ? this : this.original;
        Intrinsics.checkNotNull((Object)imageDataByPathLoader);
        return ImageDataByPathLoader.Companion.doPatch(imageDataByPathLoader, transform2, isOriginal);
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoader == classLoader || this.original != null && this.original.classLoader == classLoader;
    }

    @NotNull
    public String toString() {
        return "ImageDataByPathLoader(classLoader=" + this.classLoader + ", path=" + this.path + ", original=" + this.original + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImageDataByPathLoader)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)((ImageDataByPathLoader)other).path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classLoader, (Object)((ImageDataByPathLoader)other).classLoader)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.original, (Object)((ImageDataByPathLoader)other).original);
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = 31 * result2 + this.classLoader.hashCode();
        ImageDataByPathLoader imageDataByPathLoader = this.original;
        result2 = 31 * result2 + (imageDataByPathLoader != null ? imageDataByPathLoader.hashCode() : 0);
        return result2;
    }

    @JvmStatic
    @Nullable
    public static final Icon findIcon(@NonNls @NotNull String originalPath, @NotNull ClassLoader originalClassLoader, @Nullable Map<Pair<String, ClassLoader>, CachedImageIcon> cache2) {
        return Companion.findIcon(originalPath, originalClassLoader, cache2);
    }

    public /* synthetic */ ImageDataByPathLoader(String path2, ClassLoader classLoader, ImageDataByPathLoader original, DefaultConstructorMarker $constructor_marker) {
        this(path2, classLoader, original);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0003\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J@\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\"\u0010\u0018\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001a\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0019H\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/ui/ImageDataByPathLoader$Companion;", "", "()V", "createIcon", "Lcom/intellij/openapi/util/CachedImageIcon;", "originalPath", "", "Lorg/jetbrains/annotations/NonNls;", "originalClassLoader", "Ljava/lang/ClassLoader;", "patched", "Lkotlin/Pair;", "path", "classLoader", "doPatch", "Lcom/intellij/ui/icons/ImageDataLoader;", "originalLoader", "Lcom/intellij/openapi/ui/ImageDataByPathLoader;", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isOriginal", "", "findIcon", "Ljavax/swing/Icon;", "cache", "", "Lcom/intellij/openapi/util/Pair;", "normalizePath", "patchedPath", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Icon findIcon(@NonNls @NotNull String originalPath, @NotNull ClassLoader originalClassLoader, @Nullable Map<Pair<String, ClassLoader>, CachedImageIcon> cache2) {
            Icon icon2;
            Object object;
            Object path2;
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)originalClassLoader, (String)"originalClassLoader");
            long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
            String originalPath2 = this.normalizePath(originalPath);
            kotlin.Pair<String, ClassLoader> patched = IconLoader.patchPath(originalPath2, originalClassLoader);
            Object object2 = patched;
            if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
                object2 = path2 = originalPath2;
            }
            if ((object = patched) == null || (object = (ClassLoader)object.getSecond()) == null) {
                object = originalClassLoader;
            }
            Object classLoader = object;
            Icon icon3 = IconLoader.INSTANCE.isReflectivePath((String)path2) ? IconLoader.getReflectiveIcon(path2, classLoader) : (icon2 = cache2 == null ? (Icon)this.createIcon(originalPath2, originalClassLoader, (kotlin.Pair<String, ? extends ClassLoader>)patched, (String)path2, (ClassLoader)classLoader) : (Icon)cache2.computeIfAbsent(new Pair<String, ClassLoader>(originalPath2, originalClassLoader), arg_0 -> Companion.findIcon$lambda$0((Function1)new Function1<Pair<String, ClassLoader>, CachedImageIcon>(patched, path2, classLoader){
                final /* synthetic */ kotlin.Pair<String, ClassLoader> $patched;
                final /* synthetic */ String $path;
                final /* synthetic */ ClassLoader $classLoader;
                {
                    this.$patched = $patched;
                    this.$path = $path;
                    this.$classLoader = $classLoader;
                    super(1);
                }

                @NotNull
                public final CachedImageIcon invoke(@NotNull Pair<String, ClassLoader> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    A a = it.first;
                    Intrinsics.checkNotNullExpressionValue(a, (String)"it.first");
                    String string2 = (String)a;
                    B b = it.second;
                    Intrinsics.checkNotNull(b);
                    return com.intellij.openapi.ui.ImageDataByPathLoader$Companion.access$createIcon(ImageDataByPathLoader.Companion, string2, (ClassLoader)b, this.$patched, this.$path, this.$classLoader);
                }
            }, arg_0)));
            if (startTime != -1L) {
                IconLoadMeasurer.findIcon.end(startTime);
            }
            return icon2;
        }

        private final CachedImageIcon createIcon(String originalPath, ClassLoader originalClassLoader, kotlin.Pair<String, ? extends ClassLoader> patched, String path2, ClassLoader classLoader) {
            ImageDataByPathLoader loader = new ImageDataByPathLoader(originalPath, originalClassLoader, null, null);
            ImageDataByPathLoader resolver = patched == null ? loader : new ImageDataByPathLoader(path2, classLoader, loader, null);
            return new CachedImageIcon(null, resolver);
        }

        private final String normalizePath(String patchedPath) {
            String string2;
            if (patchedPath.charAt(0) == '/') {
                String string3 = patchedPath.substring(1);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string2 = patchedPath;
            }
            return string2;
        }

        private final ImageDataLoader doPatch(ImageDataByPathLoader originalLoader, IconTransform transform2, boolean isOriginal) {
            ImageDataLoader imageDataLoader;
            ClassLoader classLoader;
            kotlin.Pair<String, ClassLoader> pair = transform2.patchPath(originalLoader.path, originalLoader.classLoader);
            if (pair == null) {
                return isOriginal ? null : (ImageDataLoader)originalLoader;
            }
            kotlin.Pair<String, ClassLoader> patched = pair;
            if (patched.getSecond() == null) {
                classLoader = originalLoader.classLoader;
            } else {
                Object object = patched.getSecond();
                Intrinsics.checkNotNull((Object)object);
                classLoader = (ClassLoader)object;
            }
            ClassLoader classLoader2 = classLoader;
            Object object = patched.getFirst();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"patched.first");
            if (StringsKt.startsWith$default((String)((String)object), (String)"file:/", (boolean)false, (int)2, null)) {
                imageDataLoader = new ImageDataByUrlLoader(new URL((String)patched.getFirst()), (String)patched.getFirst(), classLoader2, false);
            } else {
                Object object2 = patched.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"patched.first");
                imageDataLoader = new ImageDataByPathLoader(this.normalizePath((String)object2), classLoader2, originalLoader, null);
            }
            return imageDataLoader;
        }

        private static final CachedImageIcon findIcon$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CachedImageIcon)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ CachedImageIcon access$createIcon(Companion $this, String originalPath, ClassLoader originalClassLoader, kotlin.Pair patched, String path2, ClassLoader classLoader) {
            return $this.createIcon(originalPath, originalClassLoader, (kotlin.Pair<String, ? extends ClassLoader>)patched, path2, classLoader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

