/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.IconReplacer;
import com.intellij.ui.UpdatableIcon;
import com.intellij.ui.icons.ReplaceableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.RGBImageFilter;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilteredIcon
implements ReplaceableIcon {
    private long modificationCount;
    @NotNull
    private final Icon baseIcon;
    @NotNull
    private final Supplier<? extends RGBImageFilter> filterSupplier;
    @Nullable
    private Icon iconToPaint;
    private double currentScale;

    FilteredIcon(@NotNull Icon icon2, @NotNull Supplier<? extends RGBImageFilter> filterSupplier) {
        if (icon2 == null) {
            FilteredIcon.$$$reportNull$$$0(0);
        }
        if (filterSupplier == null) {
            FilteredIcon.$$$reportNull$$$0(1);
        }
        this.modificationCount = -1L;
        this.currentScale = 1.0;
        this.baseIcon = icon2;
        this.filterSupplier = filterSupplier;
    }

    @Override
    public void paintIcon(Component c2, Graphics g, int x, int y) {
        long currentModificationCount;
        double scale = IconLoader.INSTANCE.getScaleToRenderIcon(this.baseIcon, c2);
        Icon toPaint = this.iconToPaint;
        if ((toPaint == null || this.modificationCount != -1L) && (currentModificationCount = this.calculateModificationCount()) != -1L && currentModificationCount != this.modificationCount) {
            this.modificationCount = currentModificationCount;
            toPaint = null;
        }
        if (scale != this.currentScale) {
            toPaint = null;
        }
        if (toPaint == null) {
            toPaint = IconLoader.INSTANCE.renderFilteredIcon(this.baseIcon, scale, this.filterSupplier, c2);
            this.currentScale = scale;
            this.iconToPaint = toPaint;
        }
        if (c2 != null) {
            new PaintNotifier(c2, x, y).replaceIcon(this.baseIcon);
        }
        toPaint.paintIcon(c2 != null ? c2 : IconLoaderKt.getFakeComponent(), g, x, y);
    }

    @Override
    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer2) {
        if (replacer2 == null) {
            FilteredIcon.$$$reportNull$$$0(2);
        }
        return new FilteredIcon(replacer2.replaceIcon(this.baseIcon), this.filterSupplier);
    }

    private long calculateModificationCount() {
        TimestampSearcher searcher2 = new TimestampSearcher();
        searcher2.replaceIcon(this.baseIcon);
        return searcher2.modificationCount;
    }

    @Override
    public int getIconWidth() {
        return this.baseIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.baseIcon.getIconHeight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/FilteredIcon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceBy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PaintNotifier
    implements IconReplacer {
        @NotNull
        final Component c;
        final int x;
        final int y;

        private PaintNotifier(@NotNull Component c2, int x, int y) {
            if (c2 == null) {
                PaintNotifier.$$$reportNull$$$0(0);
            }
            this.c = c2;
            this.x = x;
            this.y = y;
        }

        @Override
        public Icon replaceIcon(Icon icon2) {
            if (icon2 instanceof UpdatableIcon) {
                UpdatableIcon updatableIcon = (UpdatableIcon)icon2;
                updatableIcon.notifyPaint(this.c, this.x, this.y);
            }
            if (icon2 instanceof ReplaceableIcon) {
                ReplaceableIcon replaceableIcon = (ReplaceableIcon)icon2;
                replaceableIcon.replaceBy(this);
            }
            return IconReplacer.super.replaceIcon(icon2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/util/FilteredIcon$PaintNotifier", "<init>"));
        }
    }

    private static class TimestampSearcher
    implements IconReplacer {
        long modificationCount;

        private TimestampSearcher() {
        }

        @Override
        public Icon replaceIcon(Icon icon2) {
            if (icon2 instanceof ModificationTracker) {
                ModificationTracker withModificationCount = (ModificationTracker)((Object)icon2);
                this.modificationCount = this.modificationCount == -1L ? withModificationCount.getModificationCount() : (this.modificationCount += withModificationCount.getModificationCount());
            }
            if (icon2 instanceof ReplaceableIcon) {
                ReplaceableIcon replaceableIcon = (ReplaceableIcon)icon2;
                replaceableIcon.replaceBy(this);
            }
            return IconReplacer.super.replaceIcon(icon2);
        }
    }
}

