/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.lang.ref.WeakReference;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/util/FinalImageDataLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/String;Ljava/lang/ClassLoader;)V", "classLoaderRef", "Ljava/lang/ref/WeakReference;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "isMyClassLoader", "", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "patch", "originalPath", "transform", "Lcom/intellij/ui/icons/IconTransform;", "toString", "intellij.platform.util.ui"})
final class FinalImageDataLoader
implements ImageDataLoader {
    @NotNull
    private final String path;
    @NotNull
    private final WeakReference<ClassLoader> classLoaderRef;

    public FinalImageDataLoader(@NotNull String path2, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.path = path2;
        this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        int flags = 1;
        if (parameters2.isDark) {
            flags |= 4;
        }
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader;
        return ImageLoader.INSTANCE.loadImage(this.path, parameters2, null, classLoader2, flags, !StringsKt.endsWith$default((String)this.path, (String)".svg", (boolean)false, (int)2, null));
    }

    @Override
    @Nullable
    public URL getUrl() {
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        return classLoader != null ? classLoader.getResource(this.path) : null;
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        return null;
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoaderRef.get() == classLoader;
    }

    @NotNull
    public String toString() {
        return "FinalImageDataLoader(classLoader=" + this.classLoaderRef.get() + ", path='" + this.path + "')";
    }
}

