/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ImageDataByPathLoader;
import com.intellij.openapi.util.CachedImageIcon;
import com.intellij.openapi.util.HandleNotFound;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.openapi.util.ImageDataByUrlLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.util.ImageCache;
import java.awt.image.RGBImageFilter;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\u0006\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\bH\u0002\u001a(\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u001a2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010*0-H\u0002\u001a\u0010\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u000200H\u0002\u001a\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u0010/\u001a\u00020\u0011H\u0002\u001a\u001e\u00103\u001a\u0002042\u0014\u00105\u001a\u0010\u0012\u0006\b\u0000\u0012\u000207\u0012\u0004\u0012\u00020706H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"8\u0010\u000b\u001a,\u0012\u0004\u0012\u00020\r\u0012\"\u0012 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u000e0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0012\u001a\u00020\u00138@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\"(\u0010\u0018\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0019\u0012\u0004\u0012\u00020\u001c0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\u001d\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOOKUP", "Ljava/lang/invoke/MethodHandles$Lookup;", "kotlin.jvm.PlatformType", "STRICT_GLOBAL", "", "STRICT_LOCAL", "Ljava/lang/ThreadLocal;", "colorPatchCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "", "", "Ljavax/swing/Icon;", "fakeComponent", "Ljavax/swing/JComponent;", "getFakeComponent", "()Ljavax/swing/JComponent;", "fakeComponent$delegate", "Lkotlin/Lazy;", "iconCache", "Lcom/intellij/openapi/util/Pair;", "", "Ljava/lang/ClassLoader;", "Lcom/intellij/openapi/util/CachedImageIcon;", "iconToDisabledIcon", "Lkotlin/Function0;", "Ljava/awt/image/RGBImageFilter;", "standardDisablingFilter", "findIcon", "originalPath", "aClass", "Ljava/lang/Class;", "classLoader", "handleNotFound", "Lcom/intellij/openapi/util/HandleNotFound;", "deferUrlResolve", "findUrl", "Ljava/net/URL;", "path", "urlProvider", "Lkotlin/Function1;", "getOrigin", "icon", "Lcom/intellij/ui/RetrievableIcon;", "getScaleContextSupport", "Lcom/intellij/ui/scale/ScaleContextSupport;", "updateTransform", "", "updater", "Ljava/util/function/Function;", "Lcom/intellij/ui/icons/IconTransform;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nIconLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconLoader.kt\ncom/intellij/openapi/util/IconLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,875:1\n10#2:876\n*S KotlinDebug\n*F\n+ 1 IconLoader.kt\ncom/intellij/openapi/util/IconLoaderKt\n*L\n49#1:876\n*E\n"})
public final class IconLoaderKt {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    @NotNull
    private static final ConcurrentHashMap<Pair<String, ClassLoader>, CachedImageIcon> iconCache = new ConcurrentHashMap(100, 0.9f, 2);
    @NotNull
    private static final ConcurrentHashMap<Function0<RGBImageFilter>, Map<Icon, Icon>> iconToDisabledIcon = new ConcurrentHashMap();
    @NotNull
    private static final Function0<RGBImageFilter> standardDisablingFilter = standardDisablingFilter.1.INSTANCE;
    @NotNull
    private static final ConcurrentHashMap<Integer, Map<List<Byte>, Map<Icon, Icon>>> colorPatchCache = new ConcurrentHashMap();
    private static volatile boolean STRICT_GLOBAL;
    @NotNull
    private static final ThreadLocal<Boolean> STRICT_LOCAL;
    @NotNull
    private static final Lazy fakeComponent$delegate;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IconLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        return logger;
    }

    @NotNull
    public static final JComponent getFakeComponent() {
        Lazy lazy = fakeComponent$delegate;
        return (JComponent)lazy.getValue();
    }

    private static final Icon getOrigin(RetrievableIcon icon2) {
        int maxDeep = 10;
        Icon icon3 = icon2.retrieveIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"icon.retrieveIcon()");
        Icon origin = icon3;
        for (int level = 0; origin instanceof RetrievableIcon && level < maxDeep; ++level) {
            Intrinsics.checkNotNullExpressionValue((Object)((RetrievableIcon)origin).retrieveIcon(), (String)"origin.retrieveIcon()");
        }
        if (origin instanceof RetrievableIcon) {
            IconLoaderKt.getLOG().error("can't calculate origin icon (too deep in hierarchy), src: " + icon2);
        }
        return origin;
    }

    private static final ScaleContextSupport getScaleContextSupport(Icon icon2) {
        ScaleContextSupport scaleContextSupport;
        Icon icon3 = icon2;
        if (icon3 instanceof ScaleContextSupport) {
            scaleContextSupport = (ScaleContextSupport)((Object)icon2);
        } else if (icon3 instanceof RetrievableIcon) {
            Icon icon4 = ((RetrievableIcon)icon2).retrieveIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"icon.retrieveIcon()");
            scaleContextSupport = IconLoaderKt.getScaleContextSupport(icon4);
        } else if (icon3 instanceof CompositeIcon) {
            if (((CompositeIcon)icon2).getIconCount() == 0) {
                return null;
            }
            Icon icon5 = ((CompositeIcon)icon2).getIcon(0);
            if (icon5 == null) {
                return null;
            }
            scaleContextSupport = IconLoaderKt.getScaleContextSupport(icon5);
        } else {
            scaleContextSupport = null;
        }
        return scaleContextSupport;
    }

    private static final void updateTransform(Function<? super IconTransform, IconTransform> updater2) {
        IconTransform prev = null;
        IconTransform next2 = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)CachedImageIcon.pathTransform.get(), (String)"pathTransform.get()");
            Intrinsics.checkNotNullExpressionValue((Object)updater2.apply(prev), (String)"updater.apply(prev)");
        } while (!CachedImageIcon.pathTransform.compareAndSet(prev, next2));
        CachedImageIcon.pathTransformGlobalModCount.incrementAndGet();
        if (!Intrinsics.areEqual((Object)prev, (Object)next2)) {
            iconToDisabledIcon.clear();
            colorPatchCache.clear();
            CachedImageIcon.iconToStrokeIcon.clear();
            ImageCache.Companion.getINSTANCE().clearCache();
        }
    }

    private static final Icon findIcon(String originalPath, Class<?> aClass, ClassLoader classLoader, HandleNotFound handleNotFound, boolean deferUrlResolve) {
        ClassLoader effectiveClassLoader = classLoader;
        if (!deferUrlResolve) {
            return ImageDataByPathLoader.Companion.findIcon(originalPath, effectiveClassLoader, (Map<Pair<String, ClassLoader>, CachedImageIcon>)iconCache);
        }
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        kotlin.Pair<String, ClassLoader> patchedPath = IconLoader.patchPath(originalPath, effectiveClassLoader);
        Object object = patchedPath;
        if (object == null || (object = (String)object.getFirst()) == null) {
            object = originalPath;
        }
        Object path2 = object;
        kotlin.Pair<String, ClassLoader> pair = patchedPath;
        if ((pair != null ? (ClassLoader)pair.getSecond() : null) != null) {
            effectiveClassLoader = (ClassLoader)patchedPath.getSecond();
        }
        Icon icon2 = null;
        if (IconLoader.INSTANCE.isReflectivePath((String)path2)) {
            icon2 = IconLoader.getReflectiveIcon(path2, effectiveClassLoader);
        } else {
            Pair<String, ClassLoader> key = new Pair<String, ClassLoader>(originalPath, effectiveClassLoader);
            CachedImageIcon cachedIcon = iconCache.get(key);
            if (cachedIcon == null) {
                cachedIcon = iconCache.computeIfAbsent(key, arg_0 -> IconLoaderKt.findIcon$lambda$0((Function1)new Function1<Pair<String, ClassLoader>, CachedImageIcon>(handleNotFound, path2, aClass, originalPath){
                    final /* synthetic */ HandleNotFound $handleNotFound;
                    final /* synthetic */ String $path;
                    final /* synthetic */ Class<?> $aClass;
                    final /* synthetic */ String $originalPath;
                    {
                        this.$handleNotFound = $handleNotFound;
                        this.$path = $path;
                        this.$aClass = $aClass;
                        this.$originalPath = $originalPath;
                        super(1);
                    }

                    @NotNull
                    public final CachedImageIcon invoke(@NotNull Pair<String, ClassLoader> k) {
                        Intrinsics.checkNotNullParameter(k, (String)"k");
                        ClassLoader classLoader1 = k.getSecond();
                        HandleNotFound handleNotFound = this.$handleNotFound;
                        if (handleNotFound == null) {
                            T t = IconLoaderKt.access$getSTRICT_LOCAL$p().get();
                            Intrinsics.checkNotNullExpressionValue(t, (String)"STRICT_LOCAL.get()");
                            handleNotFound = (Boolean)t != false ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE;
                        }
                        HandleNotFound effectiveHandleNotFound = handleNotFound;
                        ImageDataByUrlLoader resolver = new ImageDataByUrlLoader(this.$path, this.$aClass, classLoader1, effectiveHandleNotFound, true);
                        return new CachedImageIcon(this.$originalPath, resolver);
                    }
                }, arg_0));
            } else {
                ScaleContext scaleContext = ScaleContext.create();
                Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"create()");
                ScaleContext scaleContext2 = scaleContext;
                if (!Intrinsics.areEqual(cachedIcon.getScaleContext(), (Object)scaleContext2)) {
                    cachedIcon = cachedIcon.copy();
                    cachedIcon.updateScaleContext(scaleContext2);
                }
            }
            icon2 = cachedIcon;
        }
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        return icon2;
    }

    private static final URL findUrl(String path2, Function1<? super String, URL> urlProvider) {
        URL uRL = (URL)urlProvider.invoke((Object)path2);
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            return it;
        }
        Object effectivePath = path2;
        if (StringsKt.endsWith$default((String)effectivePath, (String)".png", (boolean)false, (int)2, null)) {
            String string2 = ((String)effectivePath).substring(0, ((String)effectivePath).length() - 4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            effectivePath = string2 + ".svg";
        } else if (StringsKt.endsWith$default((String)effectivePath, (String)".svg", (boolean)false, (int)2, null)) {
            String string3 = ((String)effectivePath).substring(0, ((String)effectivePath).length() - 4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            effectivePath = string3 + ".png";
        } else {
            Object[] objectArray = new Object[]{effectivePath};
            IconLoaderKt.getLOG().debug("unexpected path: ", objectArray);
        }
        return (URL)urlProvider.invoke(effectivePath);
    }

    private static final CachedImageIcon findIcon$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CachedImageIcon)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ThreadLocal access$getSTRICT_LOCAL$p() {
        return STRICT_LOCAL;
    }

    public static final /* synthetic */ void access$setSTRICT_GLOBAL$p(boolean bl) {
        STRICT_GLOBAL = bl;
    }

    public static final /* synthetic */ void access$updateTransform(Function updater2) {
        IconLoaderKt.updateTransform(updater2);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIconCache$p() {
        return iconCache;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIconToDisabledIcon$p() {
        return iconToDisabledIcon;
    }

    public static final /* synthetic */ MethodHandles.Lookup access$getLOOKUP$p() {
        return LOOKUP;
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return IconLoaderKt.getLOG();
    }

    public static final /* synthetic */ Icon access$findIcon(String originalPath, Class aClass, ClassLoader classLoader, HandleNotFound handleNotFound, boolean deferUrlResolve) {
        return IconLoaderKt.findIcon(originalPath, aClass, classLoader, handleNotFound, deferUrlResolve);
    }

    public static final /* synthetic */ Icon access$getOrigin(RetrievableIcon icon2) {
        return IconLoaderKt.getOrigin(icon2);
    }

    public static final /* synthetic */ Function0 access$getStandardDisablingFilter$p() {
        return standardDisablingFilter;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getColorPatchCache$p() {
        return colorPatchCache;
    }

    public static final /* synthetic */ ScaleContextSupport access$getScaleContextSupport(Icon icon2) {
        return IconLoaderKt.getScaleContextSupport(icon2);
    }

    public static final /* synthetic */ URL access$findUrl(String path2, Function1 urlProvider) {
        return IconLoaderKt.findUrl(path2, (Function1<? super String, URL>)urlProvider);
    }

    public static final /* synthetic */ boolean access$getSTRICT_GLOBAL$p() {
        return STRICT_GLOBAL;
    }

    static {
        STRICT_LOCAL = new ThreadLocal<Boolean>(){

            @NotNull
            protected Boolean initialValue() {
                return false;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public Boolean get() {
                boolean bl;
                if (!IconLoaderKt.access$getSTRICT_GLOBAL$p()) {
                    T t = super.get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"super.get()");
                    if (!((Boolean)t).booleanValue()) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        };
        fakeComponent$delegate = LazyKt.lazy((Function0)fakeComponent.2.INSTANCE);
    }
}

