/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.HandleNotFound;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ImageDataByUrlLoader
implements ImageDataLoader {
    private static final URL UNRESOLVED_URL;
    @Nullable
    private final Class<?> ownerClass;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final String overriddenPath;
    @NotNull
    private final HandleNotFound handleNotFound;
    private volatile URL url;
    private final boolean useCacheOnLoad;

    ImageDataByUrlLoader(@NotNull URL url, @Nullable ClassLoader classLoader, boolean useCacheOnLoad) {
        if (url == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(0);
        }
        this.ownerClass = null;
        this.overriddenPath = null;
        this.classLoader = classLoader;
        this.url = url;
        this.handleNotFound = HandleNotFound.IGNORE;
        this.useCacheOnLoad = useCacheOnLoad;
    }

    public ImageDataByUrlLoader(@NotNull URL url, @NotNull String path2, @Nullable ClassLoader classLoader, boolean useCacheOnLoad) {
        if (url == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(1);
        }
        if (path2 == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(2);
        }
        this.ownerClass = null;
        this.overriddenPath = path2;
        this.classLoader = classLoader;
        this.url = url;
        this.handleNotFound = HandleNotFound.IGNORE;
        this.useCacheOnLoad = useCacheOnLoad;
    }

    ImageDataByUrlLoader(@NotNull String path2, @Nullable Class<?> ownerClass, @Nullable ClassLoader classLoader, @NotNull HandleNotFound handleNotFound, boolean useCacheOnLoad) {
        if (path2 == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(3);
        }
        if (handleNotFound == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(4);
        }
        this.overriddenPath = path2;
        this.ownerClass = ownerClass;
        this.classLoader = classLoader;
        this.handleNotFound = handleNotFound;
        this.useCacheOnLoad = useCacheOnLoad;
        this.url = UNRESOLVED_URL;
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters2) {
        String path2;
        if (parameters2 == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(5);
        }
        int flags = 9;
        if (this.useCacheOnLoad) {
            flags |= 2;
        }
        if (parameters2.isDark) {
            flags |= 4;
        }
        if ((path2 = this.overriddenPath) == null || this.ownerClass == null && (this.classLoader == null || path2.charAt(0) != '/')) {
            URL url = this.getUrl();
            if (url == null) {
                return null;
            }
            path2 = url.toString();
        }
        return ImageLoader.INSTANCE.loadImage(path2, parameters2, this.ownerClass, this.classLoader, flags, !path2.endsWith(".svg"));
    }

    public void resolve() {
        this.getUrl();
    }

    @Override
    @Nullable
    public URL getUrl() {
        URL result2 = this.url;
        if (result2 == UNRESOLVED_URL) {
            result2 = null;
            try {
                result2 = IconLoader.INSTANCE.doResolve$intellij_platform_util_ui(this.overriddenPath, this.classLoader, this.ownerClass, this.handleNotFound);
            }
            finally {
                this.url = result2;
            }
        }
        return result2;
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform2) {
        if (originalPath == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(6);
        }
        if (transform2 == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(7);
        }
        return IconLoader.INSTANCE.createNewResolverIfNeeded(this.classLoader, originalPath, transform2);
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(8);
        }
        return this.classLoader == classLoader;
    }

    public String toString() {
        return "UrlResolver{ownerClass=" + (this.ownerClass == null ? "null" : this.ownerClass.getName()) + ", classLoader=" + this.classLoader + ", overriddenPath='" + this.overriddenPath + "', url=" + this.url + ", useCacheOnLoad=" + this.useCacheOnLoad + "}";
    }

    static {
        try {
            UNRESOLVED_URL = new URL("file:///unresolved");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handleNotFound";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/ImageDataByUrlLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadImage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "patch";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

