/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.CachedImageIcon;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextSupport;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0006H$J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0006\u0010\u000f\u001a\u00020\u0006J\b\u0010\u0010\u001a\u00020\nH\u0016J*\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/util/LazyIcon;", "Lcom/intellij/ui/scale/ScaleContextSupport;", "Lcom/intellij/ui/icons/CopyableIcon;", "Lcom/intellij/ui/RetrievableIcon;", "()V", "icon", "Ljavax/swing/Icon;", "transformModCount", "", "wasComputed", "", "compute", "copy", "getIconHeight", "getIconWidth", "getOrComputeIcon", "isComplex", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "retrieveIcon", "intellij.platform.util.ui"})
abstract class LazyIcon
extends ScaleContextSupport
implements CopyableIcon,
RetrievableIcon {
    private boolean wasComputed;
    @Nullable
    private volatile Icon icon;
    private int transformModCount = CachedImageIcon.pathTransformGlobalModCount.get();

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public void paintIcon(@Nullable Component c2, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.updateScaleContext(ScaleContext.create((Graphics2D)g))) {
            this.icon = null;
        }
        this.getOrComputeIcon().paintIcon(c2, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.getOrComputeIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getOrComputeIcon().getIconHeight();
    }

    @NotNull
    public final synchronized Icon getOrComputeIcon() {
        Icon icon2;
        Icon icon3 = this.icon;
        int newTransformModCount = CachedImageIcon.pathTransformGlobalModCount.get();
        if (icon3 != null && this.wasComputed && this.transformModCount == newTransformModCount) {
            return icon3;
        }
        this.transformModCount = newTransformModCount;
        this.wasComputed = true;
        try {
            icon2 = this.compute();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            IconLoaderKt.access$getLOG().error("Cannot compute icon", e);
            icon2 = IconManager.getInstance().getPlatformIcon(PlatformIcons.Stub);
        }
        this.icon = icon3 = icon2;
        Icon icon4 = icon3;
        Intrinsics.checkNotNull((Object)icon4);
        return icon4;
    }

    @NotNull
    protected abstract Icon compute();

    @Override
    @NotNull
    public Icon retrieveIcon() {
        return this.getOrComputeIcon();
    }

    @Override
    @NotNull
    public Icon copy() {
        return IconLoader.INSTANCE.copy(this.getOrComputeIcon(), null, false);
    }
}

