/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.CachedImageIcon;
import com.intellij.openapi.util.ScaledIconCacheKt;
import com.intellij.reference.SoftReference;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.FixedHashMap;
import java.awt.Image;
import java.util.Collections;
import java.util.Map;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010Rf\u0010\u0005\u001aZ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \b*,\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/util/ScaledIconCache;", "", "host", "Lcom/intellij/openapi/util/CachedImageIcon;", "(Lcom/intellij/openapi/util/CachedImageIcon;)V", "cache", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/reference/SoftReference;", "Ljavax/swing/ImageIcon;", "", "clear", "", "getOrScaleIcon", "scale", "", "intellij.platform.util.ui"})
public final class ScaledIconCache {
    @NotNull
    private final CachedImageIcon host;
    private final Map<Long, SoftReference<ImageIcon>> cache;

    public ScaledIconCache(@NotNull CachedImageIcon host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.cache = Collections.synchronizedMap(new FixedHashMap(5));
    }

    @Nullable
    public final ImageIcon getOrScaleIcon(float scale) {
        ImageIcon imageIcon;
        long cacheKey;
        SoftReference<ImageIcon> softReference;
        Object t = this.host.getScaleContext();
        Intrinsics.checkNotNullExpressionValue(t, (String)"host.scaleContext");
        ScaleContext scaleContext = (ScaleContext)t;
        if (!(scale == 1.0f)) {
            Object t2 = scaleContext.copy();
            Intrinsics.checkNotNullExpressionValue(t2, (String)"scaleContext.copy()");
            scaleContext = (ScaleContext)t2;
            scaleContext.setScale(ScaleType.OBJ_SCALE.of(scale));
        }
        if ((softReference = this.cache.get(cacheKey = ScaledIconCacheKt.access$key(scaleContext))) != null && (imageIcon = (ImageIcon)softReference.get()) != null) {
            ImageIcon it = imageIcon;
            boolean bl = false;
            return it;
        }
        Image image = this.host.loadImage$intellij_platform_util_ui(scaleContext, this.host.isDark());
        if (image == null) {
            return null;
        }
        Image image2 = image;
        ImageIcon icon2 = ScaledIconCacheKt.access$createScaledIcon(image2, this.host, scale);
        if (icon2 != null && !ImageLoader.INSTANCE.isIconTooLargeForCache(icon2)) {
            this.cache.put(cacheKey, new SoftReference<ImageIcon>(icon2));
        }
        return icon2;
    }

    public final void clear() {
        this.cache.clear();
    }
}

