/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CachedImageIcon;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.IconReplacer;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Image;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/util/ScaledResultIcon;", "Lcom/intellij/util/ui/JBImageIcon;", "Lcom/intellij/ui/icons/ReplaceableIcon;", "image", "Ljava/awt/Image;", "original", "Lcom/intellij/openapi/util/CachedImageIcon;", "scale", "", "(Ljava/awt/Image;Lcom/intellij/openapi/util/CachedImageIcon;F)V", "replaceBy", "Ljavax/swing/Icon;", "replacer", "Lcom/intellij/ui/IconReplacer;", "toString", "", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nScaledIconCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaledIconCache.kt\ncom/intellij/openapi/util/ScaledResultIcon\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n10#2:93\n*S KotlinDebug\n*F\n+ 1 ScaledIconCache.kt\ncom/intellij/openapi/util/ScaledResultIcon\n*L\n68#1:93\n*E\n"})
final class ScaledResultIcon
extends JBImageIcon
implements ReplaceableIcon {
    @NotNull
    private final CachedImageIcon original;
    private final float scale;

    public ScaledResultIcon(@NotNull Image image, @NotNull CachedImageIcon original, float scale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        super(image);
        this.original = original;
        this.scale = scale;
    }

    @Override
    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer2) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)replacer2, (String)"replacer");
        Icon originalReplaced = replacer2.replaceIcon(this.original);
        if (originalReplaced instanceof ScalableIcon) {
            Icon icon3 = ((ScalableIcon)originalReplaced).scale(this.scale);
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"{\n      originalReplaced.scale(scale)\n    }");
            icon2 = icon3;
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ScaledResultIcon.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error("The result after replacing cannot be scaled: " + originalReplaced);
            icon2 = this;
        }
        return icon2;
    }

    @Override
    @NotNull
    public String toString() {
        return "ScaledResultIcon for " + this.original;
    }
}

