/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.BitUtil;
import com.sun.jna.platform.win32.Kernel32;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NioFiles {
    public static final BasicFileAttributes BROKEN_SYMLINK = new BasicFileAttributes(){
        private final FileTime ZERO = FileTime.fromMillis(0L);

        @Override
        public FileTime lastModifiedTime() {
            return this.ZERO;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.ZERO;
        }

        @Override
        public FileTime creationTime() {
            return this.ZERO;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    };
    private static final Logger LOG = Logger.getInstance(NioFiles.class);
    private static final LinkOption[] NO_FOLLOW = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    private NioFiles() {
    }

    @Nullable
    public static Path toPath(@NotNull String path2) {
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(0);
        }
        try {
            return Paths.get(path2, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String getFileName(@NotNull Path path2) {
        Path name;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(1);
        }
        String string2 = ((name = path2.getFileName()) != null ? name : path2).toString();
        if (string2 == null) {
            NioFiles.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path2) throws IOException {
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(3);
        }
        try {
            NioFiles.tryCreateDirectory(path2);
        }
        catch (FileAlreadyExistsException e) {
            throw e;
        }
        catch (IOException e) {
            Path parent2 = path2.getParent();
            if (parent2 == null) {
                throw e;
            }
            NioFiles.createDirectories(parent2);
            NioFiles.tryCreateDirectory(path2);
        }
        Path path3 = path2;
        if (path3 == null) {
            NioFiles.$$$reportNull$$$0(4);
        }
        return path3;
    }

    private static void tryCreateDirectory(Path path2) throws IOException {
        block2: {
            try {
                Files.createDirectory(path2, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(path2, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    public static boolean isWritable(@NotNull Path path2) {
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(5);
        }
        try {
            return Files.isWritable(path2);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static void setReadOnly(@NotNull Path path2, boolean value) throws IOException {
        PosixFileAttributeView posixView;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(6);
        }
        if ((posixView = Files.getFileAttributeView(path2, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            boolean modified;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            boolean bl = modified = value ? permissions.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE)) : permissions.add(PosixFilePermission.OWNER_WRITE);
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosView = Files.getFileAttributeView(path2, DosFileAttributeView.class, new LinkOption[0]);
            if (dosView != null) {
                dosView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path2.getFileSystem());
            }
        }
    }

    public static void setExecutable(@NotNull Path file2) throws IOException {
        Set<PosixFilePermission> permissions;
        PosixFileAttributeView view;
        if (file2 == null) {
            NioFiles.$$$reportNull$$$0(7);
        }
        if ((view = Files.getFileAttributeView(file2, PosixFileAttributeView.class, new LinkOption[0])) != null && (permissions = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view.setPermissions(permissions);
        }
    }

    @NotNull
    public static List<Path> list(@NotNull Path directory) {
        ArrayList<Path> arrayList;
        if (directory == null) {
            NioFiles.$$$reportNull$$$0(8);
        }
        try {
            ArrayList<Path> files2 = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path2 : stream) {
                    files2.add(path2);
                }
            }
            arrayList = files2;
        }
        catch (IOException e) {
            List<Path> list2 = Collections.emptyList();
            if (list2 == null) {
                NioFiles.$$$reportNull$$$0(10);
            }
            return list2;
        }
        if (arrayList == null) {
            NioFiles.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static BasicFileAttributes readAttributes(@NotNull Path path2) throws IOException, SecurityException {
        BasicFileAttributes basicFileAttributes;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(11);
        }
        try {
            basicFileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, NO_FOLLOW);
        }
        catch (AccessDeniedException | NoSuchFileException e) {
            throw e;
        }
        catch (FileSystemException e) {
            if (SystemInfo.isWindows && JnaLoader.isLoaded() && NioFiles.isNtfsReparsePoint(path2)) {
                LOG.debug(e);
                BasicFileAttributes basicFileAttributes2 = BROKEN_SYMLINK;
                if (basicFileAttributes2 == null) {
                    NioFiles.$$$reportNull$$$0(13);
                }
                return basicFileAttributes2;
            }
            throw e;
        }
        if (basicFileAttributes == null) {
            NioFiles.$$$reportNull$$$0(12);
        }
        return basicFileAttributes;
    }

    private static boolean isNtfsReparsePoint(Path path2) {
        int attrs = Kernel32.INSTANCE.GetFileAttributes(path2.toString());
        return attrs != -1 && BitUtil.isSet(attrs, 1024);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(14);
        }
        FileUtilRt.deleteRecursively(fileOrDirectory, null);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory, @NotNull Consumer<? super Path> callback) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            NioFiles.$$$reportNull$$$0(16);
        }
        FileUtilRt.deleteRecursively(fileOrDirectory, callback::accept);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectories";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readAttributes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

